/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.partitioning;

import java.io.IOException;
import java.text.ParseException;
import java.util.StringTokenizer;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.euclidean.oned.Euclidean1D;
import org.hipparchus.geometry.euclidean.oned.IntervalsSet;
import org.hipparchus.geometry.euclidean.oned.OrientedPoint;
import org.hipparchus.geometry.euclidean.oned.Vector1D;
import org.hipparchus.geometry.euclidean.threed.Euclidean3D;
import org.hipparchus.geometry.euclidean.threed.Plane;
import org.hipparchus.geometry.euclidean.threed.PolyhedronsSet;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Euclidean2D;
import org.hipparchus.geometry.euclidean.twod.Line;
import org.hipparchus.geometry.euclidean.twod.PolygonsSet;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.spherical.oned.ArcsSet;
import org.hipparchus.geometry.spherical.oned.LimitAngle;
import org.hipparchus.geometry.spherical.oned.S1Point;
import org.hipparchus.geometry.spherical.oned.Sphere1D;
import org.hipparchus.geometry.spherical.twod.Circle;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.geometry.spherical.twod.SphericalPolygonsSet;

public class RegionParser {
    private RegionParser() {
    }

    public static ArcsSet parseArcsSet(String s) throws IOException, ParseException {
        TreeBuilder<Sphere1D> builder = new TreeBuilder<Sphere1D>("ArcsSet", s){

            protected LimitAngle parseHyperplane() throws IOException, ParseException {
                return new LimitAngle(new S1Point(this.getNumber()), this.getBoolean(), this.getNumber());
            }
        };
        return new ArcsSet(builder.getTree(), builder.getTolerance());
    }

    public static SphericalPolygonsSet parseSphericalPolygonsSet(String s) throws IOException, ParseException {
        TreeBuilder<Sphere2D> builder = new TreeBuilder<Sphere2D>("SphericalPolygonsSet", s){

            public Circle parseHyperplane() throws IOException, ParseException {
                return new Circle(new Vector3D(this.getNumber(), this.getNumber(), this.getNumber()), this.getNumber());
            }
        };
        return new SphericalPolygonsSet(builder.getTree(), builder.getTolerance());
    }

    public static IntervalsSet parseIntervalsSet(String s) throws IOException, ParseException {
        TreeBuilder<Euclidean1D> builder = new TreeBuilder<Euclidean1D>("IntervalsSet", s){

            public OrientedPoint parseHyperplane() throws IOException, ParseException {
                return new OrientedPoint(new Vector1D(this.getNumber()), this.getBoolean(), this.getNumber());
            }
        };
        return new IntervalsSet(builder.getTree(), builder.getTolerance());
    }

    public static PolygonsSet parsePolygonsSet(String s) throws IOException, ParseException {
        TreeBuilder<Euclidean2D> builder = new TreeBuilder<Euclidean2D>("PolygonsSet", s){

            public Line parseHyperplane() throws IOException, ParseException {
                return new Line(new Vector2D(this.getNumber(), this.getNumber()), this.getNumber(), this.getNumber());
            }
        };
        return new PolygonsSet(builder.getTree(), builder.getTolerance());
    }

    public static PolyhedronsSet parsePolyhedronsSet(String s) throws IOException, ParseException {
        TreeBuilder<Euclidean3D> builder = new TreeBuilder<Euclidean3D>("PolyhedronsSet", s){

            public Plane parseHyperplane() throws IOException, ParseException {
                return new Plane(new Vector3D(this.getNumber(), this.getNumber(), this.getNumber()), new Vector3D(this.getNumber(), this.getNumber(), this.getNumber()), this.getNumber());
            }
        };
        return new PolyhedronsSet(builder.getTree(), builder.getTolerance());
    }

    private static abstract class TreeBuilder<S extends Space> {
        private static final String TOLERANCE = "tolerance";
        private static final String INTERNAL = "internal";
        private static final String LEAF = "leaf";
        private static final String PLUS = "plus";
        private static final String MINUS = "minus";
        private static final String TRUE = "true";
        private static final String FALSE = "false";
        private BSPTree<S> root = null;
        private final double tolerance;
        private final StringTokenizer tokenizer;

        public TreeBuilder(String type, String s) throws IOException, ParseException {
            this.tokenizer = new StringTokenizer(s);
            this.getWord(type);
            this.getWord(TOLERANCE);
            this.tolerance = this.getNumber();
            this.getWord(PLUS);
            this.root = new BSPTree();
            this.parseTree(this.root);
            if (this.tokenizer.hasMoreTokens()) {
                throw new ParseException("unexpected " + this.tokenizer.nextToken(), 0);
            }
        }

        private void parseTree(BSPTree<S> node) throws IOException, ParseException {
            if (INTERNAL.equals(this.getWord(INTERNAL, LEAF))) {
                node.insertCut(this.parseHyperplane());
                this.getWord(MINUS);
                this.parseTree(node.getMinus());
                this.getWord(PLUS);
                this.parseTree(node.getPlus());
            } else {
                node.setAttribute((Object)this.getBoolean());
            }
        }

        protected String getWord(String ... allowed) throws IOException, ParseException {
            String token = this.tokenizer.nextToken();
            for (String a : allowed) {
                if (!a.equals(token)) continue;
                return token;
            }
            throw new ParseException(token + " != " + allowed[0], 0);
        }

        protected double getNumber() throws IOException, NumberFormatException {
            return Double.parseDouble(this.tokenizer.nextToken());
        }

        protected boolean getBoolean() throws IOException, ParseException {
            return this.getWord(TRUE, FALSE).equals(TRUE);
        }

        public BSPTree<S> getTree() {
            return this.root;
        }

        public double getTolerance() {
            return this.tolerance;
        }

        protected abstract Hyperplane<S> parseHyperplane() throws IOException, ParseException;
    }
}

