/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.oned;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.RegionFactory;
import org.hipparchus.geometry.partitioning.Side;
import org.hipparchus.geometry.partitioning.SubHyperplane;
import org.hipparchus.geometry.spherical.oned.Arc;
import org.hipparchus.geometry.spherical.oned.ArcsSet;
import org.hipparchus.geometry.spherical.oned.LimitAngle;
import org.hipparchus.geometry.spherical.oned.S1Point;
import org.hipparchus.geometry.spherical.oned.SubLimitAngle;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class ArcsSetTest {
    @Test
    public void testArc() {
        ArcsSet set = new ArcsSet(2.3, 5.7, 1.0E-10);
        Assert.assertEquals((double)3.4, (double)set.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)1.0E-10, (double)set.getTolerance(), (double)1.0E-20);
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)set.checkPoint((Point)new S1Point(2.3)));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)set.checkPoint((Point)new S1Point(5.7)));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)set.checkPoint((Point)new S1Point(1.2)));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)set.checkPoint((Point)new S1Point(8.5)));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Point)new S1Point(8.7)));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Point)new S1Point(3.0)));
        Assert.assertEquals((long)1L, (long)set.asList().size());
        Assert.assertEquals((double)2.3, (double)((Arc)set.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)5.7, (double)((Arc)set.asList().get(0)).getSup(), (double)1.0E-10);
    }

    @Test
    public void testWrapAround2PiArc() {
        ArcsSet set = new ArcsSet(-0.583185307179586, 2.3, 1.0E-10);
        Assert.assertEquals((double)2.8831853071795863, (double)set.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)1.0E-10, (double)set.getTolerance(), (double)1.0E-20);
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)set.checkPoint((Point)new S1Point(2.3)));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)set.checkPoint((Point)new S1Point(5.7)));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Point)new S1Point(1.2)));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Point)new S1Point(8.5)));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)set.checkPoint((Point)new S1Point(8.7)));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)set.checkPoint((Point)new S1Point(3.0)));
        Assert.assertEquals((long)1L, (long)set.asList().size());
        Assert.assertEquals((double)5.7, (double)((Arc)set.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)8.583185307179587, (double)((Arc)set.asList().get(0)).getSup(), (double)1.0E-10);
    }

    @Test
    public void testSplitOver2Pi() {
        ArcsSet set = new ArcsSet(1.0E-10);
        Arc arc = new Arc(4.71238898038469, 7.853981633974483, 1.0E-10);
        ArcsSet.Split split = set.split(arc);
        for (double alpha = 0.0; alpha <= Math.PI * 2; alpha += 0.01) {
            S1Point p = new S1Point(alpha);
            if (alpha < 1.5707963267948966 || alpha > 4.71238898038469) {
                Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)split.getPlus().checkPoint((Point)p));
                Assert.assertEquals((Object)Region.Location.INSIDE, (Object)split.getMinus().checkPoint((Point)p));
                continue;
            }
            Assert.assertEquals((Object)Region.Location.INSIDE, (Object)split.getPlus().checkPoint((Point)p));
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)split.getMinus().checkPoint((Point)p));
        }
    }

    @Test
    public void testSplitAtEnd() {
        ArcsSet set = new ArcsSet(1.0E-10);
        Arc arc = new Arc(Math.PI, Math.PI * 2, 1.0E-10);
        ArcsSet.Split split = set.split(arc);
        for (double alpha = 0.01; alpha < Math.PI * 2; alpha += 0.01) {
            S1Point p = new S1Point(alpha);
            if (alpha > Math.PI) {
                Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)split.getPlus().checkPoint((Point)p));
                Assert.assertEquals((Object)Region.Location.INSIDE, (Object)split.getMinus().checkPoint((Point)p));
                continue;
            }
            Assert.assertEquals((Object)Region.Location.INSIDE, (Object)split.getPlus().checkPoint((Point)p));
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)split.getMinus().checkPoint((Point)p));
        }
        S1Point zero = new S1Point(0.0);
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)split.getPlus().checkPoint((Point)zero));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)split.getMinus().checkPoint((Point)zero));
        S1Point pi = new S1Point(Math.PI);
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)split.getPlus().checkPoint((Point)pi));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)split.getMinus().checkPoint((Point)pi));
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testWrongInterval() {
        new ArcsSet(1.2, 0.0, 1.0E-10);
    }

    @Test
    public void testFullEqualEndPoints() {
        ArcsSet set = new ArcsSet(1.0, 1.0, 1.0E-10);
        Assert.assertEquals((double)1.0E-10, (double)set.getTolerance(), (double)1.0E-20);
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Point)new S1Point(9.0)));
        for (double alpha = -20.0; alpha <= 20.0; alpha += 0.1) {
            Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Point)new S1Point(alpha)));
        }
        Assert.assertEquals((long)1L, (long)set.asList().size());
        Assert.assertEquals((double)0.0, (double)((Arc)set.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)(Math.PI * 2), (double)((Arc)set.asList().get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)(Math.PI * 2), (double)set.getSize(), (double)1.0E-10);
    }

    @Test
    public void testFullCircle() {
        ArcsSet set = new ArcsSet(1.0E-10);
        Assert.assertEquals((double)1.0E-10, (double)set.getTolerance(), (double)1.0E-20);
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Point)new S1Point(9.0)));
        for (double alpha = -20.0; alpha <= 20.0; alpha += 0.1) {
            Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Point)new S1Point(alpha)));
        }
        Assert.assertEquals((long)1L, (long)set.asList().size());
        Assert.assertEquals((double)0.0, (double)((Arc)set.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)(Math.PI * 2), (double)((Arc)set.asList().get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)(Math.PI * 2), (double)set.getSize(), (double)1.0E-10);
    }

    @Test
    public void testEmpty() {
        ArcsSet empty = (ArcsSet)new RegionFactory().getComplement((Region)new ArcsSet(1.0E-10));
        Assert.assertEquals((double)1.0E-10, (double)empty.getTolerance(), (double)1.0E-20);
        Assert.assertEquals((double)0.0, (double)empty.getSize(), (double)1.0E-10);
        Assert.assertTrue((boolean)empty.asList().isEmpty());
    }

    @Test
    public void testTiny() {
        ArcsSet tiny = new ArcsSet(0.0, Precision.SAFE_MIN / 2.0, 1.0E-10);
        Assert.assertEquals((double)1.0E-10, (double)tiny.getTolerance(), (double)1.0E-20);
        Assert.assertEquals((double)(Precision.SAFE_MIN / 2.0), (double)tiny.getSize(), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)tiny.asList().size());
        Assert.assertEquals((double)0.0, (double)((Arc)tiny.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)(Precision.SAFE_MIN / 2.0), (double)((Arc)tiny.asList().get(0)).getSup(), (double)1.0E-10);
    }

    @Test
    public void testSpecialConstruction() {
        ArrayList<SubLimitAngle> boundary = new ArrayList<SubLimitAngle>();
        boundary.add(new LimitAngle(new S1Point(0.0), false, 1.0E-10).wholeHyperplane());
        boundary.add(new LimitAngle(new S1Point(6.283185307169586), true, 1.0E-10).wholeHyperplane());
        ArcsSet set = new ArcsSet(boundary, 1.0E-10);
        Assert.assertEquals((double)(Math.PI * 2), (double)set.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)1.0E-10, (double)set.getTolerance(), (double)1.0E-20);
        Assert.assertEquals((long)1L, (long)set.asList().size());
        Assert.assertEquals((double)0.0, (double)((Arc)set.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)(Math.PI * 2), (double)((Arc)set.asList().get(0)).getSup(), (double)1.0E-10);
    }

    @Test
    public void testDifference() {
        ArcsSet a = new ArcsSet(1.0, 6.0, 1.0E-10);
        List aList = a.asList();
        Assert.assertEquals((long)1L, (long)aList.size());
        Assert.assertEquals((double)1.0, (double)((Arc)aList.get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)6.0, (double)((Arc)aList.get(0)).getSup(), (double)1.0E-10);
        ArcsSet b = new ArcsSet(3.0, 5.0, 1.0E-10);
        List bList = b.asList();
        Assert.assertEquals((long)1L, (long)bList.size());
        Assert.assertEquals((double)3.0, (double)((Arc)bList.get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)((Arc)bList.get(0)).getSup(), (double)1.0E-10);
        ArcsSet aMb = (ArcsSet)new RegionFactory().difference((Region)a, (Region)b);
        for (int k = -2; k < 3; ++k) {
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)aMb.checkPoint((Point)new S1Point(0.0 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)aMb.checkPoint((Point)new S1Point(0.9 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)aMb.checkPoint((Point)new S1Point(1.0 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.INSIDE, (Object)aMb.checkPoint((Point)new S1Point(1.1 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.INSIDE, (Object)aMb.checkPoint((Point)new S1Point(2.9 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)aMb.checkPoint((Point)new S1Point(3.0 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)aMb.checkPoint((Point)new S1Point(3.1 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)aMb.checkPoint((Point)new S1Point(4.9 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)aMb.checkPoint((Point)new S1Point(5.0 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.INSIDE, (Object)aMb.checkPoint((Point)new S1Point(5.1 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.INSIDE, (Object)aMb.checkPoint((Point)new S1Point(5.9 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)aMb.checkPoint((Point)new S1Point(6.0 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)aMb.checkPoint((Point)new S1Point(6.1 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)aMb.checkPoint((Point)new S1Point(6.2 + (double)k * (Math.PI * 2))));
        }
        List aMbList = aMb.asList();
        Assert.assertEquals((long)2L, (long)aMbList.size());
        Assert.assertEquals((double)1.0, (double)((Arc)aMbList.get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)((Arc)aMbList.get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)((Arc)aMbList.get(1)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)6.0, (double)((Arc)aMbList.get(1)).getSup(), (double)1.0E-10);
    }

    @Test
    public void testIntersection() {
        ArcsSet a = (ArcsSet)new RegionFactory().union((Region)new ArcsSet(1.0, 3.0, 1.0E-10), (Region)new ArcsSet(5.0, 6.0, 1.0E-10));
        List aList = a.asList();
        Assert.assertEquals((long)2L, (long)aList.size());
        Assert.assertEquals((double)1.0, (double)((Arc)aList.get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)((Arc)aList.get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)((Arc)aList.get(1)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)6.0, (double)((Arc)aList.get(1)).getSup(), (double)1.0E-10);
        ArcsSet b = new ArcsSet(0.0, 5.5, 1.0E-10);
        List bList = b.asList();
        Assert.assertEquals((long)1L, (long)bList.size());
        Assert.assertEquals((double)0.0, (double)((Arc)bList.get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)5.5, (double)((Arc)bList.get(0)).getSup(), (double)1.0E-10);
        ArcsSet aMb = (ArcsSet)new RegionFactory().intersection((Region)a, (Region)b);
        for (int k = -2; k < 3; ++k) {
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)aMb.checkPoint((Point)new S1Point(0.0 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)aMb.checkPoint((Point)new S1Point(1.0 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.INSIDE, (Object)aMb.checkPoint((Point)new S1Point(1.1 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.INSIDE, (Object)aMb.checkPoint((Point)new S1Point(2.9 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)aMb.checkPoint((Point)new S1Point(3.0 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)aMb.checkPoint((Point)new S1Point(3.1 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)aMb.checkPoint((Point)new S1Point(4.9 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)aMb.checkPoint((Point)new S1Point(5.0 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.INSIDE, (Object)aMb.checkPoint((Point)new S1Point(5.1 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.INSIDE, (Object)aMb.checkPoint((Point)new S1Point(5.4 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)aMb.checkPoint((Point)new S1Point(5.5 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)aMb.checkPoint((Point)new S1Point(5.6 + (double)k * (Math.PI * 2))));
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)aMb.checkPoint((Point)new S1Point(6.2 + (double)k * (Math.PI * 2))));
        }
        List aMbList = aMb.asList();
        Assert.assertEquals((long)2L, (long)aMbList.size());
        Assert.assertEquals((double)1.0, (double)((Arc)aMbList.get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)((Arc)aMbList.get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)((Arc)aMbList.get(1)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)5.5, (double)((Arc)aMbList.get(1)).getSup(), (double)1.0E-10);
    }

    @Test
    public void testMultiple() {
        RegionFactory factory = new RegionFactory();
        ArcsSet set = (ArcsSet)factory.intersection(factory.union(factory.difference((Region)new ArcsSet(1.0, 6.0, 1.0E-10), (Region)new ArcsSet(3.0, 5.0, 1.0E-10)), (Region)new ArcsSet(0.5, 2.0, 1.0E-10)), (Region)new ArcsSet(0.0, 5.5, 1.0E-10));
        Assert.assertEquals((double)3.0, (double)set.getSize(), (double)1.0E-10);
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)set.checkPoint((Point)new S1Point(0.0)));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)set.checkPoint((Point)new S1Point(4.0)));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)set.checkPoint((Point)new S1Point(6.0)));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Point)new S1Point(1.2)));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Point)new S1Point(5.25)));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)set.checkPoint((Point)new S1Point(0.5)));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)set.checkPoint((Point)new S1Point(3.0)));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)set.checkPoint((Point)new S1Point(5.0)));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)set.checkPoint((Point)new S1Point(5.5)));
        List list = set.asList();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((double)0.5, (double)((Arc)list.get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)((Arc)list.get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)((Arc)list.get(1)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)5.5, (double)((Arc)list.get(1)).getSup(), (double)1.0E-10);
    }

    @Test
    public void testSinglePoint() {
        ArcsSet set = new ArcsSet(1.0, FastMath.nextAfter((double)1.0, (double)Double.POSITIVE_INFINITY), 1.0E-10);
        Assert.assertEquals((double)(2.0 * Precision.EPSILON), (double)set.getSize(), (double)Precision.SAFE_MIN);
    }

    @Test
    public void testIteration() {
        ArcsSet set = (ArcsSet)new RegionFactory().difference((Region)new ArcsSet(1.0, 6.0, 1.0E-10), (Region)new ArcsSet(3.0, 5.0, 1.0E-10));
        Iterator iterator = set.iterator();
        try {
            iterator.remove();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)iterator.hasNext());
        double[] a0 = (double[])iterator.next();
        Assert.assertEquals((long)2L, (long)a0.length);
        Assert.assertEquals((double)1.0, (double)a0[0], (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)a0[1], (double)1.0E-10);
        Assert.assertTrue((boolean)iterator.hasNext());
        double[] a1 = (double[])iterator.next();
        Assert.assertEquals((long)2L, (long)a1.length);
        Assert.assertEquals((double)5.0, (double)a1[0], (double)1.0E-10);
        Assert.assertEquals((double)6.0, (double)a1[1], (double)1.0E-10);
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyTree() {
        Assert.assertEquals((double)(Math.PI * 2), (double)new ArcsSet(new BSPTree((Object)Boolean.TRUE), 1.0E-10).getSize(), (double)1.0E-10);
    }

    @Test
    public void testShiftedAngles() {
        for (int k = -2; k < 3; ++k) {
            SubLimitAngle l1 = new LimitAngle(new S1Point(1.0 + (double)k * (Math.PI * 2)), false, 1.0E-10).wholeHyperplane();
            SubLimitAngle l2 = new LimitAngle(new S1Point(1.5 + (double)k * (Math.PI * 2)), true, 1.0E-10).wholeHyperplane();
            ArcsSet set = new ArcsSet(new BSPTree((SubHyperplane)l1, new BSPTree((Object)Boolean.FALSE), new BSPTree((SubHyperplane)l2, new BSPTree((Object)Boolean.FALSE), new BSPTree((Object)Boolean.TRUE), null), null), 1.0E-10);
            for (double alpha = 1.0E-6; alpha < Math.PI * 2; alpha += 0.001) {
                if (alpha < 1.0 || alpha > 1.5) {
                    Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)set.checkPoint((Point)new S1Point(alpha)));
                    continue;
                }
                Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Point)new S1Point(alpha)));
            }
        }
    }

    @Test(expected=ArcsSet.InconsistentStateAt2PiWrapping.class)
    public void testInconsistentState() {
        SubLimitAngle l1 = new LimitAngle(new S1Point(1.0), false, 1.0E-10).wholeHyperplane();
        SubLimitAngle l2 = new LimitAngle(new S1Point(2.0), true, 1.0E-10).wholeHyperplane();
        SubLimitAngle l3 = new LimitAngle(new S1Point(3.0), false, 1.0E-10).wholeHyperplane();
        new ArcsSet(new BSPTree((SubHyperplane)l1, new BSPTree((Object)Boolean.FALSE), new BSPTree((SubHyperplane)l2, new BSPTree((SubHyperplane)l3, new BSPTree((Object)Boolean.FALSE), new BSPTree((Object)Boolean.TRUE), null), new BSPTree((Object)Boolean.TRUE), null), null), 1.0E-10);
    }

    @Test
    public void testSide() {
        ArcsSet set = (ArcsSet)new RegionFactory().difference((Region)new ArcsSet(1.0, 6.0, 1.0E-10), (Region)new ArcsSet(3.0, 5.0, 1.0E-10));
        for (int k = -2; k < 3; ++k) {
            Assert.assertEquals((Object)Side.MINUS, (Object)set.split(new Arc(0.5 + (double)k * (Math.PI * 2), 6.1 + (double)k * (Math.PI * 2), set.getTolerance())).getSide());
            Assert.assertEquals((Object)Side.PLUS, (Object)set.split(new Arc(0.5 + (double)k * (Math.PI * 2), 0.8 + (double)k * (Math.PI * 2), set.getTolerance())).getSide());
            Assert.assertEquals((Object)Side.PLUS, (Object)set.split(new Arc(6.2 + (double)k * (Math.PI * 2), 6.3 + (double)k * (Math.PI * 2), set.getTolerance())).getSide());
            Assert.assertEquals((Object)Side.PLUS, (Object)set.split(new Arc(3.5 + (double)k * (Math.PI * 2), 4.5 + (double)k * (Math.PI * 2), set.getTolerance())).getSide());
            Assert.assertEquals((Object)Side.BOTH, (Object)set.split(new Arc(2.9 + (double)k * (Math.PI * 2), 4.5 + (double)k * (Math.PI * 2), set.getTolerance())).getSide());
            Assert.assertEquals((Object)Side.BOTH, (Object)set.split(new Arc(0.5 + (double)k * (Math.PI * 2), 1.2 + (double)k * (Math.PI * 2), set.getTolerance())).getSide());
            Assert.assertEquals((Object)Side.BOTH, (Object)set.split(new Arc(0.5 + (double)k * (Math.PI * 2), 5.9 + (double)k * (Math.PI * 2), set.getTolerance())).getSide());
        }
    }

    @Test
    public void testSideEmbedded() {
        ArcsSet s35 = new ArcsSet(3.0, 5.0, 1.0E-10);
        ArcsSet s16 = new ArcsSet(1.0, 6.0, 1.0E-10);
        Assert.assertEquals((Object)Side.BOTH, (Object)s16.split(new Arc(3.0, 5.0, 1.0E-10)).getSide());
        Assert.assertEquals((Object)Side.BOTH, (Object)s16.split(new Arc(5.0, 9.283185307179586, 1.0E-10)).getSide());
        Assert.assertEquals((Object)Side.MINUS, (Object)s35.split(new Arc(1.0, 6.0, 1.0E-10)).getSide());
        Assert.assertEquals((Object)Side.PLUS, (Object)s35.split(new Arc(6.0, 7.283185307179586, 1.0E-10)).getSide());
    }

    @Test
    public void testSideOverlapping() {
        ArcsSet s35 = new ArcsSet(3.0, 5.0, 1.0E-10);
        ArcsSet s46 = new ArcsSet(4.0, 6.0, 1.0E-10);
        Assert.assertEquals((Object)Side.BOTH, (Object)s46.split(new Arc(3.0, 5.0, 1.0E-10)).getSide());
        Assert.assertEquals((Object)Side.BOTH, (Object)s46.split(new Arc(5.0, 9.283185307179586, 1.0E-10)).getSide());
        Assert.assertEquals((Object)Side.BOTH, (Object)s35.split(new Arc(4.0, 6.0, 1.0E-10)).getSide());
        Assert.assertEquals((Object)Side.BOTH, (Object)s35.split(new Arc(6.0, 10.283185307179586, 1.0E-10)).getSide());
    }

    @Test
    public void testSideHyper() {
        ArcsSet sub = (ArcsSet)new RegionFactory().getComplement((Region)new ArcsSet(1.0E-10));
        Assert.assertTrue((boolean)sub.isEmpty());
        Assert.assertEquals((Object)Side.HYPER, (Object)sub.split(new Arc(2.0, 3.0, 1.0E-10)).getSide());
    }

    @Test
    public void testSplitEmbedded() {
        ArcsSet s35 = new ArcsSet(3.0, 5.0, 1.0E-10);
        ArcsSet s16 = new ArcsSet(1.0, 6.0, 1.0E-10);
        ArcsSet.Split split1 = s16.split(new Arc(3.0, 5.0, 1.0E-10));
        ArcsSet split1Plus = split1.getPlus();
        ArcsSet split1Minus = split1.getMinus();
        Assert.assertEquals((double)3.0, (double)split1Plus.getSize(), (double)1.0E-10);
        Assert.assertEquals((long)2L, (long)split1Plus.asList().size());
        Assert.assertEquals((double)1.0, (double)((Arc)split1Plus.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)((Arc)split1Plus.asList().get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)((Arc)split1Plus.asList().get(1)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)6.0, (double)((Arc)split1Plus.asList().get(1)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)2.0, (double)split1Minus.getSize(), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)split1Minus.asList().size());
        Assert.assertEquals((double)3.0, (double)((Arc)split1Minus.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)((Arc)split1Minus.asList().get(0)).getSup(), (double)1.0E-10);
        ArcsSet.Split split2 = s16.split(new Arc(5.0, 9.283185307179586, 1.0E-10));
        ArcsSet split2Plus = split2.getPlus();
        ArcsSet split2Minus = split2.getMinus();
        Assert.assertEquals((double)2.0, (double)split2Plus.getSize(), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)split2Plus.asList().size());
        Assert.assertEquals((double)3.0, (double)((Arc)split2Plus.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)((Arc)split2Plus.asList().get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)split2Minus.getSize(), (double)1.0E-10);
        Assert.assertEquals((long)2L, (long)split2Minus.asList().size());
        Assert.assertEquals((double)1.0, (double)((Arc)split2Minus.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)((Arc)split2Minus.asList().get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)((Arc)split2Minus.asList().get(1)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)6.0, (double)((Arc)split2Minus.asList().get(1)).getSup(), (double)1.0E-10);
        ArcsSet.Split split3 = s35.split(new Arc(1.0, 6.0, 1.0E-10));
        ArcsSet split3Plus = split3.getPlus();
        ArcsSet split3Minus = split3.getMinus();
        Assert.assertNull((Object)split3Plus);
        Assert.assertEquals((double)2.0, (double)split3Minus.getSize(), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)split3Minus.asList().size());
        Assert.assertEquals((double)3.0, (double)((Arc)split3Minus.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)((Arc)split3Minus.asList().get(0)).getSup(), (double)1.0E-10);
        ArcsSet.Split split4 = s35.split(new Arc(6.0, 7.283185307179586, 1.0E-10));
        ArcsSet split4Plus = split4.getPlus();
        ArcsSet split4Minus = split4.getMinus();
        Assert.assertEquals((double)2.0, (double)split4Plus.getSize(), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)split4Plus.asList().size());
        Assert.assertEquals((double)3.0, (double)((Arc)split4Plus.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)((Arc)split4Plus.asList().get(0)).getSup(), (double)1.0E-10);
        Assert.assertNull((Object)split4Minus);
    }

    @Test
    public void testSplitOverlapping() {
        ArcsSet s35 = new ArcsSet(3.0, 5.0, 1.0E-10);
        ArcsSet s46 = new ArcsSet(4.0, 6.0, 1.0E-10);
        ArcsSet.Split split1 = s46.split(new Arc(3.0, 5.0, 1.0E-10));
        ArcsSet split1Plus = split1.getPlus();
        ArcsSet split1Minus = split1.getMinus();
        Assert.assertEquals((double)1.0, (double)split1Plus.getSize(), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)split1Plus.asList().size());
        Assert.assertEquals((double)5.0, (double)((Arc)split1Plus.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)6.0, (double)((Arc)split1Plus.asList().get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)split1Minus.getSize(), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)split1Minus.asList().size());
        Assert.assertEquals((double)4.0, (double)((Arc)split1Minus.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)((Arc)split1Minus.asList().get(0)).getSup(), (double)1.0E-10);
        ArcsSet.Split split2 = s46.split(new Arc(5.0, 9.283185307179586, 1.0E-10));
        ArcsSet split2Plus = split2.getPlus();
        ArcsSet split2Minus = split2.getMinus();
        Assert.assertEquals((double)1.0, (double)split2Plus.getSize(), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)split2Plus.asList().size());
        Assert.assertEquals((double)4.0, (double)((Arc)split2Plus.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)((Arc)split2Plus.asList().get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)split2Minus.getSize(), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)split2Minus.asList().size());
        Assert.assertEquals((double)5.0, (double)((Arc)split2Minus.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)6.0, (double)((Arc)split2Minus.asList().get(0)).getSup(), (double)1.0E-10);
        ArcsSet.Split split3 = s35.split(new Arc(4.0, 6.0, 1.0E-10));
        ArcsSet split3Plus = split3.getPlus();
        ArcsSet split3Minus = split3.getMinus();
        Assert.assertEquals((double)1.0, (double)split3Plus.getSize(), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)split3Plus.asList().size());
        Assert.assertEquals((double)3.0, (double)((Arc)split3Plus.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)4.0, (double)((Arc)split3Plus.asList().get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)split3Minus.getSize(), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)split3Minus.asList().size());
        Assert.assertEquals((double)4.0, (double)((Arc)split3Minus.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)((Arc)split3Minus.asList().get(0)).getSup(), (double)1.0E-10);
        ArcsSet.Split split4 = s35.split(new Arc(6.0, 10.283185307179586, 1.0E-10));
        ArcsSet split4Plus = split4.getPlus();
        ArcsSet split4Minus = split4.getMinus();
        Assert.assertEquals((double)1.0, (double)split4Plus.getSize(), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)split4Plus.asList().size());
        Assert.assertEquals((double)4.0, (double)((Arc)split4Plus.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)((Arc)split4Plus.asList().get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)split4Minus.getSize(), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)split4Minus.asList().size());
        Assert.assertEquals((double)3.0, (double)((Arc)split4Minus.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)4.0, (double)((Arc)split4Minus.asList().get(0)).getSup(), (double)1.0E-10);
    }

    @Test
    public void testFarSplit() {
        ArcsSet set = new ArcsSet(Math.PI, 7.853981633974483, 1.0E-10);
        ArcsSet.Split split = set.split(new Arc(1.5707963267948966, 4.71238898038469, 1.0E-10));
        ArcsSet splitPlus = split.getPlus();
        ArcsSet splitMinus = split.getMinus();
        Assert.assertEquals((long)1L, (long)splitMinus.asList().size());
        Assert.assertEquals((double)Math.PI, (double)((Arc)splitMinus.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)4.71238898038469, (double)((Arc)splitMinus.asList().get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)splitMinus.getSize(), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)splitPlus.asList().size());
        Assert.assertEquals((double)4.71238898038469, (double)((Arc)splitPlus.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)7.853981633974483, (double)((Arc)splitPlus.asList().get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)Math.PI, (double)splitPlus.getSize(), (double)1.0E-10);
    }

    @Test
    public void testSplitWithinEpsilon() {
        double epsilon = 1.0E-10;
        double a = 6.25;
        double b = a - 0.5 * epsilon;
        ArcsSet set = new ArcsSet(a - 1.0, a, epsilon);
        Arc arc = new Arc(b, b + Math.PI, epsilon);
        ArcsSet.Split split = set.split(arc);
        Assert.assertEquals((double)set.getSize(), (double)split.getPlus().getSize(), (double)epsilon);
        Assert.assertNull((Object)split.getMinus());
    }

    @Test
    public void testSideSplitConsistency() {
        double epsilon = 1.0E-6;
        double a = 4.725;
        ArcsSet set = new ArcsSet(a, a + 0.5, epsilon);
        Arc arc = new Arc(a + 0.5 * epsilon, a + 1.0, epsilon);
        ArcsSet.Split split = set.split(arc);
        Assert.assertNotNull((Object)split.getMinus());
        Assert.assertNull((Object)split.getPlus());
        Assert.assertEquals((Object)Side.MINUS, (Object)set.split(arc).getSide());
    }
}

