/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.oned;

import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.spherical.oned.LimitAngle;
import org.hipparchus.geometry.spherical.oned.S1Point;
import org.junit.Assert;
import org.junit.Test;

public class LimitAngleTest {
    @Test
    public void testReversedLimit() {
        for (int k = -2; k < 3; ++k) {
            LimitAngle l = new LimitAngle(new S1Point(1.0 + (double)k * (Math.PI * 2)), false, 1.0E-10);
            Assert.assertEquals((double)l.getLocation().getAlpha(), (double)l.getReverse().getLocation().getAlpha(), (double)1.0E-10);
            Assert.assertEquals((double)l.getTolerance(), (double)l.getReverse().getTolerance(), (double)1.0E-10);
            Assert.assertTrue((boolean)l.sameOrientationAs((Hyperplane)l));
            Assert.assertFalse((boolean)l.sameOrientationAs((Hyperplane)l.getReverse()));
            Assert.assertEquals((double)(Math.PI * 2), (double)l.wholeSpace().getSize(), (double)1.0E-10);
            Assert.assertEquals((double)(Math.PI * 2), (double)l.getReverse().wholeSpace().getSize(), (double)1.0E-10);
        }
    }
}

