/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.twod;

import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.partitioning.SubHyperplane;
import org.hipparchus.geometry.partitioning.Transform;
import org.hipparchus.geometry.spherical.oned.Arc;
import org.hipparchus.geometry.spherical.oned.LimitAngle;
import org.hipparchus.geometry.spherical.oned.S1Point;
import org.hipparchus.geometry.spherical.oned.SubLimitAngle;
import org.hipparchus.geometry.spherical.twod.Circle;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.UnitSphereRandomVectorGenerator;
import org.hipparchus.random.Well1024a;
import org.hipparchus.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class CircleTest {
    @Test
    public void testEquator() {
        Circle circle = new Circle(new Vector3D(0.0, 0.0, 1000.0), 1.0E-10).copySelf();
        Assert.assertEquals((Object)Vector3D.PLUS_K, (Object)circle.getPole());
        Assert.assertEquals((double)1.0E-10, (double)circle.getTolerance(), (double)1.0E-20);
        circle.revertSelf();
        Assert.assertEquals((Object)Vector3D.MINUS_K, (Object)circle.getPole());
        Assert.assertEquals((Object)Vector3D.PLUS_K, (Object)circle.getReverse().getPole());
        Assert.assertEquals((Object)Vector3D.MINUS_K, (Object)circle.getPole());
    }

    @Test
    public void testXY() {
        Circle circle = new Circle(new S2Point(1.2, 2.5), new S2Point(-4.3, 0.0), 1.0E-10);
        Assert.assertEquals((double)0.0, (double)circle.getPointAt(0.0).distance((Point)circle.getXAxis()), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)circle.getPointAt(1.5707963267948966).distance((Point)circle.getYAxis()), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)Vector3D.angle((Vector3D)circle.getXAxis(), (Vector3D)circle.getYAxis()), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)Vector3D.angle((Vector3D)circle.getXAxis(), (Vector3D)circle.getPole()), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)Vector3D.angle((Vector3D)circle.getPole(), (Vector3D)circle.getYAxis()), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)circle.getPole().distance((Point)Vector3D.crossProduct((Vector3D)circle.getXAxis(), (Vector3D)circle.getYAxis())), (double)1.0E-10);
    }

    @Test
    public void testReverse() {
        Circle circle = new Circle(new S2Point(1.2, 2.5), new S2Point(-4.3, 0.0), 1.0E-10);
        Circle reversed = circle.getReverse();
        Assert.assertEquals((double)0.0, (double)reversed.getPointAt(0.0).distance((Point)reversed.getXAxis()), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)reversed.getPointAt(1.5707963267948966).distance((Point)reversed.getYAxis()), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)Vector3D.angle((Vector3D)reversed.getXAxis(), (Vector3D)reversed.getYAxis()), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)Vector3D.angle((Vector3D)reversed.getXAxis(), (Vector3D)reversed.getPole()), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)Vector3D.angle((Vector3D)reversed.getPole(), (Vector3D)reversed.getYAxis()), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)reversed.getPole().distance((Point)Vector3D.crossProduct((Vector3D)reversed.getXAxis(), (Vector3D)reversed.getYAxis())), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)Vector3D.angle((Vector3D)circle.getXAxis(), (Vector3D)reversed.getXAxis()), (double)1.0E-10);
        Assert.assertEquals((double)Math.PI, (double)Vector3D.angle((Vector3D)circle.getYAxis(), (Vector3D)reversed.getYAxis()), (double)1.0E-10);
        Assert.assertEquals((double)Math.PI, (double)Vector3D.angle((Vector3D)circle.getPole(), (Vector3D)reversed.getPole()), (double)1.0E-10);
        Assert.assertTrue((boolean)circle.sameOrientationAs((Hyperplane)circle));
        Assert.assertFalse((boolean)circle.sameOrientationAs((Hyperplane)reversed));
    }

    @Test
    public void testPhase() {
        Circle circle = new Circle(new S2Point(1.2, 2.5), new S2Point(-4.3, 0.0), 1.0E-10);
        Vector3D p = new Vector3D(1.0, 2.0, -4.0);
        Vector3D samePhase = circle.getPointAt(circle.getPhase(p));
        Assert.assertEquals((double)0.0, (double)Vector3D.angle((Vector3D)Vector3D.crossProduct((Vector3D)circle.getPole(), (Vector3D)p), (Vector3D)Vector3D.crossProduct((Vector3D)circle.getPole(), (Vector3D)samePhase)), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)Vector3D.angle((Vector3D)circle.getPole(), (Vector3D)samePhase), (double)1.0E-10);
        Assert.assertEquals((double)circle.getPhase(p), (double)circle.getPhase(samePhase), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)circle.getPhase(circle.getXAxis()), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)circle.getPhase(circle.getYAxis()), (double)1.0E-10);
    }

    @Test
    public void testSubSpace() {
        Circle circle = new Circle(new S2Point(1.2, 2.5), new S2Point(-4.3, 0.0), 1.0E-10);
        Assert.assertEquals((double)0.0, (double)circle.toSubSpace((Point)new S2Point(circle.getXAxis())).getAlpha(), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)circle.toSubSpace((Point)new S2Point(circle.getYAxis())).getAlpha(), (double)1.0E-10);
        Vector3D p = new Vector3D(1.0, 2.0, -4.0);
        Assert.assertEquals((double)circle.getPhase(p), (double)circle.toSubSpace((Point)new S2Point(p)).getAlpha(), (double)1.0E-10);
    }

    @Test
    public void testSpace() {
        Circle circle = new Circle(new S2Point(1.2, 2.5), new S2Point(-4.3, 0.0), 1.0E-10);
        for (double alpha = 0.0; alpha < Math.PI * 2; alpha += 0.1) {
            Vector3D p = new Vector3D(FastMath.cos((double)alpha), circle.getXAxis(), FastMath.sin((double)alpha), circle.getYAxis());
            Vector3D q = circle.toSpace((Point)new S1Point(alpha)).getVector();
            Assert.assertEquals((double)0.0, (double)p.distance((Point)q), (double)1.0E-10);
            Assert.assertEquals((double)1.5707963267948966, (double)Vector3D.angle((Vector3D)circle.getPole(), (Vector3D)q), (double)1.0E-10);
        }
    }

    @Test
    public void testOffset() {
        Circle circle = new Circle(Vector3D.PLUS_K, 1.0E-10);
        Assert.assertEquals((double)0.0, (double)circle.getOffset((Point)new S2Point(Vector3D.PLUS_I)), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)circle.getOffset((Point)new S2Point(Vector3D.MINUS_I)), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)circle.getOffset((Point)new S2Point(Vector3D.PLUS_J)), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)circle.getOffset((Point)new S2Point(Vector3D.MINUS_J)), (double)1.0E-10);
        Assert.assertEquals((double)-1.5707963267948966, (double)circle.getOffset((Point)new S2Point(Vector3D.PLUS_K)), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)circle.getOffset((Point)new S2Point(Vector3D.MINUS_K)), (double)1.0E-10);
    }

    @Test
    public void testInsideArc() {
        Well1024a random = new Well1024a(-4624266002818155266L);
        UnitSphereRandomVectorGenerator sphRandom = new UnitSphereRandomVectorGenerator(3, (RandomGenerator)random);
        for (int i = 0; i < 100; ++i) {
            Circle c1 = new Circle(new Vector3D(sphRandom.nextVector()), 1.0E-10);
            Circle c2 = new Circle(new Vector3D(sphRandom.nextVector()), 1.0E-10);
            this.checkArcIsInside(c1, c2);
            this.checkArcIsInside(c2, c1);
        }
    }

    private void checkArcIsInside(Circle arcCircle, Circle otherCircle) {
        double alpha;
        Arc arc = arcCircle.getInsideArc(otherCircle);
        Assert.assertEquals((double)Math.PI, (double)arc.getSize(), (double)1.0E-10);
        for (alpha = arc.getInf(); alpha < arc.getSup(); alpha += 0.1) {
            Assert.assertTrue((otherCircle.getOffset(arcCircle.getPointAt(alpha)) <= 2.0E-15 ? 1 : 0) != 0);
        }
        for (alpha = arc.getSup(); alpha < arc.getInf() + Math.PI * 2; alpha += 0.1) {
            Assert.assertTrue((otherCircle.getOffset(arcCircle.getPointAt(alpha)) >= -2.0E-15 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTransform() {
        Well1024a random = new Well1024a(1628385259824083697L);
        UnitSphereRandomVectorGenerator sphRandom = new UnitSphereRandomVectorGenerator(3, (RandomGenerator)random);
        for (int i = 0; i < 100; ++i) {
            Rotation r = new Rotation(new Vector3D(sphRandom.nextVector()), Math.PI * random.nextDouble(), RotationConvention.VECTOR_OPERATOR);
            Transform t = Circle.getTransform((Rotation)r);
            S2Point p = new S2Point(new Vector3D(sphRandom.nextVector()));
            S2Point tp = (S2Point)t.apply((Point)p);
            Assert.assertEquals((double)0.0, (double)r.applyTo(p.getVector()).distance((Point)tp.getVector()), (double)1.0E-10);
            Circle c = new Circle(new Vector3D(sphRandom.nextVector()), 1.0E-10);
            Circle tc = (Circle)t.apply((Hyperplane)c);
            Assert.assertEquals((double)0.0, (double)r.applyTo(c.getPole()).distance((Point)tc.getPole()), (double)1.0E-10);
            Assert.assertEquals((double)0.0, (double)r.applyTo(c.getXAxis()).distance((Point)tc.getXAxis()), (double)1.0E-10);
            Assert.assertEquals((double)0.0, (double)r.applyTo(c.getYAxis()).distance((Point)tc.getYAxis()), (double)1.0E-10);
            Assert.assertEquals((double)c.getTolerance(), (double)((Circle)t.apply((Hyperplane)c)).getTolerance(), (double)1.0E-10);
            SubLimitAngle sub = new LimitAngle(new S1Point(Math.PI * 2 * random.nextDouble()), random.nextBoolean(), 1.0E-10).wholeHyperplane();
            Vector3D psub = c.getPointAt(((LimitAngle)sub.getHyperplane()).getLocation().getAlpha());
            SubLimitAngle tsub = (SubLimitAngle)t.apply((SubHyperplane)sub, (Hyperplane)c, (Hyperplane)tc);
            Vector3D ptsub = tc.getPointAt(((LimitAngle)tsub.getHyperplane()).getLocation().getAlpha());
            Assert.assertEquals((double)0.0, (double)r.applyTo(psub).distance((Point)ptsub), (double)1.0E-10);
        }
    }
}

