/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.twod;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.spherical.oned.Sphere1D;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class S2PointTest {
    @Test
    public void testS2Point() {
        for (int k = -2; k < 3; ++k) {
            S2Point p = new S2Point(1.0 + (double)k * (Math.PI * 2), 1.4);
            Assert.assertEquals((double)(1.0 + (double)k * (Math.PI * 2)), (double)p.getTheta(), (double)1.0E-10);
            Assert.assertEquals((double)1.4, (double)p.getPhi(), (double)1.0E-10);
            Assert.assertEquals((double)(FastMath.cos((double)1.0) * FastMath.sin((double)1.4)), (double)p.getVector().getX(), (double)1.0E-10);
            Assert.assertEquals((double)(FastMath.sin((double)1.0) * FastMath.sin((double)1.4)), (double)p.getVector().getY(), (double)1.0E-10);
            Assert.assertEquals((double)FastMath.cos((double)1.4), (double)p.getVector().getZ(), (double)1.0E-10);
            Assert.assertFalse((boolean)p.isNaN());
        }
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testNegativePolarAngle() {
        new S2Point(1.0, -1.0);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testTooLargePolarAngle() {
        new S2Point(1.0, 3.5);
    }

    @Test
    public void testNaN() {
        Assert.assertTrue((boolean)S2Point.NaN.isNaN());
        Assert.assertTrue((boolean)S2Point.NaN.equals((Object)new S2Point(Double.NaN, 1.0)));
        Assert.assertFalse((boolean)new S2Point(1.0, 1.3).equals((Object)S2Point.NaN));
    }

    @Test
    public void testEquals() {
        S2Point a = new S2Point(1.0, 1.0);
        S2Point b = new S2Point(1.0, 1.0);
        Assert.assertEquals((long)a.hashCode(), (long)b.hashCode());
        Assert.assertFalse((a == b ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a.equals((Object)b));
        Assert.assertTrue((boolean)a.equals((Object)a));
        Assert.assertFalse((boolean)a.equals((Object)Character.valueOf('a')));
    }

    @Test
    public void testDistance() {
        S2Point a = new S2Point(1.0, 1.5707963267948966);
        S2Point b = new S2Point(a.getTheta() + 1.5707963267948966, a.getPhi());
        Assert.assertEquals((double)1.5707963267948966, (double)a.distance((Point)b), (double)1.0E-10);
        Assert.assertEquals((double)Math.PI, (double)a.distance((Point)a.negate()), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)S2Point.MINUS_I.distance((Point)S2Point.MINUS_K), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)new S2Point(1.0, 0.0).distance((Point)new S2Point(2.0, 0.0)), (double)1.0E-10);
    }

    @Test
    public void testSpace() {
        S2Point a = new S2Point(1.0, 1.0);
        Assert.assertTrue((boolean)(a.getSpace() instanceof Sphere2D));
        Assert.assertEquals((long)2L, (long)a.getSpace().getDimension());
        Assert.assertTrue((boolean)(a.getSpace().getSubSpace() instanceof Sphere1D));
    }
}

