/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.partitioning;

import java.util.Formatter;
import java.util.Locale;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.oned.Euclidean1D;
import org.hipparchus.geometry.euclidean.oned.IntervalsSet;
import org.hipparchus.geometry.euclidean.oned.OrientedPoint;
import org.hipparchus.geometry.euclidean.oned.Vector1D;
import org.hipparchus.geometry.euclidean.threed.Euclidean3D;
import org.hipparchus.geometry.euclidean.threed.Plane;
import org.hipparchus.geometry.euclidean.threed.PolyhedronsSet;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Euclidean2D;
import org.hipparchus.geometry.euclidean.twod.Line;
import org.hipparchus.geometry.euclidean.twod.PolygonsSet;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.BSPTreeVisitor;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.spherical.oned.ArcsSet;
import org.hipparchus.geometry.spherical.oned.LimitAngle;
import org.hipparchus.geometry.spherical.oned.Sphere1D;
import org.hipparchus.geometry.spherical.twod.Circle;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.geometry.spherical.twod.SphericalPolygonsSet;

public class RegionDumper {
    private RegionDumper() {
    }

    public static String dump(ArcsSet arcsSet) {
        TreeDumper<Sphere1D> visitor = new TreeDumper<Sphere1D>("ArcsSet", arcsSet.getTolerance()){

            @Override
            protected void formatHyperplane(Hyperplane<Sphere1D> hyperplane) {
                LimitAngle h = (LimitAngle)hyperplane;
                this.getFormatter().format("%22.15e %b %22.15e", h.getLocation().getAlpha(), h.isDirect(), h.getTolerance());
            }
        };
        arcsSet.getTree(false).visit((BSPTreeVisitor)visitor);
        return visitor.getDump();
    }

    public static String dump(SphericalPolygonsSet sphericalPolygonsSet) {
        TreeDumper<Sphere2D> visitor = new TreeDumper<Sphere2D>("SphericalPolygonsSet", sphericalPolygonsSet.getTolerance()){

            @Override
            protected void formatHyperplane(Hyperplane<Sphere2D> hyperplane) {
                Circle h = (Circle)hyperplane;
                this.getFormatter().format("%22.15e %22.15e %22.15e %22.15e", h.getPole().getX(), h.getPole().getY(), h.getPole().getZ(), h.getTolerance());
            }
        };
        sphericalPolygonsSet.getTree(false).visit((BSPTreeVisitor)visitor);
        return visitor.getDump();
    }

    public static String dump(IntervalsSet intervalsSet) {
        TreeDumper<Euclidean1D> visitor = new TreeDumper<Euclidean1D>("IntervalsSet", intervalsSet.getTolerance()){

            @Override
            protected void formatHyperplane(Hyperplane<Euclidean1D> hyperplane) {
                OrientedPoint h = (OrientedPoint)hyperplane;
                this.getFormatter().format("%22.15e %b %22.15e", h.getLocation().getX(), h.isDirect(), h.getTolerance());
            }
        };
        intervalsSet.getTree(false).visit((BSPTreeVisitor)visitor);
        return visitor.getDump();
    }

    public static String dump(PolygonsSet polygonsSet) {
        TreeDumper<Euclidean2D> visitor = new TreeDumper<Euclidean2D>("PolygonsSet", polygonsSet.getTolerance()){

            @Override
            protected void formatHyperplane(Hyperplane<Euclidean2D> hyperplane) {
                Line h = (Line)hyperplane;
                Vector2D p = h.toSpace((Vector)Vector1D.ZERO);
                this.getFormatter().format("%22.15e %22.15e %22.15e %22.15e", p.getX(), p.getY(), h.getAngle(), h.getTolerance());
            }
        };
        polygonsSet.getTree(false).visit((BSPTreeVisitor)visitor);
        return visitor.getDump();
    }

    public static String dump(PolyhedronsSet polyhedronsSet) {
        TreeDumper<Euclidean3D> visitor = new TreeDumper<Euclidean3D>("PolyhedronsSet", polyhedronsSet.getTolerance()){

            @Override
            protected void formatHyperplane(Hyperplane<Euclidean3D> hyperplane) {
                Plane h = (Plane)hyperplane;
                Vector3D p = h.toSpace((Vector)Vector2D.ZERO);
                this.getFormatter().format("%22.15e %22.15e %22.15e %22.15e %22.15e %22.15e %22.15e", p.getX(), p.getY(), p.getZ(), h.getNormal().getX(), h.getNormal().getY(), h.getNormal().getZ(), h.getTolerance());
            }
        };
        polyhedronsSet.getTree(false).visit((BSPTreeVisitor)visitor);
        return visitor.getDump();
    }

    private static abstract class TreeDumper<S extends Space>
    implements BSPTreeVisitor<S> {
        private final StringBuilder dump = new StringBuilder();
        private final Formatter formatter = new Formatter(this.dump, Locale.US);
        private String prefix = "";

        public TreeDumper(String type, double tolerance) {
            this.formatter.format("%s%n", type);
            this.formatter.format("tolerance %22.15e%n", tolerance);
        }

        public String getDump() {
            return this.dump.toString();
        }

        protected Formatter getFormatter() {
            return this.formatter;
        }

        protected abstract void formatHyperplane(Hyperplane<S> var1);

        public BSPTreeVisitor.Order visitOrder(BSPTree<S> node) {
            return BSPTreeVisitor.Order.SUB_MINUS_PLUS;
        }

        public void visitInternalNode(BSPTree<S> node) {
            this.formatter.format("%s %s internal ", this.prefix, this.type(node));
            this.formatHyperplane(node.getCut().getHyperplane());
            this.formatter.format("%n", new Object[0]);
            this.prefix = this.prefix + "  ";
        }

        public void visitLeafNode(BSPTree<S> node) {
            this.formatter.format("%s %s leaf %s%n", this.prefix, this.type(node), node.getAttribute());
            for (BSPTree n = node; n.getParent() != null && n == n.getParent().getPlus(); n = n.getParent()) {
                this.prefix = this.prefix.substring(0, this.prefix.length() - 2);
            }
        }

        private String type(BSPTree<S> node) {
            return node.getParent() != null && node == node.getParent().getMinus() ? "minus" : "plus ";
        }
    }
}

