/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.oned;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.spherical.oned.Arc;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class ArcTest {
    @Test
    public void testArc() {
        Arc arc = new Arc(2.3, 5.7, 1.0E-10);
        Assert.assertEquals((double)3.4, (double)arc.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)4.0, (double)arc.getBarycenter(), (double)1.0E-10);
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)arc.checkPoint(2.3));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)arc.checkPoint(5.7));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)arc.checkPoint(1.2));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)arc.checkPoint(8.5));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)arc.checkPoint(8.7));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)arc.checkPoint(3.0));
        Assert.assertEquals((double)2.3, (double)arc.getInf(), (double)1.0E-10);
        Assert.assertEquals((double)5.7, (double)arc.getSup(), (double)1.0E-10);
        Assert.assertEquals((double)4.0, (double)arc.getBarycenter(), (double)1.0E-10);
        Assert.assertEquals((double)3.4, (double)arc.getSize(), (double)1.0E-10);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testWrongInterval() {
        new Arc(1.2, 0.0, 1.0E-10);
    }

    @Test
    public void testTolerance() {
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)new Arc(2.3, 5.7, 1.0).checkPoint(1.2));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)new Arc(2.3, 5.7, 1.2).checkPoint(1.2));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)new Arc(2.3, 5.7, 0.7).checkPoint(6.5));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)new Arc(2.3, 5.7, 0.9).checkPoint(6.5));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)new Arc(2.3, 5.7, 0.6).checkPoint(3.0));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)new Arc(2.3, 5.7, 0.8).checkPoint(3.0));
    }

    @Test
    public void testFullCircle() {
        Arc arc = new Arc(9.0, 9.0, 1.0E-10);
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)arc.checkPoint(9.0));
        Assert.assertEquals((double)0.0, (double)arc.getInf(), (double)1.0E-10);
        Assert.assertEquals((double)(Math.PI * 2), (double)arc.getSup(), (double)1.0E-10);
        Assert.assertEquals((double)(Math.PI * 2), (double)arc.getSize(), (double)1.0E-10);
        for (double alpha = -20.0; alpha <= 20.0; alpha += 0.1) {
            Assert.assertEquals((Object)Region.Location.INSIDE, (Object)arc.checkPoint(alpha));
        }
    }

    @Test
    public void testSmall() {
        Arc arc = new Arc(1.0, FastMath.nextAfter((double)1.0, (double)Double.POSITIVE_INFINITY), Precision.EPSILON);
        Assert.assertEquals((double)(2.0 * Precision.EPSILON), (double)arc.getSize(), (double)Precision.SAFE_MIN);
        Assert.assertEquals((double)1.0, (double)arc.getBarycenter(), (double)Precision.EPSILON);
    }
}

