/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.oned;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;

public class Arc {
    private final double lower;
    private final double upper;
    private final double middle;
    private final double tolerance;

    public Arc(double lower, double upper, double tolerance) throws MathIllegalArgumentException {
        this.tolerance = tolerance;
        if (Precision.equals((double)lower, (double)upper, (int)0) || upper - lower >= Math.PI * 2) {
            this.lower = 0.0;
            this.upper = Math.PI * 2;
            this.middle = Math.PI;
        } else if (lower <= upper) {
            this.lower = MathUtils.normalizeAngle((double)lower, (double)Math.PI);
            this.upper = this.lower + (upper - lower);
            this.middle = 0.5 * (this.lower + this.upper);
        } else {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.ENDPOINTS_NOT_AN_INTERVAL, new Object[]{lower, upper, true});
        }
    }

    public double getInf() {
        return this.lower;
    }

    public double getSup() {
        return this.upper;
    }

    public double getSize() {
        return this.upper - this.lower;
    }

    public double getBarycenter() {
        return this.middle;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public Region.Location checkPoint(double point) {
        double normalizedPoint = MathUtils.normalizeAngle((double)point, (double)this.middle);
        if (normalizedPoint < this.lower - this.tolerance || normalizedPoint > this.upper + this.tolerance) {
            return Region.Location.OUTSIDE;
        }
        if (normalizedPoint > this.lower + this.tolerance && normalizedPoint < this.upper - this.tolerance) {
            return Region.Location.INSIDE;
        }
        return this.getSize() >= Math.PI * 2 - this.tolerance ? Region.Location.INSIDE : Region.Location.BOUNDARY;
    }
}

