/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.enclosing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.enclosing.EnclosingBall;
import org.hipparchus.geometry.enclosing.SupportBallGenerator;
import org.hipparchus.geometry.enclosing.WelzlEncloser;
import org.hipparchus.geometry.euclidean.threed.Euclidean3D;
import org.hipparchus.geometry.euclidean.threed.SphereGenerator;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.UnitSphereRandomVectorGenerator;
import org.hipparchus.random.Well1024a;
import org.junit.Assert;
import org.junit.Test;

public class WelzlEncloser3DTest {
    @Test
    public void testNullList() {
        SphereGenerator generator = new SphereGenerator();
        WelzlEncloser encloser = new WelzlEncloser(1.0E-10, (SupportBallGenerator)generator);
        EnclosingBall ball = encloser.enclose(null);
        Assert.assertTrue((ball.getRadius() < 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testNoPoints() {
        SphereGenerator generator = new SphereGenerator();
        WelzlEncloser encloser = new WelzlEncloser(1.0E-10, (SupportBallGenerator)generator);
        EnclosingBall ball = encloser.enclose(new ArrayList());
        Assert.assertTrue((ball.getRadius() < 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testReducingBall() {
        WelzlEncloser encloser = new WelzlEncloser(1.0E-10, (SupportBallGenerator)new SphereGenerator());
        List<Vector3D> list = Arrays.asList(new Vector3D(-7.140397329568118, -16.571661242582177, 11.714458961735405), new Vector3D(-7.137986707455888, -16.57076732337572, 11.708602108715928), new Vector3D(-7.139185068549035, -16.57089120470225, 11.715554057357394), new Vector3D(-7.142682716997507, -16.57160981823429, 11.710787934580328), new Vector3D(-7.139018392423351, -16.57440561415702, 11.710518716711425), new Vector3D(-7.14087065993673, -16.567993074240455, 11.710914678204503), new Vector3D(-7.136350173659562, -16.57049822882093, 11.713965225900928), new Vector3D(-7.141675762759172, -16.572852471407028, 11.714033471449508), new Vector3D(-7.140453077221105, -16.570212820780647, 11.70862457800498), new Vector3D(-7.140322188726825, -16.574152894557717, 11.71030561112141), new Vector3D(-7.141116131477088, -16.57406116462456, 11.712938509321699));
        EnclosingBall ball = encloser.enclose(list);
        Assert.assertTrue((ball.getRadius() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testInfiniteLoop() {
        WelzlEncloser encloser = new WelzlEncloser(1.0E-10, (SupportBallGenerator)new SphereGenerator());
        List<Vector3D> list = Arrays.asList(new Vector3D(-0.8922707551216438, -2.893176946457139, 14.845723237433555), new Vector3D(-0.9209949894069358, -2.3108610826390894, 12.920710264676883), new Vector3D(-0.852279994110052, -3.0631473144132073, 15.40163831651287), new Vector3D(-1.7739941302078597, -3.6563039137811426, 14.131900977518734), new Vector3D(0.33157833272465354, -2.2281359175779216, 14.212252341590082), new Vector3D(-1.530655791654844, -1.6569208477013957, 14.614830557147885), new Vector3D(-1.0845709394121714, -1.9610032593560298, 13.09265170575555), new Vector3D(0.3002946958970885, -3.0547083139566737, 14.563524004263426), new Vector3D(-0.9500744393863846, -1.8681094648611836, 15.14491234340057), new Vector3D(-1.8966150380413083, -2.1700408088518586, 14.81235128513927), new Vector3D(-0.7219332876160753, -1.4451314283361827, 14.523557242185618), new Vector3D(-0.2689598093960655, -3.6951237152208414, 14.72272846327652), new Vector3D(-1.5350169343178617, -3.250551666110219, 15.155090625842748), new Vector3D(-0.7172755353551941, -3.622842794607991, 13.262567009293807), new Vector3D(-0.30220950676137365, -3.2541041250077907, 13.13682612771606), new Vector3D(-0.04543996608267075, -1.9308185392379775, 14.794979978831714), new Vector3D(-1.5334889295157164, -3.666889197035249, 14.730956008120742), new Vector3D(-0.9803489953393582, -3.3400448116276396, 13.032450140175568));
        EnclosingBall ball = encloser.enclose(list);
        Assert.assertTrue((ball.getRadius() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testLargeSamples() throws IOException {
        Well1024a random = new Well1024a(3881519022953668125L);
        UnitSphereRandomVectorGenerator sr = new UnitSphereRandomVectorGenerator(3, (RandomGenerator)random);
        for (int k = 0; k < 50; ++k) {
            double d = 25.0 * random.nextDouble();
            double refRadius = 10.0 * random.nextDouble();
            Vector3D refCenter = new Vector3D(d, new Vector3D(sr.nextVector()));
            int nbPoints = random.nextInt(1000);
            ArrayList<Vector3D> points = new ArrayList<Vector3D>();
            for (int i = 0; i < nbPoints; ++i) {
                double r = refRadius * random.nextDouble();
                points.add(new Vector3D(1.0, refCenter, r, new Vector3D(sr.nextVector())));
            }
            this.checkSphere(points, refRadius);
        }
    }

    @Test
    public void testIssue20Generator() {
        SphereGenerator generator = new SphereGenerator();
        Vector3D p1 = new Vector3D(0.9987716667, 0.0350821284, 0.0349914572);
        Vector3D p2 = new Vector3D(0.9987856181, -0.0346743952, 0.0349996489);
        Vector3D p4 = new Vector3D(0.9987798601, 0.0350739383, -0.0347650673);
        EnclosingBall s24 = generator.ballOnSupport(Arrays.asList(p2, p4));
        EnclosingBall s142 = generator.ballOnSupport(Arrays.asList(p1, p4, p2));
        Assert.assertFalse((boolean)s24.contains((Point)p1));
        Assert.assertTrue((boolean)s24.contains((Point)p2));
        Assert.assertTrue((boolean)s24.contains((Point)p4));
        Assert.assertTrue((boolean)s142.contains((Point)p1));
        Assert.assertTrue((boolean)s142.contains((Point)p4));
        Assert.assertTrue((boolean)s142.contains((Point)p2));
        Assert.assertTrue((s142.getRadius() >= s24.getRadius() ? 1 : 0) != 0);
    }

    @Test
    public void testIssue20Encloser() {
        WelzlEncloser encloser = new WelzlEncloser(1.0E-14, (SupportBallGenerator)new SphereGenerator());
        ArrayList<Vector3D> points = new ArrayList<Vector3D>();
        points.add(new Vector3D(0.9999999731, 2.00015E-4, 1.174338E-4));
        points.add(new Vector3D(0.9987716667, 0.0350821284, 0.0349914572));
        points.add(new Vector3D(0.9987856181, -0.0346743952, 0.0349996489));
        points.add(new Vector3D(0.9987938115, -0.0346825853, -0.0347568755));
        points.add(new Vector3D(0.9987798601, 0.0350739383, -0.0347650673));
        EnclosingBall enclosing3D = encloser.enclose(points);
        Assert.assertEquals((double)0.04932531217754311, (double)enclosing3D.getRadius(), (double)1.0E-15);
        for (Vector3D p : points) {
            Assert.assertTrue((boolean)enclosing3D.contains((Point)p));
        }
    }

    private void checkSphere(List<Vector3D> points, double refRadius) {
        EnclosingBall<Euclidean3D, Vector3D> sphere = this.checkSphere(points);
        Assert.assertTrue((sphere.getRadius() <= refRadius ? 1 : 0) != 0);
        for (int i = 0; i < sphere.getSupportSize(); ++i) {
            ArrayList<Vector3D> reducedSupport = new ArrayList<Vector3D>();
            int count = 0;
            for (Vector3D s : (Vector3D[])sphere.getSupport()) {
                if (count++ == i) continue;
                reducedSupport.add(s);
            }
            EnclosingBall reducedSphere = new SphereGenerator().ballOnSupport(reducedSupport);
            boolean foundOutside = false;
            for (int j = 0; j < points.size() && !foundOutside; ++j) {
                if (reducedSphere.contains((Point)points.get(j), 1.0E-10)) continue;
                foundOutside = true;
            }
            Assert.assertTrue((boolean)foundOutside);
        }
    }

    private EnclosingBall<Euclidean3D, Vector3D> checkSphere(List<Vector3D> points) {
        WelzlEncloser encloser = new WelzlEncloser(1.0E-10, (SupportBallGenerator)new SphereGenerator());
        EnclosingBall Sphere = encloser.enclose(points);
        for (Vector3D v : points) {
            Assert.assertTrue((boolean)Sphere.contains((Point)v, 1.0E-10));
        }
        for (Vector3D v : points) {
            boolean inSupport = false;
            for (Vector3D s : (Vector3D[])Sphere.getSupport()) {
                if (v != s) continue;
                inSupport = true;
            }
            if (!inSupport) continue;
            Assert.assertFalse((boolean)Sphere.contains((Point)v, -0.001));
        }
        return Sphere;
    }
}

