/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.oned;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.oned.Interval;
import org.hipparchus.geometry.euclidean.oned.IntervalsSet;
import org.hipparchus.geometry.euclidean.oned.OrientedPoint;
import org.hipparchus.geometry.euclidean.oned.Vector1D;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.RegionFactory;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class IntervalsSetTest {
    @Test
    public void testInterval() {
        IntervalsSet set = new IntervalsSet(Arrays.asList(new OrientedPoint(new Vector1D(2.3), false, 1.0E-10).wholeHyperplane(), new OrientedPoint(new Vector1D(5.7), true, 1.0E-10).wholeHyperplane()), 1.0E-10);
        Assert.assertEquals((double)3.4, (double)set.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)4.0, (double)((Vector1D)set.getBarycenter()).getX(), (double)1.0E-10);
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)set.checkPoint((Vector)new Vector1D(2.3)));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)set.checkPoint((Vector)new Vector1D(5.7)));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)set.checkPoint((Vector)new Vector1D(1.2)));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)set.checkPoint((Vector)new Vector1D(8.7)));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Vector)new Vector1D(3.0)));
        Assert.assertEquals((double)2.3, (double)set.getInf(), (double)1.0E-10);
        Assert.assertEquals((double)5.7, (double)set.getSup(), (double)1.0E-10);
        OrientedPoint op = (OrientedPoint)set.getTree(false).getCut().getHyperplane();
        Assert.assertEquals((double)0.0, (double)op.emptyHyperplane().getSize(), (double)1.0E-10);
        Assert.assertEquals((double)1.0E-10, (double)op.getTolerance(), (double)1.0E-20);
        Assert.assertTrue((boolean)Double.isInfinite(op.wholeSpace().getSize()));
        Assert.assertEquals((double)2.3, (double)op.getLocation().getX(), (double)1.0E-10);
        Assert.assertEquals((double)-0.7, (double)op.getOffset((Vector)new Vector1D(3.0)), (double)1.0E-10);
        Assert.assertSame((Object)op.getLocation(), (Object)op.project((Point)new Vector1D(3.0)));
        op.revertSelf();
        Assert.assertEquals((double)0.7, (double)op.getOffset((Vector)new Vector1D(3.0)), (double)1.0E-10);
    }

    @Test
    public void testNoBoundaries() {
        IntervalsSet set = new IntervalsSet(new ArrayList(), 1.0E-10);
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Vector)new Vector1D(-1.7976931348623157E308)));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Vector)new Vector1D(Double.MAX_VALUE)));
        Assert.assertTrue((boolean)Double.isInfinite(set.getSize()));
    }

    @Test
    public void testInfinite() {
        IntervalsSet set = new IntervalsSet(9.0, Double.POSITIVE_INFINITY, 1.0E-10);
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)set.checkPoint((Vector)new Vector1D(9.0)));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)set.checkPoint((Vector)new Vector1D(8.4)));
        for (double e = 1.0; e <= 6.0; e += 1.0) {
            Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Vector)new Vector1D(FastMath.pow((double)10.0, (double)e))));
        }
        Assert.assertTrue((boolean)Double.isInfinite(set.getSize()));
        Assert.assertEquals((double)9.0, (double)set.getInf(), (double)1.0E-10);
        Assert.assertTrue((boolean)Double.isInfinite(set.getSup()));
        set = (IntervalsSet)new RegionFactory().getComplement((Region)set);
        Assert.assertEquals((double)9.0, (double)set.getSup(), (double)1.0E-10);
        Assert.assertTrue((boolean)Double.isInfinite(set.getInf()));
    }

    @Test
    public void testMultiple() {
        RegionFactory factory = new RegionFactory();
        IntervalsSet set = (IntervalsSet)factory.intersection(factory.union(factory.difference((Region)new IntervalsSet(1.0, 6.0, 1.0E-10), (Region)new IntervalsSet(3.0, 5.0, 1.0E-10)), (Region)new IntervalsSet(9.0, Double.POSITIVE_INFINITY, 1.0E-10)), (Region)new IntervalsSet(Double.NEGATIVE_INFINITY, 11.0, 1.0E-10));
        Assert.assertEquals((double)5.0, (double)set.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)5.9, (double)((Vector1D)set.getBarycenter()).getX(), (double)1.0E-10);
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)set.checkPoint((Vector)new Vector1D(0.0)));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)set.checkPoint((Vector)new Vector1D(4.0)));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)set.checkPoint((Vector)new Vector1D(8.0)));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)set.checkPoint((Vector)new Vector1D(12.0)));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Vector)new Vector1D(1.2)));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Vector)new Vector1D(5.9)));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)set.checkPoint((Vector)new Vector1D(9.01)));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)set.checkPoint((Vector)new Vector1D(5.0)));
        Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)set.checkPoint((Vector)new Vector1D(11.0)));
        Assert.assertEquals((double)1.0, (double)set.getInf(), (double)1.0E-10);
        Assert.assertEquals((double)11.0, (double)set.getSup(), (double)1.0E-10);
        List list = set.asList();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((double)1.0, (double)((Interval)list.get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)((Interval)list.get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)((Interval)list.get(1)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)6.0, (double)((Interval)list.get(1)).getSup(), (double)1.0E-10);
        Assert.assertEquals((double)9.0, (double)((Interval)list.get(2)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)11.0, (double)((Interval)list.get(2)).getSup(), (double)1.0E-10);
    }

    @Test
    public void testSinglePoint() {
        IntervalsSet set = new IntervalsSet(1.0, 1.0, 1.0E-10);
        Assert.assertEquals((double)0.0, (double)set.getSize(), (double)Precision.SAFE_MIN);
        Assert.assertEquals((double)1.0, (double)((Vector1D)set.getBarycenter()).getX(), (double)Precision.EPSILON);
        try {
            set.iterator().remove();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

