/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.threed;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.euclidean.threed.FieldLine;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.Decimal64;
import org.hipparchus.util.Decimal64Field;
import org.hipparchus.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class FieldLineTest {
    @Test
    public void testContains() throws MathIllegalArgumentException, MathRuntimeException {
        FieldVector3D p1 = FieldVector3D.getPlusK((Field)Decimal64Field.getInstance());
        FieldLine l = new FieldLine(p1, new FieldVector3D((RealFieldElement)new Decimal64(0.0), (RealFieldElement)new Decimal64(0.0), (RealFieldElement)new Decimal64(2.0)), 1.0E-10);
        Assert.assertTrue((boolean)l.contains(p1));
        Assert.assertTrue((boolean)l.contains(new FieldVector3D(1.0, p1, 0.3, l.getDirection())));
        Assert.assertTrue((boolean)l.contains(new Vector3D(1.0, p1.toVector3D(), 0.3, l.getDirection().toVector3D())));
        FieldVector3D u = l.getDirection().orthogonal();
        FieldVector3D v = FieldVector3D.crossProduct((FieldVector3D)l.getDirection(), (FieldVector3D)u);
        for (double a = 0.0; a < Math.PI * 2; a += 0.3) {
            Decimal64 alpha = new Decimal64(a);
            Assert.assertTrue((!l.contains(p1.add(new FieldVector3D((RealFieldElement)alpha.cos(), u, (RealFieldElement)alpha.sin(), v))) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSimilar() throws MathIllegalArgumentException, MathRuntimeException {
        FieldVector3D<Decimal64> p1 = this.createVector(1.2, 3.4, -5.8);
        FieldVector3D<Decimal64> p2 = this.createVector(3.4, -5.8, 1.2);
        FieldLine lA = new FieldLine(p1, p2, 1.0E-10);
        FieldLine lB = new FieldLine(p2, p1, 1.0E-10);
        Assert.assertTrue((boolean)lA.isSimilarTo(lB));
        Assert.assertTrue((!lA.isSimilarTo(new FieldLine(p1, p1.add(lA.getDirection().orthogonal()), 1.0E-10)) ? 1 : 0) != 0);
    }

    @Test
    public void testPointDistance() throws MathIllegalArgumentException {
        FieldLine l = new FieldLine(this.createVector(0.0, 1.0, 1.0), this.createVector(0.0, 2.0, 2.0), 1.0E-10);
        Assert.assertEquals((double)FastMath.sqrt((double)1.5), (double)((Decimal64)l.distance(this.createVector(1.0, 0.0, 1.0))).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.distance(this.createVector(0.0, -4.0, -4.0))).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)1.0E-10, (double)l.getTolerance(), (double)1.0E-20);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.getAbscissa(Vector3D.ZERO)).getReal(), (double)1.0E-20);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.getAbscissa(FieldVector3D.getZero((Field)Decimal64Field.getInstance()))).getReal(), (double)1.0E-20);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.getOrigin().getX()).getReal(), (double)1.0E-20);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.getOrigin().getY()).getReal(), (double)1.0E-20);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.getOrigin().getZ()).getReal(), (double)1.0E-20);
        Assert.assertEquals((double)0.0, (double)l.pointAt((RealFieldElement)new Decimal64(1.0)).toVector3D().getX(), (double)1.0E-20);
        Assert.assertEquals((double)(0.5 * FastMath.sqrt((double)2.0)), (double)l.pointAt((RealFieldElement)new Decimal64(1.0)).toVector3D().getY(), (double)1.0E-15);
        Assert.assertEquals((double)(0.5 * FastMath.sqrt((double)2.0)), (double)l.pointAt((RealFieldElement)new Decimal64(1.0)).toVector3D().getZ(), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)l.pointAt(1.0).toVector3D().getX(), (double)1.0E-20);
        Assert.assertEquals((double)(0.5 * FastMath.sqrt((double)2.0)), (double)l.pointAt(1.0).toVector3D().getY(), (double)1.0E-15);
        Assert.assertEquals((double)(0.5 * FastMath.sqrt((double)2.0)), (double)l.pointAt(1.0).toVector3D().getZ(), (double)1.0E-15);
    }

    @Test
    public void testLineDistance() throws MathIllegalArgumentException {
        FieldLine l = new FieldLine(this.createVector(0.0, 1.0, 1.0), this.createVector(0.0, 2.0, 2.0), 1.0E-10);
        Assert.assertEquals((double)1.0, (double)((Decimal64)l.distance(new FieldLine(this.createVector(1.0, 0.0, 1.0), this.createVector(1.0, 0.0, 2.0), 1.0E-10))).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.5, (double)((Decimal64)l.distance(new FieldLine(this.createVector(-0.5, 0.0, 0.0), this.createVector(-0.5, -1.0, -1.0), 1.0E-10))).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.distance(l)).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.distance(new FieldLine(this.createVector(0.0, -4.0, -4.0), this.createVector(0.0, -5.0, -5.0), 1.0E-10))).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.distance(new FieldLine(this.createVector(0.0, -4.0, -4.0), this.createVector(0.0, -3.0, -4.0), 1.0E-10))).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.distance(new FieldLine(this.createVector(0.0, -4.0, -4.0), this.createVector(1.0, -4.0, -4.0), 1.0E-10))).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)FastMath.sqrt((double)8.0), (double)((Decimal64)l.distance(new FieldLine(this.createVector(0.0, -4.0, 0.0), this.createVector(1.0, -4.0, 0.0), 1.0E-10))).getReal(), (double)1.0E-10);
    }

    @Test
    public void testClosest() throws MathIllegalArgumentException {
        FieldLine l = new FieldLine(this.createVector(0.0, 1.0, 1.0), this.createVector(0.0, 2.0, 2.0), 1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.closestPoint(new FieldLine(this.createVector(1.0, 0.0, 1.0), this.createVector(1.0, 0.0, 2.0), 1.0E-10)).distance(this.createVector(0.0, 0.0, 0.0))).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.5, (double)((Decimal64)l.closestPoint(new FieldLine(this.createVector(-0.5, 0.0, 0.0), this.createVector(-0.5, -1.0, -1.0), 1.0E-10)).distance(this.createVector(-0.5, 0.0, 0.0))).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.closestPoint(l).distance(this.createVector(0.0, 0.0, 0.0))).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.closestPoint(new FieldLine(this.createVector(0.0, -4.0, -4.0), this.createVector(0.0, -5.0, -5.0), 1.0E-10)).distance(this.createVector(0.0, 0.0, 0.0))).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.closestPoint(new FieldLine(this.createVector(0.0, -4.0, -4.0), this.createVector(0.0, -3.0, -4.0), 1.0E-10)).distance(this.createVector(0.0, -4.0, -4.0))).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.closestPoint(new FieldLine(this.createVector(0.0, -4.0, -4.0), this.createVector(1.0, -4.0, -4.0), 1.0E-10)).distance(this.createVector(0.0, -4.0, -4.0))).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.closestPoint(new FieldLine(this.createVector(0.0, -4.0, 0.0), this.createVector(1.0, -4.0, 0.0), 1.0E-10)).distance(this.createVector(0.0, -2.0, -2.0))).getReal(), (double)1.0E-10);
    }

    @Test
    public void testIntersection() throws MathIllegalArgumentException {
        FieldLine l = new FieldLine(this.createVector(0.0, 1.0, 1.0), this.createVector(0.0, 2.0, 2.0), 1.0E-10);
        Assert.assertNull((Object)l.intersection(new FieldLine(this.createVector(1.0, 0.0, 1.0), this.createVector(1.0, 0.0, 2.0), 1.0E-10)));
        Assert.assertNull((Object)l.intersection(new FieldLine(this.createVector(-0.5, 0.0, 0.0), this.createVector(-0.5, -1.0, -1.0), 1.0E-10)));
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.intersection(l).distance(this.createVector(0.0, 0.0, 0.0))).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.intersection(new FieldLine(this.createVector(0.0, -4.0, -4.0), this.createVector(0.0, -5.0, -5.0), 1.0E-10)).distance(this.createVector(0.0, 0.0, 0.0))).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.intersection(new FieldLine(this.createVector(0.0, -4.0, -4.0), this.createVector(0.0, -3.0, -4.0), 1.0E-10)).distance(this.createVector(0.0, -4.0, -4.0))).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)((Decimal64)l.intersection(new FieldLine(this.createVector(0.0, -4.0, -4.0), this.createVector(1.0, -4.0, -4.0), 1.0E-10)).distance(this.createVector(0.0, -4.0, -4.0))).getReal(), (double)1.0E-10);
        Assert.assertNull((Object)l.intersection(new FieldLine(this.createVector(0.0, -4.0, 0.0), this.createVector(1.0, -4.0, 0.0), 1.0E-10)));
    }

    @Test
    public void testRevert() {
        FieldLine line = new FieldLine(this.createVector(1653345.6696423641, 6170370.041579291, 90000.0), this.createVector(1650757.5050732433, 6160710.879908984, 0.9), 1.0E-10);
        FieldVector3D expected = line.getDirection().negate();
        FieldLine reverted = line.revert();
        Decimal64[] e = (Decimal64[])expected.toArray();
        Decimal64[] r = (Decimal64[])reverted.getDirection().toArray();
        Assert.assertEquals((long)e.length, (long)e.length);
        for (int i = 0; i < e.length; ++i) {
            Assert.assertEquals((double)e[i].getReal(), (double)r[i].getReal(), (double)1.0E-10);
        }
    }

    private FieldVector3D<Decimal64> createVector(double x, double y, double z) {
        return new FieldVector3D((RealFieldElement)new Decimal64(x), (RealFieldElement)new Decimal64(y), (RealFieldElement)new Decimal64(z));
    }
}

