/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.threed;

import org.hipparchus.geometry.euclidean.threed.OutlineExtractor;
import org.hipparchus.geometry.euclidean.threed.PolyhedronsSet;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.RegionFactory;
import org.hipparchus.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class OutlineExtractorTest {
    @Test
    public void testBox() {
        PolyhedronsSet tree = new PolyhedronsSet(0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0E-10);
        Assert.assertEquals((double)1.0, (double)tree.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)6.0, (double)tree.getBoundarySize(), (double)1.0E-10);
        Vector2D[][] outline = new OutlineExtractor(Vector3D.PLUS_I, Vector3D.PLUS_J).getOutline(tree);
        Assert.assertEquals((long)1L, (long)outline.length);
        Assert.assertEquals((long)4L, (long)outline[0].length);
        Vector2D[] expected = new Vector2D[]{new Vector2D(0.0, 0.0), new Vector2D(0.0, 1.0), new Vector2D(1.0, 1.0), new Vector2D(1.0, 0.0)};
        for (Vector2D vertex : outline[0]) {
            for (int j = 0; j < expected.length; ++j) {
                if (expected[j] == null || !(Vector2D.distance((Vector2D)vertex, (Vector2D)expected[j]) < 1.0E-10)) continue;
                expected[j] = null;
            }
        }
        for (Vector2D e : expected) {
            Assert.assertNull((Object)e);
        }
        Rotation r = new Rotation(Vector3D.PLUS_I, Vector3D.PLUS_J, new Vector3D(1.0, 1.0, 0.0), new Vector3D(0.0, 1.0, 1.0));
        Vector2D[][] outlineSkew = new OutlineExtractor(r.applyTo(Vector3D.PLUS_I), r.applyTo(Vector3D.PLUS_J)).getOutline(tree);
        Assert.assertEquals((long)1L, (long)outlineSkew.length);
        int n = outlineSkew[0].length;
        Assert.assertEquals((long)6L, (long)n);
        for (int i = 0; i < n; ++i) {
            Vector2D v1 = outlineSkew[0][i];
            Vector2D v2 = outlineSkew[0][(i + n - 1) % n];
            Assert.assertEquals((double)FastMath.sqrt((double)0.6666666666666666), (double)Vector2D.distance((Vector2D)v1, (Vector2D)v2), (double)1.0E-10);
        }
    }

    @Test
    public void testHolesInFacet() {
        double tolerance = 1.0E-10;
        PolyhedronsSet cube = new PolyhedronsSet(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0, tolerance);
        PolyhedronsSet tubeAlongX = new PolyhedronsSet(-2.0, 2.0, -0.5, 0.5, -0.5, 0.5, tolerance);
        PolyhedronsSet tubeAlongY = new PolyhedronsSet(-0.5, 0.5, -2.0, 2.0, -0.5, 0.5, tolerance);
        PolyhedronsSet tubeAlongZ = new PolyhedronsSet(-0.5, 0.5, -0.5, 0.5, -2.0, 2.0, tolerance);
        RegionFactory factory = new RegionFactory();
        PolyhedronsSet cubeWithHoles = (PolyhedronsSet)factory.difference((Region)cube, factory.union((Region)tubeAlongX, factory.union((Region)tubeAlongY, (Region)tubeAlongZ)));
        Assert.assertEquals((double)4.0, (double)cubeWithHoles.getSize(), (double)1.0E-10);
        Vector2D[][] outline = new OutlineExtractor(Vector3D.PLUS_I, Vector3D.PLUS_J).getOutline(cubeWithHoles);
        Assert.assertEquals((long)2L, (long)outline.length);
        Assert.assertEquals((long)4L, (long)outline[0].length);
        Assert.assertEquals((long)4L, (long)outline[1].length);
    }
}

