/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.twod;

import java.text.NumberFormat;
import java.util.Locale;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.euclidean.twod.FieldVector2D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.util.Decimal64Field;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.SinCos;
import org.junit.Assert;
import org.junit.Test;

public class FieldVector2DTest {
    @Test
    public void testConstructors() {
        this.doTestConstructors((Field)Decimal64Field.getInstance());
    }

    @Test
    public void testConstants() {
        this.doTestConstants((Field)Decimal64Field.getInstance());
    }

    @Test
    public void testToMethods() {
        this.doTestToMethods((Field)Decimal64Field.getInstance());
    }

    @Test
    public void testNorms() {
        this.doTestNorms((Field)Decimal64Field.getInstance());
    }

    @Test
    public void testDistances() {
        this.doTestDistances((Field)Decimal64Field.getInstance());
    }

    @Test
    public void testAdd() {
        this.doTestAdd((Field)Decimal64Field.getInstance());
    }

    @Test
    public void testSubtract() {
        this.doTestSubtract((Field)Decimal64Field.getInstance());
    }

    @Test
    public void testNormalize() {
        this.doTestNormalize((Field)Decimal64Field.getInstance());
    }

    @Test
    public void testAngle() {
        this.doTestAngle((Field)Decimal64Field.getInstance());
    }

    @Test
    public void testNegate() {
        this.doTestNegate((Field)Decimal64Field.getInstance());
    }

    @Test
    public void testScalarMultiply() {
        this.doTestScalarMultiply((Field)Decimal64Field.getInstance());
    }

    @Test
    public void testIsNaN() {
        this.doTestIsNaN((Field)Decimal64Field.getInstance());
    }

    @Test
    public void testIsInfinite() {
        this.doTestIsInfinite((Field)Decimal64Field.getInstance());
    }

    @Test
    public void testEquals() {
        this.doTestEquals((Field)Decimal64Field.getInstance());
    }

    @Test
    public void testHashCode() {
        this.doTestHashCode((Field)Decimal64Field.getInstance());
    }

    @Test
    public void testCrossProduct() {
        this.doTestCrossProduct((Field)Decimal64Field.getInstance());
    }

    @Test
    public void testOrientation() {
        this.doTestOrientation((Field)Decimal64Field.getInstance());
    }

    private <T extends RealFieldElement<T>> void doTestConstructors(Field<T> field) {
        RealFieldElement p40 = (RealFieldElement)((RealFieldElement)field.getZero()).add(4.0);
        RealFieldElement p20 = (RealFieldElement)((RealFieldElement)field.getZero()).add(2.0);
        RealFieldElement p25 = (RealFieldElement)((RealFieldElement)field.getZero()).add(2.5);
        RealFieldElement p10 = (RealFieldElement)field.getOne();
        RealFieldElement m05 = (RealFieldElement)((RealFieldElement)field.getZero()).add(-0.5);
        RealFieldElement m30 = (RealFieldElement)((RealFieldElement)field.getZero()).add(-3.0);
        this.check(new FieldVector2D(p25, m05), 2.5, -0.5, 1.0E-15);
        RealFieldElement[] a = (RealFieldElement[])MathArrays.buildArray(field, (int)2);
        a[0] = (RealFieldElement)field.getOne();
        a[1] = (RealFieldElement)field.getZero();
        this.check(new FieldVector2D(a), 1.0, 0.0, 1.0E-15);
        try {
            new FieldVector2D((RealFieldElement[])MathArrays.buildArray(field, (int)3));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException miae) {
            Assert.assertEquals((Object)LocalizedCoreFormats.DIMENSIONS_MISMATCH, (Object)miae.getSpecifier());
            Assert.assertEquals((long)3L, (long)((Integer)miae.getParts()[0]).intValue());
            Assert.assertEquals((long)2L, (long)((Integer)miae.getParts()[1]).intValue());
        }
        this.check(new FieldVector2D(p20, new FieldVector2D(p25, m05)), 5.0, -1.0, 1.0E-15);
        this.check(new FieldVector2D(p20, new Vector2D(2.5, -0.5)), 5.0, -1.0, 1.0E-15);
        this.check(new FieldVector2D(2.0, new FieldVector2D(p25, m05)), 5.0, -1.0, 1.0E-15);
        this.check(new FieldVector2D(p20, new FieldVector2D(p25, m05), m30, new FieldVector2D(m05, p40)), 6.5, -13.0, 1.0E-15);
        this.check(new FieldVector2D(p20, new Vector2D(2.5, -0.5), m30, new Vector2D(-0.5, 4.0)), 6.5, -13.0, 1.0E-15);
        this.check(new FieldVector2D(2.0, new FieldVector2D(p25, m05), -3.0, new FieldVector2D(m05, p40)), 6.5, -13.0, 1.0E-15);
        this.check(new FieldVector2D(p20, new FieldVector2D(p25, m05), m30, new FieldVector2D(m05, p40), p40, new FieldVector2D(p25, m30)), 16.5, -25.0, 1.0E-15);
        this.check(new FieldVector2D(p20, new Vector2D(2.5, -0.5), m30, new Vector2D(-0.5, 4.0), p40, new Vector2D(2.5, -3.0)), 16.5, -25.0, 1.0E-15);
        this.check(new FieldVector2D(2.0, new FieldVector2D(p25, m05), -3.0, new FieldVector2D(m05, p40), 4.0, new FieldVector2D(p25, m30)), 16.5, -25.0, 1.0E-15);
        this.check(new FieldVector2D(p20, new FieldVector2D(p25, m05), m30, new FieldVector2D(m05, p40), p40, new FieldVector2D(p25, m30), p10, new FieldVector2D(p10, p10)), 17.5, -24.0, 1.0E-15);
        this.check(new FieldVector2D(p20, new Vector2D(2.5, -0.5), m30, new Vector2D(-0.5, 4.0), p40, new Vector2D(2.5, -3.0), p10, new Vector2D(1.0, 1.0)), 17.5, -24.0, 1.0E-15);
        this.check(new FieldVector2D(2.0, new FieldVector2D(p25, m05), -3.0, new FieldVector2D(m05, p40), 4.0, new FieldVector2D(p25, m30), 1.0, new FieldVector2D(p10, p10)), 17.5, -24.0, 1.0E-15);
    }

    private <T extends RealFieldElement<T>> void doTestConstants(Field<T> field) {
        this.check(FieldVector2D.getZero(field), 0.0, 0.0, 1.0E-15);
        this.check(FieldVector2D.getPlusI(field), 1.0, 0.0, 1.0E-15);
        this.check(FieldVector2D.getMinusI(field), -1.0, 0.0, 1.0E-15);
        this.check(FieldVector2D.getPlusJ(field), 0.0, 1.0, 1.0E-15);
        this.check(FieldVector2D.getMinusJ(field), 0.0, -1.0, 1.0E-15);
        this.check(FieldVector2D.getPositiveInfinity(field), Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0E-15);
        this.check(FieldVector2D.getNegativeInfinity(field), Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, 1.0E-15);
        Assert.assertTrue((boolean)Double.isNaN(FieldVector2D.getNaN(field).getX().getReal()));
        Assert.assertTrue((boolean)Double.isNaN(FieldVector2D.getNaN(field).getY().getReal()));
    }

    private <T extends RealFieldElement<T>> void doTestToMethods(Field<T> field) {
        FieldVector2D v = new FieldVector2D(field, new Vector2D(2.5, -0.5));
        Assert.assertEquals((long)2L, (long)v.toArray().length);
        Assert.assertEquals((double)2.5, (double)v.toArray()[0].getReal(), (double)1.0E-15);
        Assert.assertEquals((double)-0.5, (double)v.toArray()[1].getReal(), (double)1.0E-15);
        Assert.assertEquals((Object)new Vector2D(2.5, -0.5), (Object)v.toVector2D());
        Assert.assertEquals((Object)"{2.5; -0.5}", (Object)v.toString().replaceAll(",", "."));
        Assert.assertEquals((Object)"{2,5; -0,5}", (Object)v.toString(NumberFormat.getInstance(Locale.FRENCH)));
    }

    private <T extends RealFieldElement<T>> void doTestNorms(Field<T> field) {
        FieldVector2D v = new FieldVector2D(field, new Vector2D(3.0, -4.0));
        Assert.assertEquals((double)7.0, (double)v.getNorm1().getReal(), (double)1.0E-15);
        Assert.assertEquals((double)5.0, (double)v.getNorm().getReal(), (double)1.0E-15);
        Assert.assertEquals((double)25.0, (double)v.getNormSq().getReal(), (double)1.0E-15);
        Assert.assertEquals((double)4.0, (double)v.getNormInf().getReal(), (double)1.0E-15);
    }

    private <T extends RealFieldElement<T>> void doTestDistances(Field<T> field) {
        FieldVector2D u = new FieldVector2D(field, new Vector2D(2.0, -2.0));
        FieldVector2D v = new FieldVector2D(field, new Vector2D(-1.0, 2.0));
        Assert.assertEquals((double)7.0, (double)FieldVector2D.distance1((FieldVector2D)u, (FieldVector2D)v).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)5.0, (double)FieldVector2D.distance((FieldVector2D)u, (FieldVector2D)v).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)25.0, (double)FieldVector2D.distanceSq((FieldVector2D)u, (FieldVector2D)v).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)4.0, (double)FieldVector2D.distanceInf((FieldVector2D)u, (FieldVector2D)v).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)7.0, (double)FieldVector2D.distance1((FieldVector2D)u, (Vector2D)v.toVector2D()).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)5.0, (double)FieldVector2D.distance((FieldVector2D)u, (Vector2D)v.toVector2D()).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)25.0, (double)FieldVector2D.distanceSq((FieldVector2D)u, (Vector2D)v.toVector2D()).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)4.0, (double)FieldVector2D.distanceInf((FieldVector2D)u, (Vector2D)v.toVector2D()).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)7.0, (double)FieldVector2D.distance1((Vector2D)u.toVector2D(), (FieldVector2D)v).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)5.0, (double)FieldVector2D.distance((Vector2D)u.toVector2D(), (FieldVector2D)v).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)25.0, (double)FieldVector2D.distanceSq((Vector2D)u.toVector2D(), (FieldVector2D)v).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)4.0, (double)FieldVector2D.distanceInf((Vector2D)u.toVector2D(), (FieldVector2D)v).getReal(), (double)1.0E-15);
    }

    private <T extends RealFieldElement<T>> void doTestAdd(Field<T> field) {
        FieldVector2D u = new FieldVector2D(field, new Vector2D(2.0, -2.0));
        FieldVector2D v = new FieldVector2D(field, new Vector2D(-1.0, 2.0));
        this.check(u.add(v), 1.0, 0.0, 1.0E-15);
        this.check(u.add(v.toVector2D()), 1.0, 0.0, 1.0E-15);
        this.check(u.add((RealFieldElement)((RealFieldElement)field.getZero()).add(5.0), v), -3.0, 8.0, 1.0E-15);
        this.check(u.add((RealFieldElement)((RealFieldElement)field.getZero()).add(5.0), v.toVector2D()), -3.0, 8.0, 1.0E-15);
        this.check(u.add(5.0, v), -3.0, 8.0, 1.0E-15);
        this.check(u.add(5.0, v.toVector2D()), -3.0, 8.0, 1.0E-15);
    }

    private <T extends RealFieldElement<T>> void doTestSubtract(Field<T> field) {
        FieldVector2D u = new FieldVector2D(field, new Vector2D(2.0, -2.0));
        FieldVector2D v = new FieldVector2D(field, new Vector2D(1.0, -2.0));
        this.check(u.subtract(v), 1.0, 0.0, 1.0E-15);
        this.check(u.subtract(v.toVector2D()), 1.0, 0.0, 1.0E-15);
        this.check(u.subtract((RealFieldElement)((RealFieldElement)field.getZero()).add(5.0), v), -3.0, 8.0, 1.0E-15);
        this.check(u.subtract((RealFieldElement)((RealFieldElement)field.getZero()).add(5.0), v.toVector2D()), -3.0, 8.0, 1.0E-15);
        this.check(u.subtract(5.0, v), -3.0, 8.0, 1.0E-15);
        this.check(u.subtract(5.0, v.toVector2D()), -3.0, 8.0, 1.0E-15);
    }

    private <T extends RealFieldElement<T>> void doTestNormalize(Field<T> field) {
        try {
            FieldVector2D.getZero(field).normalize();
            Assert.fail((String)"an exception should habe been thrown");
        }
        catch (MathRuntimeException mre) {
            Assert.assertEquals((Object)LocalizedGeometryFormats.CANNOT_NORMALIZE_A_ZERO_NORM_VECTOR, (Object)mre.getSpecifier());
        }
        this.check(new FieldVector2D(field, new Vector2D(3.0, -4.0)).normalize(), 0.6, -0.8, 1.0E-15);
    }

    private <T extends RealFieldElement<T>> void doTestAngle(Field<T> field) {
        try {
            FieldVector2D.angle((FieldVector2D)FieldVector2D.getZero(field), (FieldVector2D)FieldVector2D.getPlusI(field));
            Assert.fail((String)"an exception should habe been thrown");
        }
        catch (MathRuntimeException mre) {
            Assert.assertEquals((Object)LocalizedCoreFormats.ZERO_NORM, (Object)mre.getSpecifier());
        }
        double alpha = 0.01;
        SinCos sc = FastMath.sinCos((double)0.01);
        Assert.assertEquals((double)0.01, (double)FieldVector2D.angle((FieldVector2D)new FieldVector2D(field, new Vector2D(sc.cos(), sc.sin())), (FieldVector2D)FieldVector2D.getPlusI(field)).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)3.1315926535897933, (double)FieldVector2D.angle((FieldVector2D)new FieldVector2D(field, new Vector2D(-sc.cos(), sc.sin())), (FieldVector2D)FieldVector2D.getPlusI(field)).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)1.5607963267948965, (double)FieldVector2D.angle((FieldVector2D)new FieldVector2D(field, new Vector2D(sc.sin(), sc.cos())), (FieldVector2D)FieldVector2D.getPlusI(field)).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)1.5807963267948966, (double)FieldVector2D.angle((FieldVector2D)new FieldVector2D(field, new Vector2D(-sc.sin(), sc.cos())), (FieldVector2D)FieldVector2D.getPlusI(field)).getReal(), (double)1.0E-15);
        try {
            FieldVector2D.angle((FieldVector2D)FieldVector2D.getZero(field), (Vector2D)Vector2D.PLUS_I);
            Assert.fail((String)"an exception should habe been thrown");
        }
        catch (MathRuntimeException mre) {
            Assert.assertEquals((Object)LocalizedCoreFormats.ZERO_NORM, (Object)mre.getSpecifier());
        }
        Assert.assertEquals((double)0.01, (double)FieldVector2D.angle((FieldVector2D)new FieldVector2D(field, new Vector2D(sc.cos(), sc.sin())), (Vector2D)Vector2D.PLUS_I).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)3.1315926535897933, (double)FieldVector2D.angle((FieldVector2D)new FieldVector2D(field, new Vector2D(-sc.cos(), sc.sin())), (Vector2D)Vector2D.PLUS_I).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)1.5607963267948965, (double)FieldVector2D.angle((FieldVector2D)new FieldVector2D(field, new Vector2D(sc.sin(), sc.cos())), (Vector2D)Vector2D.PLUS_I).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)1.5807963267948966, (double)FieldVector2D.angle((FieldVector2D)new FieldVector2D(field, new Vector2D(-sc.sin(), sc.cos())), (Vector2D)Vector2D.PLUS_I).getReal(), (double)1.0E-15);
        try {
            FieldVector2D.angle((Vector2D)Vector2D.ZERO, (FieldVector2D)FieldVector2D.getPlusI(field));
            Assert.fail((String)"an exception should habe been thrown");
        }
        catch (MathRuntimeException mre) {
            Assert.assertEquals((Object)LocalizedCoreFormats.ZERO_NORM, (Object)mre.getSpecifier());
        }
        Assert.assertEquals((double)0.01, (double)FieldVector2D.angle((Vector2D)new Vector2D(sc.cos(), sc.sin()), (FieldVector2D)FieldVector2D.getPlusI(field)).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)3.1315926535897933, (double)FieldVector2D.angle((Vector2D)new Vector2D(-sc.cos(), sc.sin()), (FieldVector2D)FieldVector2D.getPlusI(field)).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)1.5607963267948965, (double)FieldVector2D.angle((Vector2D)new Vector2D(sc.sin(), sc.cos()), (FieldVector2D)FieldVector2D.getPlusI(field)).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)1.5807963267948966, (double)FieldVector2D.angle((Vector2D)new Vector2D(-sc.sin(), sc.cos()), (FieldVector2D)FieldVector2D.getPlusI(field)).getReal(), (double)1.0E-15);
    }

    private <T extends RealFieldElement<T>> void doTestNegate(Field<T> field) {
        this.check(new FieldVector2D(field, new Vector2D(3.0, -4.0)).negate(), -3.0, 4.0, 1.0E-15);
    }

    private <T extends RealFieldElement<T>> void doTestScalarMultiply(Field<T> field) {
        this.check(new FieldVector2D(field, new Vector2D(3.0, -4.0)).scalarMultiply(2.0), 6.0, -8.0, 1.0E-15);
        this.check(new FieldVector2D(field, new Vector2D(3.0, -4.0)).scalarMultiply((RealFieldElement)((RealFieldElement)field.getZero()).add(2.0)), 6.0, -8.0, 1.0E-15);
    }

    private <T extends RealFieldElement<T>> void doTestIsNaN(Field<T> field) {
        Assert.assertTrue((boolean)new FieldVector2D(field, new Vector2D(Double.NaN, 0.0)).isNaN());
        Assert.assertTrue((boolean)new FieldVector2D(field, new Vector2D(0.0, Double.NaN)).isNaN());
        Assert.assertTrue((boolean)new FieldVector2D(field, new Vector2D(Double.NaN, Double.NaN)).isNaN());
        Assert.assertTrue((boolean)FieldVector2D.getNaN(field).isNaN());
        Assert.assertFalse((boolean)new FieldVector2D(field, new Vector2D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY)).isNaN());
        Assert.assertFalse((boolean)FieldVector2D.getMinusI(field).isNaN());
    }

    private <T extends RealFieldElement<T>> void doTestIsInfinite(Field<T> field) {
        Assert.assertFalse((boolean)new FieldVector2D(field, new Vector2D(Double.NaN, 0.0)).isInfinite());
        Assert.assertTrue((boolean)new FieldVector2D(field, new Vector2D(Double.POSITIVE_INFINITY, 0.0)).isInfinite());
        Assert.assertTrue((boolean)new FieldVector2D(field, new Vector2D(0.0, Double.POSITIVE_INFINITY)).isInfinite());
        Assert.assertTrue((boolean)new FieldVector2D(field, new Vector2D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY)).isInfinite());
        Assert.assertTrue((boolean)new FieldVector2D(field, new Vector2D(Double.NEGATIVE_INFINITY, 0.0)).isInfinite());
        Assert.assertTrue((boolean)new FieldVector2D(field, new Vector2D(0.0, Double.NEGATIVE_INFINITY)).isInfinite());
        Assert.assertTrue((boolean)new FieldVector2D(field, new Vector2D(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY)).isInfinite());
        Assert.assertFalse((boolean)FieldVector2D.getNaN(field).isInfinite());
        Assert.assertFalse((boolean)FieldVector2D.getMinusI(field).isInfinite());
    }

    private <T extends RealFieldElement<T>> void doTestEquals(Field<T> field) {
        FieldVector2D u1 = new FieldVector2D(field, Vector2D.PLUS_I);
        FieldVector2D u2 = new FieldVector2D(field, Vector2D.MINUS_I.negate());
        FieldVector2D v1 = new FieldVector2D(field, new Vector2D(1.0, 0.001));
        FieldVector2D v2 = new FieldVector2D(field, new Vector2D(0.001, 1.0));
        Assert.assertEquals((Object)u1, (Object)u1);
        Assert.assertEquals((Object)u1, (Object)u2);
        Assert.assertNotEquals((Object)u1, (Object)v1);
        Assert.assertNotEquals((Object)u1, (Object)v2);
        Assert.assertNotEquals((Object)u1, (Object)Vector2D.PLUS_I);
        Assert.assertEquals((Object)u1.toVector2D(), (Object)Vector2D.PLUS_I);
        Assert.assertEquals((Object)new FieldVector2D(Double.NaN, u1), (Object)FieldVector2D.getNaN(field));
        Assert.assertNotEquals((Object)u1, (Object)FieldVector2D.getNaN(field));
        Assert.assertNotEquals((Object)FieldVector2D.getNaN(field), (Object)v2);
    }

    private <T extends RealFieldElement<T>> void doTestHashCode(Field<T> field) {
        Assert.assertEquals((long)542L, (long)FieldVector2D.getNaN(field).hashCode());
        Assert.assertEquals((long)0x4F000000L, (long)new FieldVector2D(field, new Vector2D(1.5, -0.5)).hashCode());
    }

    private <T extends RealFieldElement<T>> void doTestCrossProduct(Field<T> field) {
        double epsilon = 1.0E-10;
        FieldVector2D p1 = new FieldVector2D(field, new Vector2D(1.0, 1.0));
        FieldVector2D p2 = new FieldVector2D(field, new Vector2D(2.0, 2.0));
        FieldVector2D p3 = new FieldVector2D(field, new Vector2D(3.0, 3.0));
        Assert.assertEquals((double)0.0, (double)p3.crossProduct(p1, p2).getReal(), (double)1.0E-10);
        FieldVector2D p4 = new FieldVector2D(field, new Vector2D(1.0, 2.0));
        Assert.assertEquals((double)1.0, (double)p4.crossProduct(p1, p2).getReal(), (double)1.0E-10);
        FieldVector2D p5 = new FieldVector2D(field, new Vector2D(2.0, 1.0));
        Assert.assertEquals((double)-1.0, (double)p5.crossProduct(p1, p2).getReal(), (double)1.0E-10);
        Assert.assertEquals((double)-1.0, (double)p5.crossProduct(p1.toVector2D(), p2.toVector2D()).getReal(), (double)1.0E-10);
    }

    private <T extends RealFieldElement<T>> void doTestOrientation(Field<T> field) {
        Assert.assertTrue((FieldVector2D.orientation((FieldVector2D)new FieldVector2D(field, new Vector2D(0.0, 0.0)), (FieldVector2D)new FieldVector2D(field, new Vector2D(1.0, 0.0)), (FieldVector2D)new FieldVector2D(field, new Vector2D(1.0, 1.0))).getReal() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((FieldVector2D.orientation((FieldVector2D)new FieldVector2D(field, new Vector2D(1.0, 0.0)), (FieldVector2D)new FieldVector2D(field, new Vector2D(0.0, 0.0)), (FieldVector2D)new FieldVector2D(field, new Vector2D(1.0, 1.0))).getReal() < 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)FieldVector2D.orientation((FieldVector2D)new FieldVector2D(field, new Vector2D(0.0, 0.0)), (FieldVector2D)new FieldVector2D(field, new Vector2D(1.0, 0.0)), (FieldVector2D)new FieldVector2D(field, new Vector2D(1.0, 0.0))).getReal(), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)FieldVector2D.orientation((FieldVector2D)new FieldVector2D(field, new Vector2D(0.0, 0.0)), (FieldVector2D)new FieldVector2D(field, new Vector2D(1.0, 0.0)), (FieldVector2D)new FieldVector2D(field, new Vector2D(2.0, 0.0))).getReal(), (double)1.0E-15);
    }

    private <T extends RealFieldElement<T>> void check(FieldVector2D<T> v, double x, double y, double tol) {
        Assert.assertEquals((double)x, (double)v.getX().getReal(), (double)tol);
        Assert.assertEquals((double)y, (double)v.getY().getReal(), (double)tol);
    }
}

