/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.twod;

import java.util.List;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.euclidean.oned.IntervalsSet;
import org.hipparchus.geometry.euclidean.twod.Line;
import org.hipparchus.geometry.euclidean.twod.Segment;
import org.hipparchus.geometry.euclidean.twod.SubLine;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.RegionFactory;
import org.junit.Assert;
import org.junit.Test;

public class SubLineTest {
    @Test
    public void testEndPoints() {
        Vector2D p1 = new Vector2D(-1.0, -7.0);
        Vector2D p2 = new Vector2D(7.0, -1.0);
        Segment segment = new Segment(p1, p2, new Line(p1, p2, 1.0E-10));
        SubLine sub = new SubLine(segment);
        List segments = sub.getSegments();
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals((double)0.0, (double)new Vector2D(-1.0, -7.0).distance((Point)((Segment)segments.get(0)).getStart()), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)new Vector2D(7.0, -1.0).distance((Point)((Segment)segments.get(0)).getEnd()), (double)1.0E-10);
    }

    @Test
    public void testNoEndPoints() {
        SubLine wholeLine = new Line(new Vector2D(-1.0, 7.0), new Vector2D(7.0, 1.0), 1.0E-10).wholeHyperplane();
        List segments = wholeLine.getSegments();
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getStart().getX()) && ((Segment)segments.get(0)).getStart().getX() < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getStart().getY()) && ((Segment)segments.get(0)).getStart().getY() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getEnd().getX()) && ((Segment)segments.get(0)).getEnd().getX() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getEnd().getY()) && ((Segment)segments.get(0)).getEnd().getY() < 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testNoSegments() {
        SubLine empty = new SubLine((Hyperplane)new Line(new Vector2D(-1.0, -7.0), new Vector2D(7.0, -1.0), 1.0E-10), new RegionFactory().getComplement((Region)new IntervalsSet(1.0E-10)));
        List segments = empty.getSegments();
        Assert.assertEquals((long)0L, (long)segments.size());
    }

    @Test
    public void testSeveralSegments() {
        SubLine twoSubs = new SubLine((Hyperplane)new Line(new Vector2D(-1.0, -7.0), new Vector2D(7.0, -1.0), 1.0E-10), new RegionFactory().union((Region)new IntervalsSet(1.0, 2.0, 1.0E-10), (Region)new IntervalsSet(3.0, 4.0, 1.0E-10)));
        List segments = twoSubs.getSegments();
        Assert.assertEquals((long)2L, (long)segments.size());
    }

    @Test
    public void testHalfInfiniteNeg() {
        SubLine empty = new SubLine((Hyperplane)new Line(new Vector2D(-1.0, -7.0), new Vector2D(7.0, -1.0), 1.0E-10), (Region)new IntervalsSet(Double.NEGATIVE_INFINITY, 0.0, 1.0E-10));
        List segments = empty.getSegments();
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getStart().getX()) && ((Segment)segments.get(0)).getStart().getX() < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getStart().getY()) && ((Segment)segments.get(0)).getStart().getY() < 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)new Vector2D(3.0, -4.0).distance((Point)((Segment)segments.get(0)).getEnd()), (double)1.0E-10);
    }

    @Test
    public void testHalfInfinitePos() {
        SubLine empty = new SubLine((Hyperplane)new Line(new Vector2D(-1.0, -7.0), new Vector2D(7.0, -1.0), 1.0E-10), (Region)new IntervalsSet(0.0, Double.POSITIVE_INFINITY, 1.0E-10));
        List segments = empty.getSegments();
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals((double)0.0, (double)new Vector2D(3.0, -4.0).distance((Point)((Segment)segments.get(0)).getStart()), (double)1.0E-10);
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getEnd().getX()) && ((Segment)segments.get(0)).getEnd().getX() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getEnd().getY()) && ((Segment)segments.get(0)).getEnd().getY() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testIntersectionInsideInside() {
        SubLine sub1 = new SubLine(new Vector2D(1.0, 1.0), new Vector2D(3.0, 1.0), 1.0E-10);
        SubLine sub2 = new SubLine(new Vector2D(2.0, 0.0), new Vector2D(2.0, 2.0), 1.0E-10);
        Assert.assertEquals((double)0.0, (double)new Vector2D(2.0, 1.0).distance((Point)sub1.intersection(sub2, true)), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)new Vector2D(2.0, 1.0).distance((Point)sub1.intersection(sub2, false)), (double)1.0E-12);
    }

    @Test
    public void testIntersectionInsideBoundary() {
        SubLine sub1 = new SubLine(new Vector2D(1.0, 1.0), new Vector2D(3.0, 1.0), 1.0E-10);
        SubLine sub2 = new SubLine(new Vector2D(2.0, 0.0), new Vector2D(2.0, 1.0), 1.0E-10);
        Assert.assertEquals((double)0.0, (double)new Vector2D(2.0, 1.0).distance((Point)sub1.intersection(sub2, true)), (double)1.0E-12);
        Assert.assertNull((Object)sub1.intersection(sub2, false));
    }

    @Test
    public void testIntersectionInsideOutside() {
        SubLine sub1 = new SubLine(new Vector2D(1.0, 1.0), new Vector2D(3.0, 1.0), 1.0E-10);
        SubLine sub2 = new SubLine(new Vector2D(2.0, 0.0), new Vector2D(2.0, 0.5), 1.0E-10);
        Assert.assertNull((Object)sub1.intersection(sub2, true));
        Assert.assertNull((Object)sub1.intersection(sub2, false));
    }

    @Test
    public void testIntersectionBoundaryBoundary() {
        SubLine sub1 = new SubLine(new Vector2D(1.0, 1.0), new Vector2D(2.0, 1.0), 1.0E-10);
        SubLine sub2 = new SubLine(new Vector2D(2.0, 0.0), new Vector2D(2.0, 1.0), 1.0E-10);
        Assert.assertEquals((double)0.0, (double)new Vector2D(2.0, 1.0).distance((Point)sub1.intersection(sub2, true)), (double)1.0E-12);
        Assert.assertNull((Object)sub1.intersection(sub2, false));
    }

    @Test
    public void testIntersectionBoundaryOutside() {
        SubLine sub1 = new SubLine(new Vector2D(1.0, 1.0), new Vector2D(2.0, 1.0), 1.0E-10);
        SubLine sub2 = new SubLine(new Vector2D(2.0, 0.0), new Vector2D(2.0, 0.5), 1.0E-10);
        Assert.assertNull((Object)sub1.intersection(sub2, true));
        Assert.assertNull((Object)sub1.intersection(sub2, false));
    }

    @Test
    public void testIntersectionOutsideOutside() {
        SubLine sub1 = new SubLine(new Vector2D(1.0, 1.0), new Vector2D(1.5, 1.0), 1.0E-10);
        SubLine sub2 = new SubLine(new Vector2D(2.0, 0.0), new Vector2D(2.0, 0.5), 1.0E-10);
        Assert.assertNull((Object)sub1.intersection(sub2, true));
        Assert.assertNull((Object)sub1.intersection(sub2, false));
    }

    @Test
    public void testIntersectionParallel() {
        SubLine sub1 = new SubLine(new Vector2D(0.0, 1.0), new Vector2D(0.0, 2.0), 1.0E-10);
        SubLine sub2 = new SubLine(new Vector2D(66.0, 3.0), new Vector2D(66.0, 4.0), 1.0E-10);
        Assert.assertNull((Object)sub1.intersection(sub2, true));
        Assert.assertNull((Object)sub1.intersection(sub2, false));
    }
}

