/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.twod;

import java.text.NumberFormat;
import java.util.Locale;
import org.hipparchus.Field;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.twod.Euclidean2D;
import org.hipparchus.geometry.euclidean.twod.FieldVector2D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.util.Decimal64Field;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.junit.Assert;
import org.junit.Test;

public class Vector2DTest {
    @Test
    public void testConstructors() {
        double p40 = 4.0;
        double p20 = 2.0;
        double p25 = 2.5;
        double p10 = 1.0;
        double m05 = -0.5;
        double m30 = -3.0;
        this.check(new Vector2D(2.5, -0.5), 2.5, -0.5, 1.0E-15);
        double[] a = new double[]{1.0, 0.0};
        this.check(new Vector2D(a), 1.0, 0.0, 1.0E-15);
        try {
            new Vector2D(new double[3]);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException miae) {
            Assert.assertEquals((Object)LocalizedCoreFormats.DIMENSIONS_MISMATCH, (Object)miae.getSpecifier());
            Assert.assertEquals((long)3L, (long)((Integer)miae.getParts()[0]).intValue());
            Assert.assertEquals((long)2L, (long)((Integer)miae.getParts()[1]).intValue());
        }
        this.check(new Vector2D(2.0, new Vector2D(2.5, -0.5)), 5.0, -1.0, 1.0E-15);
        this.check(new Vector2D(2.0, new Vector2D(2.5, -0.5)), 5.0, -1.0, 1.0E-15);
        this.check(new Vector2D(2.0, new Vector2D(2.5, -0.5)), 5.0, -1.0, 1.0E-15);
        this.check(new Vector2D(2.0, new Vector2D(2.5, -0.5), -3.0, new Vector2D(-0.5, 4.0)), 6.5, -13.0, 1.0E-15);
        this.check(new Vector2D(2.0, new Vector2D(2.5, -0.5), -3.0, new Vector2D(-0.5, 4.0)), 6.5, -13.0, 1.0E-15);
        this.check(new Vector2D(2.0, new Vector2D(2.5, -0.5), -3.0, new Vector2D(-0.5, 4.0)), 6.5, -13.0, 1.0E-15);
        this.check(new Vector2D(2.0, new Vector2D(2.5, -0.5), -3.0, new Vector2D(-0.5, 4.0), 4.0, new Vector2D(2.5, -3.0)), 16.5, -25.0, 1.0E-15);
        this.check(new Vector2D(2.0, new Vector2D(2.5, -0.5), -3.0, new Vector2D(-0.5, 4.0), 4.0, new Vector2D(2.5, -3.0)), 16.5, -25.0, 1.0E-15);
        this.check(new Vector2D(2.0, new Vector2D(2.5, -0.5), -3.0, new Vector2D(-0.5, 4.0), 4.0, new Vector2D(2.5, -3.0)), 16.5, -25.0, 1.0E-15);
        this.check(new Vector2D(2.0, new Vector2D(2.5, -0.5), -3.0, new Vector2D(-0.5, 4.0), 4.0, new Vector2D(2.5, -3.0), 1.0, new Vector2D(1.0, 1.0)), 17.5, -24.0, 1.0E-15);
        this.check(new Vector2D(2.0, new Vector2D(2.5, -0.5), -3.0, new Vector2D(-0.5, 4.0), 4.0, new Vector2D(2.5, -3.0), 1.0, new Vector2D(1.0, 1.0)), 17.5, -24.0, 1.0E-15);
        this.check(new Vector2D(2.0, new Vector2D(2.5, -0.5), -3.0, new Vector2D(-0.5, 4.0), 4.0, new Vector2D(2.5, -3.0), 1.0, new Vector2D(1.0, 1.0)), 17.5, -24.0, 1.0E-15);
    }

    @Test
    public void testConstants() {
        this.check(Vector2D.ZERO, 0.0, 0.0, 1.0E-15);
        this.check(Vector2D.PLUS_I, 1.0, 0.0, 1.0E-15);
        this.check(Vector2D.MINUS_I, -1.0, 0.0, 1.0E-15);
        this.check(Vector2D.PLUS_J, 0.0, 1.0, 1.0E-15);
        this.check(Vector2D.MINUS_J, 0.0, -1.0, 1.0E-15);
        this.check(Vector2D.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0E-15);
        this.check(Vector2D.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, 1.0E-15);
        Assert.assertTrue((boolean)Double.isNaN(Vector2D.NaN.getX()));
        Assert.assertTrue((boolean)Double.isNaN(Vector2D.NaN.getY()));
        Assert.assertSame((Object)Euclidean2D.getInstance(), (Object)Vector2D.NaN.getSpace());
        Assert.assertSame((Object)Vector2D.ZERO, (Object)new Vector2D(1.0, 2.0).getZero());
    }

    @Test
    public void testToMethods() {
        Vector2D v = new Vector2D(2.5, -0.5);
        Assert.assertEquals((long)2L, (long)v.toArray().length);
        Assert.assertEquals((double)2.5, (double)v.toArray()[0], (double)1.0E-15);
        Assert.assertEquals((double)-0.5, (double)v.toArray()[1], (double)1.0E-15);
        Assert.assertEquals((Object)"{2.5; -0.5}", (Object)v.toString().replaceAll(",", "."));
        Assert.assertEquals((Object)"{2,5; -0,5}", (Object)v.toString(NumberFormat.getInstance(Locale.FRENCH)));
    }

    @Test
    public void testNorms() {
        Vector2D v = new Vector2D(3.0, -4.0);
        Assert.assertEquals((double)7.0, (double)v.getNorm1(), (double)1.0E-15);
        Assert.assertEquals((double)5.0, (double)v.getNorm(), (double)1.0E-15);
        Assert.assertEquals((double)25.0, (double)v.getNormSq(), (double)1.0E-15);
        Assert.assertEquals((double)4.0, (double)v.getNormInf(), (double)1.0E-15);
    }

    @Test
    public void testDistances() {
        Vector2D u = new Vector2D(2.0, -2.0);
        Vector2D v = new Vector2D(-1.0, 2.0);
        Assert.assertEquals((double)7.0, (double)Vector2D.distance1((Vector2D)u, (Vector2D)v), (double)1.0E-15);
        Assert.assertEquals((double)5.0, (double)Vector2D.distance((Vector2D)u, (Vector2D)v), (double)1.0E-15);
        Assert.assertEquals((double)25.0, (double)Vector2D.distanceSq((Vector2D)u, (Vector2D)v), (double)1.0E-15);
        Assert.assertEquals((double)4.0, (double)Vector2D.distanceInf((Vector2D)u, (Vector2D)v), (double)1.0E-15);
    }

    @Test
    public void testAdd() {
        Vector2D u = new Vector2D(2.0, -2.0);
        Vector2D v = new Vector2D(-1.0, 2.0);
        this.check(u.add((Vector)v), 1.0, 0.0, 1.0E-15);
        this.check(u.add(5.0, (Vector)v), -3.0, 8.0, 1.0E-15);
    }

    @Test
    public void testSubtract() {
        Vector2D u = new Vector2D(2.0, -2.0);
        Vector2D v = new Vector2D(1.0, -2.0);
        this.check(u.subtract((Vector)v), 1.0, 0.0, 1.0E-15);
        this.check(u.subtract(5.0, (Vector)v), -3.0, 8.0, 1.0E-15);
    }

    @Test
    public void testNormalize() {
        try {
            Vector2D.ZERO.normalize();
            Assert.fail((String)"an exception should habe been thrown");
        }
        catch (MathRuntimeException mre) {
            Assert.assertEquals((Object)LocalizedGeometryFormats.CANNOT_NORMALIZE_A_ZERO_NORM_VECTOR, (Object)mre.getSpecifier());
        }
        this.check(new Vector2D(3.0, -4.0).normalize(), 0.6, -0.8, 1.0E-15);
    }

    @Test
    public void testAngle() {
        try {
            Vector2D.angle((Vector2D)Vector2D.ZERO, (Vector2D)Vector2D.PLUS_I);
            Assert.fail((String)"an exception should habe been thrown");
        }
        catch (MathRuntimeException mre) {
            Assert.assertEquals((Object)LocalizedCoreFormats.ZERO_NORM, (Object)mre.getSpecifier());
        }
        double alpha = 0.01;
        SinCos sc = FastMath.sinCos((double)0.01);
        Assert.assertEquals((double)0.01, (double)Vector2D.angle((Vector2D)new Vector2D(sc.cos(), sc.sin()), (Vector2D)Vector2D.PLUS_I), (double)1.0E-15);
        Assert.assertEquals((double)3.1315926535897933, (double)Vector2D.angle((Vector2D)new Vector2D(-sc.cos(), sc.sin()), (Vector2D)Vector2D.PLUS_I), (double)1.0E-15);
        Assert.assertEquals((double)1.5607963267948965, (double)Vector2D.angle((Vector2D)new Vector2D(sc.sin(), sc.cos()), (Vector2D)Vector2D.PLUS_I), (double)1.0E-15);
        Assert.assertEquals((double)1.5807963267948966, (double)Vector2D.angle((Vector2D)new Vector2D(-sc.sin(), sc.cos()), (Vector2D)Vector2D.PLUS_I), (double)1.0E-15);
    }

    @Test
    public void testNegate() {
        this.check(new Vector2D(3.0, -4.0).negate(), -3.0, 4.0, 1.0E-15);
    }

    @Test
    public void testScalarMultiply() {
        this.check(new Vector2D(3.0, -4.0).scalarMultiply(2.0), 6.0, -8.0, 1.0E-15);
    }

    @Test
    public void testIsNaN() {
        Assert.assertTrue((boolean)new Vector2D(Double.NaN, 0.0).isNaN());
        Assert.assertTrue((boolean)new Vector2D(0.0, Double.NaN).isNaN());
        Assert.assertTrue((boolean)new Vector2D(Double.NaN, Double.NaN).isNaN());
        Assert.assertTrue((boolean)Vector2D.NaN.isNaN());
        Assert.assertFalse((boolean)new Vector2D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY).isNaN());
        Assert.assertFalse((boolean)Vector2D.MINUS_I.isNaN());
    }

    @Test
    public void testIsInfinite() {
        Assert.assertFalse((boolean)new Vector2D(Double.NaN, 0.0).isInfinite());
        Assert.assertTrue((boolean)new Vector2D(Double.POSITIVE_INFINITY, 0.0).isInfinite());
        Assert.assertTrue((boolean)new Vector2D(0.0, Double.POSITIVE_INFINITY).isInfinite());
        Assert.assertTrue((boolean)new Vector2D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY).isInfinite());
        Assert.assertTrue((boolean)new Vector2D(Double.NEGATIVE_INFINITY, 0.0).isInfinite());
        Assert.assertTrue((boolean)new Vector2D(0.0, Double.NEGATIVE_INFINITY).isInfinite());
        Assert.assertTrue((boolean)new Vector2D(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY).isInfinite());
        Assert.assertFalse((boolean)Vector2D.NaN.isInfinite());
        Assert.assertFalse((boolean)Vector2D.MINUS_I.isInfinite());
    }

    @Test
    public void testEquals() {
        Vector2D u1 = Vector2D.PLUS_I;
        Vector2D u2 = Vector2D.MINUS_I.negate();
        Vector2D v1 = new Vector2D(1.0, 0.001);
        Vector2D v2 = new Vector2D(0.001, 1.0);
        Assert.assertEquals((Object)u1, (Object)u1);
        Assert.assertEquals((Object)u1, (Object)u2);
        Assert.assertNotEquals((Object)u1, (Object)v1);
        Assert.assertNotEquals((Object)u1, (Object)v2);
        Assert.assertNotEquals((Object)u1, (Object)FieldVector2D.getPlusI((Field)Decimal64Field.getInstance()));
        Assert.assertEquals((Object)new Vector2D(Double.NaN, u1), (Object)Vector2D.NaN);
        Assert.assertNotEquals((Object)u1, (Object)Vector2D.NaN);
        Assert.assertNotEquals((Object)Vector2D.NaN, (Object)v2);
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)542L, (long)Vector2D.NaN.hashCode());
        Assert.assertEquals((long)0x4F000000L, (long)new Vector2D(1.5, -0.5).hashCode());
    }

    @Test
    public void testCrossProduct() {
        double epsilon = 1.0E-10;
        Vector2D p1 = new Vector2D(1.0, 1.0);
        Vector2D p2 = new Vector2D(2.0, 2.0);
        Vector2D p3 = new Vector2D(3.0, 3.0);
        Assert.assertEquals((double)0.0, (double)p3.crossProduct(p1, p2), (double)1.0E-10);
        Vector2D p4 = new Vector2D(1.0, 2.0);
        Assert.assertEquals((double)1.0, (double)p4.crossProduct(p1, p2), (double)1.0E-10);
        Vector2D p5 = new Vector2D(2.0, 1.0);
        Assert.assertEquals((double)-1.0, (double)p5.crossProduct(p1, p2), (double)1.0E-10);
    }

    @Test
    public void testOrientation() {
        Assert.assertTrue((Vector2D.orientation((Vector2D)new Vector2D(0.0, 0.0), (Vector2D)new Vector2D(1.0, 0.0), (Vector2D)new Vector2D(1.0, 1.0)) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Vector2D.orientation((Vector2D)new Vector2D(1.0, 0.0), (Vector2D)new Vector2D(0.0, 0.0), (Vector2D)new Vector2D(1.0, 1.0)) < 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)Vector2D.orientation((Vector2D)new Vector2D(0.0, 0.0), (Vector2D)new Vector2D(1.0, 0.0), (Vector2D)new Vector2D(1.0, 0.0)), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)Vector2D.orientation((Vector2D)new Vector2D(0.0, 0.0), (Vector2D)new Vector2D(1.0, 0.0), (Vector2D)new Vector2D(2.0, 0.0)), (double)1.0E-15);
    }

    private void check(Vector2D v, double x, double y, double tol) {
        Assert.assertEquals((double)x, (double)v.getX(), (double)tol);
        Assert.assertEquals((double)y, (double)v.getY(), (double)tol);
    }
}

