/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.twod;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.enclosing.EnclosingBall;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.RegionFactory;
import org.hipparchus.geometry.spherical.oned.ArcsSet;
import org.hipparchus.geometry.spherical.twod.Circle;
import org.hipparchus.geometry.spherical.twod.Edge;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.geometry.spherical.twod.SphericalPolygonsSet;
import org.hipparchus.geometry.spherical.twod.SubCircle;
import org.hipparchus.geometry.spherical.twod.Vertex;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.UnitSphereRandomVectorGenerator;
import org.hipparchus.random.Well1024a;
import org.hipparchus.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class SphericalPolygonsSetTest {
    @Test
    public void testFullSphere() {
        SphericalPolygonsSet full = new SphericalPolygonsSet(1.0E-10);
        UnitSphereRandomVectorGenerator random = new UnitSphereRandomVectorGenerator(3, (RandomGenerator)new Well1024a(-8849623154137682067L));
        for (int i = 0; i < 1000; ++i) {
            Vector3D v = new Vector3D(random.nextVector());
            Assert.assertEquals((Object)Region.Location.INSIDE, (Object)full.checkPoint((Point)new S2Point(v)));
        }
        Assert.assertEquals((double)(Math.PI * 4), (double)new SphericalPolygonsSet(0.01, new S2Point[0]).getSize(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)new SphericalPolygonsSet(0.01, new S2Point[0]).getBoundarySize(), (double)1.0E-10);
        Assert.assertEquals((long)0L, (long)full.getBoundaryLoops().size());
        Assert.assertTrue((full.getEnclosingCap().getRadius() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Double.isInfinite(full.getEnclosingCap().getRadius()));
    }

    @Test
    public void testEmpty() {
        SphericalPolygonsSet empty = (SphericalPolygonsSet)new RegionFactory().getComplement((Region)new SphericalPolygonsSet(1.0E-10));
        UnitSphereRandomVectorGenerator random = new UnitSphereRandomVectorGenerator(3, (RandomGenerator)new Well1024a(8563911751859943133L));
        for (int i = 0; i < 1000; ++i) {
            Vector3D v = new Vector3D(random.nextVector());
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)empty.checkPoint((Point)new S2Point(v)));
        }
        Assert.assertEquals((double)0.0, (double)empty.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)empty.getBoundarySize(), (double)1.0E-10);
        Assert.assertEquals((long)0L, (long)empty.getBoundaryLoops().size());
        Assert.assertTrue((empty.getEnclosingCap().getRadius() < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Double.isInfinite(empty.getEnclosingCap().getRadius()));
    }

    @Test
    public void testSouthHemisphere() {
        double tol = 0.01;
        double sinTol = FastMath.sin((double)tol);
        SphericalPolygonsSet south = new SphericalPolygonsSet(Vector3D.MINUS_K, tol);
        UnitSphereRandomVectorGenerator random = new UnitSphereRandomVectorGenerator(3, (RandomGenerator)new Well1024a(7754435956170390283L));
        for (int i = 0; i < 1000; ++i) {
            Vector3D v = new Vector3D(random.nextVector());
            if (v.getZ() < -sinTol) {
                Assert.assertEquals((Object)Region.Location.INSIDE, (Object)south.checkPoint((Point)new S2Point(v)));
                continue;
            }
            if (v.getZ() > sinTol) {
                Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)south.checkPoint((Point)new S2Point(v)));
                continue;
            }
            Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)south.checkPoint((Point)new S2Point(v)));
        }
        Assert.assertEquals((long)1L, (long)south.getBoundaryLoops().size());
        EnclosingBall southCap = south.getEnclosingCap();
        Assert.assertEquals((double)0.0, (double)S2Point.MINUS_K.distance(southCap.getCenter()), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)southCap.getRadius(), (double)1.0E-10);
        EnclosingBall northCap = ((SphericalPolygonsSet)new RegionFactory().getComplement((Region)south)).getEnclosingCap();
        Assert.assertEquals((double)0.0, (double)S2Point.PLUS_K.distance(northCap.getCenter()), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)northCap.getRadius(), (double)1.0E-10);
    }

    @Test
    public void testPositiveOctantByIntersection() {
        int count;
        double tol = 0.01;
        double sinTol = FastMath.sin((double)tol);
        RegionFactory factory = new RegionFactory();
        SphericalPolygonsSet plusX = new SphericalPolygonsSet(Vector3D.PLUS_I, tol);
        SphericalPolygonsSet plusY = new SphericalPolygonsSet(Vector3D.PLUS_J, tol);
        SphericalPolygonsSet plusZ = new SphericalPolygonsSet(Vector3D.PLUS_K, tol);
        SphericalPolygonsSet octant = (SphericalPolygonsSet)factory.intersection(factory.intersection((Region)plusX, (Region)plusY), (Region)plusZ);
        UnitSphereRandomVectorGenerator random = new UnitSphereRandomVectorGenerator(3, (RandomGenerator)new Well1024a(-7162971917861007579L));
        for (int i = 0; i < 1000; ++i) {
            Vector3D v = new Vector3D(random.nextVector());
            if (v.getX() > sinTol && v.getY() > sinTol && v.getZ() > sinTol) {
                Assert.assertEquals((Object)Region.Location.INSIDE, (Object)octant.checkPoint((Point)new S2Point(v)));
                continue;
            }
            if (v.getX() < -sinTol || v.getY() < -sinTol || v.getZ() < -sinTol) {
                Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)octant.checkPoint((Point)new S2Point(v)));
                continue;
            }
            Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)octant.checkPoint((Point)new S2Point(v)));
        }
        List loops = octant.getBoundaryLoops();
        Assert.assertEquals((long)1L, (long)loops.size());
        boolean xPFound = false;
        boolean yPFound = false;
        boolean zPFound = false;
        boolean xVFound = false;
        boolean yVFound = false;
        boolean zVFound = false;
        Vertex first = (Vertex)loops.get(0);
        Vertex v = first;
        for (count = 0; count == 0 || v != first; ++count) {
            Edge e = v.getIncoming();
            Assert.assertTrue((v == e.getStart().getOutgoing().getEnd() ? 1 : 0) != 0);
            xPFound = xPFound || e.getCircle().getPole().distance((Point)Vector3D.PLUS_I) < 1.0E-10;
            yPFound = yPFound || e.getCircle().getPole().distance((Point)Vector3D.PLUS_J) < 1.0E-10;
            zPFound = zPFound || e.getCircle().getPole().distance((Point)Vector3D.PLUS_K) < 1.0E-10;
            Assert.assertEquals((double)1.5707963267948966, (double)e.getLength(), (double)1.0E-10);
            xVFound = xVFound || v.getLocation().getVector().distance((Point)Vector3D.PLUS_I) < 1.0E-10;
            yVFound = yVFound || v.getLocation().getVector().distance((Point)Vector3D.PLUS_J) < 1.0E-10;
            zVFound = zVFound || v.getLocation().getVector().distance((Point)Vector3D.PLUS_K) < 1.0E-10;
            v = v.getOutgoing().getEnd();
        }
        Assert.assertTrue((boolean)xPFound);
        Assert.assertTrue((boolean)yPFound);
        Assert.assertTrue((boolean)zPFound);
        Assert.assertTrue((boolean)xVFound);
        Assert.assertTrue((boolean)yVFound);
        Assert.assertTrue((boolean)zVFound);
        Assert.assertEquals((long)3L, (long)count);
        Assert.assertEquals((double)0.0, (double)((S2Point)octant.getBarycenter()).distance((Point)new S2Point(new Vector3D(1.0, 1.0, 1.0))), (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)octant.getSize(), (double)1.0E-10);
        EnclosingBall cap = octant.getEnclosingCap();
        Assert.assertEquals((double)0.0, (double)octant.getBarycenter().distance(cap.getCenter()), (double)1.0E-10);
        Assert.assertEquals((double)FastMath.acos((double)(1.0 / FastMath.sqrt((double)3.0))), (double)cap.getRadius(), (double)1.0E-10);
        EnclosingBall reversedCap = ((SphericalPolygonsSet)factory.getComplement((Region)octant)).getEnclosingCap();
        Assert.assertEquals((double)0.0, (double)((S2Point)reversedCap.getCenter()).distance((Point)new S2Point(new Vector3D(-1.0, -1.0, -1.0))), (double)1.0E-10);
        Assert.assertEquals((double)(Math.PI - FastMath.asin((double)(1.0 / FastMath.sqrt((double)3.0)))), (double)reversedCap.getRadius(), (double)1.0E-10);
    }

    @Test
    public void testPositiveOctantByVertices() {
        double tol = 0.01;
        double sinTol = FastMath.sin((double)tol);
        SphericalPolygonsSet octant = new SphericalPolygonsSet(tol, new S2Point[]{S2Point.PLUS_I, S2Point.PLUS_J, S2Point.PLUS_K});
        UnitSphereRandomVectorGenerator random = new UnitSphereRandomVectorGenerator(3, (RandomGenerator)new Well1024a(-5117115241946922232L));
        for (int i = 0; i < 1000; ++i) {
            Vector3D v = new Vector3D(random.nextVector());
            if (v.getX() > sinTol && v.getY() > sinTol && v.getZ() > sinTol) {
                Assert.assertEquals((Object)Region.Location.INSIDE, (Object)octant.checkPoint((Point)new S2Point(v)));
                continue;
            }
            if (v.getX() < -sinTol || v.getY() < -sinTol || v.getZ() < -sinTol) {
                Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)octant.checkPoint((Point)new S2Point(v)));
                continue;
            }
            Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)octant.checkPoint((Point)new S2Point(v)));
        }
    }

    @Test
    public void testNonConvex() {
        double tol = 0.01;
        double sinTol = FastMath.sin((double)tol);
        RegionFactory factory = new RegionFactory();
        SphericalPolygonsSet plusX = new SphericalPolygonsSet(Vector3D.PLUS_I, tol);
        SphericalPolygonsSet plusY = new SphericalPolygonsSet(Vector3D.PLUS_J, tol);
        SphericalPolygonsSet plusZ = new SphericalPolygonsSet(Vector3D.PLUS_K, tol);
        SphericalPolygonsSet threeOctants = (SphericalPolygonsSet)factory.difference((Region)plusZ, factory.intersection((Region)plusX, (Region)plusY));
        UnitSphereRandomVectorGenerator random = new UnitSphereRandomVectorGenerator(3, (RandomGenerator)new Well1024a(-7162971917861007579L));
        for (int i = 0; i < 1000; ++i) {
            Vector3D v = new Vector3D(random.nextVector());
            if ((v.getX() < -sinTol || v.getY() < -sinTol) && v.getZ() > sinTol) {
                Assert.assertEquals((Object)Region.Location.INSIDE, (Object)threeOctants.checkPoint((Point)new S2Point(v)));
                continue;
            }
            if (v.getX() > sinTol && v.getY() > sinTol || v.getZ() < -sinTol) {
                Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)threeOctants.checkPoint((Point)new S2Point(v)));
                continue;
            }
            Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)threeOctants.checkPoint((Point)new S2Point(v)));
        }
        List loops = threeOctants.getBoundaryLoops();
        Assert.assertEquals((long)1L, (long)loops.size());
        boolean xPFound = false;
        boolean yPFound = false;
        boolean zPFound = false;
        boolean xVFound = false;
        boolean yVFound = false;
        boolean zVFound = false;
        Vertex first = (Vertex)loops.get(0);
        int count = 0;
        double sumPoleX = 0.0;
        double sumPoleY = 0.0;
        double sumPoleZ = 0.0;
        Vertex v = first;
        while (count == 0 || v != first) {
            ++count;
            Edge e = v.getIncoming();
            Assert.assertTrue((v == e.getStart().getOutgoing().getEnd() ? 1 : 0) != 0);
            if (e.getCircle().getPole().distance((Point)Vector3D.MINUS_I) < 1.0E-10) {
                xPFound = true;
                sumPoleX += e.getLength();
            } else if (e.getCircle().getPole().distance((Point)Vector3D.MINUS_J) < 1.0E-10) {
                yPFound = true;
                sumPoleY += e.getLength();
            } else {
                Assert.assertEquals((double)0.0, (double)e.getCircle().getPole().distance((Point)Vector3D.PLUS_K), (double)1.0E-10);
                zPFound = true;
                sumPoleZ += e.getLength();
            }
            xVFound = xVFound || v.getLocation().getVector().distance((Point)Vector3D.PLUS_I) < 1.0E-10;
            yVFound = yVFound || v.getLocation().getVector().distance((Point)Vector3D.PLUS_J) < 1.0E-10;
            zVFound = zVFound || v.getLocation().getVector().distance((Point)Vector3D.PLUS_K) < 1.0E-10;
            v = v.getOutgoing().getEnd();
        }
        Assert.assertTrue((boolean)xPFound);
        Assert.assertTrue((boolean)yPFound);
        Assert.assertTrue((boolean)zPFound);
        Assert.assertTrue((boolean)xVFound);
        Assert.assertTrue((boolean)yVFound);
        Assert.assertTrue((boolean)zVFound);
        Assert.assertEquals((double)1.5707963267948966, (double)sumPoleX, (double)1.0E-10);
        Assert.assertEquals((double)1.5707963267948966, (double)sumPoleY, (double)1.0E-10);
        Assert.assertEquals((double)4.71238898038469, (double)sumPoleZ, (double)1.0E-10);
        Assert.assertEquals((double)4.71238898038469, (double)threeOctants.getSize(), (double)1.0E-10);
    }

    @Test
    public void testModeratlyComplexShape() {
        int count;
        double tol = 0.01;
        ArrayList<SubCircle> boundary = new ArrayList<SubCircle>();
        boundary.add(this.create(Vector3D.MINUS_J, Vector3D.PLUS_I, Vector3D.PLUS_K, tol, 0.0, 1.5707963267948966));
        boundary.add(this.create(Vector3D.MINUS_I, Vector3D.PLUS_K, Vector3D.PLUS_J, tol, 0.0, 1.5707963267948966));
        boundary.add(this.create(Vector3D.PLUS_K, Vector3D.PLUS_J, Vector3D.MINUS_I, tol, 0.0, 1.5707963267948966));
        boundary.add(this.create(Vector3D.MINUS_J, Vector3D.MINUS_I, Vector3D.MINUS_K, tol, 0.0, 1.5707963267948966));
        boundary.add(this.create(Vector3D.MINUS_I, Vector3D.MINUS_K, Vector3D.MINUS_J, tol, 0.0, 1.5707963267948966));
        boundary.add(this.create(Vector3D.PLUS_K, Vector3D.MINUS_J, Vector3D.PLUS_I, tol, 0.0, 1.5707963267948966));
        SphericalPolygonsSet polygon = new SphericalPolygonsSet(boundary, tol);
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)polygon.checkPoint((Point)new S2Point(new Vector3D(1.0, 1.0, 1.0).normalize())));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)polygon.checkPoint((Point)new S2Point(new Vector3D(-1.0, 1.0, 1.0).normalize())));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)polygon.checkPoint((Point)new S2Point(new Vector3D(-1.0, -1.0, 1.0).normalize())));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)polygon.checkPoint((Point)new S2Point(new Vector3D(1.0, -1.0, 1.0).normalize())));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)polygon.checkPoint((Point)new S2Point(new Vector3D(1.0, 1.0, -1.0).normalize())));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)polygon.checkPoint((Point)new S2Point(new Vector3D(-1.0, 1.0, -1.0).normalize())));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)polygon.checkPoint((Point)new S2Point(new Vector3D(-1.0, -1.0, -1.0).normalize())));
        Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)polygon.checkPoint((Point)new S2Point(new Vector3D(1.0, -1.0, -1.0).normalize())));
        Assert.assertEquals((double)(Math.PI * 2), (double)polygon.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)(Math.PI * 3), (double)polygon.getBoundarySize(), (double)1.0E-10);
        List loops = polygon.getBoundaryLoops();
        Assert.assertEquals((long)1L, (long)loops.size());
        boolean pXFound = false;
        boolean mXFound = false;
        boolean pYFound = false;
        boolean mYFound = false;
        boolean pZFound = false;
        boolean mZFound = false;
        Vertex first = (Vertex)loops.get(0);
        Vertex v = first;
        for (count = 0; count == 0 || v != first; ++count) {
            Edge e = v.getIncoming();
            Assert.assertTrue((v == e.getStart().getOutgoing().getEnd() ? 1 : 0) != 0);
            pXFound = pXFound || v.getLocation().getVector().distance((Point)Vector3D.PLUS_I) < 1.0E-10;
            mXFound = mXFound || v.getLocation().getVector().distance((Point)Vector3D.MINUS_I) < 1.0E-10;
            pYFound = pYFound || v.getLocation().getVector().distance((Point)Vector3D.PLUS_J) < 1.0E-10;
            mYFound = mYFound || v.getLocation().getVector().distance((Point)Vector3D.MINUS_J) < 1.0E-10;
            pZFound = pZFound || v.getLocation().getVector().distance((Point)Vector3D.PLUS_K) < 1.0E-10;
            mZFound = mZFound || v.getLocation().getVector().distance((Point)Vector3D.MINUS_K) < 1.0E-10;
            Assert.assertEquals((double)1.5707963267948966, (double)e.getLength(), (double)1.0E-10);
            v = v.getOutgoing().getEnd();
        }
        Assert.assertTrue((boolean)pXFound);
        Assert.assertTrue((boolean)mXFound);
        Assert.assertTrue((boolean)pYFound);
        Assert.assertTrue((boolean)mYFound);
        Assert.assertTrue((boolean)pZFound);
        Assert.assertTrue((boolean)mZFound);
        Assert.assertEquals((long)6L, (long)count);
    }

    @Test
    public void testSeveralParts() {
        double tol = 0.01;
        double sinTol = FastMath.sin((double)tol);
        ArrayList<SubCircle> boundary = new ArrayList<SubCircle>();
        boundary.add(this.create(Vector3D.PLUS_J, Vector3D.PLUS_K, Vector3D.PLUS_I, tol, 0.0, 1.5707963267948966));
        boundary.add(this.create(Vector3D.PLUS_K, Vector3D.PLUS_I, Vector3D.PLUS_J, tol, 0.0, 1.5707963267948966));
        boundary.add(this.create(Vector3D.PLUS_I, Vector3D.PLUS_J, Vector3D.PLUS_K, tol, 0.0, 1.5707963267948966));
        boundary.add(this.create(Vector3D.MINUS_J, Vector3D.MINUS_I, Vector3D.MINUS_K, tol, 0.0, 1.5707963267948966));
        boundary.add(this.create(Vector3D.MINUS_I, Vector3D.MINUS_K, Vector3D.MINUS_J, tol, 0.0, 1.5707963267948966));
        boundary.add(this.create(Vector3D.MINUS_K, Vector3D.MINUS_J, Vector3D.MINUS_I, tol, 0.0, 1.5707963267948966));
        SphericalPolygonsSet polygon = new SphericalPolygonsSet(boundary, tol);
        UnitSphereRandomVectorGenerator random = new UnitSphereRandomVectorGenerator(3, (RandomGenerator)new Well1024a(-3720847845094272020L));
        for (int i = 0; i < 1000; ++i) {
            Vector3D v = new Vector3D(random.nextVector());
            if (v.getX() < -sinTol && v.getY() < -sinTol && v.getZ() < -sinTol) {
                Assert.assertEquals((Object)Region.Location.INSIDE, (Object)polygon.checkPoint((Point)new S2Point(v)));
                continue;
            }
            if (v.getX() < sinTol && v.getY() < sinTol && v.getZ() < sinTol) {
                Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)polygon.checkPoint((Point)new S2Point(v)));
                continue;
            }
            if (v.getX() > sinTol && v.getY() > sinTol && v.getZ() > sinTol) {
                Assert.assertEquals((Object)Region.Location.INSIDE, (Object)polygon.checkPoint((Point)new S2Point(v)));
                continue;
            }
            if (v.getX() > -sinTol && v.getY() > -sinTol && v.getZ() > -sinTol) {
                Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)polygon.checkPoint((Point)new S2Point(v)));
                continue;
            }
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)polygon.checkPoint((Point)new S2Point(v)));
        }
        Assert.assertEquals((double)Math.PI, (double)polygon.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)(Math.PI * 3), (double)polygon.getBoundarySize(), (double)1.0E-10);
        Assert.assertEquals((long)2L, (long)polygon.getBoundaryLoops().size());
    }

    @Test
    public void testPartWithHole() {
        double tol = 0.01;
        double alpha = 0.7;
        S2Point center = new S2Point(new Vector3D(1.0, 1.0, 1.0));
        SphericalPolygonsSet hexa = new SphericalPolygonsSet(center.getVector(), Vector3D.PLUS_K, alpha, 6, tol);
        SphericalPolygonsSet hole = new SphericalPolygonsSet(tol, new S2Point[]{new S2Point(0.5235987755982988, 1.0471975511965976), new S2Point(1.0471975511965976, 1.0471975511965976), new S2Point(0.7853981633974483, 0.5235987755982988)});
        SphericalPolygonsSet hexaWithHole = (SphericalPolygonsSet)new RegionFactory().difference((Region)hexa, (Region)hole);
        for (double phi = center.getPhi() - alpha + 0.1; phi < center.getPhi() + alpha - 0.1; phi += 0.07) {
            Region.Location l = hexaWithHole.checkPoint((Point)new S2Point(0.7853981633974483, phi));
            if (phi < 0.5235987755982988 || phi > 1.0471975511965976) {
                Assert.assertEquals((Object)Region.Location.INSIDE, (Object)l);
                continue;
            }
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)l);
        }
        Assert.assertEquals((long)2L, (long)hexaWithHole.getBoundaryLoops().size());
        Assert.assertEquals((double)(hexa.getBoundarySize() + hole.getBoundarySize()), (double)hexaWithHole.getBoundarySize(), (double)1.0E-10);
        Assert.assertEquals((double)(hexa.getSize() - hole.getSize()), (double)hexaWithHole.getSize(), (double)1.0E-10);
    }

    @Test
    public void testConcentricSubParts() {
        double tol = 0.001;
        Vector3D center = new Vector3D(1.0, 1.0, 1.0);
        SphericalPolygonsSet hexaOut = new SphericalPolygonsSet(center, Vector3D.PLUS_K, 0.9, 6, tol);
        SphericalPolygonsSet hexaIn = new SphericalPolygonsSet(center, Vector3D.PLUS_K, 0.8, 6, tol);
        SphericalPolygonsSet pentaOut = new SphericalPolygonsSet(center, Vector3D.PLUS_K, 0.7, 5, tol);
        SphericalPolygonsSet pentaIn = new SphericalPolygonsSet(center, Vector3D.PLUS_K, 0.6, 5, tol);
        SphericalPolygonsSet quadriOut = new SphericalPolygonsSet(center, Vector3D.PLUS_K, 0.5, 4, tol);
        SphericalPolygonsSet quadriIn = new SphericalPolygonsSet(center, Vector3D.PLUS_K, 0.4, 4, tol);
        SphericalPolygonsSet triOut = new SphericalPolygonsSet(center, Vector3D.PLUS_K, 0.25, 3, tol);
        SphericalPolygonsSet triIn = new SphericalPolygonsSet(center, Vector3D.PLUS_K, 0.15, 3, tol);
        RegionFactory factory = new RegionFactory();
        SphericalPolygonsSet hexa = (SphericalPolygonsSet)factory.difference((Region)hexaOut, (Region)hexaIn);
        SphericalPolygonsSet penta = (SphericalPolygonsSet)factory.difference((Region)pentaOut, (Region)pentaIn);
        SphericalPolygonsSet quadri = (SphericalPolygonsSet)factory.difference((Region)quadriOut, (Region)quadriIn);
        SphericalPolygonsSet tri = (SphericalPolygonsSet)factory.difference((Region)triOut, (Region)triIn);
        SphericalPolygonsSet concentric = (SphericalPolygonsSet)factory.union(factory.union((Region)hexa, (Region)penta), factory.union((Region)quadri, (Region)tri));
        Assert.assertEquals((long)8L, (long)concentric.getBoundaryLoops().size());
        Assert.assertEquals((double)(hexaOut.getBoundarySize() + hexaIn.getBoundarySize() + pentaOut.getBoundarySize() + pentaIn.getBoundarySize() + quadriOut.getBoundarySize() + quadriIn.getBoundarySize() + triOut.getBoundarySize() + triIn.getBoundarySize()), (double)concentric.getBoundarySize(), (double)1.0E-10);
        Assert.assertEquals((double)(hexaOut.getSize() - hexaIn.getSize() + pentaOut.getSize() - pentaIn.getSize() + quadriOut.getSize() - quadriIn.getSize() + triOut.getSize() - triIn.getSize()), (double)concentric.getSize(), (double)1.0E-10);
        double phi = new S2Point(center).getPhi();
        Assert.assertEquals((double)0.207, (double)concentric.projectToBoundary((Point)new S2Point(-0.6, phi)).getOffset(), (double)0.01);
        Assert.assertEquals((double)-0.048, (double)concentric.projectToBoundary((Point)new S2Point(-0.21, phi)).getOffset(), (double)0.01);
        Assert.assertEquals((double)0.027, (double)concentric.projectToBoundary((Point)new S2Point(-0.1, phi)).getOffset(), (double)0.01);
        Assert.assertEquals((double)-0.041, (double)concentric.projectToBoundary((Point)new S2Point(0.01, phi)).getOffset(), (double)0.01);
        Assert.assertEquals((double)0.049, (double)concentric.projectToBoundary((Point)new S2Point(0.16, phi)).getOffset(), (double)0.01);
        Assert.assertEquals((double)-0.038, (double)concentric.projectToBoundary((Point)new S2Point(0.29, phi)).getOffset(), (double)0.01);
        Assert.assertEquals((double)0.097, (double)concentric.projectToBoundary((Point)new S2Point(0.48, phi)).getOffset(), (double)0.01);
        Assert.assertEquals((double)-0.022, (double)concentric.projectToBoundary((Point)new S2Point(0.64, phi)).getOffset(), (double)0.01);
        Assert.assertEquals((double)0.072, (double)concentric.projectToBoundary((Point)new S2Point(0.79, phi)).getOffset(), (double)0.01);
        Assert.assertEquals((double)-0.022, (double)concentric.projectToBoundary((Point)new S2Point(0.93, phi)).getOffset(), (double)0.01);
        Assert.assertEquals((double)0.091, (double)concentric.projectToBoundary((Point)new S2Point(1.08, phi)).getOffset(), (double)0.01);
        Assert.assertEquals((double)-0.037, (double)concentric.projectToBoundary((Point)new S2Point(1.28, phi)).getOffset(), (double)0.01);
        Assert.assertEquals((double)0.051, (double)concentric.projectToBoundary((Point)new S2Point(1.4, phi)).getOffset(), (double)0.01);
        Assert.assertEquals((double)-0.041, (double)concentric.projectToBoundary((Point)new S2Point(1.55, phi)).getOffset(), (double)0.01);
        Assert.assertEquals((double)0.027, (double)concentric.projectToBoundary((Point)new S2Point(1.67, phi)).getOffset(), (double)0.01);
        Assert.assertEquals((double)-0.044, (double)concentric.projectToBoundary((Point)new S2Point(1.79, phi)).getOffset(), (double)0.01);
        Assert.assertEquals((double)0.201, (double)concentric.projectToBoundary((Point)new S2Point(2.16, phi)).getOffset(), (double)0.01);
    }

    @Test
    public void testGeographicalMap() {
        SphericalPolygonsSet continental = this.buildSimpleZone(new double[][]{{51.1485, 2.51357}, {50.9466, 1.639}, {50.12717, 1.33876}, {49.34737, -0.98946}, {49.77634, -1.93349}, {48.64442, -1.61651}, {48.90169, -3.29581}, {48.68416, -4.59234}, {47.95495, -4.49155}, {47.57032, -2.96327}, {46.01491, -1.19379}, {44.02261, -1.38422}, {43.4228, -1.90135}, {43.03401, -1.50277}, {42.34338, 1.82679}, {42.47301, 2.98599}, {43.0752, 3.10041}, {43.39965, 4.55696}, {43.12889, 6.52924}, {43.69384, 7.43518}, {44.1279, 7.54959}, {45.02851, 6.74995}, {45.33309, 7.09665}, {46.42967, 6.50009}, {46.27298, 6.0226}, {46.72577, 6.03738}, {47.62058, 7.46675}, {49.01778, 8.09927}, {49.20195, 6.65822}, {49.44266, 5.89775}, {49.98537, 4.79922}});
        SphericalPolygonsSet corsica = this.buildSimpleZone(new double[][]{{42.15249, 9.56001}, {43.00998, 9.39}, {42.62812, 8.746}, {42.25651, 8.54421}, {41.58361, 8.77572}, {41.38, 9.22975}});
        RegionFactory factory = new RegionFactory();
        SphericalPolygonsSet zone = (SphericalPolygonsSet)factory.union((Region)continental, (Region)corsica);
        EnclosingBall enclosing = zone.getEnclosingCap();
        Vector3D enclosingCenter = ((S2Point)enclosing.getCenter()).getVector();
        double step = FastMath.toRadians((double)0.1);
        for (Vertex loopStart : zone.getBoundaryLoops()) {
            int count = 0;
            Vertex v = loopStart;
            while (count == 0 || v != loopStart) {
                ++count;
                int i = 0;
                while ((double)i < FastMath.ceil((double)(v.getOutgoing().getLength() / step))) {
                    Vector3D p = v.getOutgoing().getPointAt((double)i * step);
                    Assert.assertTrue((Vector3D.angle((Vector3D)p, (Vector3D)enclosingCenter) <= enclosing.getRadius() ? 1 : 0) != 0);
                    ++i;
                }
                v = v.getOutgoing().getEnd();
            }
        }
        S2Point supportPointA = this.s2Point(48.68416, -4.59234);
        S2Point supportPointB = this.s2Point(41.38, 9.22975);
        Assert.assertEquals((double)enclosing.getRadius(), (double)supportPointA.distance(enclosing.getCenter()), (double)1.0E-10);
        Assert.assertEquals((double)enclosing.getRadius(), (double)supportPointB.distance(enclosing.getCenter()), (double)1.0E-10);
        Assert.assertEquals((double)(0.5 * supportPointA.distance((Point)supportPointB)), (double)enclosing.getRadius(), (double)1.0E-10);
        Assert.assertEquals((long)2L, (long)enclosing.getSupportSize());
        EnclosingBall continentalInscribed = ((SphericalPolygonsSet)factory.getComplement((Region)continental)).getEnclosingCap();
        Vector3D continentalCenter = ((S2Point)continentalInscribed.getCenter()).getVector();
        Assert.assertEquals((double)2.2, (double)FastMath.toDegrees((double)(Math.PI - continentalInscribed.getRadius())), (double)0.1);
        for (Vertex loopStart : continental.getBoundaryLoops()) {
            int count = 0;
            Vertex v = loopStart;
            while (count == 0 || v != loopStart) {
                ++count;
                int i = 0;
                while ((double)i < FastMath.ceil((double)(v.getOutgoing().getLength() / step))) {
                    Vector3D p = v.getOutgoing().getPointAt((double)i * step);
                    Assert.assertTrue((Vector3D.angle((Vector3D)p, (Vector3D)continentalCenter) <= continentalInscribed.getRadius() ? 1 : 0) != 0);
                    ++i;
                }
                v = v.getOutgoing().getEnd();
            }
        }
        EnclosingBall corsicaInscribed = ((SphericalPolygonsSet)factory.getComplement((Region)corsica)).getEnclosingCap();
        Vector3D corsicaCenter = ((S2Point)corsicaInscribed.getCenter()).getVector();
        Assert.assertEquals((double)0.34, (double)FastMath.toDegrees((double)(Math.PI - corsicaInscribed.getRadius())), (double)0.01);
        for (Vertex loopStart : corsica.getBoundaryLoops()) {
            int count = 0;
            Vertex v = loopStart;
            while (count == 0 || v != loopStart) {
                ++count;
                int i = 0;
                while ((double)i < FastMath.ceil((double)(v.getOutgoing().getLength() / step))) {
                    Vector3D p = v.getOutgoing().getPointAt((double)i * step);
                    Assert.assertTrue((Vector3D.angle((Vector3D)p, (Vector3D)corsicaCenter) <= corsicaInscribed.getRadius() ? 1 : 0) != 0);
                    ++i;
                }
                v = v.getOutgoing().getEnd();
            }
        }
    }

    @Test
    public void testZigZagBoundary() {
        SphericalPolygonsSet zone = new SphericalPolygonsSet(1.0E-6, new S2Point[]{new S2Point(-0.12630940610562444, 0.8998192093789258), new S2Point(-0.12731320182988207, 0.8963735568774486), new S2Point(-0.1351107624622557, 0.8978258663483273), new S2Point(-0.13545331405131725, 0.8966781238246179), new S2Point(-0.14324883017454967, 0.8981309629283796), new S2Point(-0.14359875625524995, 0.896983965573036), new S2Point(-0.14749650541159384, 0.8977109994666864), new S2Point(-0.14785037758231825, 0.8965644005442432), new S2Point(-0.15369807257448784, 0.8976550608135502), new S2Point(-0.1526225554339386, 0.9010934265410458), new S2Point(-0.14679028466684121, 0.9000043396997698), new S2Point(-0.14643807494172612, 0.9011511073761742), new S2Point(-0.1386609051963748, 0.8996991539048602), new S2Point(-0.13831601655974668, 0.9008466623902937), new S2Point(-0.1305365419828323, 0.8993961857946309), new S2Point(-0.1301989630405964, 0.9005444294061787)});
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)zone.checkPoint((Point)new S2Point(-0.145, 0.898)));
        Assert.assertEquals((double)6.463E-5, (double)zone.getSize(), (double)1.0E-7);
        Assert.assertEquals((double)0.05487, (double)zone.getBoundarySize(), (double)1.0E-4);
    }

    @Test
    public void testGitHubIssue41() {
        RegionFactory regionFactory = new RegionFactory();
        S2Point[] s2pA = new S2Point[]{new S2Point(new Vector3D(0.2122954606, -0.629606302, 0.7473463333)), new S2Point(new Vector3D(0.2120220248, -0.6296445493, 0.747391733)), new S2Point(new Vector3D(0.2119838016, -0.6298173178, 0.7472569934)), new S2Point(new Vector3D(0.2122571927, -0.6297790738, 0.7472116182))};
        S2Point[] s2pB = new S2Point[]{new S2Point(new Vector3D(0.2120291561, -0.629952069, 0.7471305292)), new S2Point(new Vector3D(0.2123026002, -0.6299138005, 0.7470851423)), new S2Point(new Vector3D(0.2123408927, -0.6297410403, 0.7472198923)), new S2Point(new Vector3D(0.2120674039, -0.6297793122, 0.7472653037))};
        double tol = 1.0E-4;
        SphericalPolygonsSet spsA = new SphericalPolygonsSet(1.0E-4, s2pA);
        SphericalPolygonsSet spsB = new SphericalPolygonsSet(1.0E-4, s2pB);
        Assert.assertEquals((double)6.1254E-8, (double)spsA.getSize(), (double)1.0E-12);
        Assert.assertEquals((double)0.00100437, (double)spsA.getBoundarySize(), (double)1.0E-8);
        Assert.assertEquals((double)6.1269E-8, (double)spsB.getSize(), (double)1.0E-12);
        Assert.assertEquals((double)0.00100452, (double)spsB.getBoundarySize(), (double)1.0E-8);
        SphericalPolygonsSet union = (SphericalPolygonsSet)regionFactory.union((Region)spsA, (Region)spsB);
        Assert.assertEquals((double)1.15628E-7, (double)union.getSize(), (double)4.0E-9);
        Assert.assertEquals((double)0.00153824, (double)union.getBoundarySize(), (double)3.0E-4);
    }

    @Test
    public void testGitHubIssue42A() {
        try {
            this.doTestGitHubIssue42(1.0E-100);
        }
        catch (MathIllegalArgumentException miae) {
            Assert.assertEquals((Object)LocalizedGeometryFormats.TOO_SMALL_TOLERANCE, (Object)miae.getSpecifier());
            Assert.assertEquals((double)1.0E-100, (double)((Double)miae.getParts()[0]), (double)1.0E-110);
            Assert.assertEquals((Object)"Sphere2D.SMALLEST_TOLERANCE", (Object)miae.getParts()[1]);
            Assert.assertEquals((double)Sphere2D.SMALLEST_TOLERANCE, (double)((Double)miae.getParts()[2]), (double)1.0E-20);
        }
    }

    @Test
    public void testGitHubIssue42B() {
        try {
            this.doTestGitHubIssue42(9.0E-16);
        }
        catch (MathIllegalStateException e) {
            Assert.assertEquals((Object)e.getSpecifier(), (Object)LocalizedGeometryFormats.OUTLINE_BOUNDARY_LOOP_OPEN);
        }
        double tol = FastMath.ulp((double)(Math.PI * 4));
        this.doTestGitHubIssue42(tol);
    }

    private void doTestGitHubIssue42(double tolerance) throws MathIllegalArgumentException {
        S2Point[] s2pA = new S2Point[]{new S2Point(new Vector3D(0.1504230736114679, -0.6603084987333554, 0.7357754993377947)), new S2Point(new Vector3D(0.15011191112224423, -0.6603400871954631, 0.7358106980616113)), new S2Point(new Vector3D(0.15008035620222715, -0.6605195692153062, 0.7356560238085725)), new S2Point(new Vector3D(0.1503914563063968, -0.6604879854490165, 0.7356208472763267))};
        S2Point outsidePoint = new S2Point(new Vector3D(2.0, s2pA[0].getVector(), -1.0, s2pA[1].getVector(), -1.0, s2pA[2].getVector(), 2.0, s2pA[3].getVector()).normalize());
        for (int i = 0; i < s2pA.length; ++i) {
            S2Point[] points = new S2Point[s2pA.length];
            for (int j = 0; j < s2pA.length; ++j) {
                points[j] = s2pA[(i + j) % s2pA.length];
            }
            SphericalPolygonsSet spsA = new SphericalPolygonsSet(tolerance, points);
            Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)spsA.checkPoint((Point)outsidePoint));
            Assert.assertEquals((double)7.4547E-8, (double)spsA.getSize(), (double)1.0E-12);
        }
    }

    @Test
    public void testZigZagBoundaryOversampledIssue46() {
        Edge outgoing;
        Vertex start;
        double tol = 1.0E-4;
        S2Point[] vertices = new S2Point[]{new S2Point(-1.2630940610562444, 0.9819209378925775), new S2Point(-1.2731320182988206, 0.6373556877448561), new S2Point(-1.351107624622557, 0.7825866348327271), new S2Point(-1.3545331405131724, 0.6678123824617854), new S2Point(-1.4324883017454968, 0.8130962928379559), new S2Point(-1.4359875625524996, 0.6983965573035933), new S2Point(-1.4749650541159385, 0.7710999466686408), new S2Point(-1.4785037758231825, 0.6564400544243232), new S2Point(-1.5369807257448784, 0.7655060813550163), new S2Point(-1.526225554339386, 1.1093426541045837), new S2Point(-1.467902846668412, 1.000433969976977), new S2Point(-1.4643807494172612, 1.1151107376174196), new S2Point(-1.386609051963748, 0.9699153904860203), new S2Point(-1.3831601655974668, 1.0846662390293638), new S2Point(-1.305365419828323, 0.9396185794630862), new S2Point(-1.301989630405964, 1.0544429406178724)};
        SphericalPolygonsSet zone = new SphericalPolygonsSet(1.0E-4, vertices);
        ArrayList<S2Point> points = new ArrayList<S2Point>();
        Vertex v = start = (Vertex)zone.getBoundaryLoops().get(0);
        double step = 1.0E-5;
        do {
            outgoing = v.getOutgoing();
            double length = outgoing.getLength();
            int n = (int)(length / step);
            for (int i = 0; i < n; ++i) {
                points.add(new S2Point(outgoing.getPointAt((double)i * step)));
            }
        } while ((v = outgoing.getEnd()) != start);
        zone = new SphericalPolygonsSet(1.0E-4, points.toArray(new S2Point[0]));
        EnclosingBall cap = zone.getEnclosingCap();
        Assert.assertTrue((cap.getRadius() < 0.5 ? 1 : 0) != 0);
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)zone.checkPoint(zone.getBarycenter()));
        Assert.assertEquals((Object)Region.Location.INSIDE, (Object)zone.checkPoint(cap.getCenter()));
        double cornerTol = 3.1E-4;
        for (S2Point vertex : vertices) {
            Assert.assertEquals((String)("" + vertex), (Object)Region.Location.BOUNDARY, (Object)zone.checkPoint((Point)vertex));
            double offset = FastMath.abs((double)zone.projectToBoundary((Point)vertex).getOffset());
            Assert.assertEquals((String)("" + vertex + " offset: " + offset), (double)0.0, (double)offset, (double)3.1E-4);
            Assert.assertTrue((String)("vertex: " + vertex + " distance: " + (vertex.distance(cap.getCenter()) - cap.getRadius())), (boolean)cap.contains((Point)vertex, 1.0E-4));
        }
    }

    @Test
    public void testPositiveOctantByVerticesDetailIssue46() {
        double t;
        int i;
        double tol = 0.01;
        double sinTol = FastMath.sin((double)tol);
        Circle x = new Circle(Vector3D.PLUS_I, tol);
        Circle z = new Circle(Vector3D.PLUS_K, tol);
        double length = 1.5707963267948966;
        double step = tol / 10.0;
        int n = (int)(length / step);
        ArrayList<S2Point> points = new ArrayList<S2Point>();
        for (i = 0; i < n; ++i) {
            t = (double)i * step;
            points.add(new S2Point(z.getPointAt(z.getPhase(Vector3D.PLUS_I) + t)));
        }
        for (i = 0; i < n; ++i) {
            t = (double)i * step;
            points.add(new S2Point(x.getPointAt(x.getPhase(Vector3D.PLUS_J) + t)));
        }
        points.add(S2Point.PLUS_K);
        SphericalPolygonsSet octant = new SphericalPolygonsSet(tol, points.toArray(new S2Point[0]));
        UnitSphereRandomVectorGenerator random = new UnitSphereRandomVectorGenerator(3, (RandomGenerator)new Well1024a(-5117115241946922232L));
        for (int i2 = 0; i2 < 1000; ++i2) {
            Vector3D v = new Vector3D(random.nextVector());
            Region.Location actual = octant.checkPoint((Point)new S2Point(v));
            if (v.getX() > sinTol && v.getY() > sinTol && v.getZ() > sinTol) {
                if (v.getX() > 2.0 * sinTol && v.getY() > 2.0 * sinTol && v.getZ() > 2.0 * sinTol) {
                    Assert.assertEquals((String)("" + v), (Object)Region.Location.INSIDE, (Object)actual);
                    continue;
                }
                Assert.assertNotEquals((String)("" + v), (Object)Region.Location.OUTSIDE, (Object)actual);
                continue;
            }
            if (v.getX() < 0.0 || v.getY() < 0.0 || v.getZ() < 0.0) {
                if (v.getX() < -sinTol || v.getY() < -sinTol || v.getZ() < -sinTol) {
                    Assert.assertEquals((Object)Region.Location.OUTSIDE, (Object)actual);
                    continue;
                }
                Assert.assertNotEquals((Object)Region.Location.INSIDE, (Object)actual);
                continue;
            }
            Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)actual);
        }
        for (S2Point point : points) {
            Assert.assertEquals((String)("" + point), (Object)Region.Location.BOUNDARY, (Object)octant.checkPoint((Point)point));
        }
    }

    @Test
    public void testConstructingFromFewPointsIssue46() {
        double tol = 1.0E-9;
        ArrayList<S2Point> points = new ArrayList<S2Point>();
        Circle circle = new Circle(Vector3D.PLUS_K, tol);
        SphericalPolygonsSet sps = new SphericalPolygonsSet(tol, new S2Point[0]);
        Assert.assertEquals((double)sps.getSize(), (double)(Math.PI * 4), (double)tol);
        points.add(new S2Point(circle.getPointAt(0.0)));
        try {
            new SphericalPolygonsSet(tol, points.toArray(new S2Point[0]));
            Assert.fail((String)"expcected exception");
        }
        catch (MathRuntimeException mathRuntimeException) {
            // empty catch block
        }
        points.add(new S2Point(circle.getPointAt(1.5707963267948966)));
        sps = new SphericalPolygonsSet(tol, points.toArray(new S2Point[0]));
        Assert.assertEquals((double)sps.getSize(), (double)(Math.PI * 2), (double)tol);
        points.add(0, new S2Point(circle.getPointAt(Math.PI)));
        sps = new SphericalPolygonsSet(tol, points.toArray(new S2Point[0]));
        Assert.assertEquals((double)sps.getSize(), (double)(Math.PI * 2), (double)tol);
        Assert.assertEquals((double)sps.getBarycenter().distance((Point)new S2Point(Vector3D.PLUS_K)), (double)0.0, (double)tol);
        points.add(1, new S2Point(circle.getPointAt(4.71238898038469)));
        sps = new SphericalPolygonsSet(tol, points.toArray(new S2Point[0]));
        Assert.assertEquals((double)sps.getSize(), (double)(Math.PI * 2), (double)tol);
        Assert.assertEquals((double)sps.getBarycenter().distance((Point)new S2Point(Vector3D.PLUS_K)), (double)0.0, (double)tol);
        sps = new SphericalPolygonsSet(tol, new S2Point[]{new S2Point(circle.getPointAt(0.0)), new S2Point(circle.getPointAt(-0.3)), new S2Point(circle.getPointAt(-0.2)), new S2Point(circle.getPointAt(-0.1))});
        Assert.assertEquals((double)sps.getSize(), (double)(Math.PI * 2), (double)tol);
        Assert.assertEquals((double)sps.getBarycenter().distance((Point)new S2Point(Vector3D.PLUS_K)), (double)0.0, (double)tol);
    }

    private SubCircle create(Vector3D pole, Vector3D x, Vector3D y, double tolerance, double ... limits) {
        RegionFactory factory = new RegionFactory();
        Circle circle = new Circle(pole, tolerance);
        Circle phased = (Circle)Circle.getTransform((Rotation)new Rotation(circle.getXAxis(), circle.getYAxis(), x, y)).apply((Hyperplane)circle);
        ArcsSet set = (ArcsSet)factory.getComplement((Region)new ArcsSet(tolerance));
        for (int i = 0; i < limits.length; i += 2) {
            set = (ArcsSet)factory.union((Region)set, (Region)new ArcsSet(limits[i], limits[i + 1], tolerance));
        }
        return new SubCircle((Hyperplane)phased, (Region)set);
    }

    private SphericalPolygonsSet buildSimpleZone(double[][] points) {
        S2Point[] vertices = new S2Point[points.length];
        for (int i = 0; i < points.length; ++i) {
            vertices[i] = this.s2Point(points[i][0], points[i][1]);
        }
        return new SphericalPolygonsSet(1.0E-10, vertices);
    }

    private S2Point s2Point(double latitude, double longitude) {
        return new S2Point(FastMath.toRadians((double)longitude), FastMath.toRadians((double)(90.0 - latitude)));
    }
}

