/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.threed;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.euclidean.threed.Vector3D;

public enum RotationOrder {
    XYZ("XYZ", Vector3D.PLUS_I, Vector3D.PLUS_J, Vector3D.PLUS_K),
    XZY("XZY", Vector3D.PLUS_I, Vector3D.PLUS_K, Vector3D.PLUS_J),
    YXZ("YXZ", Vector3D.PLUS_J, Vector3D.PLUS_I, Vector3D.PLUS_K),
    YZX("YZX", Vector3D.PLUS_J, Vector3D.PLUS_K, Vector3D.PLUS_I),
    ZXY("ZXY", Vector3D.PLUS_K, Vector3D.PLUS_I, Vector3D.PLUS_J),
    ZYX("ZYX", Vector3D.PLUS_K, Vector3D.PLUS_J, Vector3D.PLUS_I),
    XYX("XYX", Vector3D.PLUS_I, Vector3D.PLUS_J, Vector3D.PLUS_I),
    XZX("XZX", Vector3D.PLUS_I, Vector3D.PLUS_K, Vector3D.PLUS_I),
    YXY("YXY", Vector3D.PLUS_J, Vector3D.PLUS_I, Vector3D.PLUS_J),
    YZY("YZY", Vector3D.PLUS_J, Vector3D.PLUS_K, Vector3D.PLUS_J),
    ZXZ("ZXZ", Vector3D.PLUS_K, Vector3D.PLUS_I, Vector3D.PLUS_K),
    ZYZ("ZYZ", Vector3D.PLUS_K, Vector3D.PLUS_J, Vector3D.PLUS_K);

    private static final Map<String, RotationOrder> CODES_MAP;
    private final String name;
    private final Vector3D a1;
    private final Vector3D a2;
    private final Vector3D a3;

    private RotationOrder(String name, Vector3D a1, Vector3D a2, Vector3D a3) {
        this.name = name;
        this.a1 = a1;
        this.a2 = a2;
        this.a3 = a3;
    }

    public String toString() {
        return this.name;
    }

    public Vector3D getA1() {
        return this.a1;
    }

    public Vector3D getA2() {
        return this.a2;
    }

    public Vector3D getA3() {
        return this.a3;
    }

    public static RotationOrder getRotationOrder(String value) {
        RotationOrder type = CODES_MAP.get(value);
        if (type == null) {
            throw new MathIllegalStateException((Localizable)LocalizedGeometryFormats.INVALID_ROTATION_ORDER_NAME, new Object[]{value});
        }
        return type;
    }

    static {
        CODES_MAP = new HashMap<String, RotationOrder>();
        for (RotationOrder type : RotationOrder.values()) {
            CODES_MAP.put(type.toString(), type);
        }
    }
}

