/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.threed;

import java.io.Serializable;
import java.text.NumberFormat;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Euclidean3D;
import org.hipparchus.geometry.euclidean.threed.Vector3DFormat;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;

public class Vector3D
implements Serializable,
Vector<Euclidean3D> {
    public static final Vector3D ZERO = new Vector3D(0.0, 0.0, 0.0);
    public static final Vector3D PLUS_I = new Vector3D(1.0, 0.0, 0.0);
    public static final Vector3D MINUS_I = new Vector3D(-1.0, 0.0, 0.0);
    public static final Vector3D PLUS_J = new Vector3D(0.0, 1.0, 0.0);
    public static final Vector3D MINUS_J = new Vector3D(0.0, -1.0, 0.0);
    public static final Vector3D PLUS_K = new Vector3D(0.0, 0.0, 1.0);
    public static final Vector3D MINUS_K = new Vector3D(0.0, 0.0, -1.0);
    public static final Vector3D NaN = new Vector3D(Double.NaN, Double.NaN, Double.NaN);
    public static final Vector3D POSITIVE_INFINITY = new Vector3D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Vector3D NEGATIVE_INFINITY = new Vector3D(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    private static final long serialVersionUID = 1313493323784566947L;
    private final double x;
    private final double y;
    private final double z;

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3D(double[] v) throws MathIllegalArgumentException {
        if (v.length != 3) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{v.length, 3});
        }
        this.x = v[0];
        this.y = v[1];
        this.z = v[2];
    }

    public Vector3D(double alpha, double delta) {
        SinCos sinCosAlpha = FastMath.sinCos((double)alpha);
        SinCos sinCosDelta = FastMath.sinCos((double)delta);
        this.x = sinCosAlpha.cos() * sinCosDelta.cos();
        this.y = sinCosAlpha.sin() * sinCosDelta.cos();
        this.z = sinCosDelta.sin();
    }

    public Vector3D(double a, Vector3D u) {
        this.x = a * u.x;
        this.y = a * u.y;
        this.z = a * u.z;
    }

    public Vector3D(double a1, Vector3D u1, double a2, Vector3D u2) {
        this.x = MathArrays.linearCombination((double)a1, (double)u1.x, (double)a2, (double)u2.x);
        this.y = MathArrays.linearCombination((double)a1, (double)u1.y, (double)a2, (double)u2.y);
        this.z = MathArrays.linearCombination((double)a1, (double)u1.z, (double)a2, (double)u2.z);
    }

    public Vector3D(double a1, Vector3D u1, double a2, Vector3D u2, double a3, Vector3D u3) {
        this.x = MathArrays.linearCombination((double)a1, (double)u1.x, (double)a2, (double)u2.x, (double)a3, (double)u3.x);
        this.y = MathArrays.linearCombination((double)a1, (double)u1.y, (double)a2, (double)u2.y, (double)a3, (double)u3.y);
        this.z = MathArrays.linearCombination((double)a1, (double)u1.z, (double)a2, (double)u2.z, (double)a3, (double)u3.z);
    }

    public Vector3D(double a1, Vector3D u1, double a2, Vector3D u2, double a3, Vector3D u3, double a4, Vector3D u4) {
        this.x = MathArrays.linearCombination((double)a1, (double)u1.x, (double)a2, (double)u2.x, (double)a3, (double)u3.x, (double)a4, (double)u4.x);
        this.y = MathArrays.linearCombination((double)a1, (double)u1.y, (double)a2, (double)u2.y, (double)a3, (double)u3.y, (double)a4, (double)u4.y);
        this.z = MathArrays.linearCombination((double)a1, (double)u1.z, (double)a2, (double)u2.z, (double)a3, (double)u3.z, (double)a4, (double)u4.z);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double[] toArray() {
        return new double[]{this.x, this.y, this.z};
    }

    @Override
    public Space getSpace() {
        return Euclidean3D.getInstance();
    }

    public Vector3D getZero() {
        return ZERO;
    }

    @Override
    public double getNorm1() {
        return FastMath.abs((double)this.x) + FastMath.abs((double)this.y) + FastMath.abs((double)this.z);
    }

    @Override
    public double getNorm() {
        return FastMath.sqrt((double)(this.x * this.x + this.y * this.y + this.z * this.z));
    }

    @Override
    public double getNormSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    @Override
    public double getNormInf() {
        return FastMath.max((double)FastMath.max((double)FastMath.abs((double)this.x), (double)FastMath.abs((double)this.y)), (double)FastMath.abs((double)this.z));
    }

    public double getAlpha() {
        return FastMath.atan2((double)this.y, (double)this.x);
    }

    public double getDelta() {
        return FastMath.asin((double)(this.z / this.getNorm()));
    }

    public Vector3D add(Vector<Euclidean3D> v) {
        Vector3D v3 = (Vector3D)v;
        return new Vector3D(this.x + v3.x, this.y + v3.y, this.z + v3.z);
    }

    public Vector3D add(double factor, Vector<Euclidean3D> v) {
        return new Vector3D(1.0, this, factor, (Vector3D)v);
    }

    public Vector3D subtract(Vector<Euclidean3D> v) {
        Vector3D v3 = (Vector3D)v;
        return new Vector3D(this.x - v3.x, this.y - v3.y, this.z - v3.z);
    }

    public Vector3D subtract(double factor, Vector<Euclidean3D> v) {
        return new Vector3D(1.0, this, -factor, (Vector3D)v);
    }

    public Vector3D normalize() throws MathRuntimeException {
        double s = this.getNorm();
        if (s == 0.0) {
            throw new MathRuntimeException((Localizable)LocalizedGeometryFormats.CANNOT_NORMALIZE_A_ZERO_NORM_VECTOR, new Object[0]);
        }
        return this.scalarMultiply(1.0 / s);
    }

    public Vector3D orthogonal() throws MathRuntimeException {
        double threshold = 0.6 * this.getNorm();
        if (threshold == 0.0) {
            throw new MathRuntimeException((Localizable)LocalizedCoreFormats.ZERO_NORM, new Object[0]);
        }
        if (FastMath.abs((double)this.x) <= threshold) {
            double inverse = 1.0 / FastMath.sqrt((double)(this.y * this.y + this.z * this.z));
            return new Vector3D(0.0, inverse * this.z, -inverse * this.y);
        }
        if (FastMath.abs((double)this.y) <= threshold) {
            double inverse = 1.0 / FastMath.sqrt((double)(this.x * this.x + this.z * this.z));
            return new Vector3D(-inverse * this.z, 0.0, inverse * this.x);
        }
        double inverse = 1.0 / FastMath.sqrt((double)(this.x * this.x + this.y * this.y));
        return new Vector3D(inverse * this.y, -inverse * this.x, 0.0);
    }

    public static double angle(Vector3D v1, Vector3D v2) throws MathRuntimeException {
        double threshold;
        double normProduct = v1.getNorm() * v2.getNorm();
        if (normProduct == 0.0) {
            throw new MathRuntimeException((Localizable)LocalizedCoreFormats.ZERO_NORM, new Object[0]);
        }
        double dot = v1.dotProduct(v2);
        if (dot < -(threshold = normProduct * 0.9999) || dot > threshold) {
            Vector3D v3 = Vector3D.crossProduct(v1, v2);
            if (dot >= 0.0) {
                return FastMath.asin((double)(v3.getNorm() / normProduct));
            }
            return Math.PI - FastMath.asin((double)(v3.getNorm() / normProduct));
        }
        return FastMath.acos((double)(dot / normProduct));
    }

    public Vector3D negate() {
        return new Vector3D(-this.x, -this.y, -this.z);
    }

    public Vector3D scalarMultiply(double a) {
        return new Vector3D(a * this.x, a * this.y, a * this.z);
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    @Override
    public boolean isInfinite() {
        return !this.isNaN() && (Double.isInfinite(this.x) || Double.isInfinite(this.y) || Double.isInfinite(this.z));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Vector3D) {
            Vector3D rhs = (Vector3D)other;
            return this.x == rhs.x && this.y == rhs.y && this.z == rhs.z || this.isNaN() && rhs.isNaN();
        }
        return false;
    }

    public boolean equalsIeee754(Object other) {
        if (this == other && !this.isNaN()) {
            return true;
        }
        if (other instanceof Vector3D) {
            Vector3D rhs = (Vector3D)other;
            return this.x == rhs.x && this.y == rhs.y && this.z == rhs.z;
        }
        return false;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 642;
        }
        return 643 * (164 * MathUtils.hash((double)this.x) + 3 * MathUtils.hash((double)this.y) + MathUtils.hash((double)this.z));
    }

    @Override
    public double dotProduct(Vector<Euclidean3D> v) {
        Vector3D v3 = (Vector3D)v;
        return MathArrays.linearCombination((double)this.x, (double)v3.x, (double)this.y, (double)v3.y, (double)this.z, (double)v3.z);
    }

    public Vector3D crossProduct(Vector<Euclidean3D> v) {
        Vector3D v3 = (Vector3D)v;
        return new Vector3D(MathArrays.linearCombination((double)this.y, (double)v3.z, (double)(-this.z), (double)v3.y), MathArrays.linearCombination((double)this.z, (double)v3.x, (double)(-this.x), (double)v3.z), MathArrays.linearCombination((double)this.x, (double)v3.y, (double)(-this.y), (double)v3.x));
    }

    @Override
    public double distance1(Vector<Euclidean3D> v) {
        Vector3D v3 = (Vector3D)v;
        double dx = FastMath.abs((double)(v3.x - this.x));
        double dy = FastMath.abs((double)(v3.y - this.y));
        double dz = FastMath.abs((double)(v3.z - this.z));
        return dx + dy + dz;
    }

    @Override
    public double distance(Point<Euclidean3D> v) {
        Vector3D v3 = (Vector3D)v;
        double dx = v3.x - this.x;
        double dy = v3.y - this.y;
        double dz = v3.z - this.z;
        return FastMath.sqrt((double)(dx * dx + dy * dy + dz * dz));
    }

    @Override
    public double distanceInf(Vector<Euclidean3D> v) {
        Vector3D v3 = (Vector3D)v;
        double dx = FastMath.abs((double)(v3.x - this.x));
        double dy = FastMath.abs((double)(v3.y - this.y));
        double dz = FastMath.abs((double)(v3.z - this.z));
        return FastMath.max((double)FastMath.max((double)dx, (double)dy), (double)dz);
    }

    @Override
    public double distanceSq(Vector<Euclidean3D> v) {
        Vector3D v3 = (Vector3D)v;
        double dx = v3.x - this.x;
        double dy = v3.y - this.y;
        double dz = v3.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double dotProduct(Vector3D v1, Vector3D v2) {
        return v1.dotProduct(v2);
    }

    public static Vector3D crossProduct(Vector3D v1, Vector3D v2) {
        return v1.crossProduct(v2);
    }

    public static double distance1(Vector3D v1, Vector3D v2) {
        return v1.distance1(v2);
    }

    public static double distance(Vector3D v1, Vector3D v2) {
        return v1.distance(v2);
    }

    public static double distanceInf(Vector3D v1, Vector3D v2) {
        return v1.distanceInf(v2);
    }

    public static double distanceSq(Vector3D v1, Vector3D v2) {
        return v1.distanceSq(v2);
    }

    public String toString() {
        return Vector3DFormat.getVector3DFormat().format(this);
    }

    @Override
    public String toString(NumberFormat format) {
        return new Vector3DFormat(format).format(this);
    }
}

