/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.threed;

import java.io.Serializable;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;

public class FieldRotation<T extends CalculusFieldElement<T>>
implements Serializable {
    private static final long serialVersionUID = 20130224L;
    private final T q0;
    private final T q1;
    private final T q2;
    private final T q3;

    public FieldRotation(T q0, T q1, T q2, T q3, boolean needsNormalization) {
        if (needsNormalization) {
            CalculusFieldElement inv = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q0.square()).add((FieldElement)((CalculusFieldElement)q1.square()))).add((FieldElement)((CalculusFieldElement)q2.square()))).add((FieldElement)((CalculusFieldElement)q3.square()))).sqrt()).reciprocal();
            this.q0 = (CalculusFieldElement)inv.multiply(q0);
            this.q1 = (CalculusFieldElement)inv.multiply(q1);
            this.q2 = (CalculusFieldElement)inv.multiply(q2);
            this.q3 = (CalculusFieldElement)inv.multiply(q3);
        } else {
            this.q0 = q0;
            this.q1 = q1;
            this.q2 = q2;
            this.q3 = q3;
        }
    }

    public FieldRotation(FieldVector3D<T> axis, T angle, RotationConvention convention) throws MathIllegalArgumentException {
        T norm = axis.getNorm();
        if (norm.getReal() == 0.0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedGeometryFormats.ZERO_NORM_FOR_ROTATION_AXIS, new Object[0]);
        }
        CalculusFieldElement halfAngle = (CalculusFieldElement)angle.multiply(convention == RotationConvention.VECTOR_OPERATOR ? -0.5 : 0.5);
        FieldSinCos sinCos = FastMath.sinCos((CalculusFieldElement)halfAngle);
        CalculusFieldElement coeff = (CalculusFieldElement)((CalculusFieldElement)sinCos.sin()).divide(norm);
        this.q0 = (CalculusFieldElement)sinCos.cos();
        this.q1 = (CalculusFieldElement)coeff.multiply(axis.getX());
        this.q2 = (CalculusFieldElement)coeff.multiply(axis.getY());
        this.q3 = (CalculusFieldElement)coeff.multiply(axis.getZ());
    }

    public FieldRotation(Field<T> field, Rotation r) {
        this.q0 = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(r.getQ0());
        this.q1 = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(r.getQ1());
        this.q2 = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(r.getQ2());
        this.q3 = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(r.getQ3());
    }

    public FieldRotation(T[][] m, double threshold) throws MathIllegalArgumentException {
        if (m.length != 3 || m[0].length != 3 || m[1].length != 3 || m[2].length != 3) {
            throw new MathIllegalArgumentException((Localizable)LocalizedGeometryFormats.ROTATION_MATRIX_DIMENSIONS, new Object[]{m.length, m[0].length});
        }
        CalculusFieldElement[][] ort = this.orthogonalizeMatrix((CalculusFieldElement[][])m, threshold);
        CalculusFieldElement d0 = (CalculusFieldElement)((CalculusFieldElement)ort[1][1].multiply((FieldElement)ort[2][2])).subtract((FieldElement)((CalculusFieldElement)ort[2][1].multiply((FieldElement)ort[1][2])));
        CalculusFieldElement d1 = (CalculusFieldElement)((CalculusFieldElement)ort[0][1].multiply((FieldElement)ort[2][2])).subtract((FieldElement)((CalculusFieldElement)ort[2][1].multiply((FieldElement)ort[0][2])));
        CalculusFieldElement d2 = (CalculusFieldElement)((CalculusFieldElement)ort[0][1].multiply((FieldElement)ort[1][2])).subtract((FieldElement)((CalculusFieldElement)ort[1][1].multiply((FieldElement)ort[0][2])));
        CalculusFieldElement det = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ort[0][0].multiply((FieldElement)d0)).subtract((FieldElement)((CalculusFieldElement)ort[1][0].multiply((FieldElement)d1)))).add((FieldElement)((CalculusFieldElement)ort[2][0].multiply((FieldElement)d2)));
        if (det.getReal() < 0.0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedGeometryFormats.CLOSEST_ORTHOGONAL_MATRIX_HAS_NEGATIVE_DETERMINANT, new Object[]{det});
        }
        CalculusFieldElement[] quat = this.mat2quat(ort);
        this.q0 = quat[0];
        this.q1 = quat[1];
        this.q2 = quat[2];
        this.q3 = quat[3];
    }

    public FieldRotation(FieldVector3D<T> u1, FieldVector3D<T> u2, FieldVector3D<T> v1, FieldVector3D<T> v2) throws MathRuntimeException {
        FieldVector3D<T> u3 = FieldVector3D.crossProduct(u1, u2).normalize();
        u2 = FieldVector3D.crossProduct(u3, u1).normalize();
        u1 = u1.normalize();
        FieldVector3D<T> v3 = FieldVector3D.crossProduct(v1, v2).normalize();
        v2 = FieldVector3D.crossProduct(v3, v1).normalize();
        v1 = v1.normalize();
        CalculusFieldElement[][] array = (CalculusFieldElement[][])MathArrays.buildArray((Field)u1.getX().getField(), (int)3, (int)3);
        array[0][0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u1.getX().multiply(v1.getX())).add((FieldElement)((CalculusFieldElement)u2.getX().multiply(v2.getX())))).add((FieldElement)((CalculusFieldElement)u3.getX().multiply(v3.getX())));
        array[0][1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u1.getY().multiply(v1.getX())).add((FieldElement)((CalculusFieldElement)u2.getY().multiply(v2.getX())))).add((FieldElement)((CalculusFieldElement)u3.getY().multiply(v3.getX())));
        array[0][2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u1.getZ().multiply(v1.getX())).add((FieldElement)((CalculusFieldElement)u2.getZ().multiply(v2.getX())))).add((FieldElement)((CalculusFieldElement)u3.getZ().multiply(v3.getX())));
        array[1][0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u1.getX().multiply(v1.getY())).add((FieldElement)((CalculusFieldElement)u2.getX().multiply(v2.getY())))).add((FieldElement)((CalculusFieldElement)u3.getX().multiply(v3.getY())));
        array[1][1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u1.getY().multiply(v1.getY())).add((FieldElement)((CalculusFieldElement)u2.getY().multiply(v2.getY())))).add((FieldElement)((CalculusFieldElement)u3.getY().multiply(v3.getY())));
        array[1][2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u1.getZ().multiply(v1.getY())).add((FieldElement)((CalculusFieldElement)u2.getZ().multiply(v2.getY())))).add((FieldElement)((CalculusFieldElement)u3.getZ().multiply(v3.getY())));
        array[2][0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u1.getX().multiply(v1.getZ())).add((FieldElement)((CalculusFieldElement)u2.getX().multiply(v2.getZ())))).add((FieldElement)((CalculusFieldElement)u3.getX().multiply(v3.getZ())));
        array[2][1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u1.getY().multiply(v1.getZ())).add((FieldElement)((CalculusFieldElement)u2.getY().multiply(v2.getZ())))).add((FieldElement)((CalculusFieldElement)u3.getY().multiply(v3.getZ())));
        array[2][2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u1.getZ().multiply(v1.getZ())).add((FieldElement)((CalculusFieldElement)u2.getZ().multiply(v2.getZ())))).add((FieldElement)((CalculusFieldElement)u3.getZ().multiply(v3.getZ())));
        CalculusFieldElement[] quat = this.mat2quat(array);
        this.q0 = quat[0];
        this.q1 = quat[1];
        this.q2 = quat[2];
        this.q3 = quat[3];
    }

    public FieldRotation(FieldVector3D<T> u, FieldVector3D<T> v) throws MathRuntimeException {
        CalculusFieldElement normProduct = (CalculusFieldElement)u.getNorm().multiply(v.getNorm());
        if (normProduct.getReal() == 0.0) {
            throw new MathRuntimeException((Localizable)LocalizedGeometryFormats.ZERO_NORM_FOR_ROTATION_DEFINING_VECTOR, new Object[0]);
        }
        T dot = FieldVector3D.dotProduct(u, v);
        if (dot.getReal() < -0.999999999999998 * normProduct.getReal()) {
            FieldVector3D<T> w = u.orthogonal();
            this.q0 = (CalculusFieldElement)normProduct.getField().getZero();
            this.q1 = (CalculusFieldElement)w.getX().negate();
            this.q2 = (CalculusFieldElement)w.getY().negate();
            this.q3 = (CalculusFieldElement)w.getZ().negate();
        } else {
            this.q0 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dot.divide((FieldElement)normProduct)).add(1.0)).multiply(0.5)).sqrt();
            CalculusFieldElement coeff = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply((FieldElement)normProduct)).multiply(2.0)).reciprocal();
            FieldVector3D<T> q = FieldVector3D.crossProduct(v, u);
            this.q1 = (CalculusFieldElement)coeff.multiply(q.getX());
            this.q2 = (CalculusFieldElement)coeff.multiply(q.getY());
            this.q3 = (CalculusFieldElement)coeff.multiply(q.getZ());
        }
    }

    public FieldRotation(RotationOrder order, RotationConvention convention, T alpha1, T alpha2, T alpha3) {
        Field field = alpha1.getField();
        FieldRotation r1 = new FieldRotation(new FieldVector3D(field, order.getA1()), alpha1, convention);
        FieldRotation r2 = new FieldRotation(new FieldVector3D(field, order.getA2()), alpha2, convention);
        FieldRotation r3 = new FieldRotation(new FieldVector3D(field, order.getA3()), alpha3, convention);
        FieldRotation composed = r1.compose(r2.compose(r3, convention), convention);
        this.q0 = composed.q0;
        this.q1 = composed.q1;
        this.q2 = composed.q2;
        this.q3 = composed.q3;
    }

    public static <T extends CalculusFieldElement<T>> FieldRotation<T> getIdentity(Field<T> field) {
        return new FieldRotation<T>(field, Rotation.IDENTITY);
    }

    private T[] mat2quat(T[][] ort) {
        CalculusFieldElement[] quat = (CalculusFieldElement[])MathArrays.buildArray((Field)ort[0][0].getField(), (int)4);
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)ort[0][0].add(ort[1][1])).add(ort[2][2]);
        if (s.getReal() > -0.19) {
            quat[0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s.add(1.0)).sqrt()).multiply(0.5);
            CalculusFieldElement inv = (CalculusFieldElement)((CalculusFieldElement)quat[0].reciprocal()).multiply(0.25);
            quat[1] = (CalculusFieldElement)inv.multiply((FieldElement)((CalculusFieldElement)ort[1][2].subtract(ort[2][1])));
            quat[2] = (CalculusFieldElement)inv.multiply((FieldElement)((CalculusFieldElement)ort[2][0].subtract(ort[0][2])));
            quat[3] = (CalculusFieldElement)inv.multiply((FieldElement)((CalculusFieldElement)ort[0][1].subtract(ort[1][0])));
        } else {
            s = (CalculusFieldElement)((CalculusFieldElement)ort[0][0].subtract(ort[1][1])).subtract(ort[2][2]);
            if (s.getReal() > -0.19) {
                quat[1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s.add(1.0)).sqrt()).multiply(0.5);
                CalculusFieldElement inv = (CalculusFieldElement)((CalculusFieldElement)quat[1].reciprocal()).multiply(0.25);
                quat[0] = (CalculusFieldElement)inv.multiply((FieldElement)((CalculusFieldElement)ort[1][2].subtract(ort[2][1])));
                quat[2] = (CalculusFieldElement)inv.multiply((FieldElement)((CalculusFieldElement)ort[0][1].add(ort[1][0])));
                quat[3] = (CalculusFieldElement)inv.multiply((FieldElement)((CalculusFieldElement)ort[0][2].add(ort[2][0])));
            } else {
                s = (CalculusFieldElement)((CalculusFieldElement)ort[1][1].subtract(ort[0][0])).subtract(ort[2][2]);
                if (s.getReal() > -0.19) {
                    quat[2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s.add(1.0)).sqrt()).multiply(0.5);
                    CalculusFieldElement inv = (CalculusFieldElement)((CalculusFieldElement)quat[2].reciprocal()).multiply(0.25);
                    quat[0] = (CalculusFieldElement)inv.multiply((FieldElement)((CalculusFieldElement)ort[2][0].subtract(ort[0][2])));
                    quat[1] = (CalculusFieldElement)inv.multiply((FieldElement)((CalculusFieldElement)ort[0][1].add(ort[1][0])));
                    quat[3] = (CalculusFieldElement)inv.multiply((FieldElement)((CalculusFieldElement)ort[2][1].add(ort[1][2])));
                } else {
                    s = (CalculusFieldElement)((CalculusFieldElement)ort[2][2].subtract(ort[0][0])).subtract(ort[1][1]);
                    quat[3] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s.add(1.0)).sqrt()).multiply(0.5);
                    CalculusFieldElement inv = (CalculusFieldElement)((CalculusFieldElement)quat[3].reciprocal()).multiply(0.25);
                    quat[0] = (CalculusFieldElement)inv.multiply((FieldElement)((CalculusFieldElement)ort[0][1].subtract(ort[1][0])));
                    quat[1] = (CalculusFieldElement)inv.multiply((FieldElement)((CalculusFieldElement)ort[0][2].add(ort[2][0])));
                    quat[2] = (CalculusFieldElement)inv.multiply((FieldElement)((CalculusFieldElement)ort[2][1].add(ort[1][2])));
                }
            }
        }
        return quat;
    }

    public FieldRotation<T> revert() {
        return new FieldRotation<CalculusFieldElement>((CalculusFieldElement)this.q0.negate(), (CalculusFieldElement)this.q1, (CalculusFieldElement)this.q2, (CalculusFieldElement)this.q3, false);
    }

    public T getQ0() {
        return this.q0;
    }

    public T getQ1() {
        return this.q1;
    }

    public T getQ2() {
        return this.q2;
    }

    public T getQ3() {
        return this.q3;
    }

    public FieldVector3D<T> getAxis(RotationConvention convention) {
        double sgn;
        CalculusFieldElement squaredSine = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.square()).add((FieldElement)((CalculusFieldElement)this.q2.square()))).add((FieldElement)((CalculusFieldElement)this.q3.square()));
        if (squaredSine.getReal() == 0.0) {
            Field field = squaredSine.getField();
            return new FieldVector3D<CalculusFieldElement>(convention == RotationConvention.VECTOR_OPERATOR ? (CalculusFieldElement)field.getOne() : (CalculusFieldElement)((CalculusFieldElement)field.getOne()).negate(), (CalculusFieldElement)field.getZero(), (CalculusFieldElement)field.getZero());
        }
        double d = sgn = convention == RotationConvention.VECTOR_OPERATOR ? 1.0 : -1.0;
        if (this.q0.getReal() < 0.0) {
            CalculusFieldElement inverse = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)squaredSine.sqrt()).reciprocal()).multiply(sgn);
            return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.q1.multiply((FieldElement)inverse), (CalculusFieldElement)this.q2.multiply((FieldElement)inverse), (CalculusFieldElement)this.q3.multiply((FieldElement)inverse));
        }
        CalculusFieldElement inverse = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)squaredSine.sqrt()).reciprocal()).negate()).multiply(sgn);
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)this.q1.multiply((FieldElement)inverse), (CalculusFieldElement)this.q2.multiply((FieldElement)inverse), (CalculusFieldElement)this.q3.multiply((FieldElement)inverse));
    }

    public T getAngle() {
        if (this.q0.getReal() < -0.1 || this.q0.getReal() > 0.1) {
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.square()).add((FieldElement)((CalculusFieldElement)this.q2.square()))).add((FieldElement)((CalculusFieldElement)this.q3.square()))).sqrt()).asin()).multiply(2));
        }
        if (this.q0.getReal() < 0.0) {
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.negate()).acos()).multiply(2));
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.q0.acos()).multiply(2));
    }

    public T[] getAngles(RotationOrder order, RotationConvention convention) {
        return order.getAngles(this, convention);
    }

    public T[][] getMatrix() {
        CalculusFieldElement q0q0 = (CalculusFieldElement)this.q0.square();
        CalculusFieldElement q0q1 = (CalculusFieldElement)this.q0.multiply(this.q1);
        CalculusFieldElement q0q2 = (CalculusFieldElement)this.q0.multiply(this.q2);
        CalculusFieldElement q0q3 = (CalculusFieldElement)this.q0.multiply(this.q3);
        CalculusFieldElement q1q1 = (CalculusFieldElement)this.q1.square();
        CalculusFieldElement q1q2 = (CalculusFieldElement)this.q1.multiply(this.q2);
        CalculusFieldElement q1q3 = (CalculusFieldElement)this.q1.multiply(this.q3);
        CalculusFieldElement q2q2 = (CalculusFieldElement)this.q2.square();
        CalculusFieldElement q2q3 = (CalculusFieldElement)this.q2.multiply(this.q3);
        CalculusFieldElement q3q3 = (CalculusFieldElement)this.q3.square();
        CalculusFieldElement[][] m = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.q0.getField(), (int)3, (int)3);
        m[0][0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q0q0.add((FieldElement)q1q1)).multiply(2)).subtract(1.0);
        m[1][0] = (CalculusFieldElement)((CalculusFieldElement)q1q2.subtract((FieldElement)q0q3)).multiply(2);
        m[2][0] = (CalculusFieldElement)((CalculusFieldElement)q1q3.add((FieldElement)q0q2)).multiply(2);
        m[0][1] = (CalculusFieldElement)((CalculusFieldElement)q1q2.add((FieldElement)q0q3)).multiply(2);
        m[1][1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q0q0.add((FieldElement)q2q2)).multiply(2)).subtract(1.0);
        m[2][1] = (CalculusFieldElement)((CalculusFieldElement)q2q3.subtract((FieldElement)q0q1)).multiply(2);
        m[0][2] = (CalculusFieldElement)((CalculusFieldElement)q1q3.subtract((FieldElement)q0q2)).multiply(2);
        m[1][2] = (CalculusFieldElement)((CalculusFieldElement)q2q3.add((FieldElement)q0q1)).multiply(2);
        m[2][2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q0q0.add((FieldElement)q3q3)).multiply(2)).subtract(1.0);
        return m;
    }

    public Rotation toRotation() {
        return new Rotation(this.q0.getReal(), this.q1.getReal(), this.q2.getReal(), this.q3.getReal(), false);
    }

    public FieldVector3D<T> applyTo(FieldVector3D<T> u) {
        T x = u.getX();
        T y = u.getY();
        T z = u.getZ();
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(x)).add((FieldElement)((CalculusFieldElement)this.q2.multiply(y)))).add((FieldElement)((CalculusFieldElement)this.q3.multiply(z)));
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply(this.q0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q2.multiply(z)).subtract((FieldElement)((CalculusFieldElement)this.q3.multiply(y)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q1)))).multiply(2)).subtract(x), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)y.multiply(this.q0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q3.multiply(x)).subtract((FieldElement)((CalculusFieldElement)this.q1.multiply(z)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q2)))).multiply(2)).subtract(y), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)z.multiply(this.q0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(y)).subtract((FieldElement)((CalculusFieldElement)this.q2.multiply(x)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q3)))).multiply(2)).subtract(z));
    }

    public FieldVector3D<T> applyTo(Vector3D u) {
        double x = u.getX();
        double y = u.getY();
        double z = u.getZ();
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(x)).add((FieldElement)((CalculusFieldElement)this.q2.multiply(y)))).add((FieldElement)((CalculusFieldElement)this.q3.multiply(z)));
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply(x)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q2.multiply(z)).subtract((FieldElement)((CalculusFieldElement)this.q3.multiply(y)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q1)))).multiply(2)).subtract(x), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply(y)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q3.multiply(x)).subtract((FieldElement)((CalculusFieldElement)this.q1.multiply(z)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q2)))).multiply(2)).subtract(y), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply(z)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(y)).subtract((FieldElement)((CalculusFieldElement)this.q2.multiply(x)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q3)))).multiply(2)).subtract(z));
    }

    public void applyTo(T[] in, T[] out) {
        T x = in[0];
        T y = in[1];
        T z = in[2];
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(x)).add((FieldElement)((CalculusFieldElement)this.q2.multiply(y)))).add((FieldElement)((CalculusFieldElement)this.q3.multiply(z)));
        out[0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply(this.q0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q2.multiply(z)).subtract((FieldElement)((CalculusFieldElement)this.q3.multiply(y)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q1)))).multiply(2)).subtract(x);
        out[1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)y.multiply(this.q0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q3.multiply(x)).subtract((FieldElement)((CalculusFieldElement)this.q1.multiply(z)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q2)))).multiply(2)).subtract(y);
        out[2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)z.multiply(this.q0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(y)).subtract((FieldElement)((CalculusFieldElement)this.q2.multiply(x)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q3)))).multiply(2)).subtract(z);
    }

    public void applyTo(double[] in, T[] out) {
        double x = in[0];
        double y = in[1];
        double z = in[2];
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(x)).add((FieldElement)((CalculusFieldElement)this.q2.multiply(y)))).add((FieldElement)((CalculusFieldElement)this.q3.multiply(z)));
        out[0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply(x)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q2.multiply(z)).subtract((FieldElement)((CalculusFieldElement)this.q3.multiply(y)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q1)))).multiply(2)).subtract(x);
        out[1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply(y)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q3.multiply(x)).subtract((FieldElement)((CalculusFieldElement)this.q1.multiply(z)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q2)))).multiply(2)).subtract(y);
        out[2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply(z)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(y)).subtract((FieldElement)((CalculusFieldElement)this.q2.multiply(x)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q3)))).multiply(2)).subtract(z);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> applyTo(Rotation r, FieldVector3D<T> u) {
        T x = u.getX();
        T y = u.getY();
        T z = u.getZ();
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply(r.getQ1())).add((FieldElement)((CalculusFieldElement)y.multiply(r.getQ2())))).add((FieldElement)((CalculusFieldElement)z.multiply(r.getQ3())));
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply(r.getQ0())).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)z.multiply(r.getQ2())).subtract((FieldElement)((CalculusFieldElement)y.multiply(r.getQ3())))))).multiply(r.getQ0())).add((FieldElement)((CalculusFieldElement)s.multiply(r.getQ1())))).multiply(2)).subtract(x), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)y.multiply(r.getQ0())).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply(r.getQ3())).subtract((FieldElement)((CalculusFieldElement)z.multiply(r.getQ1())))))).multiply(r.getQ0())).add((FieldElement)((CalculusFieldElement)s.multiply(r.getQ2())))).multiply(2)).subtract(y), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)z.multiply(r.getQ0())).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)y.multiply(r.getQ1())).subtract((FieldElement)((CalculusFieldElement)x.multiply(r.getQ2())))))).multiply(r.getQ0())).add((FieldElement)((CalculusFieldElement)s.multiply(r.getQ3())))).multiply(2)).subtract(z));
    }

    public FieldVector3D<T> applyInverseTo(FieldVector3D<T> u) {
        T x = u.getX();
        T y = u.getY();
        T z = u.getZ();
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(x)).add((FieldElement)((CalculusFieldElement)this.q2.multiply(y)))).add((FieldElement)((CalculusFieldElement)this.q3.multiply(z)));
        CalculusFieldElement m0 = (CalculusFieldElement)this.q0.negate();
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)m0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q2.multiply(z)).subtract((FieldElement)((CalculusFieldElement)this.q3.multiply(y)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q1)))).multiply(2)).subtract(x), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)y.multiply((FieldElement)m0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q3.multiply(x)).subtract((FieldElement)((CalculusFieldElement)this.q1.multiply(z)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q2)))).multiply(2)).subtract(y), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)z.multiply((FieldElement)m0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(y)).subtract((FieldElement)((CalculusFieldElement)this.q2.multiply(x)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q3)))).multiply(2)).subtract(z));
    }

    public FieldVector3D<T> applyInverseTo(Vector3D u) {
        double x = u.getX();
        double y = u.getY();
        double z = u.getZ();
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(x)).add((FieldElement)((CalculusFieldElement)this.q2.multiply(y)))).add((FieldElement)((CalculusFieldElement)this.q3.multiply(z)));
        CalculusFieldElement m0 = (CalculusFieldElement)this.q0.negate();
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply(x)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q2.multiply(z)).subtract((FieldElement)((CalculusFieldElement)this.q3.multiply(y)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q1)))).multiply(2)).subtract(x), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply(y)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q3.multiply(x)).subtract((FieldElement)((CalculusFieldElement)this.q1.multiply(z)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q2)))).multiply(2)).subtract(y), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply(z)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(y)).subtract((FieldElement)((CalculusFieldElement)this.q2.multiply(x)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q3)))).multiply(2)).subtract(z));
    }

    public void applyInverseTo(T[] in, T[] out) {
        T x = in[0];
        T y = in[1];
        T z = in[2];
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(x)).add((FieldElement)((CalculusFieldElement)this.q2.multiply(y)))).add((FieldElement)((CalculusFieldElement)this.q3.multiply(z)));
        CalculusFieldElement m0 = (CalculusFieldElement)this.q0.negate();
        out[0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)m0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q2.multiply(z)).subtract((FieldElement)((CalculusFieldElement)this.q3.multiply(y)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q1)))).multiply(2)).subtract(x);
        out[1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)y.multiply((FieldElement)m0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q3.multiply(x)).subtract((FieldElement)((CalculusFieldElement)this.q1.multiply(z)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q2)))).multiply(2)).subtract(y);
        out[2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)z.multiply((FieldElement)m0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(y)).subtract((FieldElement)((CalculusFieldElement)this.q2.multiply(x)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q3)))).multiply(2)).subtract(z);
    }

    public void applyInverseTo(double[] in, T[] out) {
        double x = in[0];
        double y = in[1];
        double z = in[2];
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(x)).add((FieldElement)((CalculusFieldElement)this.q2.multiply(y)))).add((FieldElement)((CalculusFieldElement)this.q3.multiply(z)));
        CalculusFieldElement m0 = (CalculusFieldElement)this.q0.negate();
        out[0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply(x)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q2.multiply(z)).subtract((FieldElement)((CalculusFieldElement)this.q3.multiply(y)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q1)))).multiply(2)).subtract(x);
        out[1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply(y)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q3.multiply(x)).subtract((FieldElement)((CalculusFieldElement)this.q1.multiply(z)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q2)))).multiply(2)).subtract(y);
        out[2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.multiply(z)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(y)).subtract((FieldElement)((CalculusFieldElement)this.q2.multiply(x)))))))).add((FieldElement)((CalculusFieldElement)s.multiply(this.q3)))).multiply(2)).subtract(z);
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> applyInverseTo(Rotation r, FieldVector3D<T> u) {
        T x = u.getX();
        T y = u.getY();
        T z = u.getZ();
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply(r.getQ1())).add((FieldElement)((CalculusFieldElement)y.multiply(r.getQ2())))).add((FieldElement)((CalculusFieldElement)z.multiply(r.getQ3())));
        double m0 = -r.getQ0();
        return new FieldVector3D<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply(m0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)z.multiply(r.getQ2())).subtract((FieldElement)((CalculusFieldElement)y.multiply(r.getQ3())))))).multiply(m0)).add((FieldElement)((CalculusFieldElement)s.multiply(r.getQ1())))).multiply(2)).subtract(x), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)y.multiply(m0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply(r.getQ3())).subtract((FieldElement)((CalculusFieldElement)z.multiply(r.getQ1())))))).multiply(m0)).add((FieldElement)((CalculusFieldElement)s.multiply(r.getQ2())))).multiply(2)).subtract(y), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)z.multiply(m0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)y.multiply(r.getQ1())).subtract((FieldElement)((CalculusFieldElement)x.multiply(r.getQ2())))))).multiply(m0)).add((FieldElement)((CalculusFieldElement)s.multiply(r.getQ3())))).multiply(2)).subtract(z));
    }

    public FieldRotation<T> applyTo(FieldRotation<T> r) {
        return this.compose(r, RotationConvention.VECTOR_OPERATOR);
    }

    public FieldRotation<T> compose(FieldRotation<T> r, RotationConvention convention) {
        return convention == RotationConvention.VECTOR_OPERATOR ? this.composeInternal(r) : super.composeInternal(this);
    }

    private FieldRotation<T> composeInternal(FieldRotation<T> r) {
        return new FieldRotation<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)r.q0.multiply(this.q0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.q1.multiply(this.q1)).add((FieldElement)((CalculusFieldElement)r.q2.multiply(this.q2)))).add((FieldElement)((CalculusFieldElement)r.q3.multiply(this.q3))))), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.q1.multiply(this.q0)).add((FieldElement)((CalculusFieldElement)r.q0.multiply(this.q1)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)r.q2.multiply(this.q3)).subtract((FieldElement)((CalculusFieldElement)r.q3.multiply(this.q2))))), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.q2.multiply(this.q0)).add((FieldElement)((CalculusFieldElement)r.q0.multiply(this.q2)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)r.q3.multiply(this.q1)).subtract((FieldElement)((CalculusFieldElement)r.q1.multiply(this.q3))))), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.q3.multiply(this.q0)).add((FieldElement)((CalculusFieldElement)r.q0.multiply(this.q3)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)r.q1.multiply(this.q2)).subtract((FieldElement)((CalculusFieldElement)r.q2.multiply(this.q1))))), false);
    }

    public FieldRotation<T> applyTo(Rotation r) {
        return this.compose(r, RotationConvention.VECTOR_OPERATOR);
    }

    public FieldRotation<T> compose(Rotation r, RotationConvention convention) {
        return convention == RotationConvention.VECTOR_OPERATOR ? this.composeInternal(r) : FieldRotation.applyTo(r, this);
    }

    private FieldRotation<T> composeInternal(Rotation r) {
        return new FieldRotation<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply(r.getQ0())).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(r.getQ1())).add((FieldElement)((CalculusFieldElement)this.q2.multiply(r.getQ2())))).add((FieldElement)((CalculusFieldElement)this.q3.multiply(r.getQ3()))))), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply(r.getQ1())).add((FieldElement)((CalculusFieldElement)this.q1.multiply(r.getQ0())))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q3.multiply(r.getQ2())).subtract((FieldElement)((CalculusFieldElement)this.q2.multiply(r.getQ3()))))), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply(r.getQ2())).add((FieldElement)((CalculusFieldElement)this.q2.multiply(r.getQ0())))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(r.getQ3())).subtract((FieldElement)((CalculusFieldElement)this.q3.multiply(r.getQ1()))))), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply(r.getQ3())).add((FieldElement)((CalculusFieldElement)this.q3.multiply(r.getQ0())))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q2.multiply(r.getQ1())).subtract((FieldElement)((CalculusFieldElement)this.q1.multiply(r.getQ2()))))), false);
    }

    public static <T extends CalculusFieldElement<T>> FieldRotation<T> applyTo(Rotation r1, FieldRotation<T> rInner) {
        return new FieldRotation<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)rInner.q0.multiply(r1.getQ0())).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rInner.q1.multiply(r1.getQ1())).add((FieldElement)((CalculusFieldElement)rInner.q2.multiply(r1.getQ2())))).add((FieldElement)((CalculusFieldElement)rInner.q3.multiply(r1.getQ3()))))), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rInner.q1.multiply(r1.getQ0())).add((FieldElement)((CalculusFieldElement)rInner.q0.multiply(r1.getQ1())))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)rInner.q2.multiply(r1.getQ3())).subtract((FieldElement)((CalculusFieldElement)rInner.q3.multiply(r1.getQ2()))))), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rInner.q2.multiply(r1.getQ0())).add((FieldElement)((CalculusFieldElement)rInner.q0.multiply(r1.getQ2())))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)rInner.q3.multiply(r1.getQ1())).subtract((FieldElement)((CalculusFieldElement)rInner.q1.multiply(r1.getQ3()))))), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rInner.q3.multiply(r1.getQ0())).add((FieldElement)((CalculusFieldElement)rInner.q0.multiply(r1.getQ3())))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)rInner.q1.multiply(r1.getQ2())).subtract((FieldElement)((CalculusFieldElement)rInner.q2.multiply(r1.getQ1()))))), false);
    }

    public FieldRotation<T> applyInverseTo(FieldRotation<T> r) {
        return this.composeInverse(r, RotationConvention.VECTOR_OPERATOR);
    }

    public FieldRotation<T> composeInverse(FieldRotation<T> r, RotationConvention convention) {
        return convention == RotationConvention.VECTOR_OPERATOR ? this.composeInverseInternal(r) : super.composeInternal(this.revert());
    }

    private FieldRotation<T> composeInverseInternal(FieldRotation<T> r) {
        return new FieldRotation<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.q0.multiply(this.q0)).add((FieldElement)((CalculusFieldElement)r.q1.multiply(this.q1)))).add((FieldElement)((CalculusFieldElement)r.q2.multiply(this.q2)))).add((FieldElement)((CalculusFieldElement)r.q3.multiply(this.q3)))).negate(), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.q0.multiply(this.q1)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)r.q2.multiply(this.q3)).subtract((FieldElement)((CalculusFieldElement)r.q3.multiply(this.q2)))))).subtract((FieldElement)((CalculusFieldElement)r.q1.multiply(this.q0))), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.q0.multiply(this.q2)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)r.q3.multiply(this.q1)).subtract((FieldElement)((CalculusFieldElement)r.q1.multiply(this.q3)))))).subtract((FieldElement)((CalculusFieldElement)r.q2.multiply(this.q0))), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.q0.multiply(this.q3)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)r.q1.multiply(this.q2)).subtract((FieldElement)((CalculusFieldElement)r.q2.multiply(this.q1)))))).subtract((FieldElement)((CalculusFieldElement)r.q3.multiply(this.q0))), false);
    }

    public FieldRotation<T> applyInverseTo(Rotation r) {
        return this.composeInverse(r, RotationConvention.VECTOR_OPERATOR);
    }

    public FieldRotation<T> composeInverse(Rotation r, RotationConvention convention) {
        return convention == RotationConvention.VECTOR_OPERATOR ? this.composeInverseInternal(r) : FieldRotation.applyTo(r, this.revert());
    }

    private FieldRotation<T> composeInverseInternal(Rotation r) {
        return new FieldRotation<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q0.multiply(r.getQ0())).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(r.getQ1())).add((FieldElement)((CalculusFieldElement)this.q2.multiply(r.getQ2())))).add((FieldElement)((CalculusFieldElement)this.q3.multiply(r.getQ3())))))).negate(), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(r.getQ0())).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q3.multiply(r.getQ2())).subtract((FieldElement)((CalculusFieldElement)this.q2.multiply(r.getQ3())))))).subtract((FieldElement)((CalculusFieldElement)this.q0.multiply(r.getQ1()))), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q2.multiply(r.getQ0())).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q1.multiply(r.getQ3())).subtract((FieldElement)((CalculusFieldElement)this.q3.multiply(r.getQ1())))))).subtract((FieldElement)((CalculusFieldElement)this.q0.multiply(r.getQ2()))), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q3.multiply(r.getQ0())).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.q2.multiply(r.getQ1())).subtract((FieldElement)((CalculusFieldElement)this.q1.multiply(r.getQ2())))))).subtract((FieldElement)((CalculusFieldElement)this.q0.multiply(r.getQ3()))), false);
    }

    public static <T extends CalculusFieldElement<T>> FieldRotation<T> applyInverseTo(Rotation rOuter, FieldRotation<T> rInner) {
        return new FieldRotation<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rInner.q0.multiply(rOuter.getQ0())).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rInner.q1.multiply(rOuter.getQ1())).add((FieldElement)((CalculusFieldElement)rInner.q2.multiply(rOuter.getQ2())))).add((FieldElement)((CalculusFieldElement)rInner.q3.multiply(rOuter.getQ3())))))).negate(), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rInner.q0.multiply(rOuter.getQ1())).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)rInner.q2.multiply(rOuter.getQ3())).subtract((FieldElement)((CalculusFieldElement)rInner.q3.multiply(rOuter.getQ2())))))).subtract((FieldElement)((CalculusFieldElement)rInner.q1.multiply(rOuter.getQ0()))), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rInner.q0.multiply(rOuter.getQ2())).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)rInner.q3.multiply(rOuter.getQ1())).subtract((FieldElement)((CalculusFieldElement)rInner.q1.multiply(rOuter.getQ3())))))).subtract((FieldElement)((CalculusFieldElement)rInner.q2.multiply(rOuter.getQ0()))), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rInner.q0.multiply(rOuter.getQ3())).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)rInner.q1.multiply(rOuter.getQ2())).subtract((FieldElement)((CalculusFieldElement)rInner.q2.multiply(rOuter.getQ1())))))).subtract((FieldElement)((CalculusFieldElement)rInner.q3.multiply(rOuter.getQ0()))), false);
    }

    private T[][] orthogonalizeMatrix(T[][] m, double threshold) throws MathIllegalArgumentException {
        int i;
        Object x00 = m[0][0];
        Object x01 = m[0][1];
        Object x02 = m[0][2];
        Object x10 = m[1][0];
        Object x11 = m[1][1];
        Object x12 = m[1][2];
        Object x20 = m[2][0];
        Object x21 = m[2][1];
        Object x22 = m[2][2];
        double fn = 0.0;
        CalculusFieldElement[][] o = (CalculusFieldElement[][])MathArrays.buildArray((Field)m[0][0].getField(), (int)3, (int)3);
        for (i = 0; i < 11; ++i) {
            double corr22;
            double corr21;
            double corr20;
            double corr12;
            double corr11;
            double corr10;
            double corr02;
            double corr01;
            CalculusFieldElement mx00 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m[0][0].multiply(x00)).add((FieldElement)((CalculusFieldElement)m[1][0].multiply(x10)))).add((FieldElement)((CalculusFieldElement)m[2][0].multiply(x20)));
            CalculusFieldElement mx10 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m[0][1].multiply(x00)).add((FieldElement)((CalculusFieldElement)m[1][1].multiply(x10)))).add((FieldElement)((CalculusFieldElement)m[2][1].multiply(x20)));
            CalculusFieldElement mx20 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m[0][2].multiply(x00)).add((FieldElement)((CalculusFieldElement)m[1][2].multiply(x10)))).add((FieldElement)((CalculusFieldElement)m[2][2].multiply(x20)));
            CalculusFieldElement mx01 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m[0][0].multiply(x01)).add((FieldElement)((CalculusFieldElement)m[1][0].multiply(x11)))).add((FieldElement)((CalculusFieldElement)m[2][0].multiply(x21)));
            CalculusFieldElement mx11 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m[0][1].multiply(x01)).add((FieldElement)((CalculusFieldElement)m[1][1].multiply(x11)))).add((FieldElement)((CalculusFieldElement)m[2][1].multiply(x21)));
            CalculusFieldElement mx21 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m[0][2].multiply(x01)).add((FieldElement)((CalculusFieldElement)m[1][2].multiply(x11)))).add((FieldElement)((CalculusFieldElement)m[2][2].multiply(x21)));
            CalculusFieldElement mx02 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m[0][0].multiply(x02)).add((FieldElement)((CalculusFieldElement)m[1][0].multiply(x12)))).add((FieldElement)((CalculusFieldElement)m[2][0].multiply(x22)));
            CalculusFieldElement mx12 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m[0][1].multiply(x02)).add((FieldElement)((CalculusFieldElement)m[1][1].multiply(x12)))).add((FieldElement)((CalculusFieldElement)m[2][1].multiply(x22)));
            CalculusFieldElement mx22 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m[0][2].multiply(x02)).add((FieldElement)((CalculusFieldElement)m[1][2].multiply(x12)))).add((FieldElement)((CalculusFieldElement)m[2][2].multiply(x22)));
            o[0][0] = (CalculusFieldElement)x00.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x00.multiply((FieldElement)mx00)).add((FieldElement)((CalculusFieldElement)x01.multiply((FieldElement)mx10)))).add((FieldElement)((CalculusFieldElement)x02.multiply((FieldElement)mx20)))).subtract(m[0][0])).multiply(0.5)));
            o[0][1] = (CalculusFieldElement)x01.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x00.multiply((FieldElement)mx01)).add((FieldElement)((CalculusFieldElement)x01.multiply((FieldElement)mx11)))).add((FieldElement)((CalculusFieldElement)x02.multiply((FieldElement)mx21)))).subtract(m[0][1])).multiply(0.5)));
            o[0][2] = (CalculusFieldElement)x02.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x00.multiply((FieldElement)mx02)).add((FieldElement)((CalculusFieldElement)x01.multiply((FieldElement)mx12)))).add((FieldElement)((CalculusFieldElement)x02.multiply((FieldElement)mx22)))).subtract(m[0][2])).multiply(0.5)));
            o[1][0] = (CalculusFieldElement)x10.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x10.multiply((FieldElement)mx00)).add((FieldElement)((CalculusFieldElement)x11.multiply((FieldElement)mx10)))).add((FieldElement)((CalculusFieldElement)x12.multiply((FieldElement)mx20)))).subtract(m[1][0])).multiply(0.5)));
            o[1][1] = (CalculusFieldElement)x11.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x10.multiply((FieldElement)mx01)).add((FieldElement)((CalculusFieldElement)x11.multiply((FieldElement)mx11)))).add((FieldElement)((CalculusFieldElement)x12.multiply((FieldElement)mx21)))).subtract(m[1][1])).multiply(0.5)));
            o[1][2] = (CalculusFieldElement)x12.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x10.multiply((FieldElement)mx02)).add((FieldElement)((CalculusFieldElement)x11.multiply((FieldElement)mx12)))).add((FieldElement)((CalculusFieldElement)x12.multiply((FieldElement)mx22)))).subtract(m[1][2])).multiply(0.5)));
            o[2][0] = (CalculusFieldElement)x20.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x20.multiply((FieldElement)mx00)).add((FieldElement)((CalculusFieldElement)x21.multiply((FieldElement)mx10)))).add((FieldElement)((CalculusFieldElement)x22.multiply((FieldElement)mx20)))).subtract(m[2][0])).multiply(0.5)));
            o[2][1] = (CalculusFieldElement)x21.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x20.multiply((FieldElement)mx01)).add((FieldElement)((CalculusFieldElement)x21.multiply((FieldElement)mx11)))).add((FieldElement)((CalculusFieldElement)x22.multiply((FieldElement)mx21)))).subtract(m[2][1])).multiply(0.5)));
            o[2][2] = (CalculusFieldElement)x22.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x20.multiply((FieldElement)mx02)).add((FieldElement)((CalculusFieldElement)x21.multiply((FieldElement)mx12)))).add((FieldElement)((CalculusFieldElement)x22.multiply((FieldElement)mx22)))).subtract(m[2][2])).multiply(0.5)));
            double corr00 = o[0][0].getReal() - m[0][0].getReal();
            double fn1 = corr00 * corr00 + (corr01 = o[0][1].getReal() - m[0][1].getReal()) * corr01 + (corr02 = o[0][2].getReal() - m[0][2].getReal()) * corr02 + (corr10 = o[1][0].getReal() - m[1][0].getReal()) * corr10 + (corr11 = o[1][1].getReal() - m[1][1].getReal()) * corr11 + (corr12 = o[1][2].getReal() - m[1][2].getReal()) * corr12 + (corr20 = o[2][0].getReal() - m[2][0].getReal()) * corr20 + (corr21 = o[2][1].getReal() - m[2][1].getReal()) * corr21 + (corr22 = o[2][2].getReal() - m[2][2].getReal()) * corr22;
            if (FastMath.abs((double)(fn1 - fn)) <= threshold) {
                return o;
            }
            x00 = o[0][0];
            x01 = o[0][1];
            x02 = o[0][2];
            x10 = o[1][0];
            x11 = o[1][1];
            x12 = o[1][2];
            x20 = o[2][0];
            x21 = o[2][1];
            x22 = o[2][2];
            fn = fn1;
        }
        throw new MathIllegalArgumentException((Localizable)LocalizedGeometryFormats.UNABLE_TO_ORTHOGONOLIZE_MATRIX, new Object[]{i - 1});
    }

    public static <T extends CalculusFieldElement<T>> T distance(FieldRotation<T> r1, FieldRotation<T> r2) {
        return super.composeInverseInternal(r2).getAngle();
    }
}

