/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.twod;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.geometry.euclidean.oned.Euclidean1D;
import org.hipparchus.geometry.euclidean.oned.Interval;
import org.hipparchus.geometry.euclidean.oned.IntervalsSet;
import org.hipparchus.geometry.euclidean.oned.OrientedPoint;
import org.hipparchus.geometry.euclidean.oned.SubOrientedPoint;
import org.hipparchus.geometry.euclidean.oned.Vector1D;
import org.hipparchus.geometry.euclidean.twod.Euclidean2D;
import org.hipparchus.geometry.euclidean.twod.Line;
import org.hipparchus.geometry.euclidean.twod.Segment;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.geometry.partitioning.AbstractSubHyperplane;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.SubHyperplane;
import org.hipparchus.util.FastMath;

public class SubLine
extends AbstractSubHyperplane<Euclidean2D, Vector2D, Line, SubLine, Euclidean1D, Vector1D, OrientedPoint, SubOrientedPoint> {
    public SubLine(Line hyperplane, Region<Euclidean1D, Vector1D, OrientedPoint, SubOrientedPoint> remainingRegion) {
        super(hyperplane, remainingRegion);
    }

    public SubLine(Vector2D start, Vector2D end, double tolerance) {
        super(new Line(start, end, tolerance), SubLine.buildIntervalSet(start, end, tolerance));
    }

    public SubLine(Segment segment) {
        super(segment.getLine(), SubLine.buildIntervalSet(segment.getStart(), segment.getEnd(), segment.getLine().getTolerance()));
    }

    public List<Segment> getSegments() {
        List<Interval> list = ((IntervalsSet)this.getRemainingRegion()).asList();
        ArrayList<Segment> segments = new ArrayList<Segment>(list.size());
        for (Interval interval : list) {
            Vector2D start = ((Line)this.getHyperplane()).toSpace(new Vector1D(interval.getInf()));
            Vector2D end = ((Line)this.getHyperplane()).toSpace(new Vector1D(interval.getSup()));
            segments.add(new Segment(start, end, (Line)this.getHyperplane()));
        }
        return segments;
    }

    public Vector2D intersection(SubLine subLine, boolean includeEndPoints) {
        Line line2;
        Line line1 = (Line)this.getHyperplane();
        Vector2D v2D = line1.intersection(line2 = (Line)subLine.getHyperplane());
        if (v2D == null) {
            return null;
        }
        Region.Location loc1 = this.getRemainingRegion().checkPoint(line1.toSubSpace(v2D));
        Region.Location loc2 = subLine.getRemainingRegion().checkPoint(line2.toSubSpace(v2D));
        if (includeEndPoints) {
            return loc1 != Region.Location.OUTSIDE && loc2 != Region.Location.OUTSIDE ? v2D : null;
        }
        return loc1 == Region.Location.INSIDE && loc2 == Region.Location.INSIDE ? v2D : null;
    }

    private static IntervalsSet buildIntervalSet(Vector2D start, Vector2D end, double tolerance) {
        Line line = new Line(start, end, tolerance);
        return new IntervalsSet(line.toSubSpace(start).getX(), line.toSubSpace(end).getX(), tolerance);
    }

    @Override
    protected SubLine buildNew(Line hyperplane, Region<Euclidean1D, Vector1D, OrientedPoint, SubOrientedPoint> remainingRegion) {
        return new SubLine(hyperplane, remainingRegion);
    }

    @Override
    public Vector2D getInteriorPoint() {
        Vector1D v = (Vector1D)this.getRemainingRegion().getInteriorPoint();
        return this.isEmpty() ? null : ((Line)this.getHyperplane()).toSpace(v);
    }

    @Override
    public SubHyperplane.SplitSubHyperplane<Euclidean2D, Vector2D, Line, SubLine> split(Line hyperplane) {
        Line thisLine = (Line)this.getHyperplane();
        Vector2D crossing = thisLine.intersection(hyperplane);
        double tolerance = thisLine.getTolerance();
        if (crossing == null) {
            double global = hyperplane.getOffset(thisLine);
            if (global < -tolerance) {
                return new SubHyperplane.SplitSubHyperplane<Euclidean2D, Vector2D, Line, SubLine>(null, this);
            }
            if (global > tolerance) {
                return new SubHyperplane.SplitSubHyperplane(this, null);
            }
            return new SubHyperplane.SplitSubHyperplane(null, null);
        }
        boolean direct = FastMath.sin((double)(thisLine.getAngle() - hyperplane.getAngle())) < 0.0;
        Vector1D x = thisLine.toSubSpace(crossing);
        SubOrientedPoint subPlus = new OrientedPoint(x, !direct, tolerance).wholeHyperplane();
        SubOrientedPoint subMinus = new OrientedPoint(x, direct, tolerance).wholeHyperplane();
        BSPTree splitTree = this.getRemainingRegion().getTree(false).split(subMinus);
        BSPTree<Euclidean1D, Vector1D, OrientedPoint, SubOrientedPoint> plusTree = this.getRemainingRegion().isEmpty(splitTree.getPlus()) ? new BSPTree<Euclidean1D, Vector1D, OrientedPoint, SubOrientedPoint>(Boolean.FALSE) : new BSPTree(subPlus, new BSPTree(Boolean.FALSE), splitTree.getPlus(), null);
        BSPTree<Euclidean1D, Vector1D, OrientedPoint, SubOrientedPoint> minusTree = this.getRemainingRegion().isEmpty(splitTree.getMinus()) ? new BSPTree<Euclidean1D, Vector1D, OrientedPoint, SubOrientedPoint>(Boolean.FALSE) : new BSPTree(subMinus, new BSPTree(Boolean.FALSE), splitTree.getMinus(), null);
        return new SubHyperplane.SplitSubHyperplane<Euclidean2D, Vector2D, Line, SubLine>(new SubLine(thisLine.copySelf(), new IntervalsSet(plusTree, tolerance)), new SubLine(thisLine.copySelf(), new IntervalsSet(minusTree, tolerance)));
    }
}

