/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.partitioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.partitioning.AbstractSubHyperplane;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.BSPTreeVisitor;
import org.hipparchus.geometry.partitioning.BoundaryAttribute;
import org.hipparchus.geometry.partitioning.BoundaryBuilder;
import org.hipparchus.geometry.partitioning.BoundaryProjection;
import org.hipparchus.geometry.partitioning.BoundaryProjector;
import org.hipparchus.geometry.partitioning.BoundarySizeVisitor;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.partitioning.NodesSet;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.RegionFactory;
import org.hipparchus.geometry.partitioning.SubHyperplane;
import org.hipparchus.geometry.partitioning.Transform;

public abstract class AbstractRegion<S extends Space, P extends Point<S, P>, H extends Hyperplane<S, P, H, I>, I extends SubHyperplane<S, P, H, I>, T extends Space, Q extends Point<T, Q>, F extends Hyperplane<T, Q, F, J>, J extends SubHyperplane<T, Q, F, J>>
implements Region<S, P, H, I> {
    private final BSPTree<S, P, H, I> tree;
    private final double tolerance;
    private double size;
    private P barycenter;

    protected AbstractRegion(double tolerance) {
        this.tree = new BSPTree(Boolean.TRUE);
        this.tolerance = tolerance;
    }

    protected AbstractRegion(BSPTree<S, P, H, I> tree, double tolerance) {
        this.tree = tree;
        this.tolerance = tolerance;
    }

    protected AbstractRegion(Collection<I> boundary, double tolerance) {
        this.tolerance = tolerance;
        if (boundary.isEmpty()) {
            this.tree = new BSPTree(Boolean.TRUE);
        } else {
            TreeSet<I> ordered = new TreeSet<I>(new Comparator<I>(){

                @Override
                public int compare(I o1, I o2) {
                    double size1 = o1.getSize();
                    double size2 = o2.getSize();
                    return size2 < size1 ? -1 : (o1 == o2 ? 0 : 1);
                }
            });
            ordered.addAll(boundary);
            this.tree = new BSPTree();
            this.insertCuts(this.tree, ordered);
            this.tree.visit(new BSPTreeVisitor<S, P, H, I>(){

                @Override
                public BSPTreeVisitor.Order visitOrder(BSPTree<S, P, H, I> node) {
                    return BSPTreeVisitor.Order.PLUS_SUB_MINUS;
                }

                @Override
                public void visitInternalNode(BSPTree<S, P, H, I> node) {
                }

                @Override
                public void visitLeafNode(BSPTree<S, P, H, I> node) {
                    if (node.getParent() == null || node == node.getParent().getMinus()) {
                        node.setAttribute(Boolean.TRUE);
                    } else {
                        node.setAttribute(Boolean.FALSE);
                    }
                }
            });
        }
    }

    public AbstractRegion(H[] hyperplanes, double tolerance) {
        this.tolerance = tolerance;
        if (hyperplanes == null || hyperplanes.length == 0) {
            this.tree = new BSPTree(Boolean.FALSE);
        } else {
            this.tree = hyperplanes[0].wholeSpace().getTree(false);
            BSPTree<S, P, H, I> node = this.tree;
            node.setAttribute(Boolean.TRUE);
            for (H hyperplane : hyperplanes) {
                if (!node.insertCut(hyperplane)) continue;
                node.setAttribute(null);
                node.getPlus().setAttribute(Boolean.FALSE);
                node = node.getMinus();
                node.setAttribute(Boolean.TRUE);
            }
        }
    }

    public abstract AbstractRegion<S, P, H, I, T, Q, F, J> buildNew(BSPTree<S, P, H, I> var1);

    public double getTolerance() {
        return this.tolerance;
    }

    private void insertCuts(BSPTree<S, P, H, I> node, Collection<I> boundary) {
        Iterator<I> iterator = boundary.iterator();
        Hyperplane inserted = null;
        while (inserted == null && iterator.hasNext()) {
            inserted = (Hyperplane)((SubHyperplane)iterator.next()).getHyperplane();
            if (node.insertCut(inserted.copySelf())) continue;
            inserted = null;
        }
        if (!iterator.hasNext()) {
            return;
        }
        ArrayList plusList = new ArrayList();
        ArrayList minusList = new ArrayList();
        while (iterator.hasNext()) {
            SubHyperplane other = (SubHyperplane)iterator.next();
            SubHyperplane.SplitSubHyperplane split = other.split(inserted);
            switch (split.getSide()) {
                case PLUS: {
                    plusList.add(other);
                    break;
                }
                case MINUS: {
                    minusList.add(other);
                    break;
                }
                case BOTH: {
                    plusList.add(split.getPlus());
                    minusList.add(split.getMinus());
                    break;
                }
            }
        }
        this.insertCuts(node.getPlus(), plusList);
        this.insertCuts(node.getMinus(), minusList);
    }

    public AbstractRegion<S, P, H, I, T, Q, F, J> copySelf() {
        return this.buildNew((BSPTree)this.tree.copySelf());
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty(this.tree);
    }

    @Override
    public boolean isEmpty(BSPTree<S, P, H, I> node) {
        if (node.getCut() == null) {
            return (Boolean)node.getAttribute() == false;
        }
        return this.isEmpty(node.getMinus()) && this.isEmpty(node.getPlus());
    }

    @Override
    public boolean isFull() {
        return this.isFull(this.tree);
    }

    @Override
    public boolean isFull(BSPTree<S, P, H, I> node) {
        if (node.getCut() == null) {
            return (Boolean)node.getAttribute();
        }
        return this.isFull(node.getMinus()) && this.isFull(node.getPlus());
    }

    @Override
    public boolean contains(Region<S, P, H, I> region) {
        return new RegionFactory<S, P, H, I>().difference(region, this).isEmpty();
    }

    @Override
    public BoundaryProjection<S, P> projectToBoundary(P point) {
        BoundaryProjector projector = new BoundaryProjector(point);
        this.getTree(true).visit(projector);
        return projector.getProjection();
    }

    @Override
    public Region.Location checkPoint(P point) {
        return this.checkPoint(this.tree, point);
    }

    protected Region.Location checkPoint(BSPTree<S, P, H, I> node, P point) {
        Region.Location plusCode;
        BSPTree<S, P, H, I> cell = node.getCell(point, this.tolerance);
        if (cell.getCut() == null) {
            return (Boolean)cell.getAttribute() != false ? Region.Location.INSIDE : Region.Location.OUTSIDE;
        }
        Region.Location minusCode = this.checkPoint(cell.getMinus(), point);
        return minusCode == (plusCode = this.checkPoint(cell.getPlus(), point)) ? minusCode : Region.Location.BOUNDARY;
    }

    @Override
    public BSPTree<S, P, H, I> getTree(boolean includeBoundaryAttributes) {
        if (includeBoundaryAttributes && this.tree.getCut() != null && this.tree.getAttribute() == null) {
            this.tree.visit(new BoundaryBuilder());
        }
        return this.tree;
    }

    @Override
    public double getBoundarySize() {
        BoundarySizeVisitor visitor = new BoundarySizeVisitor();
        this.getTree(true).visit(visitor);
        return visitor.getSize();
    }

    @Override
    public double getSize() {
        if (this.barycenter == null) {
            this.computeGeometricalProperties();
        }
        return this.size;
    }

    protected void setSize(double size) {
        this.size = size;
    }

    @Override
    public P getBarycenter() {
        if (this.barycenter == null) {
            this.computeGeometricalProperties();
        }
        return this.barycenter;
    }

    protected void setBarycenter(P barycenter) {
        this.barycenter = barycenter;
    }

    protected abstract void computeGeometricalProperties();

    @Override
    public I intersection(I sub) {
        return this.recurseIntersection(this.tree, sub);
    }

    private I recurseIntersection(BSPTree<S, P, H, I> node, I sub) {
        if (node.getCut() == null) {
            return (Boolean)node.getAttribute() != false ? (I)sub.copySelf() : null;
        }
        Object hyperplane = node.getCut().getHyperplane();
        SubHyperplane.SplitSubHyperplane split = sub.split(hyperplane);
        if (split.getPlus() != null) {
            if (split.getMinus() != null) {
                I plus = this.recurseIntersection(node.getPlus(), split.getPlus());
                I minus = this.recurseIntersection(node.getMinus(), split.getMinus());
                if (plus == null) {
                    return minus;
                }
                if (minus == null) {
                    return plus;
                }
                return plus.reunite(minus);
            }
            return this.recurseIntersection(node.getPlus(), sub);
        }
        if (split.getMinus() != null) {
            return this.recurseIntersection(node.getMinus(), sub);
        }
        return this.recurseIntersection(node.getPlus(), this.recurseIntersection(node.getMinus(), sub));
    }

    public AbstractRegion<S, P, H, I, T, Q, F, J> applyTransform(Transform<S, P, H, I, T, Q, F, J> transform) {
        HashMap<BSPTree<S, P, H, I>, BSPTree<S, P, H, I>> map = new HashMap<BSPTree<S, P, H, I>, BSPTree<S, P, H, I>>();
        BSPTree<S, P, H, I> transformedTree = this.recurseTransform(this.getTree(false), transform, map);
        for (Map.Entry entry : map.entrySet()) {
            BoundaryAttribute original;
            if (((BSPTree)entry.getKey()).getCut() == null || (original = (BoundaryAttribute)((BSPTree)entry.getKey()).getAttribute()) == null) continue;
            BoundaryAttribute transformed = (BoundaryAttribute)((BSPTree)entry.getValue()).getAttribute();
            for (BSPTree splitter : original.getSplitters()) {
                transformed.getSplitters().add((BSPTree)map.get(splitter));
            }
        }
        return this.buildNew((BSPTree)transformedTree);
    }

    private BSPTree<S, P, H, I> recurseTransform(BSPTree<S, P, H, I> node, Transform<S, P, H, I, T, Q, F, J> transform, Map<BSPTree<S, P, H, I>, BSPTree<S, P, H, I>> map) {
        BSPTree transformedNode;
        if (node.getCut() == null) {
            transformedNode = new BSPTree(node.getAttribute());
        } else {
            I sub = node.getCut();
            I tSub = ((AbstractSubHyperplane)sub).applyTransform(transform);
            BoundaryAttribute attribute = (BoundaryAttribute)node.getAttribute();
            if (attribute != null) {
                Object tPO = attribute.getPlusOutside() == null ? null : (Object)((AbstractSubHyperplane)attribute.getPlusOutside()).applyTransform(transform);
                Object tPI = attribute.getPlusInside() == null ? null : (Object)((AbstractSubHyperplane)attribute.getPlusInside()).applyTransform(transform);
                attribute = new BoundaryAttribute(tPO, tPI, new NodesSet());
            }
            transformedNode = new BSPTree<S, P, H, I>(tSub, this.recurseTransform(node.getPlus(), transform, map), this.recurseTransform(node.getMinus(), transform, map), attribute);
        }
        map.put(node, transformedNode);
        return transformedNode;
    }
}

