/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.partitioning;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.partitioning.AbstractSubHyperplane;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.BSPTreeVisitor;
import org.hipparchus.geometry.partitioning.BoundaryAttribute;
import org.hipparchus.geometry.partitioning.BoundaryProjection;
import org.hipparchus.geometry.partitioning.Embedding;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.SubHyperplane;
import org.hipparchus.util.FastMath;

class BoundaryProjector<S extends Space, P extends Point<S, P>, H extends Hyperplane<S, P, H, I>, I extends SubHyperplane<S, P, H, I>, T extends Space, Q extends Point<T, Q>, F extends Hyperplane<T, Q, F, J>, J extends SubHyperplane<T, Q, F, J>>
implements BSPTreeVisitor<S, P, H, I> {
    private final P original;
    private P projected;
    private BSPTree<S, P, H, I> leaf;
    private double offset;

    BoundaryProjector(P original) {
        this.original = original;
        this.projected = null;
        this.leaf = null;
        this.offset = Double.POSITIVE_INFINITY;
    }

    @Override
    public BSPTreeVisitor.Order visitOrder(BSPTree<S, P, H, I> node) {
        if (node.getCut().getHyperplane().getOffset(this.original) <= 0.0) {
            return BSPTreeVisitor.Order.MINUS_SUB_PLUS;
        }
        return BSPTreeVisitor.Order.PLUS_SUB_MINUS;
    }

    @Override
    public void visitInternalNode(BSPTree<S, P, H, I> node) {
        Object hyperplane = node.getCut().getHyperplane();
        double signedOffset = hyperplane.getOffset(this.original);
        if (FastMath.abs((double)signedOffset) < this.offset) {
            P regular = hyperplane.project(this.original);
            List<Region<T, Q, F, J>> boundaryParts = this.boundaryRegions(node);
            boolean regularFound = false;
            for (Region<T, Q, F, J> part : boundaryParts) {
                if (regularFound || !this.belongsToPart(regular, (Hyperplane<S, P, H, I>)hyperplane, part)) continue;
                this.projected = regular;
                this.offset = FastMath.abs((double)signedOffset);
                regularFound = true;
            }
            if (!regularFound) {
                for (Region<T, Q, F, J> part : boundaryParts) {
                    double distance;
                    P spI = this.singularProjection(regular, (Hyperplane<S, P, H, I>)hyperplane, part);
                    if (spI == null || !((distance = this.original.distance(spI)) < this.offset)) continue;
                    this.projected = spI;
                    this.offset = distance;
                }
            }
        }
    }

    @Override
    public void visitLeafNode(BSPTree<S, P, H, I> node) {
        if (this.leaf == null) {
            this.leaf = node;
        }
    }

    public BoundaryProjection<S, P> getProjection() {
        this.offset = FastMath.copySign((double)this.offset, (double)((Boolean)this.leaf.getAttribute() != false ? -1.0 : 1.0));
        return new BoundaryProjection(this.original, this.projected, this.offset);
    }

    private List<Region<T, Q, F, J>> boundaryRegions(BSPTree<S, P, H, I> node) {
        ArrayList<Region<T, Q, F, J>> regions = new ArrayList<Region<T, Q, F, J>>(2);
        BoundaryAttribute ba = (BoundaryAttribute)node.getAttribute();
        this.addRegion((SubHyperplane<S, P, H, I>)ba.getPlusInside(), (List<Region<T, Q, F, J>>)regions);
        this.addRegion((SubHyperplane<S, P, H, I>)ba.getPlusOutside(), (List<Region<T, Q, F, J>>)regions);
        return regions;
    }

    private void addRegion(SubHyperplane<S, P, H, I> sub, List<Region<T, Q, F, J>> list) {
        Region region;
        if (sub != null && (region = ((AbstractSubHyperplane)sub).getRemainingRegion()) != null) {
            list.add(region);
        }
    }

    private boolean belongsToPart(P point, Hyperplane<S, P, H, I> hyperplane, Region<T, Q, F, J> part) {
        Embedding embedding = (Embedding)((Object)hyperplane);
        return part.checkPoint(embedding.toSubSpace(point)) != Region.Location.OUTSIDE;
    }

    private P singularProjection(P point, Hyperplane<S, P, H, I> hyperplane, Region<T, Q, F, J> part) {
        Embedding embedding = (Embedding)((Object)hyperplane);
        BoundaryProjection<T, Q> bp = part.projectToBoundary(embedding.toSubSpace(point));
        return bp.getProjected() == null ? null : (P)embedding.toSpace(bp.getProjected());
    }
}

