/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.twod;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.BSPTreeVisitor;
import org.hipparchus.geometry.partitioning.BoundaryAttribute;
import org.hipparchus.geometry.partitioning.NodesSet;
import org.hipparchus.geometry.spherical.oned.Arc;
import org.hipparchus.geometry.spherical.oned.ArcsSet;
import org.hipparchus.geometry.spherical.oned.S1Point;
import org.hipparchus.geometry.spherical.twod.Circle;
import org.hipparchus.geometry.spherical.twod.EdgeWithNodeInfo;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.geometry.spherical.twod.SubCircle;
import org.hipparchus.geometry.spherical.twod.Vertex;
import org.hipparchus.util.FastMath;

class EdgesWithNodeInfoBuilder
implements BSPTreeVisitor<Sphere2D, S2Point, Circle, SubCircle> {
    private final double tolerance;
    private final List<EdgeWithNodeInfo> edges;

    EdgesWithNodeInfoBuilder(double tolerance) {
        this.tolerance = tolerance;
        this.edges = new ArrayList<EdgeWithNodeInfo>();
    }

    @Override
    public BSPTreeVisitor.Order visitOrder(BSPTree<Sphere2D, S2Point, Circle, SubCircle> node) {
        return BSPTreeVisitor.Order.MINUS_SUB_PLUS;
    }

    @Override
    public void visitInternalNode(BSPTree<Sphere2D, S2Point, Circle, SubCircle> node) {
        BoundaryAttribute attribute = (BoundaryAttribute)node.getAttribute();
        NodesSet<Sphere2D, S2Point, Circle, SubCircle> splitters = attribute.getSplitters();
        if (attribute.getPlusOutside() != null) {
            this.addContribution((SubCircle)attribute.getPlusOutside(), node, splitters, false);
        }
        if (attribute.getPlusInside() != null) {
            this.addContribution((SubCircle)attribute.getPlusInside(), node, splitters, true);
        }
    }

    @Override
    public void visitLeafNode(BSPTree<Sphere2D, S2Point, Circle, SubCircle> node) {
    }

    private void addContribution(SubCircle sub, BSPTree<Sphere2D, S2Point, Circle, SubCircle> node, Iterable<BSPTree<Sphere2D, S2Point, Circle, SubCircle>> splitters, boolean reversed) {
        Circle circle = (Circle)sub.getHyperplane();
        List<Arc> arcs = ((ArcsSet)sub.getRemainingRegion()).asList();
        for (Arc a : arcs) {
            Vertex startS = new Vertex(circle.toSpace(new S1Point(a.getInf())));
            Vertex endS = new Vertex(circle.toSpace(new S1Point(a.getSup())));
            BSPTree<Sphere2D, S2Point, Circle, SubCircle> startN = this.selectClosest(startS.getLocation(), splitters);
            BSPTree<Sphere2D, S2Point, Circle, SubCircle> endN = this.selectClosest(endS.getLocation(), splitters);
            if (reversed) {
                this.edges.add(new EdgeWithNodeInfo(endS, startS, a.getSize(), circle.getReverse(), node, endN, startN));
                continue;
            }
            this.edges.add(new EdgeWithNodeInfo(startS, endS, a.getSize(), circle, node, startN, endN));
        }
    }

    private BSPTree<Sphere2D, S2Point, Circle, SubCircle> selectClosest(S2Point point, Iterable<BSPTree<Sphere2D, S2Point, Circle, SubCircle>> candidates) {
        if (point == null) {
            return null;
        }
        BSPTree<Sphere2D, S2Point, Circle, SubCircle> selected = null;
        double min = Double.POSITIVE_INFINITY;
        for (BSPTree<Sphere2D, S2Point, Circle, SubCircle> node : candidates) {
            double distance = FastMath.abs((double)((Circle)node.getCut().getHyperplane()).getOffset(point));
            if (!(distance < min)) continue;
            selected = node;
            min = distance;
        }
        return min <= this.tolerance ? selected : null;
    }

    public List<EdgeWithNodeInfo> getEdges() {
        return this.edges;
    }
}

