/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.twod;

import java.io.Serializable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.spherical.oned.Sphere1D;
import org.hipparchus.util.FastMath;

public class Sphere2D
implements Serializable,
Space {
    public static final double SMALLEST_TOLERANCE = FastMath.ulp((double)(Math.PI * 2));
    private static final long serialVersionUID = 20131218L;

    private Sphere2D() {
    }

    public static Sphere2D getInstance() {
        return LazyHolder.INSTANCE;
    }

    public static void checkTolerance(double tolerance) throws MathIllegalArgumentException {
        if (tolerance < SMALLEST_TOLERANCE) {
            throw new MathIllegalArgumentException((Localizable)LocalizedGeometryFormats.TOO_SMALL_TOLERANCE, new Object[]{tolerance, "Sphere2D.SMALLEST_TOLERANCE", SMALLEST_TOLERANCE});
        }
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Sphere1D getSubSpace() {
        return Sphere1D.getInstance();
    }

    private Object readResolve() {
        return LazyHolder.INSTANCE;
    }

    private static class LazyHolder {
        private static final Sphere2D INSTANCE = new Sphere2D();

        private LazyHolder() {
        }
    }
}

