/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.twod;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.partitioning.AbstractSubHyperplane;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.SubHyperplane;
import org.hipparchus.geometry.spherical.oned.Arc;
import org.hipparchus.geometry.spherical.oned.ArcsSet;
import org.hipparchus.geometry.spherical.oned.LimitAngle;
import org.hipparchus.geometry.spherical.oned.S1Point;
import org.hipparchus.geometry.spherical.oned.Sphere1D;
import org.hipparchus.geometry.spherical.oned.SubLimitAngle;
import org.hipparchus.geometry.spherical.twod.Circle;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.Sphere2D;

public class SubCircle
extends AbstractSubHyperplane<Sphere2D, S2Point, Circle, SubCircle, Sphere1D, S1Point, LimitAngle, SubLimitAngle> {
    public SubCircle(Circle hyperplane, Region<Sphere1D, S1Point, LimitAngle, SubLimitAngle> remainingRegion) {
        super(hyperplane, remainingRegion);
    }

    @Override
    protected SubCircle buildNew(Circle hyperplane, Region<Sphere1D, S1Point, LimitAngle, SubLimitAngle> remainingRegion) {
        return new SubCircle(hyperplane, remainingRegion);
    }

    @Override
    public S2Point getInteriorPoint() {
        return this.isEmpty() ? null : ((Circle)this.getHyperplane()).toSpace((S1Point)this.getRemainingRegion().getInteriorPoint());
    }

    @Override
    public SubHyperplane.SplitSubHyperplane<Sphere2D, S2Point, Circle, SubCircle> split(Circle hyperplane) {
        double angle = Vector3D.angle(((Circle)this.getHyperplane()).getPole(), hyperplane.getPole());
        if (angle < ((Circle)this.getHyperplane()).getTolerance() || angle > Math.PI - ((Circle)this.getHyperplane()).getTolerance()) {
            return new SubHyperplane.SplitSubHyperplane(null, null);
        }
        Arc arc = ((Circle)this.getHyperplane()).getInsideArc(hyperplane);
        ArcsSet.Split split = ((ArcsSet)this.getRemainingRegion()).split(arc);
        ArcsSet plus = split.getPlus();
        ArcsSet minus = split.getMinus();
        return new SubHyperplane.SplitSubHyperplane<Sphere2D, S2Point, Circle, SubCircle>(plus == null ? null : new SubCircle(((Circle)this.getHyperplane()).copySelf(), plus), minus == null ? null : new SubCircle(((Circle)this.getHyperplane()).copySelf(), minus));
    }
}

