/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.samples.clustering;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.hipparchus.clustering.CentroidCluster;
import org.hipparchus.clustering.Clusterable;
import org.hipparchus.clustering.KMeansPlusPlusClusterer;
import org.hipparchus.samples.ExampleUtils;

public class ImageClusteringExample {
    public static void main(String[] args) throws Exception {
        ExampleUtils.showExampleFrame(new Display());
    }

    public static class Display
    extends ExampleUtils.ExampleFrame {
        private BufferedImage referenceImage;
        private BufferedImage clusterImage;
        private Raster referenceRaster;
        private ImagePainter painter;
        private JSpinner clusterSizeSpinner;

        public Display() throws Exception {
            this.setTitle("Hipparchus: Image Clustering Example");
            this.setSize(900, 350);
            this.setLayout(new FlowLayout());
            Box bar = Box.createHorizontalBox();
            ClassLoader classLoader = ExampleUtils.class.getClassLoader();
            this.referenceImage = ExampleUtils.resizeImage(ImageIO.read(classLoader.getResourceAsStream("ColorfulBird.jpg")), 350, 240, 1);
            this.referenceRaster = this.referenceImage.getData();
            this.clusterImage = new BufferedImage(this.referenceImage.getWidth(), this.referenceImage.getHeight(), 1);
            JLabel picLabel = new JLabel(new ImageIcon(this.referenceImage));
            bar.add(picLabel);
            this.painter = new ImagePainter(this.clusterImage.getWidth(), this.clusterImage.getHeight());
            bar.add(this.painter);
            JPanel controlBox = new JPanel();
            controlBox.setLayout(new GridLayout(5, 1));
            controlBox.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            JPanel sizeBox = new JPanel();
            JLabel sizeLabel = new JLabel("Clusters:");
            sizeBox.add(sizeLabel);
            SpinnerNumberModel model = new SpinnerNumberModel(3, 2, 10, 1);
            this.clusterSizeSpinner = new JSpinner(model);
            sizeLabel.setLabelFor(this.clusterSizeSpinner);
            sizeBox.add(this.clusterSizeSpinner);
            controlBox.add((Component)sizeBox, "North");
            JButton startButton = new JButton("Cluster");
            startButton.setActionCommand("cluster");
            controlBox.add((Component)startButton, "Center");
            bar.add(controlBox);
            this.add(bar);
            startButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.clusterImage();
                }
            });
        }

        private void clusterImage() {
            ArrayList<PixelClusterable> pixels = new ArrayList<PixelClusterable>();
            for (int row = 0; row < this.referenceImage.getHeight(); ++row) {
                for (int col = 0; col < this.referenceImage.getWidth(); ++col) {
                    pixels.add(new PixelClusterable(col, row));
                }
            }
            int clusterSize = ((Number)this.clusterSizeSpinner.getValue()).intValue();
            KMeansPlusPlusClusterer clusterer = new KMeansPlusPlusClusterer(clusterSize);
            List clusters = clusterer.cluster(pixels);
            WritableRaster raster = this.clusterImage.getRaster();
            for (CentroidCluster cluster : clusters) {
                double[] color = cluster.getCenter().getPoint();
                for (PixelClusterable pixel : cluster.getPoints()) {
                    raster.setPixel(pixel.x, pixel.y, color);
                }
            }
            this.repaint();
        }

        private class ImagePainter
        extends Component {
            private int width;
            private int height;

            public ImagePainter(int width, int height) {
                this.width = width;
                this.height = height;
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(this.width, this.height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public void paint(Graphics g) {
                g.drawImage(Display.this.clusterImage, 0, 0, this);
            }
        }

        private class PixelClusterable
        implements Clusterable {
            private final int x;
            private final int y;
            private double[] color;

            public PixelClusterable(int x, int y) {
                this.x = x;
                this.y = y;
                this.color = null;
            }

            public double[] getPoint() {
                if (this.color == null) {
                    this.color = Display.this.referenceRaster.getPixel(this.x, this.y, (double[])null);
                }
                return this.color;
            }
        }
    }
}

