/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.samples;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.hipparchus.clustering.CentroidCluster;
import org.hipparchus.clustering.Cluster;
import org.hipparchus.clustering.Clusterable;
import org.hipparchus.clustering.Clusterer;
import org.hipparchus.clustering.DBSCANClusterer;
import org.hipparchus.clustering.DoublePoint;
import org.hipparchus.clustering.FuzzyKMeansClusterer;
import org.hipparchus.clustering.KMeansPlusPlusClusterer;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.random.RandomAdaptor;
import org.hipparchus.random.RandomDataGenerator;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.SobolSequenceGenerator;
import org.hipparchus.random.Well19937c;
import org.hipparchus.samples.ExampleUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Pair;
import org.hipparchus.util.SinCos;

public class ClusterAlgorithmComparison {
    public static List<Vector2D> makeCircles(int samples, boolean shuffle, double noise, double factor, RandomGenerator random) {
        if (factor < 0.0 || factor > 1.0) {
            throw new IllegalArgumentException();
        }
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        double range = Math.PI * 2;
        double step = range / ((double)samples / 2.0 + 1.0);
        for (double angle = 0.0; angle < range; angle += step) {
            Vector2D outerCircle = ClusterAlgorithmComparison.buildVector(angle);
            Vector2D innerCircle = outerCircle.scalarMultiply(factor);
            points.add(outerCircle.add((Vector)ClusterAlgorithmComparison.generateNoiseVector(random, noise)));
            points.add(innerCircle.add((Vector)ClusterAlgorithmComparison.generateNoiseVector(random, noise)));
        }
        if (shuffle) {
            Collections.shuffle(points, (Random)new RandomAdaptor(random));
        }
        return points;
    }

    public static List<Vector2D> makeMoons(int samples, boolean shuffle, double noise, RandomGenerator random) {
        double angle;
        int nSamplesOut = samples / 2;
        int nSamplesIn = samples - nSamplesOut;
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        double range = Math.PI;
        double step = range / ((double)nSamplesOut / 2.0);
        for (angle = 0.0; angle < range; angle += step) {
            Vector2D outerCircle = ClusterAlgorithmComparison.buildVector(angle);
            points.add(outerCircle.add((Vector)ClusterAlgorithmComparison.generateNoiseVector(random, noise)));
        }
        step = range / ((double)nSamplesIn / 2.0);
        for (angle = 0.0; angle < range; angle += step) {
            SinCos sc = FastMath.sinCos((double)angle);
            Vector2D innerCircle = new Vector2D(1.0 - sc.cos(), 1.0 - sc.sin() - 0.5);
            points.add(innerCircle.add((Vector)ClusterAlgorithmComparison.generateNoiseVector(random, noise)));
        }
        if (shuffle) {
            Collections.shuffle(points, (Random)new RandomAdaptor(random));
        }
        return points;
    }

    public static List<Vector2D> makeBlobs(int samples, int centers, double clusterStd, double min, double max, boolean shuffle, RandomGenerator random) {
        RandomDataGenerator randomDataGenerator = RandomDataGenerator.of((RandomGenerator)random);
        double range = max - min;
        Vector2D[] centerPoints = new Vector2D[centers];
        for (int i = 0; i < centers; ++i) {
            double x = random.nextDouble() * range + min;
            double y = random.nextDouble() * range + min;
            centerPoints[i] = new Vector2D(x, y);
        }
        int[] nSamplesPerCenter = new int[centers];
        int count = samples / centers;
        Arrays.fill(nSamplesPerCenter, count);
        int i = 0;
        while (i < samples % centers) {
            int n = i++;
            nSamplesPerCenter[n] = nSamplesPerCenter[n] + 1;
        }
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        for (int i2 = 0; i2 < centers; ++i2) {
            for (int j = 0; j < nSamplesPerCenter[i2]; ++j) {
                Vector2D point = new Vector2D(randomDataGenerator.nextNormal(0.0, clusterStd), randomDataGenerator.nextNormal(0.0, clusterStd));
                points.add(point.add((Vector)centerPoints[i2]));
            }
        }
        if (shuffle) {
            Collections.shuffle(points, (Random)new RandomAdaptor(random));
        }
        return points;
    }

    public static List<Vector2D> makeRandom(int samples) {
        SobolSequenceGenerator generator = new SobolSequenceGenerator(2);
        generator.skipTo(999999);
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        for (double i = 0.0; i < (double)samples; i += 1.0) {
            double[] vector = generator.nextVector();
            vector[0] = vector[0] * 2.0 - 1.0;
            vector[1] = vector[1] * 2.0 - 1.0;
            Vector2D point = new Vector2D(vector);
            points.add(point);
        }
        return points;
    }

    public static Vector2D generateNoiseVector(RandomGenerator randomGenerator, double noise) {
        RandomDataGenerator randomDataGenerator = RandomDataGenerator.of((RandomGenerator)randomGenerator);
        return new Vector2D(randomDataGenerator.nextNormal(0.0, noise), randomDataGenerator.nextNormal(0.0, noise));
    }

    public static List<DoublePoint> normalize(List<Vector2D> input, double minX, double maxX, double minY, double maxY) {
        double rangeX = maxX - minX;
        double rangeY = maxY - minY;
        ArrayList<DoublePoint> points = new ArrayList<DoublePoint>();
        for (Vector2D p : input) {
            double[] arr = p.toArray();
            arr[0] = (arr[0] - minX) / rangeX * 2.0 - 1.0;
            arr[1] = (arr[1] - minY) / rangeY * 2.0 - 1.0;
            points.add(new DoublePoint(arr));
        }
        return points;
    }

    private static Vector2D buildVector(double alpha) {
        SinCos sc = FastMath.sinCos((double)alpha);
        return new Vector2D(sc.cos(), sc.sin());
    }

    public static void main(String[] args) {
        ExampleUtils.showExampleFrame(new Display());
    }

    public static class ClusterPlot
    extends JComponent {
        private static double PAD = 10.0;
        private List<? extends Cluster<DoublePoint>> clusters;
        private long duration;

        public ClusterPlot(List<? extends Cluster<DoublePoint>> clusters, long duration) {
            this.clusters = clusters;
            this.duration = duration;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int w = this.getWidth();
            int h = this.getHeight();
            g2.clearRect(0, 0, w, h);
            g2.setPaint(Color.black);
            g2.drawRect(0, 0, w - 1, h - 1);
            int index = 0;
            Color[] colors = new Color[]{Color.red, Color.blue, Color.green.darker()};
            for (Cluster<DoublePoint> cluster : this.clusters) {
                g2.setPaint(colors[index++]);
                for (DoublePoint point : cluster.getPoints()) {
                    Clusterable p = this.transform((Clusterable)point, w, h);
                    double[] arr = p.getPoint();
                    g2.fill(new Ellipse2D.Double(arr[0] - 1.0, arr[1] - 1.0, 3.0, 3.0));
                }
                if (!(cluster instanceof CentroidCluster)) continue;
                Clusterable p = this.transform(((CentroidCluster)cluster).getCenter(), w, h);
                double[] arr = p.getPoint();
                Ellipse2D.Double s = new Ellipse2D.Double(arr[0] - 4.0, arr[1] - 4.0, 8.0, 8.0);
                g2.fill(s);
                g2.setPaint(Color.black);
                g2.draw(s);
            }
            g2.setPaint(Color.black);
            g2.drawString(String.format("%.2f s", (double)this.duration / 1000.0), w - 40, h - 5);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(150, 150);
        }

        private Clusterable transform(Clusterable point, int width, int height) {
            double[] arr = point.getPoint();
            return new DoublePoint(new double[]{PAD + (arr[0] + 1.0) / 2.0 * ((double)width - 2.0 * PAD), (double)height - PAD - (arr[1] + 1.0) / 2.0 * ((double)height - 2.0 * PAD)});
        }
    }

    public static class Display
    extends ExampleUtils.ExampleFrame {
        public Display() {
            this.setTitle("Hipparchus: Cluster algorithm comparison");
            this.setSize(800, 800);
            this.setLayout(new GridBagLayout());
            int nSamples = 1500;
            Well19937c rng = new Well19937c(0);
            ArrayList<List<DoublePoint>> datasets = new ArrayList<List<DoublePoint>>();
            datasets.add(ClusterAlgorithmComparison.normalize(ClusterAlgorithmComparison.makeCircles(nSamples, true, 0.04, 0.5, (RandomGenerator)rng), -1.0, 1.0, -1.0, 1.0));
            datasets.add(ClusterAlgorithmComparison.normalize(ClusterAlgorithmComparison.makeMoons(nSamples, true, 0.04, (RandomGenerator)rng), -1.0, 2.0, -1.0, 1.0));
            datasets.add(ClusterAlgorithmComparison.normalize(ClusterAlgorithmComparison.makeBlobs(nSamples, 3, 1.0, -10.0, 10.0, true, (RandomGenerator)rng), -12.0, 12.0, -12.0, 12.0));
            datasets.add(ClusterAlgorithmComparison.normalize(ClusterAlgorithmComparison.makeRandom(nSamples), -1.0, 1.0, -1.0, 1.0));
            ArrayList<Pair> algorithms = new ArrayList<Pair>();
            algorithms.add(new Pair((Object)"KMeans\n(k=2)", (Object)new KMeansPlusPlusClusterer(2)));
            algorithms.add(new Pair((Object)"KMeans\n(k=3)", (Object)new KMeansPlusPlusClusterer(3)));
            algorithms.add(new Pair((Object)"FuzzyKMeans\n(k=3, fuzzy=2)", (Object)new FuzzyKMeansClusterer(3, 2.0)));
            algorithms.add(new Pair((Object)"FuzzyKMeans\n(k=3, fuzzy=10)", (Object)new FuzzyKMeansClusterer(3, 10.0)));
            algorithms.add(new Pair((Object)"DBSCAN\n(eps=.1, min=3)", (Object)new DBSCANClusterer(0.1, 3)));
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 3;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(2, 2, 2, 2);
            for (Pair pair : algorithms) {
                JLabel text = new JLabel("<html><body>" + ((String)pair.getFirst()).replace("\n", "<br>"));
                this.add((Component)text, c);
                ++c.gridx;
            }
            ++c.gridy;
            for (List list : datasets) {
                c.gridx = 0;
                for (Pair pair : algorithms) {
                    long start = System.currentTimeMillis();
                    List clusters = ((Clusterer)pair.getSecond()).cluster((Collection)list);
                    long end = System.currentTimeMillis();
                    this.add((Component)new ClusterPlot(clusters, end - start), c);
                    ++c.gridx;
                }
                ++c.gridy;
            }
        }
    }
}

