/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.samples;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.random.HaltonSequenceGenerator;
import org.hipparchus.random.JDKRandomGenerator;
import org.hipparchus.random.MersenneTwister;
import org.hipparchus.random.NormalizedRandomGenerator;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.random.RandomVectorGenerator;
import org.hipparchus.random.SobolSequenceGenerator;
import org.hipparchus.random.UncorrelatedRandomVectorGenerator;
import org.hipparchus.random.UniformRandomGenerator;
import org.hipparchus.samples.ExampleUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Pair;

public class LowDiscrepancyGeneratorComparison {
    public static List<Vector2D> makeCircle(int samples, RandomVectorGenerator generator) {
        List<Vector2D> points = new ArrayList<Vector2D>();
        for (double i = 0.0; i < (double)samples; i += 1.0) {
            double[] vector = generator.nextVector();
            Vector2D point = new Vector2D(vector);
            points.add(point);
        }
        points = LowDiscrepancyGeneratorComparison.normalize(points);
        ArrayList<Vector2D> circlePoints = new ArrayList<Vector2D>();
        for (Vector2D p : points) {
            if (!(p.getNorm() < 1.0)) continue;
            circlePoints.add(p);
        }
        return circlePoints;
    }

    public static List<Vector2D> makeRandom(int samples, RandomVectorGenerator generator) {
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        for (double i = 0.0; i < (double)samples; i += 1.0) {
            double[] vector = generator.nextVector();
            Vector2D point = new Vector2D(vector);
            points.add(point);
        }
        return LowDiscrepancyGeneratorComparison.normalize(points);
    }

    public static List<Vector2D> normalize(List<Vector2D> input) {
        double maxY;
        double minY;
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        for (Vector2D p : input) {
            minX = FastMath.min((double)minX, (double)p.getX());
            maxX = FastMath.max((double)maxX, (double)p.getX());
        }
        if (FastMath.abs((double)minX) < 0.1) {
            minY = 0.0;
            minX = 0.0;
            maxY = 1.0;
            maxX = 1.0;
        } else {
            minX = minY = -FastMath.sqrt((double)3.0);
            maxX = maxY = FastMath.sqrt((double)3.0);
        }
        double rangeX = maxX - minX;
        double rangeY = maxY - minY;
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        for (Vector2D p : input) {
            double[] arr = p.toArray();
            arr[0] = (arr[0] - minX) / rangeX * 2.0 - 1.0;
            arr[1] = (arr[1] - minY) / rangeY * 2.0 - 1.0;
            points.add(new Vector2D(arr));
        }
        return points;
    }

    public static void main(String[] args) {
        ExampleUtils.showExampleFrame(new Display());
    }

    public static class Plot
    extends JComponent {
        private static double PAD = 10.0;
        private List<Vector2D> points;

        public Plot(List<Vector2D> points) {
            this.points = points;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int w = this.getWidth();
            int h = this.getHeight();
            g2.clearRect(0, 0, w, h);
            g2.setPaint(Color.black);
            g2.drawRect(0, 0, w - 1, h - 1);
            for (Vector2D point : this.points) {
                Vector2D p = this.transform(point, w, h);
                double[] arr = p.toArray();
                g2.draw(new Rectangle2D.Double(arr[0] - 1.0, arr[1] - 1.0, 2.0, 2.0));
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(140, 140);
        }

        private Vector2D transform(Vector2D point, int width, int height) {
            double[] arr = point.toArray();
            return new Vector2D(new double[]{PAD + (arr[0] + 1.0) / 2.0 * ((double)width - 2.0 * PAD), (double)height - PAD - (arr[1] + 1.0) / 2.0 * ((double)height - 2.0 * PAD)});
        }
    }

    public static class Display
    extends ExampleUtils.ExampleFrame {
        public Display() {
            int type;
            JComponent text;
            this.setTitle("Hipparchus: Pseudo/Quasi-random examples");
            this.setSize(800, 800);
            this.setLayout(new GridBagLayout());
            int[] datasets = new int[]{256, 1000, 2500, 1000};
            ArrayList<Pair> generators = new ArrayList<Pair>();
            generators.add(new Pair((Object)"Uncorrelated\nUniform(JDK)", (Object)new UncorrelatedRandomVectorGenerator(2, (NormalizedRandomGenerator)new UniformRandomGenerator((RandomGenerator)new JDKRandomGenerator()))));
            generators.add(new Pair((Object)"Independent\nRandom(MT)", (Object)new RandomVectorGenerator(){
                RandomGenerator[] rngs = new RandomGenerator[]{new MersenneTwister(0), new MersenneTwister(1)};

                public double[] nextVector() {
                    double[] vector = new double[]{this.rngs[0].nextDouble(), this.rngs[1].nextDouble()};
                    return vector;
                }
            }));
            generators.add(new Pair((Object)"HaltonSequence", (Object)new HaltonSequenceGenerator(2)));
            generators.add(new Pair((Object)"SobolSequence", (Object)new SobolSequenceGenerator(2)));
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 3;
            c.gridx = 1;
            c.gridy = 0;
            c.insets = new Insets(2, 2, 2, 2);
            for (Pair pair : generators) {
                text = new JTextArea((String)pair.getFirst());
                ((JTextComponent)text).setEditable(false);
                text.setOpaque(false);
                this.add((Component)text, c);
                ++c.gridx;
            }
            int saveY = ++c.gridy;
            c.gridx = 0;
            for (type = 0; type < 4; ++type) {
                text = new JLabel("n=" + String.valueOf(datasets[type]));
                text.setOpaque(false);
                this.add((Component)text, c);
                ++c.gridy;
            }
            c.gridy = saveY;
            for (type = 0; type < 4; ++type) {
                c.gridx = 1;
                for (Pair pair : generators) {
                    List<Vector2D> points = null;
                    int samples = datasets[type];
                    switch (type) {
                        case 0: {
                            points = LowDiscrepancyGeneratorComparison.makeRandom(samples, (RandomVectorGenerator)pair.getValue());
                            break;
                        }
                        case 1: {
                            points = LowDiscrepancyGeneratorComparison.makeRandom(samples, (RandomVectorGenerator)pair.getValue());
                            break;
                        }
                        case 2: {
                            points = LowDiscrepancyGeneratorComparison.makeRandom(samples, (RandomVectorGenerator)pair.getValue());
                            break;
                        }
                        case 3: {
                            points = LowDiscrepancyGeneratorComparison.makeCircle(samples, (RandomVectorGenerator)pair.getValue());
                            break;
                        }
                        default: {
                            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.INTERNAL_ERROR, new Object[0]);
                        }
                    }
                    this.add((Component)new Plot(points), c);
                    ++c.gridx;
                }
                ++c.gridy;
            }
        }
    }
}

