/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.samples;

import com.xeiam.xchart.Chart;
import com.xeiam.xchart.ChartBuilder;
import com.xeiam.xchart.Series;
import com.xeiam.xchart.SeriesMarker;
import com.xeiam.xchart.StyleManager;
import com.xeiam.xchart.XChartPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.hipparchus.distribution.RealDistribution;
import org.hipparchus.distribution.continuous.BetaDistribution;
import org.hipparchus.distribution.continuous.CauchyDistribution;
import org.hipparchus.distribution.continuous.ChiSquaredDistribution;
import org.hipparchus.distribution.continuous.ExponentialDistribution;
import org.hipparchus.distribution.continuous.FDistribution;
import org.hipparchus.distribution.continuous.GammaDistribution;
import org.hipparchus.distribution.continuous.LevyDistribution;
import org.hipparchus.distribution.continuous.LogNormalDistribution;
import org.hipparchus.distribution.continuous.NormalDistribution;
import org.hipparchus.distribution.continuous.ParetoDistribution;
import org.hipparchus.distribution.continuous.TDistribution;
import org.hipparchus.distribution.continuous.WeibullDistribution;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.samples.ExampleUtils;
import org.hipparchus.util.FastMath;

public class RealDistributionComparison {
    private static final String ARIAL = "Arial";

    private RealDistributionComparison() {
    }

    public static void addPDFSeries(Chart chart, RealDistribution distribution, String desc, int lowerBound, int upperBound) {
        ArrayList<Double> xData = new ArrayList<Double>();
        ArrayList<Double> yData = new ArrayList<Double>();
        int samples = 100;
        double stepSize = (double)(upperBound - lowerBound) / (double)samples;
        for (double x = (double)lowerBound; x <= (double)upperBound; x += stepSize) {
            try {
                double density = distribution.density(x);
                if (Double.isInfinite(density) || Double.isNaN(density)) continue;
                xData.add(x);
                yData.add(density);
                continue;
            }
            catch (MathRuntimeException mathRuntimeException) {
                // empty catch block
            }
        }
        Series series = chart.addSeries(desc, xData, yData);
        series.setMarker(SeriesMarker.NONE);
        series.setLineStyle(new BasicStroke(1.2f));
    }

    public static void addCDFSeries(Chart chart, RealDistribution distribution, String desc, int lowerBound, int upperBound) {
        ArrayList<Double> xData = new ArrayList<Double>();
        ArrayList<Double> yData = new ArrayList<Double>();
        int samples = 100;
        double stepSize = (double)(upperBound - lowerBound) / (double)samples;
        for (double x = (double)lowerBound; x <= (double)upperBound; x += stepSize) {
            double density = distribution.cumulativeProbability(x);
            if (Double.isInfinite(density) || Double.isNaN(density)) continue;
            xData.add(x);
            yData.add(density);
        }
        Series series = chart.addSeries(desc, xData, yData);
        series.setMarker(SeriesMarker.NONE);
        series.setLineStyle(new BasicStroke(1.2f));
    }

    public static Chart createChart(String title, int minX, int maxX, StyleManager.LegendPosition position) {
        Chart chart = new ChartBuilder().width(235).height(200).build();
        chart.setChartTitle(title);
        chart.getStyleManager().setChartTitleVisible(true);
        chart.getStyleManager().setChartTitleFont(new Font(ARIAL, 0, 10));
        chart.getStyleManager().setLegendPosition(position);
        chart.getStyleManager().setLegendVisible(true);
        chart.getStyleManager().setLegendFont(new Font(ARIAL, 0, 10));
        chart.getStyleManager().setLegendPadding(6);
        chart.getStyleManager().setLegendSeriesLineLength(6);
        chart.getStyleManager().setAxisTickLabelsFont(new Font(ARIAL, 0, 9));
        chart.getStyleManager().setXAxisMin((double)minX);
        chart.getStyleManager().setXAxisMax((double)maxX);
        chart.getStyleManager().setChartBackgroundColor(Color.white);
        chart.getStyleManager().setChartPadding(4);
        chart.getStyleManager().setChartType(StyleManager.ChartType.Line);
        return chart;
    }

    public static JComponent createComponent(String distributionName, int minX, int maxX, String[] seriesText, RealDistribution ... series) {
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 3));
        container.add(new JLabel(distributionName));
        Chart chart = RealDistributionComparison.createChart("PDF", minX, maxX, StyleManager.LegendPosition.InsideNE);
        int i = 0;
        for (RealDistribution d : series) {
            RealDistributionComparison.addPDFSeries(chart, d, seriesText[i++], minX, maxX);
        }
        container.add((Component)new XChartPanel(chart));
        chart = RealDistributionComparison.createChart("CDF", minX, maxX, StyleManager.LegendPosition.InsideSE);
        i = 0;
        for (RealDistribution d : series) {
            RealDistributionComparison.addCDFSeries(chart, d, seriesText[i++], minX, maxX);
        }
        container.add((Component)new XChartPanel(chart));
        container.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        return container;
    }

    public static void main(String[] args) {
        ExampleUtils.showExampleFrame(new Display());
    }

    public static class Display
    extends ExampleUtils.ExampleFrame {
        private JComponent container;

        public Display() {
            this.setTitle("Hipparchus: Real distributions overview");
            this.setSize(1320, 920);
            this.container = new JPanel();
            this.container.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 3;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(2, 2, 2, 2);
            JComponent comp = null;
            comp = RealDistributionComparison.createComponent("Normal", -5, 5, new String[]{"\u03bc=0,\u03c3\u00b2=0.2", "\u03bc=0,\u03c3\u00b2=1", "\u03bc=0,\u03c3\u00b2=5", "\u03bc=-2,\u03c3\u00b2=0.5"}, new RealDistribution[]{new NormalDistribution(0.0, FastMath.sqrt((double)0.2)), new NormalDistribution(), new NormalDistribution(0.0, FastMath.sqrt((double)5.0)), new NormalDistribution(-2.0, FastMath.sqrt((double)0.5))});
            this.container.add((Component)comp, c);
            ++c.gridx;
            comp = RealDistributionComparison.createComponent("Beta", 0, 1, new String[]{"\u03b1=\u03b2=0.5", "\u03b1=5,\u03b2=1", "\u03b1=1,\u03b2=3", "\u03b1=2,\u03b2=2", "\u03b1=2,\u03b2=5"}, new RealDistribution[]{new BetaDistribution(0.5, 0.5), new BetaDistribution(5.0, 1.0), new BetaDistribution(1.0, 3.0), new BetaDistribution(2.0, 2.0), new BetaDistribution(2.0, 5.0)});
            this.container.add((Component)comp, c);
            ++c.gridx;
            comp = RealDistributionComparison.createComponent("Cauchy", -5, 5, new String[]{"x=0,\u03b3=0.5", "x=0,\u03b3=1", "x=0,\u03b3=2", "x=-2,\u03b3=1"}, new RealDistribution[]{new CauchyDistribution(0.0, 0.5), new CauchyDistribution(0.0, 1.0), new CauchyDistribution(0.0, 2.0), new CauchyDistribution(-2.0, 1.0)});
            this.container.add((Component)comp, c);
            ++c.gridx;
            comp = RealDistributionComparison.createComponent("ChiSquared", 0, 5, new String[]{"k=1", "k=2", "k=3", "k=4", "k=6"}, new RealDistribution[]{new ChiSquaredDistribution(1.0), new ChiSquaredDistribution(2.0), new ChiSquaredDistribution(3.0), new ChiSquaredDistribution(4.0), new ChiSquaredDistribution(6.0)});
            this.container.add((Component)comp, c);
            ++c.gridy;
            c.gridx = 0;
            comp = RealDistributionComparison.createComponent("Exponential", 0, 5, new String[]{"\u03bb=0.5", "\u03bb=1", "\u03bb=1.5", "\u03bb=2.5"}, new RealDistribution[]{new ExponentialDistribution(0.5), new ExponentialDistribution(1.0), new ExponentialDistribution(1.5), new ExponentialDistribution(2.5)});
            this.container.add((Component)comp, c);
            ++c.gridx;
            comp = RealDistributionComparison.createComponent("Fisher-Snedecor", 0, 5, new String[]{"d1=1,d2=1", "d1=2,d2=1", "d1=5,d2=2", "d1=100,d2=1", "d1=100,d2=100"}, new RealDistribution[]{new FDistribution(1.0, 1.0), new FDistribution(2.0, 1.0), new FDistribution(5.0, 2.0), new FDistribution(100.0, 1.0), new FDistribution(100.0, 100.0)});
            this.container.add((Component)comp, c);
            ++c.gridx;
            comp = RealDistributionComparison.createComponent("Gamma", 0, 20, new String[]{"k=1,\u03b8=2", "k=2,\u03b8=2", "k=3,\u03b8=2", "k=5,\u03b8=1", "k=9,\u03b8=0.5"}, new RealDistribution[]{new GammaDistribution(1.0, 2.0), new GammaDistribution(2.0, 2.0), new GammaDistribution(3.0, 2.0), new GammaDistribution(5.0, 1.0), new GammaDistribution(9.0, 0.5)});
            this.container.add((Component)comp, c);
            ++c.gridx;
            comp = RealDistributionComparison.createComponent("Levy", 0, 3, new String[]{"c=0.5", "c=1", "c=2", "c=4", "c=8"}, new RealDistribution[]{new LevyDistribution(0.0, 0.5), new LevyDistribution(0.0, 1.0), new LevyDistribution(0.0, 2.0), new LevyDistribution(0.0, 4.0), new LevyDistribution(0.0, 8.0)});
            this.container.add((Component)comp, c);
            ++c.gridy;
            c.gridx = 0;
            comp = RealDistributionComparison.createComponent("Log-Normal", 0, 3, new String[]{"\u03bc=0,\u03c3\u00b2=10", "\u03bc=0,\u03c3\u00b2=1.5", "\u03bc=0,\u03c3\u00b2=1", "\u03bc=0,\u03c3\u00b2=0.5", "\u03bc=0,\u03c3\u00b2=0.25", "\u03bc=0,\u03c3\u00b2=0.125"}, new RealDistribution[]{new LogNormalDistribution(0.0, 10.0), new LogNormalDistribution(0.0, 1.5), new LogNormalDistribution(0.0, 1.0), new LogNormalDistribution(0.0, 0.5), new LogNormalDistribution(0.0, 0.25), new LogNormalDistribution(0.0, 0.125)});
            this.container.add((Component)comp, c);
            ++c.gridx;
            comp = RealDistributionComparison.createComponent("Pareto", 0, 5, new String[]{"x=1,\u03b1=1", "x=1,\u03b1=2", "x=1,\u03b1=3", "x=1,\u03b1=10"}, new RealDistribution[]{new ParetoDistribution(1.0, 1.0), new ParetoDistribution(1.0, 2.0), new ParetoDistribution(1.0, 3.0), new ParetoDistribution(1.0, 10.0)});
            this.container.add((Component)comp, c);
            ++c.gridx;
            comp = RealDistributionComparison.createComponent("Student-T", -5, 5, new String[]{"df=1", "df=2", "df=5", "df=10000"}, new RealDistribution[]{new TDistribution(1.0), new TDistribution(2.0), new TDistribution(5.0), new TDistribution(10000.0)});
            this.container.add((Component)comp, c);
            ++c.gridx;
            comp = RealDistributionComparison.createComponent("Weibull", 0, 3, new String[]{"\u03bb=0.5,k=1", "\u03bb=1,k=1", "\u03bb=1.5,k=1", "\u03bb=5,k=1"}, new RealDistribution[]{new WeibullDistribution(0.5, 1.0), new WeibullDistribution(1.0, 1.0), new WeibullDistribution(1.5, 1.0), new WeibullDistribution(5.0, 1.0)});
            this.container.add((Component)comp, c);
            JScrollPane scrollPane = new JScrollPane(this.container);
            this.add(scrollPane);
        }

        @Override
        public Component getMainPanel() {
            return this.container;
        }
    }
}

