/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.samples.complex;

import org.hipparchus.complex.Complex;
import org.hipparchus.util.FastMath;

public abstract class DomainColoring {
    private final double saturation;

    protected DomainColoring(double saturation) {
        this.saturation = saturation;
    }

    public double hue(Complex z) {
        double phase = Math.PI + FastMath.atan2((double)(-z.getImaginaryPart()), (double)(-z.getRealPart()));
        return phase / (Math.PI * 2);
    }

    public double saturation(Complex z) {
        return this.saturation;
    }

    protected abstract double value(Complex var1);
}

