/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.samples;

import com.xeiam.xchart.Chart;
import com.xeiam.xchart.ChartBuilder;
import com.xeiam.xchart.Series;
import com.xeiam.xchart.SeriesMarker;
import com.xeiam.xchart.StyleManager;
import com.xeiam.xchart.XChartPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.hipparchus.distribution.IntegerDistribution;
import org.hipparchus.distribution.discrete.BinomialDistribution;
import org.hipparchus.distribution.discrete.GeometricDistribution;
import org.hipparchus.distribution.discrete.HypergeometricDistribution;
import org.hipparchus.distribution.discrete.PascalDistribution;
import org.hipparchus.distribution.discrete.PoissonDistribution;
import org.hipparchus.distribution.discrete.UniformIntegerDistribution;
import org.hipparchus.distribution.discrete.ZipfDistribution;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.samples.ExampleUtils;

public class IntegerDistributionComparison {
    private static final String ARIAL = "Arial";
    private static final String P02 = "p=0.2";
    private static final String P03 = "p=0.3";
    private static final String P05 = "p=0.5";
    private static final String P07 = "p=0.7";
    private static final String P075 = "p=0.75";
    private static final String P08 = "p=0.8";

    public static void addPDFSeries(Chart chart, IntegerDistribution distribution, String desc, int lowerBound, int upperBound) {
        ArrayList<Integer> xData = new ArrayList<Integer>();
        ArrayList<Double> yData = new ArrayList<Double>();
        for (int x = lowerBound; x <= upperBound; ++x) {
            try {
                double probability = distribution.probability(x);
                if (Double.isInfinite(probability) || Double.isNaN(probability)) continue;
                xData.add(x);
                yData.add(probability);
                continue;
            }
            catch (MathRuntimeException mathRuntimeException) {
                // empty catch block
            }
        }
        Series series = chart.addSeries(desc, xData, yData);
        series.setMarker(SeriesMarker.NONE);
        series.setLineStyle(new BasicStroke(1.2f));
    }

    public static void addCDFSeries(Chart chart, IntegerDistribution distribution, String desc, int lowerBound, int upperBound) {
        ArrayList<Integer> xData = new ArrayList<Integer>();
        ArrayList<Double> yData = new ArrayList<Double>();
        for (int x = lowerBound; x <= upperBound; ++x) {
            double density = distribution.cumulativeProbability(x);
            if (Double.isInfinite(density) || Double.isNaN(density)) continue;
            xData.add(x);
            yData.add(density);
        }
        Series series = chart.addSeries(desc, xData, yData);
        series.setMarker(SeriesMarker.NONE);
        series.setLineStyle(new BasicStroke(1.2f));
    }

    public static Chart createChart(String title, int minX, int maxX, StyleManager.LegendPosition position) {
        Chart chart = new ChartBuilder().width(235).height(200).build();
        chart.setChartTitle(title);
        chart.getStyleManager().setChartTitleVisible(true);
        chart.getStyleManager().setChartTitleFont(new Font(ARIAL, 0, 10));
        chart.getStyleManager().setLegendPosition(position);
        chart.getStyleManager().setLegendVisible(true);
        chart.getStyleManager().setLegendFont(new Font(ARIAL, 0, 10));
        chart.getStyleManager().setLegendPadding(6);
        chart.getStyleManager().setLegendSeriesLineLength(6);
        chart.getStyleManager().setAxisTickLabelsFont(new Font(ARIAL, 0, 9));
        chart.getStyleManager().setXAxisMin((double)minX);
        chart.getStyleManager().setXAxisMax((double)maxX);
        chart.getStyleManager().setChartBackgroundColor(Color.white);
        chart.getStyleManager().setChartPadding(4);
        chart.getStyleManager().setChartType(StyleManager.ChartType.Line);
        return chart;
    }

    public static JComponent createComponent(String distributionName, int minX, int maxX, String[] seriesText, IntegerDistribution ... series) {
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 3));
        container.add(new JLabel(distributionName));
        Chart chart = IntegerDistributionComparison.createChart("PDF", minX, maxX, StyleManager.LegendPosition.InsideNE);
        int i = 0;
        for (IntegerDistribution d : series) {
            IntegerDistributionComparison.addPDFSeries(chart, d, seriesText[i++], minX, maxX);
        }
        container.add((Component)new XChartPanel(chart));
        chart = IntegerDistributionComparison.createChart("CDF", minX, maxX, StyleManager.LegendPosition.InsideSE);
        i = 0;
        for (IntegerDistribution d : series) {
            IntegerDistributionComparison.addCDFSeries(chart, d, seriesText[i++], minX, maxX);
        }
        container.add((Component)new XChartPanel(chart));
        container.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        return container;
    }

    public static void main(String[] args) {
        ExampleUtils.showExampleFrame(new Display());
    }

    public static class Display
    extends ExampleUtils.ExampleFrame {
        private JComponent container;

        public Display() {
            this.setTitle("Hipparchus: Integer distributions overview");
            this.setSize(1320, 920);
            this.container = new JPanel();
            this.container.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 3;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(2, 2, 2, 2);
            JComponent comp = IntegerDistributionComparison.createComponent("Binomial", 0, 40, new String[]{"p=0.5,n=20", "p=0.7,n=20", "p=0.5,n=40"}, new IntegerDistribution[]{new BinomialDistribution(20, 0.5), new BinomialDistribution(20, 0.7), new BinomialDistribution(40, 0.5)});
            this.container.add((Component)comp, c);
            ++c.gridx;
            comp = IntegerDistributionComparison.createComponent("Geometric", 0, 10, new String[]{IntegerDistributionComparison.P02, IntegerDistributionComparison.P05, IntegerDistributionComparison.P08}, new IntegerDistribution[]{new GeometricDistribution(0.2), new GeometricDistribution(0.5), new GeometricDistribution(0.8)});
            this.container.add((Component)comp, c);
            ++c.gridx;
            comp = IntegerDistributionComparison.createComponent("Hypergeometric", 0, 10, new String[]{IntegerDistributionComparison.P03, IntegerDistributionComparison.P05, IntegerDistributionComparison.P075}, new IntegerDistribution[]{new HypergeometricDistribution(100, 6, 20), new HypergeometricDistribution(100, 10, 20), new HypergeometricDistribution(100, 15, 20)});
            this.container.add((Component)comp, c);
            ++c.gridx;
            comp = IntegerDistributionComparison.createComponent("Pascal", 0, 50, new String[]{IntegerDistributionComparison.P03, IntegerDistributionComparison.P05, IntegerDistributionComparison.P07}, new IntegerDistribution[]{new PascalDistribution(10, 0.3), new PascalDistribution(10, 0.5), new PascalDistribution(10, 0.7)});
            this.container.add((Component)comp, c);
            ++c.gridy;
            c.gridx = 0;
            comp = IntegerDistributionComparison.createComponent("Poisson", 0, 20, new String[]{"\u03bb=1", "\u03bb=4", "\u03bb=10"}, new IntegerDistribution[]{new PoissonDistribution(1.0), new PoissonDistribution(4.0), new PoissonDistribution(10.0)});
            this.container.add((Component)comp, c);
            ++c.gridx;
            comp = IntegerDistributionComparison.createComponent("Uniform", 0, 30, new String[]{"l=1,u=10", "l=5,u=20", "l=1,u=25"}, new IntegerDistribution[]{new UniformIntegerDistribution(1, 10), new UniformIntegerDistribution(5, 20), new UniformIntegerDistribution(1, 25)});
            this.container.add((Component)comp, c);
            ++c.gridx;
            comp = IntegerDistributionComparison.createComponent("Zipf", 0, 15, new String[]{"n=10,e=0.5", "n=10,e=1", "n=10,e=2", "n=10,e=5"}, new IntegerDistribution[]{new ZipfDistribution(10, 0.5), new ZipfDistribution(10, 1.0), new ZipfDistribution(10, 2.0), new ZipfDistribution(10, 5.0)});
            this.container.add((Component)comp, c);
            JScrollPane scrollPane = new JScrollPane(this.container);
            this.add(scrollPane);
        }

        @Override
        public Component getMainPanel() {
            return this.container;
        }
    }
}

