/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.samples.ode;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.nonstiff.DormandPrince853Integrator;
import org.hipparchus.ode.sampling.ODEStepHandler;
import org.hipparchus.ode.sampling.StepNormalizer;

public class LorenzPlotter {
    private double duration = 125.0;
    private double step = 0.002;
    private double sigma = 10.0;
    private double rho = 28.0;
    private double beta = 2.6666666666666665;
    private File output = null;
    private int width = 1000;
    private int height = 1000;
    private double viewXRot = 70.0;
    private double viewZRot = 20.0;

    private LorenzPlotter() {
    }

    public static void main(String[] args) {
        LorenzPlotter plotter = new LorenzPlotter();
        try {
            block27: for (int i = 0; i < args.length; ++i) {
                switch (args[i]) {
                    case "--help": {
                        LorenzPlotter.usage(0);
                        continue block27;
                    }
                    case "--duration": {
                        plotter.duration = Double.parseDouble(args[++i]);
                        continue block27;
                    }
                    case "--step": {
                        plotter.step = Double.parseDouble(args[++i]);
                        continue block27;
                    }
                    case "--sigma": {
                        plotter.sigma = Double.parseDouble(args[++i]);
                        continue block27;
                    }
                    case "--rhon": {
                        plotter.rho = Double.parseDouble(args[++i]);
                        continue block27;
                    }
                    case "--beta": {
                        plotter.beta = Double.parseDouble(args[++i]);
                        continue block27;
                    }
                    case "--output-dir": {
                        plotter.output = new File(args[++i]);
                        if (plotter.output.exists() && plotter.output.isDirectory() && plotter.output.canWrite()) continue block27;
                        System.err.format(Locale.US, "cannot generate output file in %s%n", plotter.output.getAbsolutePath());
                        System.exit(1);
                        continue block27;
                    }
                    case "--width": {
                        plotter.width = Integer.parseInt(args[++i]);
                        continue block27;
                    }
                    case "--height": {
                        plotter.height = Integer.parseInt(args[++i]);
                        continue block27;
                    }
                    case "--view": {
                        plotter.viewXRot = Double.parseDouble(args[++i]);
                        plotter.viewZRot = Double.parseDouble(args[++i]);
                        continue block27;
                    }
                    default: {
                        LorenzPlotter.usage(1);
                    }
                }
            }
            plotter.plot();
        }
        catch (IndexOutOfBoundsException iobe) {
            LorenzPlotter.usage(1);
        }
        catch (IOException ioe) {
            System.err.println(ioe.getLocalizedMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    private static void usage(int status) {
        System.err.println("usage: java org.hipparchus.samples.ode.LorenzPlotter [--help] [--duration duration] [--step step] [--sigma sigma] [--rho rho] [--beta beta] [--output-dir directory] [--view xRot zRot]");
        System.exit(status);
    }

    public void plot() throws IOException {
        ProcessBuilder pb = new ProcessBuilder("gnuplot").redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT);
        pb.environment().remove("XDG_SESSION_TYPE");
        Process gnuplot = pb.start();
        try (PrintStream out = new PrintStream(gnuplot.getOutputStream(), false, StandardCharsets.UTF_8.name());){
            File outputFile;
            if (this.output == null) {
                out.format(Locale.US, "set terminal qt size %d, %d title 'Lorenz plotter'%n", this.width, this.height);
                outputFile = null;
            } else {
                out.format(Locale.US, "set terminal pngcairo size %d, %d%n", this.width, this.height);
                outputFile = new File(this.output, "Lorenz-attractor.png");
                out.format(Locale.US, "set output '%s'%n", outputFile.getAbsolutePath());
            }
            out.format(Locale.US, "set xlabel 'X'%n", new Object[0]);
            out.format(Locale.US, "set ylabel 'Y'%n", new Object[0]);
            out.format(Locale.US, "set zlabel 'Z'%n", new Object[0]);
            out.format(Locale.US, "set key off%n", new Object[0]);
            out.format(Locale.US, "unset colorbox%n", new Object[0]);
            out.format(Locale.US, "set palette model RGB defined (0 0.45 0.66 0.85,0.25 0.725 0.9 1, 0.33 0.85 0.95 1, 0.33 0.68 0.82 0.65,0.4 0.58 0.75 0.53,0.575 0.95 0.9 0.75, 0.8 0.66 0.52 0.32,0.85 0.66 0.6 0.5, 1 0.95 0.95 0.95)%n", new Object[0]);
            out.format(Locale.US, "$data <<EOD%n", new Object[0]);
            DormandPrince853Integrator integrator = new DormandPrince853Integrator(0.001, 10.0, 1.0E-12, 1.0E-12);
            integrator.addStepHandler((ODEStepHandler)new StepNormalizer(this.step, (state, isLast) -> out.format(Locale.US, "%.6f %.3f %.3f %.3f%n", state.getTime() / this.duration, state.getCompleteState()[0], state.getCompleteState()[1], state.getCompleteState()[2])));
            integrator.integrate((OrdinaryDifferentialEquation)new LorenzOde(), new ODEState(0.0, new double[]{-8.0, 8.0, this.rho - 1.0}), this.duration);
            out.format(Locale.US, "EOD%n", new Object[0]);
            out.format(Locale.US, "set view %f, %f%n", this.viewXRot, this.viewZRot);
            out.format(Locale.US, "splot $data using 2:3:4:1 with lines lc palette%n", new Object[0]);
            if (this.output == null) {
                out.format(Locale.US, "pause mouse close%n", new Object[0]);
            } else {
                System.out.format(Locale.US, "output written to %s%n", outputFile.getAbsolutePath());
            }
        }
    }

    private class LorenzOde
    implements OrdinaryDifferentialEquation {
        private LorenzOde() {
        }

        public int getDimension() {
            return 3;
        }

        public double[] computeDerivatives(double t, double[] y) {
            return new double[]{LorenzPlotter.this.sigma * (y[1] - y[0]), y[0] * (LorenzPlotter.this.rho - y[2]) - y[1], y[0] * y[1] - LorenzPlotter.this.beta * y[2]};
        }
    }
}

