/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.inference.MannWhitneyUTest;
import org.junit.Assert;
import org.junit.Test;

public class MannWhitneyUTestTest {
    protected MannWhitneyUTest testStatistic = new MannWhitneyUTest();

    @Test
    public void testMannWhitneyUSimple() {
        double[] x = new double[]{19.0, 22.0, 16.0, 29.0, 24.0};
        double[] y = new double[]{20.0, 11.0, 17.0, 12.0};
        Assert.assertEquals((double)17.0, (double)this.testStatistic.mannWhitneyU(x, y), (double)1.0E-10);
        Assert.assertEquals((double)0.08641, (double)this.testStatistic.mannWhitneyUTest(x, y), (double)1.0E-5);
    }

    @Test
    public void testMannWhitneyUInputValidation() {
        try {
            this.testStatistic.mannWhitneyUTest(new double[0], new double[]{1.0});
            Assert.fail((String)"x does not contain samples (exact), MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.mannWhitneyUTest(new double[]{1.0}, new double[0]);
            Assert.fail((String)"y does not contain samples (exact), MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.mannWhitneyUTest(null, null);
            Assert.fail((String)"x and y is null (exact), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.mannWhitneyUTest(null, null);
            Assert.fail((String)"x and y is null (asymptotic), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.mannWhitneyUTest(null, new double[]{1.0});
            Assert.fail((String)"x is null (exact), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.mannWhitneyUTest(new double[]{1.0}, null);
            Assert.fail((String)"y is null (exact), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBigDataSet() {
        double[] d1 = new double[1500];
        double[] d2 = new double[1500];
        for (int i = 0; i < 1500; ++i) {
            d1[i] = 2 * i;
            d2[i] = 2 * i + 1;
        }
        double result = this.testStatistic.mannWhitneyUTest(d1, d2);
        Assert.assertTrue((result > 0.1 ? 1 : 0) != 0);
    }

    @Test
    public void testBigDataSetOverflow() {
        double[] d1 = new double[110000];
        double[] d2 = new double[110000];
        for (int i = 0; i < 110000; ++i) {
            d1[i] = i;
            d2[i] = i;
        }
        double result = this.testStatistic.mannWhitneyUTest(d1, d2);
        Assert.assertTrue((result == 1.0 ? 1 : 0) != 0);
    }
}

