/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.inference.WilcoxonSignedRankTest;
import org.junit.Assert;
import org.junit.Test;

public class WilcoxonSignedRankTestTest {
    protected WilcoxonSignedRankTest testStatistic = new WilcoxonSignedRankTest();

    @Test
    public void testWilcoxonSignedRankSimple() {
        double[] x = new double[]{1.83, 0.5, 1.62, 2.48, 1.68, 1.88, 1.55, 3.06, 1.3};
        double[] y = new double[]{0.878, 0.647, 0.598, 2.05, 1.06, 1.29, 1.06, 3.14, 1.29};
        Assert.assertEquals((double)40.0, (double)this.testStatistic.wilcoxonSignedRank(x, y), (double)1.0E-10);
        Assert.assertEquals((double)0.03906, (double)this.testStatistic.wilcoxonSignedRankTest(x, y, true), (double)1.0E-5);
        Assert.assertEquals((double)40.0, (double)this.testStatistic.wilcoxonSignedRank(x, y), (double)1.0E-10);
        Assert.assertEquals((double)0.0329693812, (double)this.testStatistic.wilcoxonSignedRankTest(x, y, false), (double)1.0E-10);
    }

    @Test
    public void testWilcoxonSignedRankInputValidation() {
        double[] x1 = new double[30];
        double[] x2 = new double[31];
        double[] y1 = new double[30];
        double[] y2 = new double[31];
        for (int i = 0; i < 30; ++i) {
            y1[i] = y2[i] = (double)i;
            x2[i] = y2[i];
            x1[i] = y2[i];
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(x2, y2, true);
            Assert.fail((String)"More than 30 samples and exact chosen, MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(new double[0], new double[]{1.0}, true);
            Assert.fail((String)"x does not contain samples (exact), MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(new double[0], new double[]{1.0}, false);
            Assert.fail((String)"x does not contain samples (asymptotic), MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(new double[]{1.0}, new double[0], true);
            Assert.fail((String)"y does not contain samples (exact), MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(new double[]{1.0}, new double[0], false);
            Assert.fail((String)"y does not contain samples (asymptotic), MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(new double[]{1.0, 2.0}, new double[]{3.0}, true);
            Assert.fail((String)"x and y not same size (exact), MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(new double[]{1.0, 2.0}, new double[]{3.0}, false);
            Assert.fail((String)"x and y not same size (asymptotic), MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(null, null, true);
            Assert.fail((String)"x and y is null (exact), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(null, null, false);
            Assert.fail((String)"x and y is null (asymptotic), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(null, new double[]{1.0}, true);
            Assert.fail((String)"x is null (exact), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(null, new double[]{1.0}, false);
            Assert.fail((String)"x is null (asymptotic), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(new double[]{1.0}, null, true);
            Assert.fail((String)"y is null (exact), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            this.testStatistic.wilcoxonSignedRankTest(new double[]{1.0}, null, false);
            Assert.fail((String)"y is null (asymptotic), NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }
}

