/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.stat.descriptive.UnivariateStatistic;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public interface StorelessUnivariateStatistic
extends UnivariateStatistic {
    @Override
    default public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        if (MathArrays.verifyValues((double[])values, (int)begin, (int)length)) {
            StorelessUnivariateStatistic stat = this.copy();
            stat.clear();
            stat.incrementAll(values, begin, length);
            return stat.getResult();
        }
        return Double.NaN;
    }

    public void increment(double var1);

    default public void incrementAll(double[] values) throws MathIllegalArgumentException {
        MathUtils.checkNotNull((Object)values, (Localizable)LocalizedCoreFormats.INPUT_ARRAY, (Object[])new Object[0]);
        this.incrementAll(values, 0, values.length);
    }

    default public void incrementAll(double[] values, int start, int length) throws MathIllegalArgumentException {
        if (MathArrays.verifyValues((double[])values, (int)start, (int)length)) {
            int k = start + length;
            for (int i = start; i < k; ++i) {
                this.increment(values[i]);
            }
        }
    }

    public double getResult();

    public long getN();

    public void clear();

    @Override
    public StorelessUnivariateStatistic copy();
}

