/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import java.io.Serializable;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.AggregatableStatistic;
import org.hipparchus.stat.descriptive.StatisticalSummary;
import org.hipparchus.stat.descriptive.StatisticalSummaryValues;
import org.hipparchus.stat.descriptive.moment.GeometricMean;
import org.hipparchus.stat.descriptive.moment.Mean;
import org.hipparchus.stat.descriptive.moment.SecondMoment;
import org.hipparchus.stat.descriptive.moment.Variance;
import org.hipparchus.stat.descriptive.rank.Max;
import org.hipparchus.stat.descriptive.rank.Min;
import org.hipparchus.stat.descriptive.summary.Sum;
import org.hipparchus.stat.descriptive.summary.SumOfLogs;
import org.hipparchus.stat.descriptive.summary.SumOfSquares;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;

public class StreamingStatistics
implements StatisticalSummary,
AggregatableStatistic<StreamingStatistics>,
Serializable {
    private static final long serialVersionUID = 20160422L;
    private long n = 0L;
    private final SecondMoment secondMoment;
    private final Min minImpl;
    private final Max maxImpl;
    private final Sum sumImpl;
    private final SumOfSquares sumOfSquaresImpl;
    private final SumOfLogs sumOfLogsImpl;
    private final Mean meanImpl;
    private final Variance varianceImpl;
    private final GeometricMean geoMeanImpl;
    private final Variance populationVariance;

    public StreamingStatistics() {
        this.secondMoment = new SecondMoment();
        this.maxImpl = new Max();
        this.minImpl = new Min();
        this.sumImpl = new Sum();
        this.sumOfSquaresImpl = new SumOfSquares();
        this.sumOfLogsImpl = new SumOfLogs();
        this.meanImpl = new Mean(this.secondMoment);
        this.varianceImpl = new Variance(this.secondMoment);
        this.geoMeanImpl = new GeometricMean(this.sumOfLogsImpl);
        this.populationVariance = new Variance(false, this.secondMoment);
    }

    StreamingStatistics(StreamingStatistics original) throws NullArgumentException {
        MathUtils.checkNotNull((Object)original);
        this.n = original.n;
        this.secondMoment = original.secondMoment.copy();
        this.maxImpl = original.maxImpl.copy();
        this.minImpl = original.minImpl.copy();
        this.sumImpl = original.sumImpl.copy();
        this.sumOfLogsImpl = original.sumOfLogsImpl.copy();
        this.sumOfSquaresImpl = original.sumOfSquaresImpl.copy();
        this.meanImpl = new Mean(this.secondMoment);
        this.varianceImpl = new Variance(this.secondMoment);
        this.geoMeanImpl = new GeometricMean(this.sumOfLogsImpl);
        this.populationVariance = new Variance(false, this.secondMoment);
    }

    public StreamingStatistics copy() {
        return new StreamingStatistics(this);
    }

    public StatisticalSummary getSummary() {
        return new StatisticalSummaryValues(this.getMean(), this.getVariance(), this.getN(), this.getMax(), this.getMin(), this.getSum());
    }

    public void addValue(double value) {
        this.secondMoment.increment(value);
        this.minImpl.increment(value);
        this.maxImpl.increment(value);
        this.sumImpl.increment(value);
        this.sumOfSquaresImpl.increment(value);
        this.sumOfLogsImpl.increment(value);
        ++this.n;
    }

    public void clear() {
        this.n = 0L;
        this.minImpl.clear();
        this.maxImpl.clear();
        this.sumImpl.clear();
        this.sumOfLogsImpl.clear();
        this.sumOfSquaresImpl.clear();
        this.secondMoment.clear();
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public double getMax() {
        return this.maxImpl.getResult();
    }

    @Override
    public double getMin() {
        return this.minImpl.getResult();
    }

    @Override
    public double getSum() {
        return this.sumImpl.getResult();
    }

    public double getSumOfSquares() {
        return this.sumOfSquaresImpl.getResult();
    }

    @Override
    public double getMean() {
        return this.meanImpl.getResult();
    }

    @Override
    public double getVariance() {
        return this.varianceImpl.getResult();
    }

    public double getPopulationVariance() {
        return this.populationVariance.getResult();
    }

    public double getGeometricMean() {
        return this.geoMeanImpl.getResult();
    }

    public double getSumOfLogs() {
        return this.sumOfLogsImpl.getResult();
    }

    public double getSecondMoment() {
        return this.secondMoment.getResult();
    }

    public double getQuadraticMean() {
        long size = this.getN();
        return size > 0L ? FastMath.sqrt((double)(this.getSumOfSquares() / (double)size)) : Double.NaN;
    }

    @Override
    public double getStandardDeviation() {
        long size = this.getN();
        if (size > 0L) {
            return size > 1L ? FastMath.sqrt((double)this.getVariance()) : 0.0;
        }
        return Double.NaN;
    }

    @Override
    public void aggregate(StreamingStatistics other) {
        MathUtils.checkNotNull((Object)other);
        if (other.n > 0L) {
            this.n += other.n;
            this.secondMoment.aggregate(other.secondMoment);
            this.minImpl.aggregate(other.minImpl);
            this.maxImpl.aggregate(other.maxImpl);
            this.sumImpl.aggregate(other.sumImpl);
            this.sumOfLogsImpl.aggregate(other.sumOfLogsImpl);
            this.sumOfSquaresImpl.aggregate(other.sumOfSquaresImpl);
        }
    }

    public String toString() {
        StringBuilder outBuffer = new StringBuilder();
        String endl = "\n";
        outBuffer.append("SummaryStatistics:").append(endl);
        outBuffer.append("n: ").append(this.getN()).append(endl);
        outBuffer.append("min: ").append(this.getMin()).append(endl);
        outBuffer.append("max: ").append(this.getMax()).append(endl);
        outBuffer.append("sum: ").append(this.getSum()).append(endl);
        outBuffer.append("mean: ").append(this.getMean()).append(endl);
        outBuffer.append("variance: ").append(this.getVariance()).append(endl);
        outBuffer.append("population variance: ").append(this.getPopulationVariance()).append(endl);
        outBuffer.append("standard deviation: ").append(this.getStandardDeviation()).append(endl);
        outBuffer.append("geometric mean: ").append(this.getGeometricMean()).append(endl);
        outBuffer.append("second moment: ").append(this.getSecondMoment()).append(endl);
        outBuffer.append("sum of squares: ").append(this.getSumOfSquares()).append(endl);
        outBuffer.append("sum of logs: ").append(this.getSumOfLogs()).append(endl);
        return outBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StreamingStatistics)) {
            return false;
        }
        StreamingStatistics other = (StreamingStatistics)object;
        return other.getN() == this.getN() && Precision.equalsIncludingNaN((double)other.getMax(), (double)this.getMax()) && Precision.equalsIncludingNaN((double)other.getMin(), (double)this.getMin()) && Precision.equalsIncludingNaN((double)other.getSum(), (double)this.getSum()) && Precision.equalsIncludingNaN((double)other.getGeometricMean(), (double)this.getGeometricMean()) && Precision.equalsIncludingNaN((double)other.getMean(), (double)this.getMean()) && Precision.equalsIncludingNaN((double)other.getSumOfSquares(), (double)this.getSumOfSquares()) && Precision.equalsIncludingNaN((double)other.getSumOfLogs(), (double)this.getSumOfLogs()) && Precision.equalsIncludingNaN((double)other.getVariance(), (double)this.getVariance());
    }

    public int hashCode() {
        int result = 31 + MathUtils.hash((double)this.getN());
        result = result * 31 + MathUtils.hash((double)this.getMax());
        result = result * 31 + MathUtils.hash((double)this.getMin());
        result = result * 31 + MathUtils.hash((double)this.getSum());
        result = result * 31 + MathUtils.hash((double)this.getGeometricMean());
        result = result * 31 + MathUtils.hash((double)this.getMean());
        result = result * 31 + MathUtils.hash((double)this.getSumOfSquares());
        result = result * 31 + MathUtils.hash((double)this.getSumOfLogs());
        result = result * 31 + MathUtils.hash((double)this.getVariance());
        return result;
    }
}

