/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import org.hipparchus.distribution.discrete.BinomialDistribution;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.stat.inference.AlternativeHypothesis;
import org.hipparchus.util.MathUtils;

public class BinomialTest {
    public boolean binomialTest(int numberOfTrials, int numberOfSuccesses, double probability, AlternativeHypothesis alternativeHypothesis, double alpha) {
        double pValue = this.binomialTest(numberOfTrials, numberOfSuccesses, probability, alternativeHypothesis);
        return pValue < alpha;
    }

    public double binomialTest(int numberOfTrials, int numberOfSuccesses, double probability, AlternativeHypothesis alternativeHypothesis) {
        if (numberOfTrials < 0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL, new Object[]{numberOfTrials, 0});
        }
        if (numberOfSuccesses < 0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL, new Object[]{numberOfSuccesses, 0});
        }
        MathUtils.checkRangeInclusive((double)probability, (double)0.0, (double)1.0);
        if (numberOfTrials < numberOfSuccesses) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.BINOMIAL_INVALID_PARAMETERS_ORDER, new Object[]{numberOfTrials, numberOfSuccesses});
        }
        MathUtils.checkNotNull((Object)((Object)alternativeHypothesis));
        BinomialDistribution distribution = new BinomialDistribution(numberOfTrials, probability);
        switch (alternativeHypothesis) {
            case GREATER_THAN: {
                return 1.0 - distribution.cumulativeProbability(numberOfSuccesses - 1);
            }
            case LESS_THAN: {
                return distribution.cumulativeProbability(numberOfSuccesses);
            }
            case TWO_SIDED: {
                int criticalValueLow = 0;
                int criticalValueHigh = numberOfTrials;
                double pTotal = 0.0;
                do {
                    double pHigh;
                    double pLow;
                    if ((pLow = distribution.probability(criticalValueLow)) == (pHigh = distribution.probability(criticalValueHigh))) {
                        pTotal += 2.0 * pLow;
                        ++criticalValueLow;
                        --criticalValueHigh;
                        continue;
                    }
                    if (pLow < pHigh) {
                        pTotal += pLow;
                        ++criticalValueLow;
                        continue;
                    }
                    pTotal += pHigh;
                    --criticalValueHigh;
                } while (criticalValueLow <= numberOfSuccesses && criticalValueHigh >= numberOfSuccesses);
                return pTotal;
            }
        }
        throw MathRuntimeException.createInternalError();
    }
}

