/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.moment;

import org.hipparchus.stat.StatUtils;
import org.hipparchus.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.moment.SecondMoment;
import org.hipparchus.stat.descriptive.moment.Variance;
import org.hipparchus.util.MathArrays;
import org.junit.Assert;
import org.junit.Test;

public class VarianceTest
extends StorelessUnivariateStatisticAbstractTest {
    public Variance getUnivariateStatistic() {
        return new Variance();
    }

    @Override
    public double expectedValue() {
        return this.var;
    }

    public double expectedWeightedValue() {
        return this.weightedVar;
    }

    @Test
    public void testNaN() {
        Variance var = this.getUnivariateStatistic();
        Assert.assertTrue((boolean)Double.isNaN(var.getResult()));
        var.increment(1.0);
        Assert.assertEquals((double)0.0, (double)var.getResult(), (double)0.0);
    }

    @Test
    public void testPopulation() {
        double[] values = new double[]{-1.0, 3.1, 4.0, -2.1, 22.0, 11.7, 3.0, 14.0};
        SecondMoment m = new SecondMoment();
        m.incrementAll(values);
        Variance v1 = new Variance();
        v1 = v1.withBiasCorrection(false);
        Assert.assertEquals((double)this.populationVariance(values), (double)v1.evaluate(values), (double)1.0E-14);
        v1.incrementAll(values);
        Assert.assertEquals((double)this.populationVariance(values), (double)v1.getResult(), (double)1.0E-14);
        v1 = new Variance(false, m);
        Assert.assertEquals((double)this.populationVariance(values), (double)v1.getResult(), (double)1.0E-14);
        v1 = new Variance(false);
        Assert.assertEquals((double)this.populationVariance(values), (double)v1.evaluate(values), (double)1.0E-14);
        v1.incrementAll(values);
        Assert.assertEquals((double)this.populationVariance(values), (double)v1.getResult(), (double)1.0E-14);
    }

    protected double populationVariance(double[] v) {
        double mean = StatUtils.mean((double[])v);
        double sum = 0.0;
        for (double val : v) {
            sum += (val - mean) * (val - mean);
        }
        return sum / (double)v.length;
    }

    @Test
    public void testWeightedVariance() {
        Variance variance = this.getUnivariateStatistic();
        Assert.assertEquals((double)this.expectedWeightedValue(), (double)variance.evaluate(this.testArray, this.testWeightsArray, 0, this.testArray.length), (double)this.getTolerance());
        Assert.assertEquals((double)this.expectedValue(), (double)variance.evaluate(this.testArray, this.unitWeightsArray, 0, this.testArray.length), (double)this.getTolerance());
        Assert.assertEquals((double)this.expectedValue(), (double)variance.evaluate(this.testArray, MathArrays.normalizeArray((double[])this.identicalWeightsArray, (double)this.testArray.length), 0, this.testArray.length), (double)this.getTolerance());
    }
}

