/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.correlation;

import java.util.Arrays;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.BlockRealMatrix;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class KendallsCorrelation {
    private final RealMatrix correlationMatrix;

    public KendallsCorrelation() {
        this.correlationMatrix = null;
    }

    public KendallsCorrelation(double[][] data) {
        this(MatrixUtils.createRealMatrix((double[][])data));
    }

    public KendallsCorrelation(RealMatrix matrix) {
        this.correlationMatrix = this.computeCorrelationMatrix(matrix);
    }

    public RealMatrix getCorrelationMatrix() {
        return this.correlationMatrix;
    }

    public RealMatrix computeCorrelationMatrix(RealMatrix matrix) {
        int nVars = matrix.getColumnDimension();
        BlockRealMatrix outMatrix = new BlockRealMatrix(nVars, nVars);
        for (int i = 0; i < nVars; ++i) {
            for (int j = 0; j < i; ++j) {
                double corr = this.correlation(matrix.getColumn(i), matrix.getColumn(j));
                outMatrix.setEntry(i, j, corr);
                outMatrix.setEntry(j, i, corr);
            }
            outMatrix.setEntry(i, i, 1.0);
        }
        return outMatrix;
    }

    public RealMatrix computeCorrelationMatrix(double[][] matrix) {
        return this.computeCorrelationMatrix((RealMatrix)new BlockRealMatrix(matrix));
    }

    public double correlation(double[] xArray, double[] yArray) throws MathIllegalArgumentException {
        MathArrays.checkEqualLength((double[])xArray, (double[])yArray);
        int n = xArray.length;
        long numPairs = KendallsCorrelation.sum(n - 1);
        Object[] pairs = new DoublePair[n];
        for (int i = 0; i < n; ++i) {
            pairs[i] = new DoublePair(xArray[i], yArray[i]);
        }
        Arrays.sort(pairs);
        long tiedXPairs = 0L;
        long tiedXYPairs = 0L;
        long consecutiveXTies = 1L;
        long consecutiveXYTies = 1L;
        Object prev = pairs[0];
        for (int i = 1; i < n; ++i) {
            Object curr = pairs[i];
            if (Double.compare(((DoublePair)curr).getFirst(), ((DoublePair)prev).getFirst()) == 0) {
                ++consecutiveXTies;
                if (Double.compare(((DoublePair)curr).getSecond(), ((DoublePair)prev).getSecond()) == 0) {
                    ++consecutiveXYTies;
                } else {
                    tiedXYPairs += KendallsCorrelation.sum(consecutiveXYTies - 1L);
                    consecutiveXYTies = 1L;
                }
            } else {
                tiedXPairs += KendallsCorrelation.sum(consecutiveXTies - 1L);
                consecutiveXTies = 1L;
                tiedXYPairs += KendallsCorrelation.sum(consecutiveXYTies - 1L);
                consecutiveXYTies = 1L;
            }
            prev = curr;
        }
        tiedXPairs += KendallsCorrelation.sum(consecutiveXTies - 1L);
        tiedXYPairs += KendallsCorrelation.sum(consecutiveXYTies - 1L);
        long swaps = 0L;
        Object[] pairsDestination = new DoublePair[n];
        for (int segmentSize = 1; segmentSize < n; segmentSize <<= 1) {
            for (int offset = 0; offset < n; offset += 2 * segmentSize) {
                int iEnd;
                int i = offset;
                int j = iEnd = FastMath.min((int)(i + segmentSize), (int)n);
                int jEnd = FastMath.min((int)(j + segmentSize), (int)n);
                int copyLocation = offset;
                while (i < iEnd || j < jEnd) {
                    if (i < iEnd) {
                        if (j < jEnd) {
                            if (Double.compare(((DoublePair)pairs[i]).getSecond(), ((DoublePair)pairs[j]).getSecond()) <= 0) {
                                pairsDestination[copyLocation] = pairs[i];
                                ++i;
                            } else {
                                pairsDestination[copyLocation] = pairs[j];
                                ++j;
                                swaps += (long)(iEnd - i);
                            }
                        } else {
                            pairsDestination[copyLocation] = pairs[i];
                            ++i;
                        }
                    } else {
                        pairsDestination[copyLocation] = pairs[j];
                        ++j;
                    }
                    ++copyLocation;
                }
            }
            Object[] pairsTemp = pairs;
            pairs = pairsDestination;
            pairsDestination = pairsTemp;
        }
        long tiedYPairs = 0L;
        long consecutiveYTies = 1L;
        prev = pairs[0];
        for (int i = 1; i < n; ++i) {
            Object curr = pairs[i];
            if (Double.compare(((DoublePair)curr).getSecond(), ((DoublePair)prev).getSecond()) == 0) {
                ++consecutiveYTies;
            } else {
                tiedYPairs += KendallsCorrelation.sum(consecutiveYTies - 1L);
                consecutiveYTies = 1L;
            }
            prev = curr;
        }
        long concordantMinusDiscordant = numPairs - tiedXPairs - (tiedYPairs += KendallsCorrelation.sum(consecutiveYTies - 1L)) + tiedXYPairs - 2L * swaps;
        double nonTiedPairsMultiplied = (double)(numPairs - tiedXPairs) * (double)(numPairs - tiedYPairs);
        return (double)concordantMinusDiscordant / FastMath.sqrt((double)nonTiedPairsMultiplied);
    }

    private static long sum(long n) {
        return n * (n + 1L) / 2L;
    }

    private static class DoublePair
    implements Comparable<DoublePair> {
        private final double first;
        private final double second;

        DoublePair(double first, double second) {
            this.first = first;
            this.second = second;
        }

        public double getFirst() {
            return this.first;
        }

        public double getSecond() {
            return this.second;
        }

        @Override
        public int compareTo(DoublePair other) {
            int compareKey = Double.compare(this.getFirst(), other.getFirst());
            return compareKey != 0 ? compareKey : Double.compare(this.getSecond(), other.getSecond());
        }
    }
}

