/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import java.util.Locale;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.stat.descriptive.StatisticalSummaryValues;
import org.junit.Assert;
import org.junit.Test;

public final class StatisticalSummaryValuesTest {
    @Test
    public void testSerialization() {
        StatisticalSummaryValues u = new StatisticalSummaryValues(1.0, 2.0, 3L, 4.0, 5.0, 6.0);
        UnitTestUtils.checkSerializedEquality((Object)u);
        StatisticalSummaryValues t = (StatisticalSummaryValues)UnitTestUtils.serializeAndRecover((Object)u);
        this.verifyEquality(u, t);
    }

    @Test
    public void testEqualsAndHashCode() {
        StatisticalSummaryValues u = new StatisticalSummaryValues(1.0, 2.0, 3L, 4.0, 5.0, 6.0);
        StatisticalSummaryValues t = null;
        Assert.assertTrue((String)"reflexive", (boolean)u.equals((Object)u));
        Assert.assertFalse((String)"non-null compared to null", (boolean)u.equals(t));
        Assert.assertFalse((String)"wrong type", (boolean)u.equals((Object)0.0));
        t = new StatisticalSummaryValues(1.0, 2.0, 3L, 4.0, 5.0, 6.0);
        Assert.assertTrue((String)"instances with same data should be equal", (boolean)t.equals((Object)u));
        Assert.assertEquals((String)"hash code", (long)u.hashCode(), (long)t.hashCode());
        u = new StatisticalSummaryValues(Double.NaN, 2.0, 3L, 4.0, 5.0, 6.0);
        t = new StatisticalSummaryValues(1.0, Double.NaN, 3L, 4.0, 5.0, 6.0);
        Assert.assertFalse((String)"instances based on different data should be different", (u.equals((Object)t) || t.equals((Object)u) ? 1 : 0) != 0);
    }

    private void verifyEquality(StatisticalSummaryValues s, StatisticalSummaryValues u) {
        Assert.assertEquals((String)"N", (long)s.getN(), (long)u.getN());
        UnitTestUtils.assertEquals((String)"sum", (double)s.getSum(), (double)u.getSum(), (double)0.0);
        UnitTestUtils.assertEquals((String)"var", (double)s.getVariance(), (double)u.getVariance(), (double)0.0);
        UnitTestUtils.assertEquals((String)"std", (double)s.getStandardDeviation(), (double)u.getStandardDeviation(), (double)0.0);
        UnitTestUtils.assertEquals((String)"mean", (double)s.getMean(), (double)u.getMean(), (double)0.0);
        UnitTestUtils.assertEquals((String)"min", (double)s.getMin(), (double)u.getMin(), (double)0.0);
        UnitTestUtils.assertEquals((String)"max", (double)s.getMax(), (double)u.getMax(), (double)0.0);
    }

    @Test
    public void testToString() {
        StatisticalSummaryValues u = new StatisticalSummaryValues(4.5, 16.0, 10L, 5.0, 4.0, 45.0);
        Locale d = Locale.getDefault();
        Locale.setDefault(Locale.US);
        Assert.assertEquals((Object)"StatisticalSummaryValues:\nn: 10\nmin: 4.0\nmax: 5.0\nmean: 4.5\nstd dev: 4.0\nvariance: 16.0\nsum: 45.0\n", (Object)u.toString());
        Locale.setDefault(d);
    }
}

