/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.regression;

import org.hipparchus.UnitTestUtils;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.DefaultRealMatrixChangingVisitor;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealMatrixChangingVisitor;
import org.hipparchus.linear.RealVector;
import org.hipparchus.stat.StatUtils;
import org.hipparchus.stat.regression.MultipleLinearRegressionAbstractTest;
import org.hipparchus.stat.regression.OLSMultipleLinearRegression;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OLSMultipleLinearRegressionTest
extends MultipleLinearRegressionAbstractTest {
    private double[] y;
    private double[][] x;

    @Override
    @Before
    public void setUp() {
        this.y = new double[]{11.0, 12.0, 13.0, 14.0, 15.0, 16.0};
        this.x = new double[6][];
        this.x[0] = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        this.x[1] = new double[]{2.0, 0.0, 0.0, 0.0, 0.0};
        this.x[2] = new double[]{0.0, 3.0, 0.0, 0.0, 0.0};
        this.x[3] = new double[]{0.0, 0.0, 4.0, 0.0, 0.0};
        this.x[4] = new double[]{0.0, 0.0, 0.0, 5.0, 0.0};
        this.x[5] = new double[]{0.0, 0.0, 0.0, 0.0, 6.0};
        super.setUp();
    }

    protected OLSMultipleLinearRegression createRegression() {
        OLSMultipleLinearRegression regression = new OLSMultipleLinearRegression();
        regression.newSampleData(this.y, this.x);
        return regression;
    }

    @Override
    protected int getNumberOfRegressors() {
        return this.x[0].length + 1;
    }

    @Override
    protected int getSampleSize() {
        return this.y.length;
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void cannotAddSampleDataWithSizeMismatch() {
        double[] y = new double[]{1.0, 2.0};
        double[][] x = new double[][]{{1.0, 0.0}};
        this.createRegression().newSampleData(y, (double[][])x);
    }

    @Test
    public void testPerfectFit() {
        double[] betaHat = this.regression.estimateRegressionParameters();
        UnitTestUtils.assertEquals((double[])betaHat, (double[])new double[]{11.0, 0.5, 0.6666666666666666, 0.75, 0.8, 0.8333333333333334}, (double)1.0E-14);
        double[] residuals = this.regression.estimateResiduals();
        UnitTestUtils.assertEquals((double[])residuals, (double[])new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, (double)1.0E-14);
        Array2DRowRealMatrix errors = new Array2DRowRealMatrix(this.regression.estimateRegressionParametersVariance(), false);
        final double[] s = new double[]{1.0, -0.5, -0.3333333333333333, -0.25, -0.2, -0.16666666666666666};
        Array2DRowRealMatrix referenceVariance = new Array2DRowRealMatrix(s.length, s.length);
        referenceVariance.walkInOptimizedOrder((RealMatrixChangingVisitor)new DefaultRealMatrixChangingVisitor(){

            public double visit(int row, int column, double value) {
                if (row == 0) {
                    return s[column];
                }
                double x = s[row] * s[column];
                return row == column ? 2.0 * x : x;
            }
        });
        Assert.assertEquals((double)0.0, (double)errors.subtract((RealMatrix)referenceVariance).getNorm(), (double)(5.0E-16 * referenceVariance.getNorm()));
        Assert.assertEquals((double)1.0, (double)((OLSMultipleLinearRegression)this.regression).calculateRSquared(), (double)1.0E-12);
    }

    @Test
    public void testLongly() {
        double[] design = new double[]{60323.0, 83.0, 234289.0, 2356.0, 1590.0, 107608.0, 1947.0, 61122.0, 88.5, 259426.0, 2325.0, 1456.0, 108632.0, 1948.0, 60171.0, 88.2, 258054.0, 3682.0, 1616.0, 109773.0, 1949.0, 61187.0, 89.5, 284599.0, 3351.0, 1650.0, 110929.0, 1950.0, 63221.0, 96.2, 328975.0, 2099.0, 3099.0, 112075.0, 1951.0, 63639.0, 98.1, 346999.0, 1932.0, 3594.0, 113270.0, 1952.0, 64989.0, 99.0, 365385.0, 1870.0, 3547.0, 115094.0, 1953.0, 63761.0, 100.0, 363112.0, 3578.0, 3350.0, 116219.0, 1954.0, 66019.0, 101.2, 397469.0, 2904.0, 3048.0, 117388.0, 1955.0, 67857.0, 104.6, 419180.0, 2822.0, 2857.0, 118734.0, 1956.0, 68169.0, 108.4, 442769.0, 2936.0, 2798.0, 120445.0, 1957.0, 66513.0, 110.8, 444546.0, 4681.0, 2637.0, 121950.0, 1958.0, 68655.0, 112.6, 482704.0, 3813.0, 2552.0, 123366.0, 1959.0, 69564.0, 114.2, 502601.0, 3931.0, 2514.0, 125368.0, 1960.0, 69331.0, 115.7, 518173.0, 4806.0, 2572.0, 127852.0, 1961.0, 70551.0, 116.9, 554894.0, 4007.0, 2827.0, 130081.0, 1962.0};
        int nobs = 16;
        int nvars = 6;
        OLSMultipleLinearRegression model = new OLSMultipleLinearRegression();
        model.newSampleData(design, 16, 6);
        double[] betaHat = model.estimateRegressionParameters();
        UnitTestUtils.assertEquals((double[])betaHat, (double[])new double[]{-3482258.63459582, 15.0618722713733, -0.035819179292591, -2.02022980381683, -1.03322686717359, -0.0511041056535807, 1829.15146461355}, (double)2.0E-8);
        double[] residuals = model.estimateResiduals();
        UnitTestUtils.assertEquals((double[])residuals, (double[])new double[]{267.340029759711, -94.0139423988359, 46.28716775752924, -410.114621930906, 309.7145907602313, -249.3112153297231, -164.0489563956039, -13.18035686637081, 14.30477260005235, 455.394094551857, -17.26892711483297, -39.0550425226967, -155.5499735953195, -85.6713080421283, 341.9315139607727, -206.7578251937366}, (double)1.0E-8);
        double[] errors = model.estimateRegressionParametersStandardErrors();
        UnitTestUtils.assertEquals((double[])new double[]{890420.383607373, 84.9149257747669, 0.0334910077722432, 0.488399681651699, 0.214274163161675, 0.22607320006937, 455.478499142212}, (double[])errors, (double)1.0E-6);
        Assert.assertEquals((double)304.8540735619638, (double)model.estimateRegressionStandardError(), (double)1.0E-10);
        Assert.assertEquals((double)0.995479004577296, (double)model.calculateRSquared(), (double)1.0E-12);
        Assert.assertEquals((double)0.992465007628826, (double)model.calculateAdjustedRSquared(), (double)1.0E-12);
        this.checkVarianceConsistency(model);
        model.setNoIntercept(true);
        model.newSampleData(design, 16, 6);
        betaHat = model.estimateRegressionParameters();
        UnitTestUtils.assertEquals((double[])betaHat, (double[])new double[]{-52.99357013868291, 0.07107319907358, -0.42346585566399, -0.57256866841929, -0.41420358884978, 48.41786562001326}, (double)1.0E-11);
        errors = model.estimateRegressionParametersStandardErrors();
        UnitTestUtils.assertEquals((double[])new double[]{129.54486693117232, 0.03016640003786, 0.41773654056612, 0.27899087467676, 0.32128496193363, 17.68948737819961}, (double[])errors, (double)1.0E-11);
        residuals = model.estimateResiduals();
        UnitTestUtils.assertEquals((double[])residuals, (double[])new double[]{279.9027492729309, -130.32465380836874, 90.73228661967445, -401.3125220163495, -440.46768772620027, -543.5451285377479, 201.321116395363, 215.90889365977932, 73.09368242049943, 913.2169449448187, 424.82484953610174, -8.56475876776709, -361.32974610842876, 27.34560497213464, 151.28955976355002, -492.49937355336846}, (double)1.0E-10);
        Assert.assertEquals((double)475.1655079819517, (double)model.estimateRegressionStandardError(), (double)1.0E-10);
        Assert.assertEquals((double)0.9999670130706, (double)model.calculateRSquared(), (double)1.0E-12);
        Assert.assertEquals((double)0.999947220913, (double)model.calculateAdjustedRSquared(), (double)1.0E-12);
    }

    @Test
    public void testSwissFertility() {
        double[] design = new double[]{80.2, 17.0, 15.0, 12.0, 9.96, 83.1, 45.1, 6.0, 9.0, 84.84, 92.5, 39.7, 5.0, 5.0, 93.4, 85.8, 36.5, 12.0, 7.0, 33.77, 76.9, 43.5, 17.0, 15.0, 5.16, 76.1, 35.3, 9.0, 7.0, 90.57, 83.8, 70.2, 16.0, 7.0, 92.85, 92.4, 67.8, 14.0, 8.0, 97.16, 82.4, 53.3, 12.0, 7.0, 97.67, 82.9, 45.2, 16.0, 13.0, 91.38, 87.1, 64.5, 14.0, 6.0, 98.61, 64.1, 62.0, 21.0, 12.0, 8.52, 66.9, 67.5, 14.0, 7.0, 2.27, 68.9, 60.7, 19.0, 12.0, 4.43, 61.7, 69.3, 22.0, 5.0, 2.82, 68.3, 72.6, 18.0, 2.0, 24.2, 71.7, 34.0, 17.0, 8.0, 3.3, 55.7, 19.4, 26.0, 28.0, 12.11, 54.3, 15.2, 31.0, 20.0, 2.15, 65.1, 73.0, 19.0, 9.0, 2.84, 65.5, 59.8, 22.0, 10.0, 5.23, 65.0, 55.1, 14.0, 3.0, 4.52, 56.6, 50.9, 22.0, 12.0, 15.14, 57.4, 54.1, 20.0, 6.0, 4.2, 72.5, 71.2, 12.0, 1.0, 2.4, 74.2, 58.1, 14.0, 8.0, 5.23, 72.0, 63.5, 6.0, 3.0, 2.56, 60.5, 60.8, 16.0, 10.0, 7.72, 58.3, 26.8, 25.0, 19.0, 18.46, 65.4, 49.5, 15.0, 8.0, 6.1, 75.5, 85.9, 3.0, 2.0, 99.71, 69.3, 84.9, 7.0, 6.0, 99.68, 77.3, 89.7, 5.0, 2.0, 100.0, 70.5, 78.2, 12.0, 6.0, 98.96, 79.4, 64.9, 7.0, 3.0, 98.22, 65.0, 75.9, 9.0, 9.0, 99.06, 92.2, 84.6, 3.0, 3.0, 99.46, 79.3, 63.1, 13.0, 13.0, 96.83, 70.4, 38.4, 26.0, 12.0, 5.62, 65.7, 7.7, 29.0, 11.0, 13.79, 72.7, 16.7, 22.0, 13.0, 11.22, 64.4, 17.6, 35.0, 32.0, 16.92, 77.6, 37.6, 15.0, 7.0, 4.97, 67.6, 18.7, 25.0, 7.0, 8.65, 35.0, 1.2, 37.0, 53.0, 42.34, 44.7, 46.6, 16.0, 29.0, 50.43, 42.8, 27.7, 22.0, 29.0, 58.33};
        int nobs = 47;
        int nvars = 4;
        OLSMultipleLinearRegression model = new OLSMultipleLinearRegression();
        model.newSampleData(design, 47, 4);
        double[] betaHat = model.estimateRegressionParameters();
        UnitTestUtils.assertEquals((double[])betaHat, (double[])new double[]{91.05542390271397, -0.22064551045715, -0.26058239824328, -0.9616123845603, 0.12441843147162}, (double)1.0E-12);
        double[] residuals = model.estimateResiduals();
        UnitTestUtils.assertEquals((double[])residuals, (double[])new double[]{7.104426785973051, 1.6580347433531366, 4.694495277002964, 8.454802269016616, 13.654743234318621, -9.358686445850077, 7.5822446330520386, 15.556899556385929, 0.811309073659898, 7.118676273248431, 7.425137877122872, 2.676131687323411, 0.8351584810309354, 7.176999111961518, -3.8746753206299553, -3.133777947638725, -0.1412575244091504, 1.118680917046978, -6.358809734681659, 3.4039270429434074, 2.3374058329820175, -7.92723685769005, -7.836101096849796, -11.259736926935707, 0.9445333697827101, 6.654424510138033, -0.9146136301118665, -4.315244940384857, -4.353693204700918, -3.890788516930466, -6.302764392630219, -7.830898218928909, -3.179228001533275, -6.716729877115823, -4.846994671804175, -10.633566435363369, 11.103113436203696, 6.008403264181173, 5.432623083018848, -7.237557862969223, 2.167155081444822, 15.014757465276311, 4.8625103516321015, -7.159725641390771, -0.4515205619767598, -10.291687090383759, -15.781298457190006}, (double)1.0E-12);
        double[] errors = model.estimateRegressionParametersStandardErrors();
        UnitTestUtils.assertEquals((double[])new double[]{6.94881329475087, 0.0736000897234, 0.27410957467466, 0.19454551679325, 0.03726654773803}, (double[])errors, (double)1.0E-10);
        Assert.assertEquals((double)7.73642194433223, (double)model.estimateRegressionStandardError(), (double)1.0E-12);
        Assert.assertEquals((double)0.649789742860228, (double)model.calculateRSquared(), (double)1.0E-12);
        Assert.assertEquals((double)0.6164363850373927, (double)model.calculateAdjustedRSquared(), (double)1.0E-12);
        this.checkVarianceConsistency(model);
        model = new OLSMultipleLinearRegression();
        model.setNoIntercept(true);
        model.newSampleData(design, 47, 4);
        betaHat = model.estimateRegressionParameters();
        UnitTestUtils.assertEquals((double[])betaHat, (double[])new double[]{0.52191832900513, 2.36588087917963, -0.94770353802795, 0.30851985863609}, (double)1.0E-12);
        residuals = model.estimateResiduals();
        UnitTestUtils.assertEquals((double[])residuals, (double[])new double[]{44.13875988353825, 27.720705122356215, 35.8732008361268, 34.57461958121198, 26.600168342080213, 15.074636243026923, -12.704904871199814, 1.497443824078134, 2.691972687079431, 5.582798774291231, -4.422986561283165, -9.198581600334345, 4.481765170730647, 2.273520207553216, -22.649827853221336, -17.74790001394331, 20.298314638496436, 6.861405135329779, -8.684712790954924, -10.298639278062371, -9.896618896845819, 4.568568616351242, -15.313570491727944, -13.762961360873966, 7.156100301980509, 16.72228221984399, 26.716200609071898, -1.991466398777079, -2.523342564719335, 9.776486693095093, -5.297535127628603, -16.639070567471094, -10.302057295211819, -23.549487860816846, 1.506624392156384, -17.93917443834593, 13.10579220276504, -1.943329906928462, -1.516005841666695, -0.759066561832886, 20.793137744128977, -2.485236153005426, 27.588238710486976, 2.658333257106881, -15.998337823623046, -5.550742066720694, -14.219077806826615}, (double)1.0E-12);
        errors = model.estimateRegressionParametersStandardErrors();
        UnitTestUtils.assertEquals((double[])new double[]{0.10470063765677, 0.4168410058429, 0.43370143099691, 0.07694953606522}, (double[])errors, (double)1.0E-10);
        Assert.assertEquals((double)17.24710630547, (double)model.estimateRegressionStandardError(), (double)1.0E-10);
        Assert.assertEquals((double)0.946350722085, (double)model.calculateRSquared(), (double)1.0E-12);
        Assert.assertEquals((double)0.9413600915813, (double)model.calculateAdjustedRSquared(), (double)1.0E-12);
    }

    @Test
    public void testHat() {
        double[] design = new double[]{11.14, 0.499, 11.1, 12.74, 0.558, 8.9, 13.13, 0.604, 8.8, 11.51, 0.441, 8.9, 12.38, 0.55, 8.8, 12.6, 0.528, 9.9, 11.13, 0.418, 10.7, 11.7, 0.48, 10.5, 11.02, 0.406, 10.5, 11.41, 0.467, 10.7};
        int nobs = 10;
        int nvars = 2;
        OLSMultipleLinearRegression model = new OLSMultipleLinearRegression();
        model.newSampleData(design, nobs, nvars);
        RealMatrix hat = model.calculateHat();
        double[] referenceData = new double[]{0.418, -0.002, 0.079, -0.274, -0.046, 0.181, 0.128, 0.222, 0.05, 0.242, 0.242, 0.292, 0.136, 0.243, 0.128, -0.041, 0.033, -0.035, 0.004, 0.417, -0.019, 0.273, 0.187, -0.126, 0.044, -0.153, 0.004, 0.604, 0.197, -0.038, 0.168, -0.022, 0.275, -0.028, 0.252, 0.111, -0.03, 0.019, -0.01, -0.01, 0.148, 0.042, 0.117, 0.012, 0.111, 0.262, 0.145, 0.277, 0.174, 0.154, 0.12, 0.168, 0.315, 0.148, 0.187};
        int k = 0;
        for (int i = 0; i < 10; ++i) {
            for (int j = i; j < 10; ++j) {
                Assert.assertEquals((double)referenceData[k], (double)hat.getEntry(i, j), (double)0.01);
                Assert.assertEquals((double)hat.getEntry(i, j), (double)hat.getEntry(j, i), (double)1.0E-11);
                ++k;
            }
        }
        double[] residuals = model.estimateResiduals();
        RealMatrix I = MatrixUtils.createRealIdentityMatrix((int)10);
        double[] hatResiduals = I.subtract(hat).operate(model.getY()).toArray();
        UnitTestUtils.assertEquals((double[])residuals, (double[])hatResiduals, (double)1.0E-11);
    }

    @Test
    public void testYVariance() {
        OLSMultipleLinearRegression model = new OLSMultipleLinearRegression();
        model.newSampleData(this.y, this.x);
        UnitTestUtils.assertEquals((double)model.calculateYVariance(), (double)3.5, (double)0.0);
    }

    protected void checkVarianceConsistency(OLSMultipleLinearRegression model) {
        UnitTestUtils.assertEquals((double)StatUtils.variance((double[])model.getY().toArray()), (double)model.calculateYVariance(), (double)0.0);
        double[] residuals = model.calculateResiduals().toArray();
        RealMatrix X = model.getX();
        UnitTestUtils.assertEquals((double)(StatUtils.variance((double[])model.calculateResiduals().toArray()) * (double)(residuals.length - 1)), (double)(model.calculateErrorVariance() * (double)(X.getRowDimension() - X.getColumnDimension())), (double)1.0E-20);
    }

    @Test
    public void testNewSample2() {
        double[] y = new double[]{1.0, 2.0, 3.0, 4.0};
        double[][] x = new double[][]{{19.0, 22.0, 33.0}, {20.0, 30.0, 40.0}, {25.0, 35.0, 45.0}, {27.0, 37.0, 47.0}};
        OLSMultipleLinearRegression regression = new OLSMultipleLinearRegression();
        regression.newSampleData(y, (double[][])x);
        RealMatrix combinedX = regression.getX().copy();
        RealVector combinedY = regression.getY().copy();
        regression.newXSampleData((double[][])x);
        regression.newYSampleData(y);
        Assert.assertEquals((Object)combinedX, (Object)regression.getX());
        Assert.assertEquals((Object)combinedY, (Object)regression.getY());
        regression.setNoIntercept(true);
        regression.newSampleData(y, (double[][])x);
        combinedX = regression.getX().copy();
        combinedY = regression.getY().copy();
        regression.newXSampleData((double[][])x);
        regression.newYSampleData(y);
        Assert.assertEquals((Object)combinedX, (Object)regression.getX());
        Assert.assertEquals((Object)combinedY, (Object)regression.getY());
    }

    @Test(expected=NullArgumentException.class)
    public void testNewSampleDataYNull() {
        this.createRegression().newSampleData(null, (double[][])new double[0][]);
    }

    @Test(expected=NullArgumentException.class)
    public void testNewSampleDataXNull() {
        this.createRegression().newSampleData(new double[0], null);
    }

    @Test
    public void testWampler1() {
        double[] data = new double[]{1.0, 0.0, 6.0, 1.0, 63.0, 2.0, 364.0, 3.0, 1365.0, 4.0, 3906.0, 5.0, 9331.0, 6.0, 19608.0, 7.0, 37449.0, 8.0, 66430.0, 9.0, 111111.0, 10.0, 177156.0, 11.0, 271453.0, 12.0, 402234.0, 13.0, 579195.0, 14.0, 813616.0, 15.0, 1118481.0, 16.0, 1508598.0, 17.0, 2000719.0, 18.0, 2613660.0, 19.0, 3368421.0, 20.0};
        OLSMultipleLinearRegression model = new OLSMultipleLinearRegression();
        int nvars = 5;
        int nobs = 21;
        double[] tmp = new double[126];
        int off = 0;
        int off2 = 0;
        for (int i = 0; i < 21; ++i) {
            tmp[off2] = data[off];
            tmp[off2 + 1] = data[off + 1];
            tmp[off2 + 2] = tmp[off2 + 1] * tmp[off2 + 1];
            tmp[off2 + 3] = tmp[off2 + 1] * tmp[off2 + 2];
            tmp[off2 + 4] = tmp[off2 + 1] * tmp[off2 + 3];
            tmp[off2 + 5] = tmp[off2 + 1] * tmp[off2 + 4];
            off2 += 6;
            off += 2;
        }
        model.newSampleData(tmp, 21, 5);
        double[] betaHat = model.estimateRegressionParameters();
        UnitTestUtils.assertEquals((double[])betaHat, (double[])new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, (double)1.0E-8);
        double[] se = model.estimateRegressionParametersStandardErrors();
        UnitTestUtils.assertEquals((double[])se, (double[])new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, (double)1.0E-8);
        UnitTestUtils.assertEquals((double)1.0, (double)model.calculateRSquared(), (double)1.0E-10);
        UnitTestUtils.assertEquals((double)0.0, (double)model.estimateErrorVariance(), (double)1.0E-7);
        UnitTestUtils.assertEquals((double)0.0, (double)model.calculateResidualSumOfSquares(), (double)1.0E-6);
    }

    @Test
    public void testWampler2() {
        double[] data = new double[]{1.0, 0.0, 1.11111, 1.0, 1.24992, 2.0, 1.42753, 3.0, 1.65984, 4.0, 1.96875, 5.0, 2.38336, 6.0, 2.94117, 7.0, 3.68928, 8.0, 4.68559, 9.0, 6.0, 10.0, 7.71561, 11.0, 9.92992, 12.0, 12.75603, 13.0, 16.32384, 14.0, 20.78125, 15.0, 26.29536, 16.0, 33.05367, 17.0, 41.26528, 18.0, 51.16209, 19.0, 63.0, 20.0};
        OLSMultipleLinearRegression model = new OLSMultipleLinearRegression();
        int nvars = 5;
        int nobs = 21;
        double[] tmp = new double[126];
        int off = 0;
        int off2 = 0;
        for (int i = 0; i < 21; ++i) {
            tmp[off2] = data[off];
            tmp[off2 + 1] = data[off + 1];
            tmp[off2 + 2] = tmp[off2 + 1] * tmp[off2 + 1];
            tmp[off2 + 3] = tmp[off2 + 1] * tmp[off2 + 2];
            tmp[off2 + 4] = tmp[off2 + 1] * tmp[off2 + 3];
            tmp[off2 + 5] = tmp[off2 + 1] * tmp[off2 + 4];
            off2 += 6;
            off += 2;
        }
        model.newSampleData(tmp, 21, 5);
        double[] betaHat = model.estimateRegressionParameters();
        UnitTestUtils.assertEquals((double[])betaHat, (double[])new double[]{1.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5}, (double)1.0E-8);
        double[] se = model.estimateRegressionParametersStandardErrors();
        UnitTestUtils.assertEquals((double[])se, (double[])new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, (double)1.0E-8);
        UnitTestUtils.assertEquals((double)1.0, (double)model.calculateRSquared(), (double)1.0E-10);
        UnitTestUtils.assertEquals((double)0.0, (double)model.estimateErrorVariance(), (double)1.0E-7);
        UnitTestUtils.assertEquals((double)0.0, (double)model.calculateResidualSumOfSquares(), (double)1.0E-6);
    }

    @Test
    public void testWampler3() {
        double[] data = new double[]{760.0, 0.0, -2042.0, 1.0, 2111.0, 2.0, -1684.0, 3.0, 3888.0, 4.0, 1858.0, 5.0, 11379.0, 6.0, 17560.0, 7.0, 39287.0, 8.0, 64382.0, 9.0, 113159.0, 10.0, 175108.0, 11.0, 273291.0, 12.0, 400186.0, 13.0, 581243.0, 14.0, 811568.0, 15.0, 1121004.0, 16.0, 1506550.0, 17.0, 2002767.0, 18.0, 2611612.0, 19.0, 3369180.0, 20.0};
        OLSMultipleLinearRegression model = new OLSMultipleLinearRegression();
        int nvars = 5;
        int nobs = 21;
        double[] tmp = new double[126];
        int off = 0;
        int off2 = 0;
        for (int i = 0; i < 21; ++i) {
            tmp[off2] = data[off];
            tmp[off2 + 1] = data[off + 1];
            tmp[off2 + 2] = tmp[off2 + 1] * tmp[off2 + 1];
            tmp[off2 + 3] = tmp[off2 + 1] * tmp[off2 + 2];
            tmp[off2 + 4] = tmp[off2 + 1] * tmp[off2 + 3];
            tmp[off2 + 5] = tmp[off2 + 1] * tmp[off2 + 4];
            off2 += 6;
            off += 2;
        }
        model.newSampleData(tmp, 21, 5);
        double[] betaHat = model.estimateRegressionParameters();
        UnitTestUtils.assertEquals((double[])betaHat, (double[])new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, (double)1.0E-8);
        double[] se = model.estimateRegressionParametersStandardErrors();
        UnitTestUtils.assertEquals((double[])se, (double[])new double[]{2152.3262467817, 2363.55173469681, 779.343524331583, 101.47550755035, 5.64566512170752, 0.112324854679312}, (double)1.0E-8);
        UnitTestUtils.assertEquals((double)0.99999555902582, (double)model.calculateRSquared(), (double)1.0E-10);
        UnitTestUtils.assertEquals((double)5570284.53333333, (double)model.estimateErrorVariance(), (double)1.0E-6);
        UnitTestUtils.assertEquals((double)8.3554268E7, (double)model.calculateResidualSumOfSquares(), (double)1.0E-5);
    }

    @Test
    public void testWampler4() {
        double[] data = new double[]{75901.0, 0.0, -204794.0, 1.0, 204863.0, 2.0, -204436.0, 3.0, 253665.0, 4.0, -200894.0, 5.0, 214131.0, 6.0, -185192.0, 7.0, 221249.0, 8.0, -138370.0, 9.0, 315911.0, 10.0, -27644.0, 11.0, 455253.0, 12.0, 197434.0, 13.0, 783995.0, 14.0, 608816.0, 15.0, 1370781.0, 16.0, 1303798.0, 17.0, 2205519.0, 18.0, 2408860.0, 19.0, 3444321.0, 20.0};
        OLSMultipleLinearRegression model = new OLSMultipleLinearRegression();
        int nvars = 5;
        int nobs = 21;
        double[] tmp = new double[126];
        int off = 0;
        int off2 = 0;
        for (int i = 0; i < 21; ++i) {
            tmp[off2] = data[off];
            tmp[off2 + 1] = data[off + 1];
            tmp[off2 + 2] = tmp[off2 + 1] * tmp[off2 + 1];
            tmp[off2 + 3] = tmp[off2 + 1] * tmp[off2 + 2];
            tmp[off2 + 4] = tmp[off2 + 1] * tmp[off2 + 3];
            tmp[off2 + 5] = tmp[off2 + 1] * tmp[off2 + 4];
            off2 += 6;
            off += 2;
        }
        model.newSampleData(tmp, 21, 5);
        double[] betaHat = model.estimateRegressionParameters();
        UnitTestUtils.assertEquals((double[])betaHat, (double[])new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, (double)1.0E-6);
        double[] se = model.estimateRegressionParametersStandardErrors();
        UnitTestUtils.assertEquals((double[])se, (double[])new double[]{215232.62467817, 236355.173469681, 77934.3524331583, 10147.550755035, 564.566512170752, 11.2324854679312}, (double)1.0E-8);
        UnitTestUtils.assertEquals((double)0.957478440825662, (double)model.calculateRSquared(), (double)1.0E-10);
        UnitTestUtils.assertEquals((double)5.57028453333333E10, (double)model.estimateErrorVariance(), (double)1.0E-4);
        UnitTestUtils.assertEquals((double)8.3554268E11, (double)model.calculateResidualSumOfSquares(), (double)0.001);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testSingularCalculateBeta() {
        OLSMultipleLinearRegression model = new OLSMultipleLinearRegression();
        model.newSampleData(new double[]{1.0, 2.0, 3.0, 1.0, 2.0, 3.0, 1.0, 2.0, 3.0}, 3, 2);
        model.calculateBeta();
    }

    @Test
    public void testNoSSTOCalculateRsquare() {
        OLSMultipleLinearRegression model = new OLSMultipleLinearRegression();
        model.newSampleData(new double[]{1.0, 2.0, 3.0, 1.0, 7.0, 8.0, 1.0, 10.0, 12.0}, 3, 2);
        Assert.assertTrue((boolean)Double.isNaN(model.calculateRSquared()));
    }

    @Test(expected=NullPointerException.class)
    public void testNoDataNPECalculateBeta() {
        OLSMultipleLinearRegression model = new OLSMultipleLinearRegression();
        model.calculateBeta();
    }

    @Test(expected=NullPointerException.class)
    public void testNoDataNPECalculateHat() {
        OLSMultipleLinearRegression model = new OLSMultipleLinearRegression();
        model.calculateHat();
    }

    @Test(expected=NullPointerException.class)
    public void testNoDataNPESSTO() {
        OLSMultipleLinearRegression model = new OLSMultipleLinearRegression();
        model.calculateTotalSumOfSquares();
    }

    @Test
    public void testNewSampleDataNoIntercept() {
        double[][] x = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        double[] y = new double[]{1.0, 2.0, 3.0, 4.0};
        OLSMultipleLinearRegression regression = new OLSMultipleLinearRegression();
        regression.setNoIntercept(true);
        regression.newSampleData(y, (double[][])x);
        double[] b = regression.estimateRegressionParameters();
        for (int i = 0; i < y.length; ++i) {
            Assert.assertEquals((double)b[i], (double)y[i], (double)0.001);
        }
    }
}

