/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.moment;

import org.hipparchus.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.moment.Mean;
import org.junit.Assert;
import org.junit.Test;

public class MeanTest
extends StorelessUnivariateStatisticAbstractTest {
    public Mean getUnivariateStatistic() {
        return new Mean();
    }

    @Override
    public double expectedValue() {
        return this.mean;
    }

    public double expectedWeightedValue() {
        return this.weightedMean;
    }

    @Test
    public void testSmallSamples() {
        Mean mean = this.getUnivariateStatistic();
        Assert.assertTrue((boolean)Double.isNaN(mean.getResult()));
        mean.increment(1.0);
        Assert.assertEquals((double)1.0, (double)mean.getResult(), (double)0.0);
    }

    @Test
    public void testWeightedMean() {
        Mean mean = this.getUnivariateStatistic();
        Assert.assertEquals((double)this.expectedWeightedValue(), (double)mean.evaluate(this.testArray, this.testWeightsArray, 0, this.testArray.length), (double)this.getTolerance());
        Assert.assertEquals((double)this.expectedValue(), (double)mean.evaluate(this.testArray, this.identicalWeightsArray, 0, this.testArray.length), (double)this.getTolerance());
    }
}

