/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.stat.Frequency;
import org.junit.Assert;
import org.junit.Test;

public final class FrequencyTest {
    private static final long ONE_LONG = 1L;
    private static final long TWO_LONG = 2L;
    private static final long THREE_LONG = 3L;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final char CHAR_A = 'a';
    private static final double TOLERANCE = 1.0E-14;

    @Test
    public void testCounts() {
        Frequency f = new Frequency();
        Assert.assertEquals((String)"total count", (long)0L, (long)f.getSumFreq());
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(1L));
        Assert.assertEquals((String)"one frequency count", (long)3L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((String)"two frequency count", (long)1L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        Assert.assertEquals((String)"three frequency count", (long)0L, (long)f.getCount((Comparable)Long.valueOf(3L)));
        Assert.assertEquals((String)"total count", (long)4L, (long)f.getSumFreq());
        Assert.assertEquals((String)"zero cumulative frequency", (long)0L, (long)f.getCumFreq((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((String)"one cumulative frequency", (long)3L, (long)f.getCumFreq((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((String)"two cumulative frequency", (long)4L, (long)f.getCumFreq((Comparable)Long.valueOf(2L)));
        Assert.assertEquals((String)"five cumulative frequency", (long)4L, (long)f.getCumFreq((Comparable)Long.valueOf(5L)));
        f.clear();
        Assert.assertEquals((String)"total count", (long)0L, (long)f.getSumFreq());
    }

    @Test
    public void testCountsString() {
        Frequency f = new Frequency();
        f.addValue((Comparable)((Object)"one"));
        f.addValue((Comparable)((Object)"One"));
        f.addValue((Comparable)((Object)"oNe"));
        f.addValue((Comparable)((Object)"Z"));
        Assert.assertEquals((String)"one cumulative frequency", (long)1L, (long)f.getCount((Comparable)((Object)"one")));
        Assert.assertEquals((String)"Z cumulative pct", (double)0.5, (double)f.getCumPct((Comparable)((Object)"Z")), (double)1.0E-14);
        Assert.assertEquals((String)"z cumulative pct", (double)1.0, (double)f.getCumPct((Comparable)((Object)"z")), (double)1.0E-14);
        Assert.assertEquals((String)"Ot cumulative pct", (double)0.25, (double)f.getCumPct((Comparable)((Object)"Ot")), (double)1.0E-14);
        f.clear();
    }

    @Test
    public void testCountsInteger() {
        Frequency f = new Frequency();
        f.addValue((Comparable)Integer.valueOf(1));
        f.addValue((Comparable)Integer.valueOf(1));
        f.addValue((Comparable)Integer.valueOf(Long.valueOf(1L).intValue()));
        f.addValue((Comparable)Integer.valueOf(2));
        f.addValue((Comparable)Integer.valueOf(-1));
        Assert.assertEquals((String)"1 count", (long)3L, (long)f.getCount((Comparable)Integer.valueOf(1)));
        Assert.assertEquals((String)"1 count", (long)3L, (long)f.getCount((Comparable)Integer.valueOf(1)));
        Assert.assertEquals((String)"0 cum pct", (double)0.2, (double)f.getCumPct((Comparable)Integer.valueOf(0)), (double)1.0E-14);
        Assert.assertEquals((String)"1 pct", (double)0.6, (double)f.getPct((Comparable)Integer.valueOf(1)), (double)1.0E-14);
        Assert.assertEquals((String)"-2 cum pct", (double)0.0, (double)f.getCumPct((Comparable)Integer.valueOf(-2)), (double)1.0E-14);
        Assert.assertEquals((String)"10 cum pct", (double)1.0, (double)f.getCumPct((Comparable)Integer.valueOf(10)), (double)1.0E-14);
    }

    @Test
    public void testCountsComparator() {
        Frequency f = new Frequency(String.CASE_INSENSITIVE_ORDER);
        f.addValue((Comparable)((Object)"one"));
        f.addValue((Comparable)((Object)"One"));
        f.addValue((Comparable)((Object)"oNe"));
        f.addValue((Comparable)((Object)"Z"));
        Assert.assertEquals((String)"one count", (long)3L, (long)f.getCount((Comparable)((Object)"one")));
        Assert.assertEquals((String)"Z cumulative pct -- case insensitive", (double)1.0, (double)f.getCumPct((Comparable)((Object)"Z")), (double)1.0E-14);
        Assert.assertEquals((String)"z cumulative pct -- case insensitive", (double)1.0, (double)f.getCumPct((Comparable)((Object)"z")), (double)1.0E-14);
    }

    @Test
    public void testCountsCharacter() {
        Frequency f = new Frequency();
        Assert.assertEquals((long)0L, (long)f.getCount((Comparable)Character.valueOf('a')));
        Assert.assertEquals((long)0L, (long)f.getCumFreq((Comparable)Character.valueOf('b')));
        UnitTestUtils.assertEquals((double)Double.NaN, (double)f.getPct((Comparable)Character.valueOf('a')), (double)0.0);
        UnitTestUtils.assertEquals((double)Double.NaN, (double)f.getCumPct((Comparable)Character.valueOf('b')), (double)0.0);
        f.addValue((Comparable)Character.valueOf('a'));
        f.addValue((Comparable)Character.valueOf('b'));
        f.addValue((Comparable)Character.valueOf('c'));
        f.addValue((Comparable)Character.valueOf('d'));
        Assert.assertEquals((long)1L, (long)f.getCount((Comparable)Character.valueOf('a')));
        Assert.assertEquals((long)2L, (long)f.getCumFreq((Comparable)Character.valueOf('b')));
        Assert.assertEquals((double)0.25, (double)f.getPct((Comparable)Character.valueOf('a')), (double)0.0);
        Assert.assertEquals((double)0.5, (double)f.getCumPct((Comparable)Character.valueOf('b')), (double)0.0);
        Assert.assertEquals((double)1.0, (double)f.getCumPct((Comparable)Character.valueOf('e')), (double)0.0);
    }

    @Test
    public void testPcts() {
        Frequency f = new Frequency();
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(3L));
        f.addValue((Comparable)Long.valueOf(3L));
        f.addValue((Comparable)Long.valueOf(3L));
        f.addValue((Comparable)Long.valueOf(3L));
        Assert.assertEquals((String)"one pct", (double)0.25, (double)f.getPct((Comparable)Long.valueOf(1L)), (double)1.0E-14);
        Assert.assertEquals((String)"two pct", (double)0.25, (double)f.getPct((Comparable)Long.valueOf(2L)), (double)1.0E-14);
        Assert.assertEquals((String)"three pct", (double)0.5, (double)f.getPct((Comparable)Long.valueOf(3L)), (double)1.0E-14);
        Assert.assertEquals((String)"five pct", (double)0.0, (double)f.getPct((Comparable)Long.valueOf(5L)), (double)1.0E-14);
        Assert.assertEquals((String)"one cum pct", (double)0.25, (double)f.getCumPct((Comparable)Long.valueOf(1L)), (double)1.0E-14);
        Assert.assertEquals((String)"two cum pct", (double)0.5, (double)f.getCumPct((Comparable)Long.valueOf(2L)), (double)1.0E-14);
        Assert.assertEquals((String)"three cum pct", (double)1.0, (double)f.getCumPct((Comparable)Long.valueOf(3L)), (double)1.0E-14);
        Assert.assertEquals((String)"five cum pct", (double)1.0, (double)f.getCumPct((Comparable)Long.valueOf(5L)), (double)1.0E-14);
        Assert.assertEquals((String)"zero cum pct", (double)0.0, (double)f.getCumPct((Comparable)Long.valueOf(0L)), (double)1.0E-14);
    }

    @Test
    public void testEmptyTable() {
        Frequency freq = new Frequency();
        Assert.assertEquals((String)"freq sum, empty table", (long)0L, (long)freq.getSumFreq());
        Assert.assertEquals((String)"count, empty table", (long)0L, (long)freq.getCount((Comparable)Integer.valueOf(0)));
        Assert.assertEquals((String)"count, empty table", (long)0L, (long)freq.getCount((Comparable)Integer.valueOf(0)));
        Assert.assertEquals((String)"cum freq, empty table", (long)0L, (long)freq.getCumFreq((Comparable)Integer.valueOf(0)));
        Assert.assertEquals((String)"cum freq, empty table", (long)0L, (long)freq.getCumFreq((Comparable)Integer.valueOf(2)));
        Assert.assertTrue((String)"pct, empty table", (boolean)Double.isNaN(freq.getPct((Comparable)Integer.valueOf(0))));
        Assert.assertTrue((String)"pct, empty table", (boolean)Double.isNaN(freq.getPct((Comparable)Integer.valueOf(0))));
        Assert.assertTrue((String)"cum pct, empty table", (boolean)Double.isNaN(freq.getCumPct((Comparable)Integer.valueOf(0))));
        Assert.assertTrue((String)"cum pct, empty table", (boolean)Double.isNaN(freq.getCumPct((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void testCumPct() {
        Frequency f = new Frequency();
        f.addValue((Comparable)Integer.valueOf(3));
        f.addValue((Comparable)Integer.valueOf(4));
        f.addValue((Comparable)Integer.valueOf(5));
        f.addValue((Comparable)Integer.valueOf(6));
        Assert.assertEquals((String)"cum freq, single entry", (double)0.25, (double)f.getCumPct((Comparable)Integer.valueOf(3)), (double)1.0E-14);
        Assert.assertEquals((String)"cum freq, single entry", (double)1.0, (double)f.getCumPct((Comparable)Integer.valueOf(6)), (double)1.0E-14);
        Assert.assertEquals((String)"cum freq, single entry", (double)0.0, (double)f.getCumPct((Comparable)Integer.valueOf(1)), (double)1.0E-14);
        Assert.assertEquals((String)"cum freq, single entry", (double)1.0, (double)f.getCumPct((Comparable)Integer.valueOf(10)), (double)1.0E-14);
    }

    @Test
    public void testToString() throws Exception {
        Frequency f = new Frequency();
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        String s = f.toString();
        Assert.assertNotNull((Object)s);
        BufferedReader reader = new BufferedReader(new StringReader(s));
        String line = reader.readLine();
        Assert.assertNotNull((Object)line);
        line = reader.readLine();
        Assert.assertNotNull((Object)line);
        line = reader.readLine();
        Assert.assertNotNull((Object)line);
        line = reader.readLine();
        Assert.assertNull((Object)line);
    }

    @Test
    public void testIntegerValues() {
        Frequency f = new Frequency();
        Integer obj1 = null;
        obj1 = 1;
        Integer int1 = 1;
        f.addValue((Comparable)obj1);
        f.addValue((Comparable)int1);
        f.addValue((Comparable)Integer.valueOf(2));
        f.addValue((Comparable)Integer.valueOf(Long.valueOf(2L).intValue()));
        Assert.assertEquals((String)"Integer 1 count", (long)2L, (long)f.getCount((Comparable)Integer.valueOf(1)));
        Assert.assertEquals((String)"Integer 1 count", (long)2L, (long)f.getCount((Comparable)Integer.valueOf(1)));
        Assert.assertEquals((String)"Integer 1 count", (long)2L, (long)f.getCount((Comparable)Integer.valueOf(Long.valueOf(1L).intValue())));
        Assert.assertEquals((String)"Integer 1 cumPct", (double)0.5, (double)f.getCumPct((Comparable)Integer.valueOf(1)), (double)1.0E-14);
        Assert.assertEquals((String)"Integer 1 cumPct", (double)0.5, (double)f.getCumPct((Comparable)Integer.valueOf(Long.valueOf(1L).intValue())), (double)1.0E-14);
        Assert.assertEquals((String)"Integer 1 cumPct", (double)0.5, (double)f.getCumPct((Comparable)Integer.valueOf(1)), (double)1.0E-14);
        f.incrementValue((Comparable)Integer.valueOf(1), -2L);
        f.incrementValue((Comparable)Integer.valueOf(3), 5L);
        Assert.assertEquals((String)"Integer 1 count", (long)0L, (long)f.getCount((Comparable)Integer.valueOf(1)));
        Assert.assertEquals((String)"Integer 3 count", (long)5L, (long)f.getCount((Comparable)Integer.valueOf(3)));
        Iterator it = f.valuesIterator();
        while (it.hasNext()) {
            Assert.assertTrue((boolean)(it.next() instanceof Integer));
        }
    }

    @Test
    public void testSerial() {
        Frequency f = new Frequency();
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        Assert.assertEquals((Object)f, (Object)UnitTestUtils.serializeAndRecover((Object)f));
    }

    @Test
    public void testGetUniqueCount() {
        Frequency f = new Frequency();
        Assert.assertEquals((long)0L, (long)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(1L));
        Assert.assertEquals((long)1L, (long)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(1L));
        Assert.assertEquals((long)1L, (long)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(2L));
        Assert.assertEquals((long)2L, (long)f.getUniqueCount());
    }

    @Test
    public void testIncrement() {
        Frequency f = new Frequency();
        Assert.assertEquals((long)0L, (long)f.getUniqueCount());
        f.incrementValue((Comparable)Long.valueOf(1L), 1L);
        Assert.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        f.incrementValue((Comparable)Long.valueOf(1L), 4L);
        Assert.assertEquals((long)5L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        f.incrementValue((Comparable)Long.valueOf(1L), -5L);
        Assert.assertEquals((long)0L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Frequency f2 = new Frequency();
        f2.incrementValue((Comparable)Character.valueOf('a'), 2L);
        Assert.assertEquals((long)2L, (long)f2.getCount((Comparable)Character.valueOf('a')));
        f2.incrementValue((Comparable)Character.valueOf('a'), 3L);
        Assert.assertEquals((long)5L, (long)f2.getCount((Comparable)Character.valueOf('a')));
    }

    @Test
    public void testMerge() {
        Frequency f = new Frequency();
        Assert.assertEquals((long)0L, (long)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        f.addValue((Comparable)Long.valueOf(1L));
        f.addValue((Comparable)Long.valueOf(2L));
        Assert.assertEquals((long)2L, (long)f.getUniqueCount());
        Assert.assertEquals((long)2L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((long)2L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        Frequency g = new Frequency();
        g.addValue((Comparable)Long.valueOf(1L));
        g.addValue((Comparable)Long.valueOf(3L));
        g.addValue((Comparable)Long.valueOf(3L));
        Assert.assertEquals((long)2L, (long)g.getUniqueCount());
        Assert.assertEquals((long)1L, (long)g.getCount((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((long)2L, (long)g.getCount((Comparable)Long.valueOf(3L)));
        f.merge(g);
        Assert.assertEquals((long)3L, (long)f.getUniqueCount());
        Assert.assertEquals((long)3L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((long)2L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        Assert.assertEquals((long)2L, (long)f.getCount((Comparable)Long.valueOf(3L)));
    }

    @Test
    public void testMergeCollection() {
        Frequency f = new Frequency();
        Assert.assertEquals((long)0L, (long)f.getUniqueCount());
        f.addValue((Comparable)Long.valueOf(1L));
        Assert.assertEquals((long)1L, (long)f.getUniqueCount());
        Assert.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((long)0L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        Frequency g = new Frequency();
        g.addValue((Comparable)Long.valueOf(2L));
        Frequency h = new Frequency();
        h.addValue((Comparable)Long.valueOf(3L));
        ArrayList<Frequency> coll = new ArrayList<Frequency>();
        coll.add(g);
        coll.add(h);
        f.merge(coll);
        Assert.assertEquals((long)3L, (long)f.getUniqueCount());
        Assert.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(2L)));
        Assert.assertEquals((long)1L, (long)f.getCount((Comparable)Long.valueOf(3L)));
    }

    @Test
    public void testMode() {
        Frequency f = new Frequency();
        List mode = f.getMode();
        Assert.assertEquals((long)0L, (long)mode.size());
        f.addValue((Comparable)((Object)"3"));
        mode = f.getMode();
        Assert.assertEquals((long)1L, (long)mode.size());
        Assert.assertEquals((Object)"3", mode.get(0));
        f.addValue((Comparable)((Object)"2"));
        mode = f.getMode();
        Assert.assertEquals((long)2L, (long)mode.size());
        Assert.assertEquals((Object)"2", mode.get(0));
        Assert.assertEquals((Object)"3", mode.get(1));
        f.addValue((Comparable)((Object)"2"));
        mode = f.getMode();
        Assert.assertEquals((long)1L, (long)mode.size());
        Assert.assertEquals((Object)"2", mode.get(0));
        Assert.assertFalse((boolean)mode.contains("1"));
        Assert.assertTrue((boolean)mode.contains("2"));
    }

    @Test
    public void testModeDoubleNan() {
        Frequency f = new Frequency();
        f.addValue((Comparable)Double.valueOf(Double.NaN));
        f.addValue((Comparable)Double.valueOf(Double.NaN));
        f.addValue((Comparable)Double.valueOf(Double.NaN));
        f.addValue((Comparable)Double.valueOf(Double.NEGATIVE_INFINITY));
        f.addValue((Comparable)Double.valueOf(Double.POSITIVE_INFINITY));
        f.addValue((Comparable)Double.valueOf(Double.NEGATIVE_INFINITY));
        f.addValue((Comparable)Double.valueOf(Double.POSITIVE_INFINITY));
        f.addValue((Comparable)Double.valueOf(Double.NEGATIVE_INFINITY));
        f.addValue((Comparable)Double.valueOf(Double.POSITIVE_INFINITY));
        List mode = f.getMode();
        Assert.assertEquals((long)3L, (long)mode.size());
        Assert.assertEquals((Object)Double.NEGATIVE_INFINITY, mode.get(0));
        Assert.assertEquals((Object)Double.POSITIVE_INFINITY, mode.get(1));
        Assert.assertEquals((Object)Double.NaN, mode.get(2));
    }

    @Test
    public void testModeFloatNan() {
        Frequency f = new Frequency();
        f.addValue((Comparable)Float.valueOf(Float.NaN));
        f.addValue((Comparable)Float.valueOf(Float.NaN));
        f.addValue((Comparable)Float.valueOf(Float.NaN));
        f.addValue((Comparable)Float.valueOf(Float.NEGATIVE_INFINITY));
        f.addValue((Comparable)Float.valueOf(Float.POSITIVE_INFINITY));
        f.addValue((Comparable)Float.valueOf(Float.NEGATIVE_INFINITY));
        f.addValue((Comparable)Float.valueOf(Float.POSITIVE_INFINITY));
        f.addValue((Comparable)Float.valueOf(Float.NEGATIVE_INFINITY));
        f.addValue((Comparable)Float.valueOf(Float.POSITIVE_INFINITY));
        List mode = f.getMode();
        Assert.assertEquals((long)3L, (long)mode.size());
        Assert.assertEquals((Object)Float.valueOf(Float.NEGATIVE_INFINITY), mode.get(0));
        Assert.assertEquals((Object)Float.valueOf(Float.POSITIVE_INFINITY), mode.get(1));
        Assert.assertEquals((Object)Float.valueOf(Float.NaN), mode.get(2));
    }
}

