/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.correlation;

import org.hipparchus.UnitTestUtils;
import org.hipparchus.distribution.continuous.TDistribution;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.BlockRealMatrix;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.stat.correlation.Covariance;
import org.hipparchus.stat.correlation.PearsonsCorrelation;
import org.hipparchus.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class PearsonsCorrelationTest {
    protected final double[] longleyData = new double[]{60323.0, 83.0, 234289.0, 2356.0, 1590.0, 107608.0, 1947.0, 61122.0, 88.5, 259426.0, 2325.0, 1456.0, 108632.0, 1948.0, 60171.0, 88.2, 258054.0, 3682.0, 1616.0, 109773.0, 1949.0, 61187.0, 89.5, 284599.0, 3351.0, 1650.0, 110929.0, 1950.0, 63221.0, 96.2, 328975.0, 2099.0, 3099.0, 112075.0, 1951.0, 63639.0, 98.1, 346999.0, 1932.0, 3594.0, 113270.0, 1952.0, 64989.0, 99.0, 365385.0, 1870.0, 3547.0, 115094.0, 1953.0, 63761.0, 100.0, 363112.0, 3578.0, 3350.0, 116219.0, 1954.0, 66019.0, 101.2, 397469.0, 2904.0, 3048.0, 117388.0, 1955.0, 67857.0, 104.6, 419180.0, 2822.0, 2857.0, 118734.0, 1956.0, 68169.0, 108.4, 442769.0, 2936.0, 2798.0, 120445.0, 1957.0, 66513.0, 110.8, 444546.0, 4681.0, 2637.0, 121950.0, 1958.0, 68655.0, 112.6, 482704.0, 3813.0, 2552.0, 123366.0, 1959.0, 69564.0, 114.2, 502601.0, 3931.0, 2514.0, 125368.0, 1960.0, 69331.0, 115.7, 518173.0, 4806.0, 2572.0, 127852.0, 1961.0, 70551.0, 116.9, 554894.0, 4007.0, 2827.0, 130081.0, 1962.0};
    protected final double[] swissData = new double[]{80.2, 17.0, 15.0, 12.0, 9.96, 83.1, 45.1, 6.0, 9.0, 84.84, 92.5, 39.7, 5.0, 5.0, 93.4, 85.8, 36.5, 12.0, 7.0, 33.77, 76.9, 43.5, 17.0, 15.0, 5.16, 76.1, 35.3, 9.0, 7.0, 90.57, 83.8, 70.2, 16.0, 7.0, 92.85, 92.4, 67.8, 14.0, 8.0, 97.16, 82.4, 53.3, 12.0, 7.0, 97.67, 82.9, 45.2, 16.0, 13.0, 91.38, 87.1, 64.5, 14.0, 6.0, 98.61, 64.1, 62.0, 21.0, 12.0, 8.52, 66.9, 67.5, 14.0, 7.0, 2.27, 68.9, 60.7, 19.0, 12.0, 4.43, 61.7, 69.3, 22.0, 5.0, 2.82, 68.3, 72.6, 18.0, 2.0, 24.2, 71.7, 34.0, 17.0, 8.0, 3.3, 55.7, 19.4, 26.0, 28.0, 12.11, 54.3, 15.2, 31.0, 20.0, 2.15, 65.1, 73.0, 19.0, 9.0, 2.84, 65.5, 59.8, 22.0, 10.0, 5.23, 65.0, 55.1, 14.0, 3.0, 4.52, 56.6, 50.9, 22.0, 12.0, 15.14, 57.4, 54.1, 20.0, 6.0, 4.2, 72.5, 71.2, 12.0, 1.0, 2.4, 74.2, 58.1, 14.0, 8.0, 5.23, 72.0, 63.5, 6.0, 3.0, 2.56, 60.5, 60.8, 16.0, 10.0, 7.72, 58.3, 26.8, 25.0, 19.0, 18.46, 65.4, 49.5, 15.0, 8.0, 6.1, 75.5, 85.9, 3.0, 2.0, 99.71, 69.3, 84.9, 7.0, 6.0, 99.68, 77.3, 89.7, 5.0, 2.0, 100.0, 70.5, 78.2, 12.0, 6.0, 98.96, 79.4, 64.9, 7.0, 3.0, 98.22, 65.0, 75.9, 9.0, 9.0, 99.06, 92.2, 84.6, 3.0, 3.0, 99.46, 79.3, 63.1, 13.0, 13.0, 96.83, 70.4, 38.4, 26.0, 12.0, 5.62, 65.7, 7.7, 29.0, 11.0, 13.79, 72.7, 16.7, 22.0, 13.0, 11.22, 64.4, 17.6, 35.0, 32.0, 16.92, 77.6, 37.6, 15.0, 7.0, 4.97, 67.6, 18.7, 25.0, 7.0, 8.65, 35.0, 1.2, 37.0, 53.0, 42.34, 44.7, 46.6, 16.0, 29.0, 50.43, 42.8, 27.7, 22.0, 29.0, 58.33};

    @Test
    public void testLongly() {
        RealMatrix matrix = this.createRealMatrix(this.longleyData, 16, 7);
        PearsonsCorrelation corrInstance = new PearsonsCorrelation(matrix);
        RealMatrix correlationMatrix = corrInstance.getCorrelationMatrix();
        double[] rData = new double[]{1.0, 0.970898525061056, 0.9835516111796693, 0.5024980838759942, 0.4573073999764817, 0.960390571594376, 0.9713294591921188, 0.970898525061056, 1.0, 0.9915891780247822, 0.6206333925590966, 0.4647441876006747, 0.979163432977498, 0.9911491900672053, 0.983551611179669, 0.9915891780247822, 1.0, 0.604260939889558, 0.4464367918926265, 0.991090069458478, 0.9952734837647849, 0.502498083875994, 0.6206333925590966, 0.604260939889558, 1.0, -0.1774206295018783, 0.686551516365312, 0.6682566045621746, 0.457307399976482, 0.4647441876006747, 0.4464367918926265, -0.1774206295018783, 1.0, 0.364416267189032, 0.4172451498349454, 0.960390571594376, 0.9791634329774981, 0.9910900694584777, 0.686551516365312, 0.364416267189032, 1.0, 0.9939528462329257, 0.971329459192119, 0.9911491900672053, 0.9952734837647849, 0.6682566045621746, 0.4172451498349454, 0.993952846232926, 1.0};
        UnitTestUtils.assertEquals((String)"correlation matrix", (RealMatrix)this.createRealMatrix(rData, 7, 7), (RealMatrix)correlationMatrix, (double)1.0E-14);
        double[] rPvalues = new double[]{4.38904690369668E-10, 8.36353208910623E-12, 7.8159700933611E-14, 0.0472894097790304, 0.01030636128354301, 0.01316878049026582, 0.0749178049642416, 0.06971758330341182, 0.0830166169296545, 0.510948586323452, 3.693245043123738E-9, 4.327782576751815E-11, 1.167954621905665E-13, 0.00331028281967516, 0.1652293725106684, 3.95834476307755E-10, 1.114663916723657E-13, 1.332267629550188E-15, 0.00466039138541463, 0.1078477071581498, 7.771561172376096E-15};
        RealMatrix rPMatrix = this.createLowerTriangularRealMatrix(rPvalues, 7);
        this.fillUpper(rPMatrix, 0.0);
        UnitTestUtils.assertEquals((String)"correlation p values", (RealMatrix)rPMatrix, (RealMatrix)corrInstance.getCorrelationPValues(), (double)1.0E-14);
    }

    @Test
    public void testSwissFertility() {
        RealMatrix matrix = this.createRealMatrix(this.swissData, 47, 5);
        PearsonsCorrelation corrInstance = new PearsonsCorrelation(matrix);
        RealMatrix correlationMatrix = corrInstance.getCorrelationMatrix();
        double[] rData = new double[]{1.0, 0.3530791836199747, -0.6458827064572875, -0.6637888570350691, 0.4636847006517939, 0.3530791836199747, 1.0, -0.6865422086171366, -0.6395225189483201, 0.4010950530487398, -0.6458827064572875, -0.6865422086171366, 1.0, 0.698415296288483, -0.5727418060641666, -0.6637888570350691, -0.6395225189483201, 0.698415296288483, 1.0, -0.1538589170909148, 0.4636847006517939, 0.4010950530487398, -0.5727418060641666, -0.1538589170909148, 1.0};
        UnitTestUtils.assertEquals((String)"correlation matrix", (RealMatrix)this.createRealMatrix(rData, 5, 5), (RealMatrix)correlationMatrix, (double)1.0E-14);
        double[] rPvalues = new double[]{0.01491720061472623, 9.45043734069043E-7, 9.95151527133974E-8, 3.658616965962355E-7, 1.304590105694471E-6, 4.811397236181847E-8, 0.001028523190118147, 0.005204433539191644, 2.588307925380906E-5, 0.301807756132683};
        RealMatrix rPMatrix = this.createLowerTriangularRealMatrix(rPvalues, 5);
        this.fillUpper(rPMatrix, 0.0);
        UnitTestUtils.assertEquals((String)"correlation p values", (RealMatrix)rPMatrix, (RealMatrix)corrInstance.getCorrelationPValues(), (double)1.0E-14);
    }

    @Test
    public void testPValueNearZero() {
        int dimension = 120;
        double[][] data = new double[dimension][2];
        for (int i = 0; i < dimension; ++i) {
            data[i][0] = i;
            data[i][1] = (double)i + 1.0 / ((double)i + 1.0);
        }
        PearsonsCorrelation corrInstance = new PearsonsCorrelation(data);
        Assert.assertTrue((corrInstance.getCorrelationPValues().getEntry(0, 1) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testConstant() {
        double[] noVariance = new double[]{1.0, 1.0, 1.0, 1.0};
        double[] values = new double[]{1.0, 2.0, 3.0, 4.0};
        Assert.assertTrue((boolean)Double.isNaN(new PearsonsCorrelation().correlation(noVariance, values)));
        Assert.assertTrue((boolean)Double.isNaN(new PearsonsCorrelation().correlation(values, noVariance)));
    }

    @Test
    public void testInsufficientData() {
        double[] one = new double[]{1.0};
        double[] two = new double[]{2.0};
        try {
            new PearsonsCorrelation().correlation(one, two);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        BlockRealMatrix matrix = new BlockRealMatrix((double[][])new double[][]{{0.0}, {1.0}});
        try {
            new PearsonsCorrelation((RealMatrix)matrix);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testStdErrorConsistency() {
        TDistribution tDistribution = new TDistribution(45.0);
        RealMatrix matrix = this.createRealMatrix(this.swissData, 47, 5);
        PearsonsCorrelation corrInstance = new PearsonsCorrelation(matrix);
        RealMatrix rValues = corrInstance.getCorrelationMatrix();
        RealMatrix pValues = corrInstance.getCorrelationPValues();
        RealMatrix stdErrors = corrInstance.getCorrelationStandardErrors();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < i; ++j) {
                double t = FastMath.abs((double)rValues.getEntry(i, j)) / stdErrors.getEntry(i, j);
                double p = 2.0 * (1.0 - tDistribution.cumulativeProbability(t));
                Assert.assertEquals((double)p, (double)pValues.getEntry(i, j), (double)1.0E-14);
            }
        }
    }

    @Test
    public void testCovarianceConsistency() {
        RealMatrix matrix = this.createRealMatrix(this.longleyData, 16, 7);
        PearsonsCorrelation corrInstance = new PearsonsCorrelation(matrix);
        Covariance covInstance = new Covariance(matrix);
        PearsonsCorrelation corrFromCovInstance = new PearsonsCorrelation(covInstance);
        UnitTestUtils.assertEquals((String)"correlation values", (RealMatrix)corrInstance.getCorrelationMatrix(), (RealMatrix)corrFromCovInstance.getCorrelationMatrix(), (double)1.0E-14);
        UnitTestUtils.assertEquals((String)"p values", (RealMatrix)corrInstance.getCorrelationPValues(), (RealMatrix)corrFromCovInstance.getCorrelationPValues(), (double)1.0E-14);
        UnitTestUtils.assertEquals((String)"standard errors", (RealMatrix)corrInstance.getCorrelationStandardErrors(), (RealMatrix)corrFromCovInstance.getCorrelationStandardErrors(), (double)1.0E-14);
        PearsonsCorrelation corrFromCovInstance2 = new PearsonsCorrelation(covInstance.getCovarianceMatrix(), 16);
        UnitTestUtils.assertEquals((String)"correlation values", (RealMatrix)corrInstance.getCorrelationMatrix(), (RealMatrix)corrFromCovInstance2.getCorrelationMatrix(), (double)1.0E-14);
        UnitTestUtils.assertEquals((String)"p values", (RealMatrix)corrInstance.getCorrelationPValues(), (RealMatrix)corrFromCovInstance2.getCorrelationPValues(), (double)1.0E-14);
        UnitTestUtils.assertEquals((String)"standard errors", (RealMatrix)corrInstance.getCorrelationStandardErrors(), (RealMatrix)corrFromCovInstance2.getCorrelationStandardErrors(), (double)1.0E-14);
    }

    @Test
    public void testConsistency() {
        RealMatrix matrix = this.createRealMatrix(this.longleyData, 16, 7);
        PearsonsCorrelation corrInstance = new PearsonsCorrelation(matrix);
        double[][] data = matrix.getData();
        double[] x = matrix.getColumn(0);
        double[] y = matrix.getColumn(1);
        Assert.assertEquals((double)new PearsonsCorrelation().correlation(x, y), (double)corrInstance.getCorrelationMatrix().getEntry(0, 1), (double)Double.MIN_VALUE);
        UnitTestUtils.assertEquals((String)"Correlation matrix", (RealMatrix)corrInstance.getCorrelationMatrix(), (RealMatrix)new PearsonsCorrelation().computeCorrelationMatrix(data), (double)Double.MIN_VALUE);
    }

    protected RealMatrix createRealMatrix(double[] data, int nRows, int nCols) {
        double[][] matrixData = new double[nRows][nCols];
        int ptr = 0;
        for (int i = 0; i < nRows; ++i) {
            System.arraycopy(data, ptr, matrixData[i], 0, nCols);
            ptr += nCols;
        }
        return new BlockRealMatrix(matrixData);
    }

    protected RealMatrix createLowerTriangularRealMatrix(double[] data, int dimension) {
        int ptr = 0;
        BlockRealMatrix result = new BlockRealMatrix(dimension, dimension);
        for (int i = 1; i < dimension; ++i) {
            for (int j = 0; j < i; ++j) {
                result.setEntry(i, j, data[ptr]);
                ++ptr;
            }
        }
        return result;
    }

    protected void fillUpper(RealMatrix matrix, double diagonalValue) {
        int dimension = matrix.getColumnDimension();
        for (int i = 0; i < dimension; ++i) {
            matrix.setEntry(i, i, diagonalValue);
            for (int j = i + 1; j < dimension; ++j) {
                matrix.setEntry(i, j, matrix.getEntry(j, i));
            }
        }
    }
}

