/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import java.util.Arrays;
import java.util.Locale;
import java.util.function.DoubleConsumer;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.stat.descriptive.DescriptiveStatistics;
import org.hipparchus.stat.descriptive.StreamingStatistics;
import org.hipparchus.stat.descriptive.moment.GeometricMean;
import org.hipparchus.stat.descriptive.moment.Mean;
import org.hipparchus.stat.descriptive.moment.Variance;
import org.hipparchus.stat.descriptive.rank.Max;
import org.hipparchus.stat.descriptive.rank.Min;
import org.hipparchus.stat.descriptive.summary.Sum;
import org.hipparchus.stat.descriptive.summary.SumOfSquares;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class DescriptiveStatisticsTest {
    private final double[] testArray = new double[]{1.0, 2.0, 2.0, 3.0};
    private final double one = 1.0;
    private final float twoF = 2.0f;
    private final long twoL = 2L;
    private final int three = 3;
    private final double mean = 2.0;
    private final double sumSq = 18.0;
    private final double sum = 8.0;
    private final double var = 0.6666666666666666;
    private final double popVar = 0.5;
    private final double std = FastMath.sqrt((double)0.6666666666666666);
    private final double n = 4.0;
    private final double min = 1.0;
    private final double max = 3.0;
    private final double tolerance = 1.0E-14;

    protected DescriptiveStatistics createDescriptiveStatistics() {
        return new DescriptiveStatistics();
    }

    @Test
    public void testStats() {
        DescriptiveStatistics u = this.createDescriptiveStatistics();
        Assert.assertEquals((String)"total count", (double)0.0, (double)u.getN(), (double)1.0E-14);
        u.addValue(1.0);
        u.addValue(2.0);
        u.addValue(2.0);
        u.addValue(3.0);
        Assert.assertEquals((String)"N", (double)4.0, (double)u.getN(), (double)1.0E-14);
        Assert.assertEquals((String)"sum", (double)8.0, (double)u.getSum(), (double)1.0E-14);
        Assert.assertEquals((String)"sumsq", (double)18.0, (double)u.getSumOfSquares(), (double)1.0E-14);
        Assert.assertEquals((String)"var", (double)0.6666666666666666, (double)u.getVariance(), (double)1.0E-14);
        Assert.assertEquals((String)"population var", (double)0.5, (double)u.getPopulationVariance(), (double)1.0E-14);
        Assert.assertEquals((String)"std", (double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14);
        Assert.assertEquals((String)"mean", (double)2.0, (double)u.getMean(), (double)1.0E-14);
        Assert.assertEquals((String)"min", (double)1.0, (double)u.getMin(), (double)1.0E-14);
        Assert.assertEquals((String)"max", (double)3.0, (double)u.getMax(), (double)1.0E-14);
        u.clear();
        Assert.assertEquals((String)"total count", (double)0.0, (double)u.getN(), (double)1.0E-14);
    }

    @Test
    public void testConsume() {
        DescriptiveStatistics u = this.createDescriptiveStatistics();
        Assert.assertEquals((String)"total count", (double)0.0, (double)u.getN(), (double)1.0E-14);
        Arrays.stream(this.testArray).forEach((DoubleConsumer)u);
        Assert.assertEquals((String)"N", (double)4.0, (double)u.getN(), (double)1.0E-14);
        Assert.assertEquals((String)"sum", (double)8.0, (double)u.getSum(), (double)1.0E-14);
        Assert.assertEquals((String)"sumsq", (double)18.0, (double)u.getSumOfSquares(), (double)1.0E-14);
        Assert.assertEquals((String)"var", (double)0.6666666666666666, (double)u.getVariance(), (double)1.0E-14);
        Assert.assertEquals((String)"population var", (double)0.5, (double)u.getPopulationVariance(), (double)1.0E-14);
        Assert.assertEquals((String)"std", (double)this.std, (double)u.getStandardDeviation(), (double)1.0E-14);
        Assert.assertEquals((String)"mean", (double)2.0, (double)u.getMean(), (double)1.0E-14);
        Assert.assertEquals((String)"min", (double)1.0, (double)u.getMin(), (double)1.0E-14);
        Assert.assertEquals((String)"max", (double)3.0, (double)u.getMax(), (double)1.0E-14);
        u.clear();
        Assert.assertEquals((String)"total count", (double)0.0, (double)u.getN(), (double)1.0E-14);
    }

    @Test
    public void testCopy() {
        DescriptiveStatistics stats = this.createDescriptiveStatistics();
        stats.addValue(1.0);
        stats.addValue(3.0);
        Assert.assertEquals((double)2.0, (double)stats.getMean(), (double)1.0E-10);
        DescriptiveStatistics copy = stats.copy();
        Assert.assertEquals((double)2.0, (double)copy.getMean(), (double)1.0E-10);
    }

    @Test
    public void testWindowSize() {
        DescriptiveStatistics stats = this.createDescriptiveStatistics();
        stats.setWindowSize(300);
        for (int i = 0; i < 100; ++i) {
            stats.addValue((double)(i + 1));
        }
        int refSum = 5050;
        Assert.assertEquals((double)((double)refSum / 100.0), (double)stats.getMean(), (double)1.0E-10);
        Assert.assertEquals((long)300L, (long)stats.getWindowSize());
        try {
            stats.setWindowSize(-3);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)300L, (long)stats.getWindowSize());
        stats.setWindowSize(50);
        Assert.assertEquals((long)50L, (long)stats.getWindowSize());
        int refSum2 = refSum - 1275;
        Assert.assertEquals((double)((double)refSum2 / 50.0), (double)stats.getMean(), (double)1.0E-10);
    }

    @Test
    public void testGetValues() {
        DescriptiveStatistics stats = this.createDescriptiveStatistics();
        for (int i = 100; i > 0; --i) {
            stats.addValue((double)i);
        }
        int refSum = 5050;
        Assert.assertEquals((double)((double)refSum / 100.0), (double)stats.getMean(), (double)1.0E-10);
        double[] v = stats.getValues();
        for (int i = 0; i < v.length; ++i) {
            Assert.assertEquals((double)(100.0 - (double)i), (double)v[i], (double)1.0E-10);
        }
        double[] s = stats.getSortedValues();
        for (int i = 0; i < s.length; ++i) {
            Assert.assertEquals((double)((double)i + 1.0), (double)s[i], (double)1.0E-10);
        }
        Assert.assertEquals((double)12.0, (double)stats.getElement(88), (double)1.0E-10);
    }

    @Test
    public void testQuadraticMean() {
        double[] values = new double[]{1.2, 3.4, 5.6, 7.89};
        DescriptiveStatistics stats = new DescriptiveStatistics(values);
        int len = values.length;
        double expected = 0.0;
        for (int i = 0; i < len; ++i) {
            double v = values[i];
            expected += v * v / (double)len;
        }
        expected = Math.sqrt(expected);
        Assert.assertEquals((double)expected, (double)stats.getQuadraticMean(), (double)Math.ulp(expected));
    }

    @Test
    public void testToString() {
        DescriptiveStatistics stats = this.createDescriptiveStatistics();
        stats.addValue(1.0);
        stats.addValue(2.0);
        stats.addValue(3.0);
        Locale d = Locale.getDefault();
        Locale.setDefault(Locale.US);
        Assert.assertEquals((Object)"DescriptiveStatistics:\nn: 3\nmin: 1.0\nmax: 3.0\nmean: 2.0\nstd dev: 1.0\nmedian: 2.0\nskewness: 0.0\nkurtosis: NaN\n", (Object)stats.toString());
        Locale.setDefault(d);
    }

    @Test
    public void testPercentile() {
        DescriptiveStatistics stats = this.createDescriptiveStatistics();
        stats.addValue(1.0);
        stats.addValue(2.0);
        stats.addValue(3.0);
        Assert.assertEquals((double)2.0, (double)stats.getPercentile(50.0), (double)1.0E-10);
    }

    @Test
    public void test20090720() {
        DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics(100);
        for (int i = 0; i < 161; ++i) {
            descriptiveStatistics.addValue(1.2);
        }
        descriptiveStatistics.clear();
        descriptiveStatistics.addValue(1.2);
        Assert.assertEquals((long)1L, (long)descriptiveStatistics.getN());
    }

    @Test
    public void testRemoval() {
        DescriptiveStatistics dstat = this.createDescriptiveStatistics();
        this.checkRemoval(dstat, 1, 6.0, 0.0, Double.NaN);
        this.checkRemoval(dstat, 3, 5.0, 3.0, 4.5);
        this.checkRemoval(dstat, 6, 3.5, 2.5, 3.0);
        this.checkRemoval(dstat, 9, 3.5, 2.5, 3.0);
        this.checkRemoval(dstat, -1, 3.5, 2.5, 3.0);
    }

    @Test
    public void testSummaryConsistency() {
        int windowSize = 5;
        DescriptiveStatistics dstats = new DescriptiveStatistics(5);
        StreamingStatistics sstats = new StreamingStatistics();
        double tol = 1.0E-12;
        for (int i = 0; i < 20; ++i) {
            dstats.addValue((double)i);
            sstats.clear();
            double[] values = dstats.getValues();
            for (int j = 0; j < values.length; ++j) {
                sstats.addValue(values[j]);
            }
            UnitTestUtils.assertEquals((double)dstats.getMean(), (double)sstats.getMean(), (double)1.0E-12);
            UnitTestUtils.assertEquals((double)new Mean().evaluate(values), (double)dstats.getMean(), (double)1.0E-12);
            UnitTestUtils.assertEquals((double)dstats.getMax(), (double)sstats.getMax(), (double)1.0E-12);
            UnitTestUtils.assertEquals((double)new Max().evaluate(values), (double)dstats.getMax(), (double)1.0E-12);
            UnitTestUtils.assertEquals((double)dstats.getGeometricMean(), (double)sstats.getGeometricMean(), (double)1.0E-12);
            UnitTestUtils.assertEquals((double)new GeometricMean().evaluate(values), (double)dstats.getGeometricMean(), (double)1.0E-12);
            UnitTestUtils.assertEquals((double)dstats.getMin(), (double)sstats.getMin(), (double)1.0E-12);
            UnitTestUtils.assertEquals((double)new Min().evaluate(values), (double)dstats.getMin(), (double)1.0E-12);
            UnitTestUtils.assertEquals((double)dstats.getStandardDeviation(), (double)sstats.getStandardDeviation(), (double)1.0E-12);
            UnitTestUtils.assertEquals((double)dstats.getVariance(), (double)sstats.getVariance(), (double)1.0E-12);
            UnitTestUtils.assertEquals((double)new Variance().evaluate(values), (double)dstats.getVariance(), (double)1.0E-12);
            UnitTestUtils.assertEquals((double)dstats.getSum(), (double)sstats.getSum(), (double)1.0E-12);
            UnitTestUtils.assertEquals((double)new Sum().evaluate(values), (double)dstats.getSum(), (double)1.0E-12);
            UnitTestUtils.assertEquals((double)dstats.getSumOfSquares(), (double)sstats.getSumOfSquares(), (double)1.0E-12);
            UnitTestUtils.assertEquals((double)new SumOfSquares().evaluate(values), (double)dstats.getSumOfSquares(), (double)1.0E-12);
            UnitTestUtils.assertEquals((double)dstats.getPopulationVariance(), (double)sstats.getPopulationVariance(), (double)1.0E-12);
            UnitTestUtils.assertEquals((double)new Variance(false).evaluate(values), (double)dstats.getPopulationVariance(), (double)1.0E-12);
        }
    }

    @Test
    public void testMath1129() {
        double o;
        double[] data = new double[]{-0.012086732064244697, -0.24975668704012527, 0.5706168483164684, -0.322111769955327, 0.24166759508327315, Double.NaN, 0.16698443218942854, -0.10427763937565114, -0.15595963093172435, -0.028075857595882995, -0.24137994506058857, 0.47543170476574426, -0.07495595384947631, 0.37445697625436497, -0.09944199541668033};
        DescriptiveStatistics ds = new DescriptiveStatistics(data);
        double t = ds.getPercentile(75.0);
        double iqr = t - (o = ds.getPercentile(25.0));
        Assert.assertTrue((iqr >= 0.0 ? 1 : 0) != 0);
    }

    public void checkRemoval(DescriptiveStatistics dstat, int wsize, double mean1, double mean2, double mean3) {
        dstat.setWindowSize(wsize);
        dstat.clear();
        for (int i = 1; i <= 6; ++i) {
            dstat.addValue((double)i);
        }
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)mean1, (double)dstat.getMean()));
        dstat.replaceMostRecentValue(0.0);
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)mean2, (double)dstat.getMean()));
        dstat.removeMostRecentValue();
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)mean3, (double)dstat.getMean()));
    }
}

