/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import java.util.ArrayList;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.distribution.RealDistribution;
import org.hipparchus.distribution.continuous.UniformRealDistribution;
import org.hipparchus.random.RandomDataGenerator;
import org.hipparchus.stat.descriptive.StatisticalSummary;
import org.hipparchus.stat.descriptive.StreamingStatistics;
import org.junit.Assert;
import org.junit.Test;

public class StatisticalSummaryTest {
    @Test
    public void testAggregate() {
        double[] totalSample = this.generateSample();
        double[][] subSamples = this.generatePartition(totalSample);
        int nSamples = subSamples.length;
        StreamingStatistics totalStats = new StreamingStatistics();
        for (int i = 0; i < totalSample.length; ++i) {
            totalStats.addValue(totalSample[i]);
        }
        StreamingStatistics[] subSampleStats = new StreamingStatistics[nSamples];
        for (int i = 0; i < nSamples; ++i) {
            subSampleStats[i] = new StreamingStatistics();
        }
        ArrayList<StreamingStatistics> aggregate = new ArrayList<StreamingStatistics>();
        for (int i = 0; i < nSamples; ++i) {
            for (int j = 0; j < subSamples[i].length; ++j) {
                subSampleStats[i].addValue(subSamples[i][j]);
            }
            aggregate.add(subSampleStats[i]);
        }
        StatisticalSummary aggregatedStats = StatisticalSummary.aggregate(aggregate);
        StatisticalSummaryTest.assertStatisticalSummaryEquals(totalStats.getSummary(), aggregatedStats, 1.0E-11);
    }

    @Test
    public void testAggregateStatisticalSummary() {
        double[] totalSample = this.generateSample();
        double[][] subSamples = this.generatePartition(totalSample);
        int nSamples = subSamples.length;
        StreamingStatistics totalStats = new StreamingStatistics();
        for (int i = 0; i < totalSample.length; ++i) {
            totalStats.addValue(totalSample[i]);
        }
        StreamingStatistics[] subSampleStats = new StreamingStatistics[nSamples];
        for (int i = 0; i < nSamples; ++i) {
            subSampleStats[i] = new StreamingStatistics();
        }
        ArrayList<StatisticalSummary> aggregate = new ArrayList<StatisticalSummary>();
        for (int i = 0; i < nSamples; ++i) {
            for (int j = 0; j < subSamples[i].length; ++j) {
                subSampleStats[i].addValue(subSamples[i][j]);
            }
            aggregate.add(subSampleStats[i].getSummary());
        }
        StatisticalSummary aggregatedStats = StatisticalSummary.aggregate(aggregate);
        StatisticalSummaryTest.assertStatisticalSummaryEquals(totalStats.getSummary(), aggregatedStats, 1.0E-11);
    }

    @Test
    public void testAggregateDegenerate() {
        double[] totalSample = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        double[][] subSamples = new double[][]{{1.0}, {2.0}, {3.0}, {4.0}, {5.0}};
        StreamingStatistics totalStats = new StreamingStatistics();
        for (int i = 0; i < totalSample.length; ++i) {
            totalStats.addValue(totalSample[i]);
        }
        StreamingStatistics[] subSampleStats = new StreamingStatistics[5];
        for (int i = 0; i < 5; ++i) {
            subSampleStats[i] = new StreamingStatistics();
        }
        ArrayList<StreamingStatistics> aggregate = new ArrayList<StreamingStatistics>();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < subSamples[i].length; ++j) {
                subSampleStats[i].addValue(subSamples[i][j]);
            }
            aggregate.add(subSampleStats[i]);
        }
        StatisticalSummary aggregatedStats = StatisticalSummary.aggregate(aggregate);
        StatisticalSummaryTest.assertStatisticalSummaryEquals(totalStats.getSummary(), aggregatedStats, 1.0E-11);
    }

    @Test
    public void testAggregateSpecialValues() {
        double[] totalSample = new double[]{Double.POSITIVE_INFINITY, 2.0, 3.0, Double.NaN, 5.0};
        double[][] subSamples = new double[][]{{Double.POSITIVE_INFINITY, 2.0}, {3.0}, {Double.NaN}, {5.0}};
        StreamingStatistics totalStats = new StreamingStatistics();
        for (int i = 0; i < totalSample.length; ++i) {
            totalStats.addValue(totalSample[i]);
        }
        StreamingStatistics[] subSampleStats = new StreamingStatistics[5];
        for (int i = 0; i < 4; ++i) {
            subSampleStats[i] = new StreamingStatistics();
        }
        ArrayList<StreamingStatistics> aggregate = new ArrayList<StreamingStatistics>();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < subSamples[i].length; ++j) {
                subSampleStats[i].addValue(subSamples[i][j]);
            }
            aggregate.add(subSampleStats[i]);
        }
        StatisticalSummary aggregatedStats = StatisticalSummary.aggregate(aggregate);
        StatisticalSummaryTest.assertStatisticalSummaryEquals(totalStats.getSummary(), aggregatedStats, 1.0E-11);
    }

    protected static void assertStatisticalSummaryEquals(StatisticalSummary expected, StatisticalSummary observed, double delta) {
        UnitTestUtils.assertEquals((double)expected.getMax(), (double)observed.getMax(), (double)0.0);
        UnitTestUtils.assertEquals((double)expected.getMin(), (double)observed.getMin(), (double)0.0);
        Assert.assertEquals((long)expected.getN(), (long)observed.getN());
        UnitTestUtils.assertEquals((double)expected.getSum(), (double)observed.getSum(), (double)delta);
        UnitTestUtils.assertEquals((double)expected.getMean(), (double)observed.getMean(), (double)delta);
        UnitTestUtils.assertEquals((double)expected.getStandardDeviation(), (double)observed.getStandardDeviation(), (double)delta);
        UnitTestUtils.assertEquals((double)expected.getVariance(), (double)observed.getVariance(), (double)delta);
    }

    private double[] generateSample() {
        UniformRealDistribution uniformDist = new UniformRealDistribution(-100.0, 100.0);
        RandomDataGenerator randomDataGenerator = new RandomDataGenerator(100L);
        int sampleSize = randomDataGenerator.nextInt(10, 100);
        double[] out = randomDataGenerator.nextDeviates((RealDistribution)uniformDist, sampleSize);
        return out;
    }

    private double[][] generatePartition(double[] sample) {
        int subLength;
        RandomDataGenerator randomDataGenerator = new RandomDataGenerator(100L);
        int length = sample.length;
        double[][] out = new double[5][];
        int cur = 0;
        int offset = 0;
        int sampleCount = 0;
        for (int i = 0; i < 5 && cur != length && offset != length; offset += subLength, ++i) {
            int next = i == 4 || cur == length - 1 ? length - 1 : randomDataGenerator.nextInt(cur, length - 1);
            subLength = next - cur + 1;
            out[i] = new double[subLength];
            System.arraycopy(sample, offset, out[i], 0, subLength);
            cur = next + 1;
            ++sampleCount;
        }
        if (sampleCount < 5) {
            double[][] out2 = new double[sampleCount][];
            for (int j = 0; j < sampleCount; ++j) {
                int curSize = out[j].length;
                out2[j] = new double[curSize];
                System.arraycopy(out[j], 0, out2[j], 0, curSize);
            }
            return out2;
        }
        return out;
    }
}

