/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.moment;

import java.util.Arrays;
import org.hipparchus.UnitTestUtils;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.StatUtils;
import org.hipparchus.stat.descriptive.UnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.moment.SemiVariance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SemiVarianceTest
extends UnivariateStatisticAbstractTest {
    private double semiVariance;

    @Before
    public void setup() {
        double val = Arrays.stream(this.testArray).filter(x -> x < this.mean).reduce(0.0, (x, y) -> x + (y - this.mean) * (y - this.mean));
        this.semiVariance = val / (double)(this.testArray.length - 1);
    }

    public SemiVariance getUnivariateStatistic() {
        return new SemiVariance();
    }

    @Override
    public double expectedValue() {
        return this.semiVariance;
    }

    @Test
    public void testInsufficientData() {
        SemiVariance sv = this.getUnivariateStatistic();
        try {
            sv.evaluate(null);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            sv = sv.withVarianceDirection(SemiVariance.UPSIDE_VARIANCE);
            sv.evaluate(null);
            Assert.fail((String)"null is not a valid data array.");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)Double.isNaN(sv.evaluate(new double[0])));
    }

    @Test
    public void testSingleDown() {
        SemiVariance sv = new SemiVariance();
        double[] values = new double[]{50.0};
        double singletest = sv.evaluate(values);
        Assert.assertEquals((double)0.0, (double)singletest, (double)0.0);
    }

    @Test
    public void testSingleUp() {
        SemiVariance sv = new SemiVariance(SemiVariance.UPSIDE_VARIANCE);
        double[] values = new double[]{50.0};
        double singletest = sv.evaluate(values);
        Assert.assertEquals((double)0.0, (double)singletest, (double)0.0);
    }

    @Test
    public void testSample() {
        double[] values = new double[]{-2.0, 2.0, 4.0, -2.0, 22.0, 11.0, 3.0, 14.0, 5.0};
        int length = values.length;
        double mean = StatUtils.mean((double[])values);
        SemiVariance sv = this.getUnivariateStatistic();
        double downsideSemiVariance = sv.evaluate(values);
        Assert.assertEquals((double)(UnitTestUtils.sumSquareDev((double[])new double[]{-2.0, 2.0, 4.0, -2.0, 3.0, 5.0}, (double)mean) / (double)(length - 1)), (double)downsideSemiVariance, (double)1.0E-14);
        sv = sv.withVarianceDirection(SemiVariance.UPSIDE_VARIANCE);
        double upsideSemiVariance = sv.evaluate(values);
        Assert.assertEquals((double)(UnitTestUtils.sumSquareDev((double[])new double[]{22.0, 11.0, 14.0}, (double)mean) / (double)(length - 1)), (double)upsideSemiVariance, (double)1.0E-14);
        Assert.assertEquals((double)StatUtils.variance((double[])values), (double)(downsideSemiVariance + upsideSemiVariance), (double)1.0E-11);
    }

    @Test
    public void testPopulation() {
        double[] values = new double[]{-2.0, 2.0, 4.0, -2.0, 22.0, 11.0, 3.0, 14.0, 5.0};
        SemiVariance sv = new SemiVariance(false);
        double singletest = sv.evaluate(values);
        Assert.assertEquals((double)19.556, (double)singletest, (double)0.01);
        sv = sv.withVarianceDirection(SemiVariance.UPSIDE_VARIANCE);
        singletest = sv.evaluate(values);
        Assert.assertEquals((double)36.222, (double)singletest, (double)0.01);
    }

    @Test
    public void testNonMeanCutoffs() {
        double[] values = new double[]{-2.0, 2.0, 4.0, -2.0, 22.0, 11.0, 3.0, 14.0, 5.0};
        SemiVariance sv = new SemiVariance(false);
        double singletest = sv.evaluate(values, 1.0, SemiVariance.DOWNSIDE_VARIANCE, false, 0, values.length);
        Assert.assertEquals((double)(UnitTestUtils.sumSquareDev((double[])new double[]{-2.0, -2.0}, (double)1.0) / (double)values.length), (double)singletest, (double)0.01);
        singletest = sv.evaluate(values, 3.0, SemiVariance.UPSIDE_VARIANCE, false, 0, values.length);
        Assert.assertEquals((double)(UnitTestUtils.sumSquareDev((double[])new double[]{4.0, 22.0, 11.0, 14.0, 5.0}, (double)3.0) / (double)values.length), (double)singletest, (double)0.01);
    }

    @Test
    public void testVarianceDecompMeanCutoff() {
        double[] values = new double[]{-2.0, 2.0, 4.0, -2.0, 22.0, 11.0, 3.0, 14.0, 5.0};
        double variance = StatUtils.variance((double[])values);
        SemiVariance sv = new SemiVariance(true);
        sv = sv.withVarianceDirection(SemiVariance.DOWNSIDE_VARIANCE);
        double lower = sv.evaluate(values);
        sv = sv.withVarianceDirection(SemiVariance.UPSIDE_VARIANCE);
        double upper = sv.evaluate(values);
        Assert.assertEquals((double)variance, (double)(lower + upper), (double)1.0E-11);
    }

    @Test
    public void testVarianceDecompNonMeanCutoff() {
        double[] values = new double[]{-2.0, 2.0, 4.0, -2.0, 22.0, 11.0, 3.0, 14.0, 5.0};
        double target = 0.0;
        double totalSumOfSquares = UnitTestUtils.sumSquareDev((double[])values, (double)target);
        SemiVariance sv = new SemiVariance(true);
        sv = sv.withVarianceDirection(SemiVariance.DOWNSIDE_VARIANCE);
        double lower = sv.evaluate(values, target);
        sv = sv.withVarianceDirection(SemiVariance.UPSIDE_VARIANCE);
        double upper = sv.evaluate(values, target);
        Assert.assertEquals((double)(totalSumOfSquares / (double)(values.length - 1)), (double)(lower + upper), (double)1.0E-11);
    }

    @Test
    public void testNoVariance() {
        double[] values = new double[]{100.0, 100.0, 100.0, 100.0};
        SemiVariance sv = this.getUnivariateStatistic();
        Assert.assertEquals((double)0.0, (double)sv.evaluate(values), (double)1.0E-11);
        Assert.assertEquals((double)0.0, (double)sv.evaluate(values, 100.0), (double)1.0E-11);
        Assert.assertEquals((double)0.0, (double)sv.evaluate(values, 100.0, SemiVariance.UPSIDE_VARIANCE, false, 0, values.length), (double)1.0E-11);
    }
}

