/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.rank;

import org.hipparchus.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.rank.Min;
import org.junit.Assert;
import org.junit.Test;

public class MinTest
extends StorelessUnivariateStatisticAbstractTest {
    public Min getUnivariateStatistic() {
        return new Min();
    }

    @Override
    public double expectedValue() {
        return this.min;
    }

    @Test
    public void testSpecialValues() {
        double[] testArray = new double[]{0.0, Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        Min min = this.getUnivariateStatistic();
        Assert.assertTrue((boolean)Double.isNaN(min.getResult()));
        min.increment(testArray[0]);
        Assert.assertEquals((double)0.0, (double)min.getResult(), (double)0.0);
        min.increment(testArray[1]);
        Assert.assertEquals((double)0.0, (double)min.getResult(), (double)0.0);
        min.increment(testArray[2]);
        Assert.assertEquals((double)0.0, (double)min.getResult(), (double)0.0);
        min.increment(testArray[3]);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)min.getResult(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)min.evaluate(testArray), (double)0.0);
    }

    @Test
    public void testNaNs() {
        Min min = this.getUnivariateStatistic();
        double nan = Double.NaN;
        Assert.assertEquals((double)2.0, (double)min.evaluate(new double[]{nan, 2.0, 3.0}), (double)0.0);
        Assert.assertEquals((double)1.0, (double)min.evaluate(new double[]{1.0, nan, 3.0}), (double)0.0);
        Assert.assertEquals((double)1.0, (double)min.evaluate(new double[]{1.0, 2.0, nan}), (double)0.0);
        Assert.assertTrue((boolean)Double.isNaN(min.evaluate(new double[]{nan, nan, nan})));
    }
}

