/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.rank;

import java.util.Arrays;
import org.hipparchus.distribution.RealDistribution;
import org.hipparchus.distribution.continuous.NormalDistribution;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.random.RandomDataGenerator;
import org.hipparchus.stat.descriptive.UnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.rank.Percentile;
import org.hipparchus.stat.ranking.NaNStrategy;
import org.hipparchus.util.KthSelector;
import org.hipparchus.util.PivotingStrategy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PercentileTest
extends UnivariateStatisticAbstractTest {
    private double quantile;
    private Percentile.EstimationType type;
    private NaNStrategy nanStrategy;
    private KthSelector kthSelector;
    protected final double DEFAULT_PERCENTILE = 95.0;
    static final int TINY = 10;
    static final int SMALL = 50;
    static final int NOMINAL = 100;
    static final int MEDIUM = 500;
    static final int STANDARD = 1000;
    static final int BIG = 10000;
    static final int VERY_BIG = 50000;
    static final int LARGE = 1000000;
    static final int VERY_LARGE = 10000000;
    static final int[] sampleSizes = new int[]{10, 50, 100, 500, 1000, 10000};

    @Before
    public void setup() {
        this.quantile = 95.0;
        this.type = Percentile.EstimationType.LEGACY;
        this.nanStrategy = NaNStrategy.REMOVED;
        this.kthSelector = new KthSelector(PivotingStrategy.MEDIAN_OF_3);
    }

    private void reset(double p, Percentile.EstimationType type) {
        this.quantile = p;
        this.type = type;
        this.nanStrategy = type == Percentile.EstimationType.LEGACY ? NaNStrategy.FIXED : NaNStrategy.REMOVED;
    }

    public Percentile getUnivariateStatistic() {
        return new Percentile(this.quantile).withEstimationType(this.type).withNaNStrategy(this.nanStrategy).withKthSelector(this.kthSelector);
    }

    @Override
    public double expectedValue() {
        return this.percentile95;
    }

    @Test
    public void testHighPercentile() {
        double[] d = new double[]{1.0, 2.0, 3.0};
        Percentile p = new Percentile(75.0);
        Assert.assertEquals((double)3.0, (double)p.evaluate(d), (double)1.0E-5);
    }

    @Test
    public void testLowPercentile() {
        double[] d = new double[]{0.0, 1.0};
        Percentile p = new Percentile(25.0);
        Assert.assertEquals((double)0.0, (double)p.evaluate(d), (double)Double.MIN_VALUE);
    }

    @Test
    public void testPercentile() {
        double[] d = new double[]{1.0, 3.0, 2.0, 4.0};
        Percentile p = new Percentile(30.0);
        Assert.assertEquals((double)1.5, (double)p.evaluate(d), (double)1.0E-5);
        p.setQuantile(25.0);
        Assert.assertEquals((double)1.25, (double)p.evaluate(d), (double)1.0E-5);
        p.setQuantile(75.0);
        Assert.assertEquals((double)3.75, (double)p.evaluate(d), (double)1.0E-5);
        p.setQuantile(50.0);
        Assert.assertEquals((double)2.5, (double)p.evaluate(d), (double)1.0E-5);
        try {
            p.evaluate(d, 0, d.length, -1.0);
            Assert.fail();
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            p.evaluate(d, 0, d.length, 101.0);
            Assert.fail();
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNISTExample() {
        double[] d = new double[]{95.1772, 95.1567, 95.1937, 95.1959, 95.1442, 95.061, 95.1591, 95.1195, 95.1772, 95.0925, 95.199, 95.1682};
        Percentile p = new Percentile(90.0);
        Assert.assertEquals((double)95.1981, (double)p.evaluate(d), (double)1.0E-4);
        Assert.assertEquals((double)95.199, (double)p.evaluate(d, 0, d.length, 100.0), (double)0.0);
    }

    @Test
    public void test5() {
        Percentile percentile = new Percentile(5.0);
        Assert.assertEquals((double)this.percentile5, (double)percentile.evaluate(this.testArray), (double)this.getTolerance());
    }

    @Test
    public void testNullEmpty() {
        Percentile percentile = new Percentile(50.0);
        double[] nullArray = null;
        double[] emptyArray = new double[]{};
        try {
            percentile.evaluate(nullArray);
            Assert.fail((String)"Expecting NullArgumentException for null array");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)Double.isNaN(percentile.evaluate(emptyArray)));
    }

    @Test
    public void testSingleton() {
        Percentile percentile = new Percentile(50.0);
        double[] singletonArray = new double[]{1.0};
        Assert.assertEquals((double)1.0, (double)percentile.evaluate(singletonArray), (double)0.0);
        Assert.assertEquals((double)1.0, (double)percentile.evaluate(singletonArray, 0, 1), (double)0.0);
        Assert.assertEquals((double)1.0, (double)percentile.evaluate(singletonArray, 0, 1, 5.0), (double)0.0);
        Assert.assertEquals((double)1.0, (double)percentile.evaluate(singletonArray, 0, 1, 100.0), (double)0.0);
        Assert.assertTrue((boolean)Double.isNaN(percentile.evaluate(singletonArray, 0, 0)));
    }

    @Test
    public void testSpecialValues() {
        Percentile percentile = new Percentile(50.0);
        double[] specialValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, Double.NaN};
        Assert.assertEquals((double)2.0, (double)percentile.evaluate(specialValues), (double)0.0);
        specialValues = new double[]{Double.NEGATIVE_INFINITY, 1.0, 2.0, 3.0, Double.NaN, Double.POSITIVE_INFINITY};
        Assert.assertEquals((double)2.0, (double)percentile.evaluate(specialValues), (double)0.0);
        specialValues = new double[]{1.0, 1.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        Assert.assertTrue((boolean)Double.isInfinite(percentile.evaluate(specialValues)));
        specialValues = new double[]{1.0, 1.0, Double.NaN, Double.NaN};
        Assert.assertTrue((!Double.isNaN(percentile.evaluate(specialValues)) ? 1 : 0) != 0);
        Assert.assertTrue((1.0 == percentile.evaluate(specialValues) ? 1 : 0) != 0);
        specialValues = new double[]{1.0, 1.0, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        Assert.assertTrue((boolean)Double.isNaN(percentile.evaluate(specialValues)));
    }

    @Test
    public void testSetQuantile() {
        Percentile percentile = new Percentile(10.0);
        percentile.setQuantile(100.0);
        Assert.assertEquals((double)100.0, (double)percentile.getQuantile(), (double)0.0);
        try {
            percentile.setQuantile(0.0);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            new Percentile(0.0);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAllTechniquesHighPercentile() {
        double[] d = new double[]{1.0, 2.0, 3.0};
        this.testAssertMappedValues(d, new Object[][]{{Percentile.EstimationType.LEGACY, 3.0}, {Percentile.EstimationType.R_1, 3.0}, {Percentile.EstimationType.R_2, 3.0}, {Percentile.EstimationType.R_3, 2.0}, {Percentile.EstimationType.R_4, 2.25}, {Percentile.EstimationType.R_5, 2.75}, {Percentile.EstimationType.R_6, 3.0}, {Percentile.EstimationType.R_7, 2.5}, {Percentile.EstimationType.R_8, 2.83333}, {Percentile.EstimationType.R_9, 2.8125}}, 75.0, 1.0E-5);
    }

    @Test
    public void testAllTechniquesLowPercentile() {
        double[] d = new double[]{0.0, 1.0};
        this.testAssertMappedValues(d, new Object[][]{{Percentile.EstimationType.LEGACY, 0.0}, {Percentile.EstimationType.R_1, 0.0}, {Percentile.EstimationType.R_2, 0.0}, {Percentile.EstimationType.R_3, 0.0}, {Percentile.EstimationType.R_4, 0.0}, {Percentile.EstimationType.R_5, 0.0}, {Percentile.EstimationType.R_6, 0.0}, {Percentile.EstimationType.R_7, 0.25}, {Percentile.EstimationType.R_8, 0.0}, {Percentile.EstimationType.R_9, 0.0}}, 25.0, (Double)Double.MIN_VALUE);
    }

    public void checkAllTechniquesPercentile() {
        double[] d = new double[]{1.0, 3.0, 2.0, 4.0};
        this.testAssertMappedValues(d, new Object[][]{{Percentile.EstimationType.LEGACY, 1.5}, {Percentile.EstimationType.R_1, 2.0}, {Percentile.EstimationType.R_2, 2.0}, {Percentile.EstimationType.R_3, 1.0}, {Percentile.EstimationType.R_4, 1.2}, {Percentile.EstimationType.R_5, 1.7}, {Percentile.EstimationType.R_6, 1.5}, {Percentile.EstimationType.R_7, 1.9}, {Percentile.EstimationType.R_8, 1.63333}, {Percentile.EstimationType.R_9, 1.65}}, 30.0, 1.0E-5);
        this.testAssertMappedValues(d, new Object[][]{{Percentile.EstimationType.LEGACY, 1.25}, {Percentile.EstimationType.R_1, 1.0}, {Percentile.EstimationType.R_2, 1.5}, {Percentile.EstimationType.R_3, 1.0}, {Percentile.EstimationType.R_4, 1.0}, {Percentile.EstimationType.R_5, 1.5}, {Percentile.EstimationType.R_6, 1.25}, {Percentile.EstimationType.R_7, 1.75}, {Percentile.EstimationType.R_8, 1.41667}, {Percentile.EstimationType.R_9, 1.4375}}, 25.0, 1.0E-5);
        this.testAssertMappedValues(d, new Object[][]{{Percentile.EstimationType.LEGACY, 3.75}, {Percentile.EstimationType.R_1, 3.0}, {Percentile.EstimationType.R_2, 3.5}, {Percentile.EstimationType.R_3, 3.0}, {Percentile.EstimationType.R_4, 3.0}, {Percentile.EstimationType.R_5, 3.5}, {Percentile.EstimationType.R_6, 3.75}, {Percentile.EstimationType.R_7, 3.25}, {Percentile.EstimationType.R_8, 3.58333}, {Percentile.EstimationType.R_9, 3.5625}}, 75.0, 1.0E-5);
        this.testAssertMappedValues(d, new Object[][]{{Percentile.EstimationType.LEGACY, 2.5}, {Percentile.EstimationType.R_1, 2.0}, {Percentile.EstimationType.R_2, 2.5}, {Percentile.EstimationType.R_3, 2.0}, {Percentile.EstimationType.R_4, 2.0}, {Percentile.EstimationType.R_5, 2.5}, {Percentile.EstimationType.R_6, 2.5}, {Percentile.EstimationType.R_7, 2.5}, {Percentile.EstimationType.R_8, 2.5}, {Percentile.EstimationType.R_9, 2.5}}, 50.0, 1.0E-5);
        for (Percentile.EstimationType e : Percentile.EstimationType.values()) {
            try {
                this.reset(-1.0, e);
                this.getUnivariateStatistic().evaluate(d, 0, d.length);
                Assert.fail();
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                // empty catch block
            }
        }
        for (Percentile.EstimationType e : Percentile.EstimationType.values()) {
            try {
                this.reset(101.0, e);
                this.getUnivariateStatistic().evaluate(d, 0, d.length);
                Assert.fail();
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testAllTechniquesPercentileUsingMedianOf3Pivoting() {
        this.kthSelector = new KthSelector(PivotingStrategy.MEDIAN_OF_3);
        this.checkAllTechniquesPercentile();
    }

    @Test
    public void testAllTechniquesPercentileUsingCentralPivoting() {
        this.kthSelector = new KthSelector(PivotingStrategy.CENTRAL);
        this.checkAllTechniquesPercentile();
    }

    @Test
    public void testAllTechniquesNISTExample() {
        double[] d = new double[]{95.1772, 95.1567, 95.1937, 95.1959, 95.1442, 95.061, 95.1591, 95.1195, 95.1772, 95.0925, 95.199, 95.1682};
        this.testAssertMappedValues(d, new Object[][]{{Percentile.EstimationType.LEGACY, 95.1981}, {Percentile.EstimationType.R_1, 95.1959}, {Percentile.EstimationType.R_2, 95.1959}, {Percentile.EstimationType.R_3, 95.1959}, {Percentile.EstimationType.R_4, 95.19546}, {Percentile.EstimationType.R_5, 95.19683}, {Percentile.EstimationType.R_6, 95.19807}, {Percentile.EstimationType.R_7, 95.19568}, {Percentile.EstimationType.R_8, 95.19724}, {Percentile.EstimationType.R_9, 95.19714}}, 90.0, 1.0E-4);
        for (Percentile.EstimationType e : Percentile.EstimationType.values()) {
            this.reset(100.0, e);
            Assert.assertEquals((double)95.199, (double)this.getUnivariateStatistic().evaluate(d), (double)1.0E-4);
        }
    }

    @Test
    public void testAllTechniques5() {
        this.reset(5.0, Percentile.EstimationType.LEGACY);
        Percentile percentile = this.getUnivariateStatistic();
        Assert.assertEquals((double)this.percentile5, (double)percentile.evaluate(this.testArray), (double)this.getTolerance());
        this.testAssertMappedValues(this.testArray, new Object[][]{{Percentile.EstimationType.LEGACY, this.percentile5}, {Percentile.EstimationType.R_1, 8.8}, {Percentile.EstimationType.R_2, 8.8}, {Percentile.EstimationType.R_3, 8.2}, {Percentile.EstimationType.R_4, 8.26}, {Percentile.EstimationType.R_5, 8.56}, {Percentile.EstimationType.R_6, 8.29}, {Percentile.EstimationType.R_7, 8.81}, {Percentile.EstimationType.R_8, 8.47}, {Percentile.EstimationType.R_9, 8.4925}}, 5.0, this.getTolerance());
    }

    @Test
    public void testAllTechniquesNullEmpty() {
        double[] nullArray = null;
        double[] emptyArray = new double[]{};
        for (Percentile.EstimationType e : Percentile.EstimationType.values()) {
            this.reset(50.0, e);
            Percentile percentile = this.getUnivariateStatistic();
            try {
                percentile.evaluate(nullArray);
                Assert.fail((String)"Expecting NullArgumentException for null array");
            }
            catch (NullArgumentException nullArgumentException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)Double.isNaN(percentile.evaluate(emptyArray)));
        }
    }

    @Test
    public void testAllTechniquesSingleton() {
        double[] singletonArray = new double[]{1.0};
        for (Percentile.EstimationType e : Percentile.EstimationType.values()) {
            this.reset(50.0, e);
            Percentile percentile = this.getUnivariateStatistic();
            Assert.assertEquals((double)1.0, (double)percentile.evaluate(singletonArray), (double)0.0);
            Assert.assertEquals((double)1.0, (double)percentile.evaluate(singletonArray, 0, 1), (double)0.0);
            Assert.assertEquals((double)1.0, (double)new Percentile().evaluate(singletonArray, 0, 1, 5.0), (double)0.0);
            Assert.assertEquals((double)1.0, (double)new Percentile().evaluate(singletonArray, 0, 1, 100.0), (double)0.0);
            Assert.assertTrue((boolean)Double.isNaN(percentile.evaluate(singletonArray, 0, 0)));
        }
    }

    @Test
    public void testAllTechniquesEmpty() {
        double[] singletonArray = new double[]{};
        for (Percentile.EstimationType e : Percentile.EstimationType.values()) {
            this.reset(50.0, e);
            Percentile percentile = this.getUnivariateStatistic();
            Assert.assertEquals((double)Double.NaN, (double)percentile.evaluate(singletonArray), (double)0.0);
            Assert.assertEquals((double)Double.NaN, (double)percentile.evaluate(singletonArray, 0, 0), (double)0.0);
            Assert.assertEquals((double)Double.NaN, (double)new Percentile().evaluate(singletonArray, 0, 0, 5.0), (double)0.0);
            Assert.assertEquals((double)Double.NaN, (double)new Percentile().evaluate(singletonArray, 0, 0, 100.0), (double)0.0);
            Assert.assertTrue((boolean)Double.isNaN(percentile.evaluate(singletonArray, 0, 0)));
        }
    }

    @Test
    public void testReplaceNanInRange() {
        double[] specialValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, Double.NaN, Double.NaN, 5.0, 7.0, Double.NaN, 8.0};
        Assert.assertEquals((double)3.5, (double)new Percentile(50.0).evaluate(specialValues), (double)0.0);
        this.reset(50.0, Percentile.EstimationType.R_1);
        Assert.assertEquals((double)3.0, (double)this.getUnivariateStatistic().evaluate(specialValues), (double)0.0);
        this.reset(50.0, Percentile.EstimationType.R_2);
        Assert.assertEquals((double)3.5, (double)this.getUnivariateStatistic().evaluate(specialValues), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)new Percentile(70.0).withNaNStrategy(NaNStrategy.MAXIMAL).evaluate(specialValues), (double)0.0);
    }

    @Test
    public void testRemoveNan() {
        double[] specialValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, Double.NaN};
        double[] expectedValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
        this.reset(50.0, Percentile.EstimationType.R_1);
        Assert.assertEquals((double)2.0, (double)this.getUnivariateStatistic().evaluate(specialValues), (double)0.0);
        Assert.assertEquals((double)2.0, (double)this.getUnivariateStatistic().evaluate(expectedValues), (double)0.0);
        Assert.assertTrue((boolean)Double.isNaN(this.getUnivariateStatistic().evaluate(specialValues, 5, 1)));
        Assert.assertEquals((double)4.0, (double)this.getUnivariateStatistic().evaluate(specialValues, 4, 2), (double)0.0);
        Assert.assertEquals((double)3.0, (double)this.getUnivariateStatistic().evaluate(specialValues, 3, 3), (double)0.0);
        this.reset(50.0, Percentile.EstimationType.R_2);
        Assert.assertEquals((double)3.5, (double)this.getUnivariateStatistic().evaluate(specialValues, 3, 3), (double)0.0);
    }

    @Test
    public void testPercentileCopy() {
        this.reset(50.0, Percentile.EstimationType.LEGACY);
        Percentile original = this.getUnivariateStatistic();
        Percentile copy = new Percentile(original);
        Assert.assertEquals((Object)original.getNaNStrategy(), (Object)copy.getNaNStrategy());
        Assert.assertEquals((double)original.getQuantile(), (double)copy.getQuantile(), (double)0.0);
        Assert.assertEquals((Object)original.getEstimationType(), (Object)copy.getEstimationType());
        Assert.assertEquals((Object)NaNStrategy.FIXED, (Object)original.getNaNStrategy());
    }

    @Test
    public void testAllTechniquesSpecialValues() {
        this.reset(50.0, Percentile.EstimationType.LEGACY);
        Percentile percentile = this.getUnivariateStatistic();
        double[] specialValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, Double.NaN};
        Assert.assertEquals((double)2.5, (double)percentile.evaluate(specialValues), (double)0.0);
        this.testAssertMappedValues(specialValues, new Object[][]{{Percentile.EstimationType.LEGACY, 2.5}, {Percentile.EstimationType.R_1, 2.0}, {Percentile.EstimationType.R_2, 2.0}, {Percentile.EstimationType.R_3, 1.0}, {Percentile.EstimationType.R_4, 1.5}, {Percentile.EstimationType.R_5, 2.0}, {Percentile.EstimationType.R_6, 2.0}, {Percentile.EstimationType.R_7, 2.0}, {Percentile.EstimationType.R_8, 2.0}, {Percentile.EstimationType.R_9, 2.0}}, 50.0, 0.0);
        specialValues = new double[]{Double.NEGATIVE_INFINITY, 1.0, 2.0, 3.0, Double.NaN, Double.POSITIVE_INFINITY};
        Assert.assertEquals((double)2.5, (double)percentile.evaluate(specialValues), (double)0.0);
        this.testAssertMappedValues(specialValues, new Object[][]{{Percentile.EstimationType.LEGACY, 2.5}, {Percentile.EstimationType.R_1, 2.0}, {Percentile.EstimationType.R_2, 2.0}, {Percentile.EstimationType.R_3, 1.0}, {Percentile.EstimationType.R_4, 1.5}, {Percentile.EstimationType.R_5, 2.0}, {Percentile.EstimationType.R_7, 2.0}, {Percentile.EstimationType.R_7, 2.0}, {Percentile.EstimationType.R_8, 2.0}, {Percentile.EstimationType.R_9, 2.0}}, 50.0, 0.0);
        specialValues = new double[]{1.0, 1.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        Assert.assertTrue((boolean)Double.isInfinite(percentile.evaluate(specialValues)));
        this.testAssertMappedValues(specialValues, new Object[][]{{Percentile.EstimationType.LEGACY, Double.POSITIVE_INFINITY}, {Percentile.EstimationType.R_1, Double.NaN}, {Percentile.EstimationType.R_2, Double.NaN}, {Percentile.EstimationType.R_3, Double.NaN}, {Percentile.EstimationType.R_4, Double.NaN}, {Percentile.EstimationType.R_5, Double.POSITIVE_INFINITY}, {Percentile.EstimationType.R_6, Double.POSITIVE_INFINITY}, {Percentile.EstimationType.R_7, Double.POSITIVE_INFINITY}, {Percentile.EstimationType.R_8, Double.POSITIVE_INFINITY}, {Percentile.EstimationType.R_9, Double.POSITIVE_INFINITY}}, 50.0, 0.0);
        specialValues = new double[]{1.0, 1.0, Double.NaN, Double.NaN};
        Assert.assertTrue((boolean)Double.isNaN(percentile.evaluate(specialValues)));
        this.testAssertMappedValues(specialValues, new Object[][]{{Percentile.EstimationType.LEGACY, Double.NaN}, {Percentile.EstimationType.R_1, 1.0}, {Percentile.EstimationType.R_2, 1.0}, {Percentile.EstimationType.R_3, 1.0}, {Percentile.EstimationType.R_4, 1.0}, {Percentile.EstimationType.R_5, 1.0}, {Percentile.EstimationType.R_6, 1.0}, {Percentile.EstimationType.R_7, 1.0}, {Percentile.EstimationType.R_8, 1.0}, {Percentile.EstimationType.R_9, 1.0}}, 50.0, 0.0);
        specialValues = new double[]{1.0, 1.0, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        this.testAssertMappedValues(specialValues, new Object[][]{{Percentile.EstimationType.LEGACY, Double.NaN}, {Percentile.EstimationType.R_1, Double.NaN}, {Percentile.EstimationType.R_2, Double.NaN}, {Percentile.EstimationType.R_3, Double.NaN}, {Percentile.EstimationType.R_4, Double.NaN}, {Percentile.EstimationType.R_5, Double.NaN}, {Percentile.EstimationType.R_6, Double.NaN}, {Percentile.EstimationType.R_7, Double.NaN}, {Percentile.EstimationType.R_8, Double.NaN}, {Percentile.EstimationType.R_9, Double.NaN}}, 50.0, 0.0);
    }

    @Test
    public void testAllTechniquesSetQuantile() {
        for (Percentile.EstimationType e : Percentile.EstimationType.values()) {
            this.reset(10.0, e);
            Percentile percentile = this.getUnivariateStatistic();
            percentile.setQuantile(100.0);
            Assert.assertEquals((double)100.0, (double)percentile.getQuantile(), (double)0.0);
            try {
                percentile.setQuantile(0.0);
                Assert.fail((String)"Expecting MathIllegalArgumentException");
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                // empty catch block
            }
            try {
                new Percentile(0.0);
                Assert.fail((String)"Expecting MathIllegalArgumentException");
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testAllTechniquesEvaluateArraySegmentWeighted() {
        for (Percentile.EstimationType e : Percentile.EstimationType.values()) {
            this.reset(this.quantile, e);
            this.testEvaluateArraySegmentWeighted();
        }
    }

    @Test
    public void testAllTechniquesEvaluateArraySegment() {
        for (Percentile.EstimationType e : Percentile.EstimationType.values()) {
            this.reset(this.quantile, e);
            this.testEvaluateArraySegment();
        }
    }

    @Test
    public void testAllTechniquesWeightedConsistency() {
        for (Percentile.EstimationType e : Percentile.EstimationType.values()) {
            this.reset(this.quantile, e);
            this.testWeightedConsistency();
        }
    }

    @Test
    public void testAllTechniquesEvaluation() {
        this.testAssertMappedValues(this.testArray, new Object[][]{{Percentile.EstimationType.LEGACY, 20.82}, {Percentile.EstimationType.R_1, 19.8}, {Percentile.EstimationType.R_2, 19.8}, {Percentile.EstimationType.R_3, 19.8}, {Percentile.EstimationType.R_4, 19.31}, {Percentile.EstimationType.R_5, 20.28}, {Percentile.EstimationType.R_6, 20.82}, {Percentile.EstimationType.R_7, 19.555}, {Percentile.EstimationType.R_8, 20.46}, {Percentile.EstimationType.R_9, 20.415}}, 95.0, this.tolerance);
    }

    @Test
    public void testPercentileWithTechnique() {
        this.reset(50.0, Percentile.EstimationType.LEGACY);
        Percentile p = this.getUnivariateStatistic();
        Assert.assertTrue((boolean)Percentile.EstimationType.LEGACY.equals((Object)p.getEstimationType()));
        Assert.assertFalse((boolean)Percentile.EstimationType.R_1.equals((Object)p.getEstimationType()));
    }

    @Test
    public void testStoredVsDirect() {
        RandomDataGenerator randomDataGenerator = new RandomDataGenerator(100L);
        NormalDistribution normalDistribution = new NormalDistribution(4000.0, 50.0);
        for (int sampleSize : sampleSizes) {
            double[] data = randomDataGenerator.nextDeviates((RealDistribution)normalDistribution, sampleSize);
            for (double p : new double[]{50.0, 95.0}) {
                for (Percentile.EstimationType e : Percentile.EstimationType.values()) {
                    this.reset(p, e);
                    Percentile pStoredData = this.getUnivariateStatistic();
                    pStoredData.setData(data);
                    double storedDataResult = pStoredData.evaluate();
                    pStoredData.setData(null);
                    Percentile pDirect = this.getUnivariateStatistic();
                    Assert.assertEquals((String)("Sample=" + sampleSize + ",P=" + p + " e=" + e), (double)storedDataResult, (double)pDirect.evaluate(data), (double)0.0);
                }
            }
        }
    }

    @Test
    public void testPercentileWithDataRef() {
        this.reset(50.0, Percentile.EstimationType.R_7);
        Percentile p = this.getUnivariateStatistic();
        p.setData(this.testArray);
        Assert.assertTrue((boolean)Percentile.EstimationType.R_7.equals((Object)p.getEstimationType()));
        Assert.assertFalse((boolean)Percentile.EstimationType.R_1.equals((Object)p.getEstimationType()));
        Assert.assertEquals((double)12.0, (double)p.evaluate(), (double)0.0);
        Assert.assertEquals((double)12.16, (double)p.evaluate(60.0), (double)0.0);
    }

    @Test(expected=NullArgumentException.class)
    public void testNullEstimation() {
        this.type = null;
        this.getUnivariateStatistic();
    }

    @Test
    public void testAllEstimationTechniquesOnlyLimits() {
        Object[][] map;
        int N = this.testArray.length;
        double[] input = (double[])this.testArray.clone();
        Arrays.sort(input);
        double min = input[0];
        double max = input[input.length - 1];
        for (Object[] arr : map = new Object[][]{{Percentile.EstimationType.LEGACY, 0.0, 1.0}, {Percentile.EstimationType.R_1, 0.0, 1.0}, {Percentile.EstimationType.R_2, 0.0, 1.0}, {Percentile.EstimationType.R_3, 0.5 / (double)N, 1.0}, {Percentile.EstimationType.R_4, 1.0 / (double)N - 0.001, 1.0}, {Percentile.EstimationType.R_5, 0.5 / (double)N - 0.001, ((double)N - 0.5) / (double)N}, {Percentile.EstimationType.R_6, 0.99 / (double)(N + 1), 1.01 * (double)N / (double)(N + 1)}, {Percentile.EstimationType.R_7, 0.0, 1.0}, {Percentile.EstimationType.R_8, 0.6633333333333333 / ((double)N + 0.3333333333333333), ((double)N - 0.3333333333333333) / ((double)N + 0.3333333333333333)}, {Percentile.EstimationType.R_9, 0.62375 / ((double)N + 0.25), ((double)N - 0.375) / ((double)N + 0.25)}}) {
            Percentile.EstimationType t = (Percentile.EstimationType)arr[0];
            double pMin = (Double)arr[1];
            double pMax = (Double)arr[2];
            Assert.assertEquals((String)("Type:" + t), (double)0.0, (double)t.index(pMin, N), (double)0.0);
            Assert.assertEquals((String)("Type:" + t), (double)N, (double)t.index(pMax, N), (double)0.5);
            pMin = pMin == 0.0 ? pMin + 0.01 : pMin;
            this.testAssertMappedValues(this.testArray, new Object[][]{{t, min}}, pMin, 0.01);
            this.testAssertMappedValues(this.testArray, new Object[][]{{t, max}}, pMax * 100.0, this.tolerance);
        }
    }

    @Test
    public void testAllEstimationTechniquesOnly() {
        Assert.assertEquals((Object)"Legacy Hipparchus", (Object)Percentile.EstimationType.LEGACY.getName());
        Object[][] map = new Object[][]{{Percentile.EstimationType.LEGACY, 20.82}, {Percentile.EstimationType.R_1, 19.8}, {Percentile.EstimationType.R_2, 19.8}, {Percentile.EstimationType.R_3, 19.8}, {Percentile.EstimationType.R_4, 19.31}, {Percentile.EstimationType.R_5, 20.28}, {Percentile.EstimationType.R_6, 20.82}, {Percentile.EstimationType.R_7, 19.555}, {Percentile.EstimationType.R_8, 20.46}, {Percentile.EstimationType.R_9, 20.415}};
        try {
            Percentile.EstimationType.LEGACY.evaluate(this.testArray, -1.0, new KthSelector(PivotingStrategy.MEDIAN_OF_3));
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            Percentile.EstimationType.LEGACY.evaluate(this.testArray, 101.0, new KthSelector());
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            Percentile.EstimationType.LEGACY.evaluate(this.testArray, 50.0, new KthSelector());
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        for (Object[] o : map) {
            Percentile.EstimationType e = (Percentile.EstimationType)o[0];
            double expected = (Double)o[1];
            double result = e.evaluate(this.testArray, 95.0, new KthSelector());
            Assert.assertEquals((String)("expected[" + e + "] = " + expected + " but was = " + result), (double)expected, (double)result, (double)this.tolerance);
        }
    }

    @Test
    public void testAllEstimationTechniquesOnlyForAllPivotingStrategies() {
        Assert.assertEquals((Object)"Legacy Hipparchus", (Object)Percentile.EstimationType.LEGACY.getName());
        for (PivotingStrategy strategy : PivotingStrategy.values()) {
            this.kthSelector = new KthSelector(strategy);
            this.testAllEstimationTechniquesOnly();
        }
    }

    @Test
    public void testAllEstimationTechniquesOnlyForExtremeIndexes() {
        Object[][] map;
        double MAX = 100.0;
        for (Object[] o : map = new Object[][]{{Percentile.EstimationType.LEGACY, 0.0, 100.0}, {Percentile.EstimationType.R_1, 0.0, 100.5}, {Percentile.EstimationType.R_2, 0.0, 100.0}, {Percentile.EstimationType.R_3, 0.0, 100.0}, {Percentile.EstimationType.R_4, 0.0, 100.0}, {Percentile.EstimationType.R_5, 0.0, 100.0}, {Percentile.EstimationType.R_6, 0.0, 100.0}, {Percentile.EstimationType.R_7, 0.0, 100.0}, {Percentile.EstimationType.R_8, 0.0, 100.0}, {Percentile.EstimationType.R_9, 0.0, 100.0}}) {
            Percentile.EstimationType e = (Percentile.EstimationType)o[0];
            Assert.assertEquals((double)((Double)o[1]), (double)e.index(0.0, 100), (double)0.0);
            Assert.assertEquals((String)("Enum:" + e), (double)((Double)o[2]), (double)e.index(1.0, 100), (double)0.0);
        }
    }

    @Test
    public void testAllEstimationTechniquesOnlyForNullsAndOOR() {
        Object[][] map;
        for (Object[] o : map = new Object[][]{{Percentile.EstimationType.LEGACY, 20.82}, {Percentile.EstimationType.R_1, 19.8}, {Percentile.EstimationType.R_2, 19.8}, {Percentile.EstimationType.R_3, 19.8}, {Percentile.EstimationType.R_4, 19.31}, {Percentile.EstimationType.R_5, 20.28}, {Percentile.EstimationType.R_6, 20.82}, {Percentile.EstimationType.R_7, 19.555}, {Percentile.EstimationType.R_8, 20.46}, {Percentile.EstimationType.R_9, 20.415}}) {
            Percentile.EstimationType e = (Percentile.EstimationType)o[0];
            try {
                e.evaluate(null, 95.0, new KthSelector());
                Assert.fail((String)"Expecting NullArgumentException");
            }
            catch (NullArgumentException nullArgumentException) {
                // empty catch block
            }
            try {
                e.evaluate(this.testArray, 120.0, new KthSelector());
                Assert.fail((String)"Expecting MathIllegalArgumentException");
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                // empty catch block
            }
        }
    }

    protected void testAssertMappedValues(double[] data, Object[][] map, Double p, Double tolerance) {
        for (Object[] o : map) {
            Percentile.EstimationType e = (Percentile.EstimationType)o[0];
            double expected = (Double)o[1];
            try {
                this.reset(p, e);
                double result = this.getUnivariateStatistic().evaluate(data);
                Assert.assertEquals((String)("expected[" + e + "] = " + expected + " but was = " + result), (double)expected, (double)result, (double)tolerance);
            }
            catch (Exception ex) {
                Assert.fail((String)("Exception occured for estimation type " + e + ":" + ex.getLocalizedMessage()));
            }
        }
    }

    @Test
    public void testNanStrategySpecific() {
        double[] specialValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, Double.NaN};
        Assert.assertTrue((boolean)Double.isNaN(new Percentile(50.0).withEstimationType(Percentile.EstimationType.LEGACY).withNaNStrategy(NaNStrategy.MAXIMAL).evaluate(specialValues, 3, 3)));
        Assert.assertEquals((double)2.0, (double)new Percentile(50.0).withEstimationType(Percentile.EstimationType.R_1).withNaNStrategy(NaNStrategy.REMOVED).evaluate(specialValues), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)new Percentile(50.0).withEstimationType(Percentile.EstimationType.R_5).withNaNStrategy(NaNStrategy.REMOVED).evaluate(new double[]{Double.NaN, Double.NaN, Double.NaN}), (double)0.0);
        Assert.assertEquals((double)50.0, (double)new Percentile(50.0).withEstimationType(Percentile.EstimationType.R_7).withNaNStrategy(NaNStrategy.MINIMAL).evaluate(new double[]{50.0, 50.0, 50.0}, 1, 2), (double)0.0);
        specialValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, Double.NaN, Double.NaN};
        Assert.assertEquals((double)3.5, (double)new Percentile().evaluate(specialValues, 3, 4), (double)0.0);
        Assert.assertEquals((double)4.0, (double)new Percentile().evaluate(specialValues, 4, 3), (double)0.0);
        Assert.assertTrue((boolean)Double.isNaN(new Percentile().evaluate(specialValues, 5, 2)));
        specialValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, Double.NaN, Double.NaN, 5.0, 6.0};
        Assert.assertEquals((double)4.5, (double)new Percentile().evaluate(specialValues, 3, 6), (double)0.0);
        Assert.assertEquals((double)5.0, (double)new Percentile().evaluate(specialValues, 4, 5), (double)0.0);
        Assert.assertTrue((boolean)Double.isNaN(new Percentile().evaluate(specialValues, 5, 2)));
        Assert.assertTrue((boolean)Double.isNaN(new Percentile().evaluate(specialValues, 5, 1)));
        Assert.assertEquals((double)5.5, (double)new Percentile().evaluate(specialValues, 5, 4), (double)0.0);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testNanStrategyFailed() {
        double[] specialValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, Double.NaN};
        new Percentile(50.0).withEstimationType(Percentile.EstimationType.R_9).withNaNStrategy(NaNStrategy.FAILED).evaluate(specialValues);
    }

    @Test
    public void testAllTechniquesSpecialValuesWithNaNStrategy() {
        double[] specialValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, Double.NaN};
        try {
            new Percentile(50.0).withEstimationType(Percentile.EstimationType.LEGACY).withNaNStrategy(null);
            Assert.fail((String)"Expecting NullArgumentArgumentException for null Nan Strategy");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        this.testAssertMappedValues(specialValues, new Object[][]{{Percentile.EstimationType.LEGACY, 2.5}, {Percentile.EstimationType.R_1, 2.0}, {Percentile.EstimationType.R_2, 2.0}, {Percentile.EstimationType.R_3, 1.0}, {Percentile.EstimationType.R_4, 1.5}, {Percentile.EstimationType.R_5, 2.0}, {Percentile.EstimationType.R_6, 2.0}, {Percentile.EstimationType.R_7, 2.0}, {Percentile.EstimationType.R_8, 2.0}, {Percentile.EstimationType.R_9, 2.0}}, 50.0, 0.0);
        this.testAssertMappedValues(specialValues, new Object[][]{{Percentile.EstimationType.LEGACY, 2.5}, {Percentile.EstimationType.R_1, 2.0}, {Percentile.EstimationType.R_2, 2.5}, {Percentile.EstimationType.R_3, 2.0}, {Percentile.EstimationType.R_4, 2.0}, {Percentile.EstimationType.R_5, 2.5}, {Percentile.EstimationType.R_6, 2.5}, {Percentile.EstimationType.R_7, 2.5}, {Percentile.EstimationType.R_8, 2.5}, {Percentile.EstimationType.R_9, 2.5}}, 50.0, 0.0, NaNStrategy.MAXIMAL);
        this.testAssertMappedValues(specialValues, new Object[][]{{Percentile.EstimationType.LEGACY, 1.5}, {Percentile.EstimationType.R_1, 1.0}, {Percentile.EstimationType.R_2, 1.5}, {Percentile.EstimationType.R_3, 1.0}, {Percentile.EstimationType.R_4, 1.0}, {Percentile.EstimationType.R_5, 1.5}, {Percentile.EstimationType.R_6, 1.5}, {Percentile.EstimationType.R_7, 1.5}, {Percentile.EstimationType.R_8, 1.5}, {Percentile.EstimationType.R_9, 1.5}}, 50.0, 0.0, NaNStrategy.MINIMAL);
        this.testAssertMappedValues(specialValues, new Object[][]{{Percentile.EstimationType.LEGACY, 2.0}, {Percentile.EstimationType.R_1, 2.0}, {Percentile.EstimationType.R_2, 2.0}, {Percentile.EstimationType.R_3, 1.0}, {Percentile.EstimationType.R_4, 1.5}, {Percentile.EstimationType.R_5, 2.0}, {Percentile.EstimationType.R_6, 2.0}, {Percentile.EstimationType.R_7, 2.0}, {Percentile.EstimationType.R_8, 2.0}, {Percentile.EstimationType.R_9, 2.0}}, 50.0, 0.0, NaNStrategy.REMOVED);
    }

    protected void testAssertMappedValues(double[] data, Object[][] map, Double p, Double tolerance, NaNStrategy nanStrategy) {
        for (Object[] o : map) {
            Percentile.EstimationType e = (Percentile.EstimationType)o[0];
            double expected = (Double)o[1];
            try {
                double result = new Percentile(p.doubleValue()).withEstimationType(e).withNaNStrategy(nanStrategy).evaluate(data);
                Assert.assertEquals((String)("expected[" + e + "] = " + expected + " but was = " + result), (double)expected, (double)result, (double)tolerance);
            }
            catch (Exception ex) {
                Assert.fail((String)("Exception occured for estimation type " + e + ":" + ex.getLocalizedMessage()));
            }
        }
    }
}

