/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.summary;

import org.hipparchus.stat.descriptive.StorelessUnivariateStatistic;
import org.hipparchus.stat.descriptive.StorelessUnivariateStatisticAbstractTest;
import org.hipparchus.stat.descriptive.summary.Product;
import org.junit.Assert;
import org.junit.Test;

public class ProductTest
extends StorelessUnivariateStatisticAbstractTest {
    public Product getUnivariateStatistic() {
        return new Product();
    }

    @Override
    public double getTolerance() {
        return 1.0E9;
    }

    @Override
    public double expectedValue() {
        return this.product;
    }

    public double expectedWeightedValue() {
        return this.weightedProduct;
    }

    @Test
    public void testSpecialValues() {
        Product product = this.getUnivariateStatistic();
        Assert.assertEquals((double)1.0, (double)product.getResult(), (double)0.0);
        product.increment(1.0);
        Assert.assertEquals((double)1.0, (double)product.getResult(), (double)0.0);
        product.increment(Double.POSITIVE_INFINITY);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)product.getResult(), (double)0.0);
        product.increment(Double.NEGATIVE_INFINITY);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)product.getResult(), (double)0.0);
        product.increment(Double.NaN);
        Assert.assertTrue((boolean)Double.isNaN(product.getResult()));
        product.increment(1.0);
        Assert.assertTrue((boolean)Double.isNaN(product.getResult()));
    }

    @Test
    public void testWeightedProduct() {
        Product product = new Product();
        Assert.assertEquals((double)this.expectedWeightedValue(), (double)product.evaluate(this.testArray, this.testWeightsArray, 0, this.testArray.length), (double)this.getTolerance());
        Assert.assertEquals((double)this.expectedValue(), (double)product.evaluate(this.testArray, this.unitWeightsArray, 0, this.testArray.length), (double)this.getTolerance());
    }

    @Override
    protected void checkClearValue(StorelessUnivariateStatistic statistic) {
        Assert.assertEquals((double)1.0, (double)statistic.getResult(), (double)0.0);
    }
}

